<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

try {
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;
    
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    $params = array(
        'qtype' => 'almox.id',
        'query' => '1',
        'oper' => '>=',
        'page' => '1',
        'rp' => '100',
        'sortname' => 'almox.id',
        'sortorder' => 'asc'
    );
    
    $api->get('almox', $params);
    $retorno = $api->getRespostaConteudo(false);
    $data = json_decode($retorno, true);
    
    if (isset($data['registros']) && count($data['registros']) > 0) {
        // Retornar o primeiro almoxarifado (do usuário logado)
        $almox = $data['registros'][0];
        echo json_encode([
            'success' => true,
            'id_almox' => $almox['id'],
            'descricao' => $almox['descricao'],
            'id_filial' => $almox['id_filial']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Nenhum almoxarifado encontrado'
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
