<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

// Receber dados
$input = file_get_contents('php://input');
$data = json_decode($input, true);

$id_chamado = $data['id_chamado'] ?? '';
$mensagem = $data['mensagem'] ?? '';
$data_final = $data['data_final'] ?? date('Y-m-d');
$id_proxima_tarefa = $data['id_proxima_tarefa'] ?? '';
$id_tecnico = $data['id_tecnico'] ?? '';

if (empty($id_chamado)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do chamado não informado'
    ]);
    exit;
}

if (empty($id_tecnico)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do técnico não informado'
    ]);
    exit;
}

try {
    $dataHoraAtual = date('Y-m-d H:i:s');
    
    // Dados básicos obrigatórios
    $dados = array(
        'id_chamado' => $id_chamado,
        'id_tecnico' => $id_tecnico,
        'data_inicio' => $dataHoraAtual,
        'data_final' => $data_final,
        'data' => date('Y-m-d'),
        'mensagem' => $mensagem,
        'status' => 'F'
    );

    // Se tiver próxima tarefa (id_assunto 27,28,31,81), adiciona
    if (!empty($id_proxima_tarefa)) {
        $dados['id_proxima_tarefa'] = $id_proxima_tarefa;
    }

    // Log do payload
    error_log('📤 Payload fechar OS: ' . json_encode($dados, JSON_PRETTY_PRINT));

    $api->post('su_oss_chamado_fechar', $dados);
    $retorno = $api->getRespostaConteudo(false);
    $resultado = json_decode($retorno, true);

    // Log do retorno
    error_log('📥 Retorno IXC fechar OS: ' . json_encode($resultado, JSON_PRETTY_PRINT));

    if (isset($resultado['type']) && $resultado['type'] === 'success') {
        echo json_encode([
            'success' => true,
            'message' => 'OS fechada com sucesso',
            'retorno_ixc' => $resultado
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => $resultado['message'] ?? 'Erro ao fechar OS',
            'retorno_ixc' => $resultado,
            'payload_enviado' => $dados
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage(),
        'payload_enviado' => $dados ?? null
    ]);
}
?>
