<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

// Receber o ID do arquivo
$id_arquivo = $_GET['id'] ?? '';

if (empty($id_arquivo)) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'ID do arquivo não fornecido']);
    exit;
}

try {
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    $params = array(
        'id' => $id_arquivo
    );
    
    $api->get('visualizar_arquivo_os', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    if (!empty($retorno)) {
        // Tentar decodificar base64
        $decoded = base64_decode($retorno, true);
        
        // Se for base64 válido, usar o decodificado
        if ($decoded !== false && base64_encode($decoded) === $retorno) {
            $fileData = $decoded;
        } else {
            // Caso contrário, usar o retorno direto (já é binário)
            $fileData = $retorno;
        }
        
        // Detectar tipo de arquivo pelos magic bytes
        $finfo = new finfo(FILEINFO_MIME_TYPE);
        $mimeType = $finfo->buffer($fileData);
        
        header('Content-Type: ' . $mimeType);
        header('Content-Length: ' . strlen($fileData));
        header('Content-Disposition: inline');
        header('Cache-Control: public, max-age=86400');
        
        echo $fileData;
    } else {
        header('HTTP/1.1 404 Not Found');
        echo json_encode(['error' => 'Arquivo não encontrado']);
    }
    
} catch (Exception $e) {
    header('HTTP/1.1 500 Internal Server Error');
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Erro ao baixar arquivo: ' . $e->getMessage()]);
}
?>
