<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    // Receber os dados
    $id_chamado = $_POST['id_chamado'] ?? '';
    $id_tecnico = $_POST['id_tecnico'] ?? '';
    $latitude = $_POST['latitude'] ?? '';
    $longitude = $_POST['longitude'] ?? '';
    $gps_time = $_POST['gps_time'] ?? '';
    
    if (empty($id_chamado)) {
        throw new Exception('ID do chamado não fornecido');
    }
    
    if (empty($id_tecnico)) {
        throw new Exception('ID do técnico não fornecido');
    }
    
    // Preparar dados EXATAMENTE como a documentação
    $postData = [
        'id_chamado' => $id_chamado,
        'id_tarefa_atual' => '',
        'eh_tarefa_decisao' => '',
        'sequencia_atual' => '',
        'proxima_sequencia_forcada' => '',
        'finaliza_processo_aux' => '',
        'gera_comissao_aux' => '',
        'id_processo' => '',
        'data_inicio' => '',
        'data_final' => '',
        'id_resposta' => '',
        'mensagem' => 'Técnico em deslocamento',
        'id_tecnico' => $id_tecnico,
        'id_equipe' => '',
        'gera_comissao' => '',
        'status' => 'DS',
        'data' => '',
        'id_evento' => '',
        'id_su_diagnostico' => '',
        'justificativa_sla_atrasado' => '',
        'id_evento_status' => '',
        'id_proxima_tarefa' => '',
        'id_proxima_tarefa_aux' => '',
        'latitude' => $latitude,
        'longitude' => $longitude,
        'gps_time' => $gps_time
    ];
    
    $jsonData = json_encode($postData);
    
    // URL da API
    $url = $ixc_host . '/su_oss_chamado_executar';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'User-Agent: Mozilla/5.0'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Deslocamento iniciado com sucesso!',
        'id_chamado' => $id_chamado
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log("ERRO ao deslocar OS: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao iniciar deslocamento: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>

