<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Log de debug
error_log("=== REQUISIÇÃO EMAIL ===");
error_log("POST data: " . print_r($_POST, true));

// Função para log detalhado
function writeEmailLog($message) {
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[{$timestamp}] {$message}\n";
    file_put_contents('/tmp/email_log.txt', $log_entry, FILE_APPEND | LOCK_EX);
    error_log($message);
}

try {
    $action = $_POST['action'] ?? '';
    error_log("Action recebida: '" . $action . "'");
    
    if ($action === 'recuperar-senha') {
        $email = $_POST['email'] ?? '';
        $nome = $_POST['nome'] ?? 'Cliente';
        $senha = $_POST['senha'] ?? '';
        $telefone = $_POST['telefone'] ?? '';
        
        if (empty($email) || empty($senha)) {
            throw new Exception('E-mail e senha são obrigatórios');
        }
        
        writeEmailLog("=== INICIANDO ENVIO DE E-MAIL ===");
        writeEmailLog("Destinatário: " . $email);
        writeEmailLog("Nome: " . $nome);
        writeEmailLog("Senha: " . $senha);
        writeEmailLog("Telefone: " . $telefone);
        
        // Configurações do servidor de e-mail
        $smtp_host = 'milo.cactus.net.br';
        $smtp_port = 465;
        $smtp_username = 'atendimento@core3chip.com.br';
        $smtp_password = 'A@9025dfsty';
        $from_email = 'atendimento@core3chip.com.br';
        $from_name = 'Core3Chip';
        
        // Assunto do e-mail
        $subject = 'Recuperação de Senha Core3Business';
        
        // Corpo do e-mail em HTML
        $html_body = '
        <!DOCTYPE html>
        <html lang="pt-BR">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Recuperação de Senha</title>
            <style>
                body {
                    font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
                    line-height: 1.6;
                    color: #333;
                    max-width: 600px;
                    margin: 0 auto;
                    background-color: #f8fafc;
                }
                .container {
                    background-color: #ffffff;
                    padding: 40px;
                    border-radius: 12px;
                    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                    margin: 20px;
                }
                .logo {
                    text-align: center;
                    margin-bottom: 30px;
                }
                .logo h1 {
                    color: #2563eb;
                    font-size: 28px;
                    font-weight: bold;
                    margin: 0;
                    text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.1);
                }
                .content {
                    margin-bottom: 30px;
                }
                .greeting {
                    font-size: 18px;
                    color: #1f2937;
                    margin-bottom: 20px;
                }
                .message {
                    font-size: 16px;
                    color: #374151;
                    margin-bottom: 25px;
                    line-height: 1.7;
                }
                .password-box {
                    background: linear-gradient(135deg, #3b82f6, #1d4ed8);
                    color: white;
                    padding: 20px;
                    border-radius: 8px;
                    text-align: center;
                    margin: 25px 0;
                    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3);
                }
                .password-label {
                    font-size: 14px;
                    opacity: 0.9;
                    margin-bottom: 8px;
                }
                .password-value {
                    font-size: 24px;
                    font-weight: bold;
                    letter-spacing: 2px;
                    font-family: "Courier New", monospace;
                }
                .signature {
                    margin-top: 30px;
                    text-align: center;
                    color: #6b7280;
                    font-style: italic;
                }
                .support {
                    background-color: #f3f4f6;
                    padding: 20px;
                    border-radius: 8px;
                    margin-top: 25px;
                    border-left: 4px solid #10b981;
                }
                .support-title {
                    font-weight: bold;
                    color: #059669;
                    margin-bottom: 10px;
                }
                .whatsapp {
                    color: #25d366;
                    font-weight: bold;
                    text-decoration: none;
                }
                .footer {
                    text-align: center;
                    margin-top: 40px;
                    padding-top: 20px;
                    border-top: 2px solid #e5e7eb;
                    color: #2563eb;
                    font-weight: bold;
                    font-size: 16px;
                }
                .chip-icon {
                    font-size: 24px;
                    margin-right: 8px;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="logo">
                    <h1>📱 CORE3BUSINESS</h1>
                </div>
                
                <div class="content">
                    <div class="greeting">Olá ' . htmlspecialchars($nome) . ',</div>
                    
                    <div class="message">
                        Você solicitou a recuperação de sua senha de acesso ao app Core3Chip.
                        Segue abaixo suas informações de acesso:
                    </div>
                    
                    <div class="password-box">
                        <div class="password-label">Sua senha é:</div>
                        <div class="password-value">' . htmlspecialchars($senha) . '</div>
                    </div>
                    
                    <div class="signature">
                        Atenciosamente,<br>
                        <strong>Core3Chip</strong>
                    </div>
                    
                    <div class="support">
                        <div class="support-title">⚠️ Não solicitou esta senha?</div>
                        Entre em contato com nosso suporte no WhatsApp:<br>
                        <a href="https://wa.me/557530237350" class="whatsapp">📱 (75) 3023-7350</a>
                    </div>
                </div>
                
                <div class="footer">
                    <span class="chip-icon">📱</span>
                    Core3Chip - A operadora que entende você!
                </div>
            </div>
        </body>
        </html>';
        
        // Versão em texto simples para clientes que não suportam HTML
        $text_body = "
CORE3BUSINESS - RECUPERAÇÃO DE SENHA

Olá {$nome},

Você solicitou a recuperação de sua senha de acesso ao app Core3Chip.

Sua senha é: {$senha}

Atenciosamente,
Core3Chip

⚠️ Se você não solicitou a senha, entre em contato com nosso suporte:
WhatsApp: (75) 3023-7350

Core3Chip - A operadora que entende você!
        ";
        
        // Configurar headers do e-mail
        $headers = array(
            'From' => "{$from_name} <{$from_email}>",
            'Reply-To' => $from_email,
            'X-Mailer' => 'PHP/' . phpversion(),
            'MIME-Version' => '1.0',
            'Content-Type' => 'multipart/alternative; boundary="boundary_' . md5(time()) . '"'
        );
        
        // Criar mensagem multipart
        $boundary = "boundary_" . md5(time());
        $message = "--{$boundary}\r\n";
        $message .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $message .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
        $message .= $text_body . "\r\n\r\n";
        
        $message .= "--{$boundary}\r\n";
        $message .= "Content-Type: text/html; charset=UTF-8\r\n";
        $message .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
        $message .= $html_body . "\r\n\r\n";
        $message .= "--{$boundary}--\r\n";
        
        // Função para enviar e-mail via SMTP com autenticação
        function sendEmailViaSMTP($to, $subject, $html_body, $text_body, $from_email, $from_name) {
            // Configurações do servidor SMTP Core3Chip
            $smtp_host = 'milo.cactus.net.br';
            $smtp_port = 587; // Porta para STARTTLS
            $smtp_username = 'atendimento@core3chip.com.br';
            $smtp_password = 'A@9025dfsty';
            
            // Criar mensagem MIME
            $boundary = "boundary_" . md5(time());
            $message = "--{$boundary}\r\n";
            $message .= "Content-Type: text/plain; charset=UTF-8\r\n";
            $message .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
            $message .= $text_body . "\r\n\r\n";
            
            $message .= "--{$boundary}\r\n";
            $message .= "Content-Type: text/html; charset=UTF-8\r\n";
            $message .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
            $message .= $html_body . "\r\n\r\n";
            $message .= "--{$boundary}--\r\n";
            
            // Headers do e-mail
            $headers = [
                'From: ' . $from_name . ' <' . $from_email . '>',
                'Reply-To: ' . $from_email,
                'X-Mailer: PHP/' . phpversion(),
                'MIME-Version: 1.0',
                'Content-Type: multipart/alternative; boundary="' . $boundary . '"'
            ];
            
            // Tentar primeiro com mail() nativo
            $mail_sent = mail($to, $subject, $message, implode("\r\n", $headers));
            
            if ($mail_sent) {
                writeEmailLog("E-mail enviado com sucesso via mail() para: " . $to);
                return true;
            }
            
            // Se mail() falhar, tentar com fsockopen para SMTP
            writeEmailLog("mail() falhou, tentando SMTP direto para: " . $to);
            
            try {
                // Criar conexão SSL para SMTP
                $context = stream_context_create([
                    "ssl" => [
                        "verify_peer" => false,
                        "verify_peer_name" => false,
                    ],
                ]);
                
                $socket = stream_socket_client(
                    "ssl://{$smtp_host}:{$smtp_port}",
                    $errno,
                    $errstr,
                    30,
                    STREAM_CLIENT_CONNECT,
                    $context
                );
                
                if (!$socket) {
                    writeEmailLog("ERRO: Falha ao conectar SMTP: {$errstr} ({$errno})");
                    throw new Exception("Falha ao conectar SMTP: {$errstr} ({$errno})");
                }
                
                writeEmailLog("Conectado ao SMTP: {$smtp_host}:{$smtp_port}");
                
                // Ler resposta inicial
                fgets($socket, 512);
                
                // EHLO
                fputs($socket, "EHLO {$smtp_host}\r\n");
                fgets($socket, 512);
                
                // AUTH LOGIN
                fputs($socket, "AUTH LOGIN\r\n");
                fgets($socket, 512);
                
                // Username
                fputs($socket, base64_encode($smtp_username) . "\r\n");
                fgets($socket, 512);
                
                // Password
                fputs($socket, base64_encode($smtp_password) . "\r\n");
                fgets($socket, 512);
                
                // MAIL FROM
                fputs($socket, "MAIL FROM:<{$from_email}>\r\n");
                fgets($socket, 512);
                
                // RCPT TO
                fputs($socket, "RCPT TO:<{$to}>\r\n");
                fgets($socket, 512);
                
                // DATA
                fputs($socket, "DATA\r\n");
                fgets($socket, 512);
                
                // Enviar headers e mensagem
                $email_data = "Subject: {$subject}\r\n";
                $email_data .= "From: {$from_name} <{$from_email}>\r\n";
                $email_data .= "To: {$to}\r\n";
                $email_data .= implode("\r\n", $headers) . "\r\n";
                $email_data .= "\r\n";
                $email_data .= $message;
                $email_data .= "\r\n.\r\n";
                
                fputs($socket, $email_data);
                $response = fgets($socket, 512);
                
                // QUIT
                fputs($socket, "QUIT\r\n");
                fclose($socket);
                
                if (strpos($response, '250') !== false) {
                    error_log("E-mail enviado com sucesso via SMTP para: " . $to);
                    return true;
                } else {
                    throw new Exception("SMTP falhou: " . $response);
                }
                
            } catch (Exception $e) {
                error_log("Erro SMTP: " . $e->getMessage());
                return false;
            }
        }
        
        // Enviar e-mail usando a versão que funciona
        $mail_sent = sendEmailWorking($email, $subject, $html_body, $text_body);
        
        if ($mail_sent) {
            echo json_encode([
                'success' => true,
                'message' => 'E-mail enviado com sucesso',
                'email' => $email,
                'timestamp' => date('Y-m-d H:i:s'),
                'method' => 'SMTP'
            ]);
        } else {
            error_log("Falha ao enviar e-mail para: " . $email);
            throw new Exception('Falha ao enviar e-mail. Verifique as configurações do servidor SMTP.');
        }
        
    } elseif ($action === 'test') {
        echo json_encode([
            'success' => true,
            'message' => 'Serviço de e-mail OK',
            'timestamp' => date('Y-m-d H:i:s')
        ]);
    } else {
        throw new Exception('Ação não especificada');
    }
    
} catch (Exception $e) {
    error_log("Erro no envio de e-mail: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'error' => true,
        'message' => $e->getMessage()
    ]);
}
?>
