<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    // Receber os dados do JSON
    $input = json_decode(file_get_contents('php://input'), true);
    
    $id_chamado = $input['id_chamado'] ?? '';
    $mensagem = $input['mensagem'] ?? '';
    $latitude = $input['latitude'] ?? '';
    $longitude = $input['longitude'] ?? '';
    $gps_time = $input['gps_time'] ?? '';
    
    if (empty($id_chamado)) {
        throw new Exception('ID do chamado não fornecido');
    }
    
    if (empty($mensagem)) {
        throw new Exception('Mensagem não fornecida');
    }
    
    // Preparar dados para encaminhar
    // ID SETOR FIXO = 4
    // ID TÉCNICO FIXO = 100
    $postData = [
        'id_chamado' => $id_chamado,
        'id_setor' => '4',
        'id_tecnico' => '100',
        'id_assunto' => '',
        'mensagem' => $mensagem,
        'status' => 'EN'
    ];
    
    $jsonData = json_encode($postData);
    
    error_log("=== ENCAMINHAR OS ===");
    error_log("URL: " . $ixc_host . '/su_oss_chamado_alterar_setor');
    error_log("JSON: " . $jsonData);
    
    // URL da API
    $url = $ixc_host . '/su_oss_chamado_alterar_setor';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    error_log("HTTP Code: " . $httpCode);
    error_log("Response: " . substr($response, 0, 500));
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    // Verificar se a resposta do IXC é um erro
    $responseData = json_decode($response, true);
    if (isset($responseData['type']) && $responseData['type'] === 'error') {
        throw new Exception('Erro IXC: ' . $responseData['message']);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'OS encaminhada com sucesso!',
        'id_chamado' => $id_chamado,
        'mensagem' => $mensagem,
        'ixc_response' => $response
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log("ERRO ao encaminhar OS: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
