<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $clienteId = $_POST['cliente_id'] ?? null;

    if (!$clienteId) {
        throw new Exception('ID do cliente não fornecido');
    }

    $params = array(
        'qtype' => 'su_oss_chamado.id_cliente',
        'query' => $clienteId,
        'oper' => '=',
        'rp' => '200000',
        'sortname' => 'su_oss_chamado.data_abertura',
        'sortorder' => 'desc',
        'grid_param' => json_encode(array(
            array('TB' => 'su_oss_chamado.tipo', 'OP' => '=', 'P' => 'C'), // Filtrar por Chamados
            array('TB' => 'su_oss_chamado.id_assunto', 'OP' => '=', 'P' => '42') // Filtrar apenas assunto 122
        ))
    );

    $api->get('su_oss_chamado', $params);
    $retorno = $api->getRespostaConteudo(false);

    echo json_encode(['success' => true, 'data' => $retorno, 'message' => 'Suportes recuperados com sucesso']);

} catch (Exception $e) {
    error_log("Erro na API de meus suportes: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>