<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Receber o caminho do arquivo
$local_arquivo = $_GET['arquivo'] ?? '';

if (empty($local_arquivo)) {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'Arquivo não especificado']);
    exit;
}

// Credenciais IXC
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$auth = base64_encode($token);

// URL completa do arquivo no IXC
$fileUrl = 'https://app.core3.com.br/' . $local_arquivo;

// Inicializar cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $fileUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . $auth,
    'ixcsoft: ligar',
    'Content-Type: application/json'
]);

// Executar requisição
$fileContent = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
curl_close($ch);

if ($httpCode !== 200) {
    header('HTTP/1.1 404 Not Found');
    echo json_encode(['error' => 'Arquivo não encontrado']);
    exit;
}

// Retornar o arquivo com o tipo correto
header('Content-Type: ' . $contentType);
header('Content-Disposition: inline; filename="' . basename($local_arquivo) . '"');
echo $fileContent;
?>

