<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    // Receber dados
    $input = json_decode(file_get_contents('php://input'), true);
    
    $id_os = $input['id_os'] ?? '';
    $assinatura_base64 = $input['assinatura_base64'] ?? '';
    
    if (empty($id_os)) {
        throw new Exception('ID da OS não fornecido');
    }
    
    if (empty($assinatura_base64)) {
        throw new Exception('Assinatura não fornecida');
    }
    
    error_log("=== FINALIZAR OS COMPLETO ===");
    error_log("ID OS: " . $id_os);
    
    // PASSO 1: Gerar PDF da OS
    error_log("PASSO 1: Gerando PDF da OS...");
    
    $urlPdf = $ixc_host . '/imprimir_jato_laser_os';
    $postDataPdf = ['id' => $id_os];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $urlPdf);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postDataPdf));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    
    $pdfContent = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200 || empty($pdfContent)) {
        throw new Exception('Erro ao gerar PDF da OS');
    }
    
    error_log("PDF gerado com sucesso! Tamanho: " . strlen($pdfContent) . " bytes");
    
    // PASSO 2: Salvar PDF da OS como arquivo
    error_log("PASSO 2: Salvando PDF da OS...");
    
    $pdfTempFile = tempnam(sys_get_temp_dir(), 'os_pdf_');
    file_put_contents($pdfTempFile, $pdfContent);
    
    $urlUpload = $ixc_host . '/su_oss_chamado_arquivos';
    
    $postDataPdfUpload = [
        'descricao' => 'Ordem de Serviço - PDF',
        'local_arquivo' => new CURLFile($pdfTempFile, 'application/pdf', "OS_{$id_os}.pdf"),
        'id_oss_chamado' => $id_os,
        'classificacao_arquivo' => 'P'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $urlUpload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataPdfUpload);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    
    $responsePdf = curl_exec($ch);
    curl_close($ch);
    unlink($pdfTempFile);
    
    $dataPdf = json_decode($responsePdf, true);
    if (isset($dataPdf['type']) && $dataPdf['type'] === 'error') {
        error_log("Erro ao salvar PDF: " . $dataPdf['message']);
    } else {
        error_log("PDF salvo com sucesso!");
    }
    
    // PASSO 3: Salvar assinatura como imagem
    error_log("PASSO 3: Salvando assinatura...");
    
    // Decodificar base64 da assinatura
    $assinaturaData = $assinatura_base64;
    if (strpos($assinaturaData, 'data:image/png;base64,') === 0) {
        $assinaturaData = substr($assinaturaData, strlen('data:image/png;base64,'));
    }
    
    $assinaturaDecoded = base64_decode($assinaturaData);
    
    $assinaturaTempFile = tempnam(sys_get_temp_dir(), 'assinatura_');
    file_put_contents($assinaturaTempFile, $assinaturaDecoded);
    
    $postDataAssinatura = [
        'descricao' => 'Assinatura Digital do Técnico',
        'local_arquivo' => new CURLFile($assinaturaTempFile, 'image/png', "Assinatura_OS_{$id_os}.png"),
        'id_oss_chamado' => $id_os,
        'classificacao_arquivo' => 'P'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $urlUpload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataAssinatura);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    
    $responseAssinatura = curl_exec($ch);
    curl_close($ch);
    unlink($assinaturaTempFile);
    
    $dataAssinatura = json_decode($responseAssinatura, true);
    if (isset($dataAssinatura['type']) && $dataAssinatura['type'] === 'error') {
        throw new Exception('Erro ao salvar assinatura: ' . $dataAssinatura['message']);
    }
    
    error_log("Assinatura salva com sucesso!");
    
    echo json_encode([
        'success' => true,
        'message' => 'PDF e assinatura salvos com sucesso!',
        'pdf_salvo' => isset($dataPdf['type']) && $dataPdf['type'] === 'success',
        'assinatura_salva' => isset($dataAssinatura['type']) && $dataAssinatura['type'] === 'success'
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    error_log("ERRO ao finalizar OS: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
