<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

// Receber o ID do assunto
$id_assunto = $_POST['id_assunto'] ?? '';

if (empty($id_assunto)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do assunto não fornecido'
    ]);
    exit;
}

try {
    $params = array(
        'qtype' => 'su_oss_assunto.id',
        'query' => $id_assunto,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'su_oss_assunto.id',
        'sortorder' => 'desc'
    );

    $api->get('su_oss_assunto', $params);
    $retorno = $api->getRespostaConteudo(false);
    $resultado = json_decode($retorno, true);

    if (isset($resultado['registros']) && !empty($resultado['registros'])) {
        $assunto = $resultado['registros'][0];
        echo json_encode([
            'success' => true,
            'assunto' => $assunto['assunto'] ?? null,
            'descricao' => $assunto['descricao'] ?? null
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Assunto não encontrado'
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
