<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Configuração da API IXC
$ixc_host = 'https://app.core3.com.br/webservice/v1';
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';

try {
    // Receber o ID do contrato
    $id_contrato = $_POST['id_contrato'] ?? '';
    
    error_log("=== BUSCAR CONTRATO STATUS ===");
    error_log("ID Contrato recebido: " . $id_contrato);
    
    if (empty($id_contrato)) {
        echo json_encode([
            'success' => false,
            'message' => 'ID do contrato não fornecido'
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
    
    // URL da API de contratos
    $url = $ixc_host . '/cliente_contrato';
    
    $postData = [
        'qtype' => 'cliente_contrato.id',
        'query' => $id_contrato,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'cliente_contrato.id',
        'sortorder' => 'desc'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $ixc_token);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'ixcsoft: listar',
        'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HEADER, false);
    
    error_log("Fazendo requisição para IXC Contrato: " . $url);
    error_log("Dados enviados: " . http_build_query($postData));
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    error_log("Resposta IXC Contrato - HTTP: " . $httpCode . ", Error: " . $error);
    error_log("Resposta IXC Contrato (primeiros 300 chars): " . substr($response, 0, 300));
    
    if ($error) {
        throw new Exception('Erro cURL: ' . $error);
    }
    
    if ($httpCode !== 200) {
        throw new Exception('HTTP ' . $httpCode . ': ' . substr($response, 0, 300));
    }
    
    // Verificar se a resposta é JSON válido
    $decoded = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Resposta inválida da API IXC');
    }
    
    // Extrair status do contrato
    if (isset($decoded['registros']) && count($decoded['registros']) > 0) {
        $contrato = $decoded['registros'][0];
        
        echo json_encode([
            'success' => true,
            'status_internet' => $contrato['status_internet'] ?? '',
            'contrato' => $contrato['contrato'] ?? '',
            'vigencia' => $contrato['vigencia'] ?? '',
            'plano' => $contrato['plano'] ?? ''
        ], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Contrato não encontrado'
        ], JSON_UNESCAPED_UNICODE);
    }
    
} catch (Exception $e) {
    error_log("ERRO ao buscar contrato: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao buscar contrato: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>

