<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;

$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

// Receber dados
$input = file_get_contents('php://input');
$data = json_decode($input, true);

$id_contrato = $data['id_contrato'] ?? '';

if (empty($id_contrato)) {
    echo json_encode([
        'success' => false,
        'message' => 'ID do contrato não informado'
    ]);
    exit;
}

try {
    // Usar movimento_produtos.id_contrato como filtro mas get em cliente_contrato_comodato
    $params = array(
        'qtype' => 'movimento_produtos.id_contrato',
        'query' => $id_contrato,
        'oper' => '=',
        'page' => '1',
        'rp' => '100',
        'sortname' => 'movimento_produtos.id',
        'sortorder' => 'desc'
    );

    $api->get('cliente_contrato_comodato', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    error_log('📥 Retorno verificar comodato: ' . $retorno);
    
    $resultado = json_decode($retorno, true);

    if (isset($resultado['registros']) && !empty($resultado['registros'])) {
        // Filtrar apenas comodatos com status 'E' (Emprestado/Saída)
        $comodatosAtivos = array_filter($resultado['registros'], function($comodato) {
            return isset($comodato['status_comodato']) && $comodato['status_comodato'] === 'E';
        });
        
        echo json_encode([
            'success' => true,
            'tem_comodato' => !empty($comodatosAtivos),
            'quantidade' => count($comodatosAtivos),
            'total_registros' => count($resultado['registros'])
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'tem_comodato' => false,
            'quantidade' => 0,
            'total_registros' => 0
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>
