<?php
// Sistema de envio de e-mail funcionando
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Função para log
function writeEmailLog($message) {
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[{$timestamp}] {$message}\n";
    file_put_contents('/tmp/email_log.txt', $log_entry, FILE_APPEND | LOCK_EX);
    error_log($message);
}

try {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'recuperar-senha') {
        $email = $_POST['email'] ?? '';
        $nome = $_POST['nome'] ?? 'Cliente';
        $senha = $_POST['senha'] ?? '';
        $telefone = $_POST['telefone'] ?? '';
        
        writeEmailLog("=== DEBUG EMAIL RECEBIDO ===");
        writeEmailLog("Email original recebido: '" . $email . "'");
        writeEmailLog("Nome recebido: '" . $nome . "'");
        writeEmailLog("Senha recebida: '" . $senha . "'");
        writeEmailLog("Telefone recebido: '" . $telefone . "'");
        writeEmailLog("Todos os POST data: " . print_r($_POST, true));
        
        if (empty($email) || empty($senha)) {
            throw new Exception('E-mail e senha são obrigatórios');
        }
        
        // Limpar e-mail - pegar apenas o primeiro se houver múltiplos
        $email = trim(explode(';', $email)[0]);
        $email = trim(explode(',', $email)[0]);
        
        writeEmailLog("=== INICIANDO ENVIO DE E-MAIL WORKING ===");
        writeEmailLog("Email final após limpeza: '" . $email . "'");
        writeEmailLog("Nome: " . $nome);
        writeEmailLog("Senha: " . $senha);
        
        // Configurações SMTP
        $smtp_host = 'milo.cactus.net.br';
        $smtp_port = 465;
        $smtp_username = 'atendimento@core3chip.com.br';
        $smtp_password = 'A@9025dfsty';
        
        // Criar o e-mail
        $subject = 'Recuperação de Senha Core3Business';
        
        // E-mail em HTML (formatado para evitar linhas muito longas)
        $html_body = "<!DOCTYPE html>\n<html>\n<head>\n<meta charset='UTF-8'>\n<style>\n" .
            "body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background-color: #f5f5f5; }\n" .
            ".container { max-width: 600px; margin: 0 auto; background: white; border-radius: 10px; overflow: hidden; }\n" .
            ".header { background: #2563eb; color: white; padding: 30px; text-align: center; }\n" .
            ".content { padding: 30px; }\n" .
            ".logo { font-size: 24px; font-weight: bold; margin-bottom: 10px; }\n" .
            ".message { font-size: 16px; line-height: 1.6; color: #333; margin-bottom: 20px; }\n" .
            ".password-box { background: #f8fafc; border: 2px solid #e2e8f0; border-radius: 8px; padding: 20px; text-align: center; margin: 20px 0; }\n" .
            ".password { font-size: 24px; font-weight: bold; color: #2563eb; font-family: monospace; }\n" .
            ".footer { background: #1f2937; color: white; padding: 20px; text-align: center; font-size: 14px; }\n" .
            ".warning { background: #fef2f2; border: 1px solid #fecaca; border-radius: 6px; padding: 15px; margin: 20px 0; color: #dc2626; }\n" .
            "</style>\n</head>\n<body>\n" .
            "<div class='container'>\n" .
            "<div class='header'>\n" .
            "<div class='logo'>📱 CORE3BUSINESS</div>\n" .
            "<div>A operadora que entende você</div>\n" .
            "</div>\n" .
            "<div class='content'>\n" .
            "<h2>Olá {$nome}!</h2>\n" .
            "<div class='message'>\n" .
            "Você solicitou a recuperação de sua senha de acesso ao app Core3Business:\n" .
            "</div>\n" .
            "<div class='password-box'>\n" .
            "<div>Sua senha é:</div>\n" .
            "<div class='password'>{$senha}</div>\n" .
            "</div>\n" .
            "<div class='message'>\n" .
            "<strong>Atenciosamente,<br>Core3Business</strong>\n" .
            "</div>\n" .
            "<div class='warning'>\n" .
            "<strong>⚠️ Importante:</strong><br>\n" .
            "Se você não solicitou a recuperação desta senha, entre em contato com nosso suporte no WhatsApp no número (75) 3023-7350<br>\n" .
            "<strong>Core3Business - A operadora que entende você!</strong>\n" .
            "</div>\n" .
            "</div>\n" .
            "<div class='footer'>\n" .
            "<div>Core3Business - Sistema de Recuperação de Senha</div>\n" .
            "<div>Enviado em " . date('d/m/Y H:i:s') . "</div>\n" .
            "</div>\n" .
            "</div>\n" .
            "</body>\n</html>";
        
        // E-mail em texto simples
        $text_body = "
CORE3BUSINESS - A operadora que entende você

Olá {$nome}!

Você solicitou a recuperação de sua senha de acesso ao app Core3Business:

Sua senha é: {$senha}

Atenciosamente,
Core3Business

IMPORTANTE: Se você não solicitou a recuperação desta senha, entre em contato com nosso suporte no WhatsApp no número (75) 3023-7350

Core3Business - A operadora que entende você!

Enviado em " . date('d/m/Y H:i:s');
        
        // Enviar e-mail
        $result = sendEmailWorking($smtp_host, $smtp_port, $smtp_username, $smtp_password, $email, $subject, $html_body, $text_body);
        
        if ($result) {
            echo json_encode([
                'success' => true,
                'message' => 'E-mail enviado com sucesso via SMTP',
                'email' => $email,
                'timestamp' => date('Y-m-d H:i:s')
            ]);
        } else {
            throw new Exception('Falha ao enviar e-mail via SMTP');
        }
        
    } elseif ($action === 'test') {
        echo json_encode([
            'success' => true,
            'message' => 'Serviço SMTP OK',
            'timestamp' => date('Y-m-d H:i:s')
        ]);
    } else {
        throw new Exception('Ação não especificada');
    }
    
} catch (Exception $e) {
    writeEmailLog("ERRO: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}

// Função que funciona (baseada no teste bem-sucedido)
function sendEmailWorking($host, $port, $username, $password, $to, $subject, $html_body, $text_body) {
    writeEmailLog("Iniciando conexão SMTP: {$host}:{$port}");
    
    try {
        // Conectar via SSL
        $context = stream_context_create([
            "ssl" => [
                "verify_peer" => false,
                "verify_peer_name" => false,
            ],
        ]);
        
        $socket = stream_socket_client(
            "ssl://{$host}:{$port}",
            $errno,
            $errstr,
            30,
            STREAM_CLIENT_CONNECT,
            $context
        );
        
        if (!$socket) {
            writeEmailLog("ERRO: Falha ao conectar: {$errstr} ({$errno})");
            return false;
        }
        
        writeEmailLog("Conectado ao SMTP via SSL");
        
        // Função para ler resposta (igual ao teste que funcionou)
        function readResponse($socket) {
            $response = '';
            while (($line = fgets($socket, 512)) !== false) {
                $response .= trim($line) . "\n";
                if (preg_match('/^\d{3}\s/', $line)) {
                    break;
                }
            }
            return trim($response);
        }
        
        // Ler resposta inicial
        $response = readResponse($socket);
        writeEmailLog("Resposta inicial recebida");
        
        // EHLO
        fputs($socket, "EHLO localhost\r\n");
        $response = readResponse($socket);
        writeEmailLog("EHLO enviado");
        
        // AUTH LOGIN
        fputs($socket, "AUTH LOGIN\r\n");
        $response = readResponse($socket);
        writeEmailLog("AUTH LOGIN enviado");
        
        // Username
        fputs($socket, base64_encode($username) . "\r\n");
        $response = readResponse($socket);
        writeEmailLog("Username enviado");
        
        // Password
        fputs($socket, base64_encode($password) . "\r\n");
        $response = readResponse($socket);
        writeEmailLog("Password enviado");
        
        // Verificar autenticação
        if (strpos($response, '235') !== false) {
            writeEmailLog("Autenticação bem-sucedida");
            
            // MAIL FROM
            fputs($socket, "MAIL FROM:<atendimento@core3chip.com.br>\r\n");
            $response = readResponse($socket);
            writeEmailLog("MAIL FROM enviado");
            
            // RCPT TO
            fputs($socket, "RCPT TO:<{$to}>\r\n");
            $response = readResponse($socket);
            writeEmailLog("RCPT TO enviado");
            
            // DATA
            fputs($socket, "DATA\r\n");
            $response = readResponse($socket);
            writeEmailLog("DATA enviado");
            
            // Função para quebrar linhas longas (RFC 5322 - máximo 998 caracteres por linha)
            function wrapLines($text, $maxLength = 78) {
                return wordwrap($text, $maxLength, "\r\n", true);
            }
            
            // Criar mensagem MIME
            $boundary = "boundary_" . md5(time());
            $email_data = "Subject: {$subject}\r\n";
            $email_data .= "From: Core3Chip <atendimento@core3chip.com.br>\r\n";
            $email_data .= "To: {$to}\r\n";
            $email_data .= "MIME-Version: 1.0\r\n";
            $email_data .= "Content-Type: multipart/alternative; boundary=\"{$boundary}\"\r\n";
            $email_data .= "\r\n";
            
            // Parte texto
            $email_data .= "--{$boundary}\r\n";
            $email_data .= "Content-Type: text/plain; charset=UTF-8\r\n";
            $email_data .= "\r\n";
            $email_data .= wrapLines($text_body) . "\r\n\r\n";
            
            // Parte HTML
            $email_data .= "--{$boundary}\r\n";
            $email_data .= "Content-Type: text/html; charset=UTF-8\r\n";
            $email_data .= "\r\n";
            $email_data .= wrapLines($html_body) . "\r\n\r\n";
            
            $email_data .= "--{$boundary}--\r\n";
            $email_data .= "\r\n.\r\n";
            
            fputs($socket, $email_data);
            $response = readResponse($socket);
            writeEmailLog("E-mail enviado: " . substr($response, 0, 50));
            
            // QUIT
            fputs($socket, "QUIT\r\n");
            fclose($socket);
            
            if (strpos($response, '250') !== false) {
                writeEmailLog("E-mail enviado com sucesso para: {$to}");
                return true;
            } else {
                writeEmailLog("ERRO: Falha no envio: " . $response);
                return false;
            }
            
        } else {
            writeEmailLog("ERRO: Falha na autenticação: " . $response);
            fclose($socket);
            return false;
        }
        
    } catch (Exception $e) {
        writeEmailLog("ERRO SMTP: " . $e->getMessage());
        if (isset($socket) && $socket) {
            fclose($socket);
        }
        return false;
    }
}
?>
