<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

try {
    $input = file_get_contents('php://input');
    $json = json_decode($input, true);
    $id_almox = $_POST['id_almox'] ?? ($json['id_almox'] ?? null);

    if (empty($id_almox)) {
        echo json_encode(['success' => false, 'message' => 'id_almox não informado']);
        exit;
    }

    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;

    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

    $params = array(
        'qtype' => 'estoque_produtos_almox_filial.id_almox',
        'query' => (string)$id_almox,
        'oper' => '=',
        'page' => '1',
        'rp' => '1000',
        'sortname' => 'estoque_produtos_almox_filial.id',
        'sortorder' => 'desc'
    );

    $api->get('estoque_produtos_almox_filial', $params);
    $ret = $api->getRespostaConteudo(false);
    $dados = json_decode($ret, true);

    $registros = isset($dados['registros']) && is_array($dados['registros']) ? $dados['registros'] : [];

    // Buscar dados complementares de cada produto (unidade_sigla e fator_conversao)
    foreach ($registros as &$produto) {
        $id_unidade = $produto['produto_unidade'] ?? null;
        
        if ($id_unidade) {
            // Buscar dados da unidade
            $paramsUnidade = array(
                'qtype' => 'unidade.id',
                'query' => (string)$id_unidade,
                'oper' => '=',
                'page' => '1',
                'rp' => '1'
            );
            
            $api->get('unidade', $paramsUnidade);
            $retUnidade = $api->getRespostaConteudo(false);
            $dadosUnidade = json_decode($retUnidade, true);
            
            if (isset($dadosUnidade['registros'][0])) {
                $unidade = $dadosUnidade['registros'][0];
                $produto['unidade_sigla'] = $unidade['sigla'] ?? 'UN';
                $produto['fator_conversao'] = $unidade['fator_conversao'] ?? '1.000000000';
            } else {
                $produto['unidade_sigla'] = 'UN';
                $produto['fator_conversao'] = '1.000000000';
            }
        } else {
            $produto['unidade_sigla'] = 'UN';
            $produto['fator_conversao'] = '1.000000000';
        }
    }

    echo json_encode([
        'success' => true,
        'produtos' => $registros,
        'total' => count($registros)
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>


