<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

try {
    // Aceitar JSON e form-data
    $input = file_get_contents('php://input');
    $json = json_decode($input, true);
    $id_usuario = $_POST['id_usuario'] ?? ($json['id_usuario'] ?? null);

    if (empty($id_usuario)) {
        echo json_encode(['success' => false, 'message' => 'id_usuario não informado']);
        exit;
    }

    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;

    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

    // Buscar todos os vínculos de almox do usuário e filtrar padrao_usuario = 'S' no PHP
    $params = array(
        'qtype' => 'almox_usuario.id_usuario',
        'query' => (string)$id_usuario,
        'oper' => '=',
        'page' => '1',
        'rp' => '1000',
        'sortname' => 'almox_usuario.id',
        'sortorder' => 'desc'
    );

    $api->get('almox_usuario', $params);
    $ret = $api->getRespostaConteudo(false);
    $dados = json_decode($ret, true);

    if (!isset($dados['registros']) || count($dados['registros']) === 0) {
        echo json_encode(['success' => false, 'message' => 'Usuário sem almox vinculado']);
        exit;
    }

    $padrao = null;
    foreach ($dados['registros'] as $v) {
        if (isset($v['padrao_usuario']) && strtoupper($v['padrao_usuario']) === 'S') {
            $padrao = $v;
            break;
        }
    }

    if (!$padrao) {
        // fallback: primeiro registro
        $padrao = $dados['registros'][0];
    }

    echo json_encode([
        'success' => true,
        'id_almox' => $padrao['id_almox'] ?? null,
        'registro' => $padrao,
        'total_vinculos' => count($dados['registros'])
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>


