<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

try {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    $id_login = $_POST['id_login'] ?? $data['id_login'] ?? null;
    if (empty($id_login)) {
        throw new Exception('ID do login não informado');
    }

    require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

    // Mesmas credenciais já utilizadas com sucesso para radpop_radio_cliente_fibra
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;

    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

    // Passo 1: Obter o registro da fibra pelo id_login
    $paramsFibra = array(
        'qtype' => 'radpop_radio_cliente_fibra.id_login',
        'query' => $id_login,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'radpop_radio_cliente_fibra.id',
        'sortorder' => 'desc'
    );
    $api->get('radpop_radio_cliente_fibra', $paramsFibra);
    $retFibra = $api->getRespostaConteudo(false);
    $dadosFibra = json_decode($retFibra, true);

    if (!isset($dadosFibra['registros'][0]['id'])) {
        throw new Exception('Registro de fibra não encontrado para este id_login');
    }

    $id_cliente_fibra = $dadosFibra['registros'][0]['id'];

    // Passo 2: Consultar histórico usando o id do cliente fibra
    $api2 = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    // Preferindo filtrar por id_cliente_fibra
    $paramsHistorico = array(
        'qtype' => 'radpop_radio_cliente_fibra_historico.id_cliente_fibra',
        'query' => (string)$id_cliente_fibra,
        'oper' => '=',
        'page' => '1',
        'rp' => '100',
        'sortname' => 'radpop_radio_cliente_fibra_historico.id',
        'sortorder' => 'desc'
    );
    $api2->get('radpop_radio_cliente_fibra_historico', $paramsHistorico);
    $retHistorico = $api2->getRespostaConteudo(false);
    $dadosHistorico = json_decode($retHistorico, true);

    $registros = isset($dadosHistorico['registros']) && is_array($dadosHistorico['registros'])
        ? $dadosHistorico['registros']
        : [];

    // Normalizar campos de data e sinal para facilitar no app
    $normalizados = [];
    foreach ($registros as $r) {
        $dataBruta = '';
        // Tentar primeiro 'data_sinal' (comum nesse endpoint)
        foreach (['data_sinal', 'data', 'data_hora', 'criado_em', 'created_at', 'data_mov', 'data_alteracao', 'timestamp', 'datahora', 'data_evento', 'data_registro', 'dt_cad', 'dt', 'data_update'] as $k) {
            if (!empty($r[$k])) { $dataBruta = $r[$k]; break; }
        }
        $dataFormatada = $dataBruta;
        // Tentar converter para Y-m-d H:i:s
        if (!empty($dataBruta)) {
            // Se vier em timestamp numérico
            if (is_numeric($dataBruta)) {
                $dataFormatada = date('d/m/Y H:i:s', (int)$dataBruta);
            } else {
                $ts = strtotime(str_replace('/', '-', (string)$dataBruta));
                if ($ts) { $dataFormatada = date('d/m/Y H:i:s', $ts); }
            }
        }

        $sinal = '';
        foreach (['sinal_rx', 'sinal', 'power_rx', 'potencia_rx', 'rx', 'nivel_rx'] as $k) {
            if (isset($r[$k]) && $r[$k] !== '' && $r[$k] !== null) { $sinal = $r[$k]; break; }
        }

        $r['data_formatada'] = $dataFormatada ?: '';
        $r['sinal_rx_normalizado'] = $sinal;
        $normalizados[] = $r;
    }

    echo json_encode(array(
        'success' => true,
        'id_cliente_fibra' => $id_cliente_fibra,
        'historico' => $normalizados,
        'total' => count($normalizados)
    ));
} catch (Exception $e) {
    echo json_encode(array('success' => false, 'message' => $e->getMessage()));
}
?>


