<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

try {
    // Aceitar tanto JSON quanto form-data
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);
    
    $id_login = $_POST['login'] ?? $data['login'] ?? null;
    
    if (empty($id_login)) {
        throw new Exception('ID do login não informado');
    }
    
    require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');
    
    // TOKEN que funciona com radpop_radio_cliente_fibra
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;
    
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    // ========================================
    // ETAPA 1: Buscar dados da fibra
    // ========================================
    $params = array(
        'qtype' => 'radpop_radio_cliente_fibra.id_login',
        'query' => $id_login,
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'radpop_radio_cliente_fibra.id',
        'sortorder' => 'desc'
    );
    
    $api->get('radpop_radio_cliente_fibra', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    $decoded = json_decode($retorno, true);
    
    if (!isset($decoded['registros']) || empty($decoded['registros'])) {
        throw new Exception('Nenhum registro encontrado para id_login: ' . $id_login);
    }
    
    $dadosFibra = $decoded['registros'][0];
    
    $ponid = $dadosFibra['ponid'] ?? null;
    $onu_numero = $dadosFibra['onu_numero'] ?? null;
    $id_transmissor = $dadosFibra['id_transmissor'] ?? null;
    
    if (!$id_transmissor) {
        throw new Exception('id_transmissor não encontrado');
    }
    
    // ========================================
    // ETAPA 2: Buscar dados do transmissor (OLT)
    // ========================================
    $api2 = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    $paramsTransmissor = array(
        'qtype' => 'radpop_radio.id',
        'query' => $id_transmissor,
        'oper' => '=',
        'page' => '1',
        'rp' => '1',
        'sortname' => 'radpop_radio.id',
        'sortorder' => 'desc'
    );
    
    $api2->get('radpop_radio', $paramsTransmissor);
    $retornoTransmissor = $api2->getRespostaConteudo(false);
    
    $decodedTransmissor = json_decode($retornoTransmissor, true);
    
    if (!isset($decodedTransmissor['registros']) || empty($decodedTransmissor['registros'])) {
        throw new Exception('Transmissor não encontrado para id: ' . $id_transmissor);
    }
    
    $dadosTransmissor = $decodedTransmissor['registros'][0];
    
    $ip_olt = $dadosTransmissor['ip'] ?? null;
    $descricao_olt = $dadosTransmissor['descricao'] ?? 'N/A';
    
    if (!$ip_olt) {
        throw new Exception('IP da OLT não encontrado');
    }
    
    // ========================================
    // ETAPA 3: Conectar na OLT via SSH
    // ========================================
    $usuario_olt = 'dash';
    $senha_olt = 'dash2020';
    $comando_ssh = "show interface gpon {$ponid} onu";
    
    // Executar SSH usando sshpass
    $shell_command = sprintf(
        "sshpass -p %s ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o ConnectTimeout=10 %s@%s %s 2>&1",
        escapeshellarg($senha_olt),
        escapeshellarg($usuario_olt),
        escapeshellarg($ip_olt),
        escapeshellarg($comando_ssh)
    );
    
    $resultado_olt = shell_exec($shell_command);
    
    if (empty($resultado_olt)) {
        $resultado_olt = "⚠️ Não foi possível executar o comando na OLT.\n";
        $resultado_olt .= "IP: {$ip_olt}\n";
        $resultado_olt .= "Comando: {$comando_ssh}\n";
        $resultado_olt .= "Verifique se sshpass está instalado no servidor.";
    }
    
    // ========================================
    // ETAPA 3.5: Parsear resultado OLT
    // ========================================
    $onus = array();
    
    // Extrair linhas de ONUs do resultado
    $linhas = explode("\n", $resultado_olt);
    foreach ($linhas as $linha) {
        // Padrão: 1/1/2     32       MSTC03A16DCC    Up           None                         GROOT
        if (preg_match('/^(\d+\/\d+\/\d+)\s+(\d+)\s+(\S+)\s+(Up|Down)\s+\S+\s+(.+)$/', trim($linha), $matches)) {
            $onus[] = array(
                'interface' => trim($matches[1]),
                'onu_id' => trim($matches[2]),
                'serial' => trim($matches[3]),
                'status' => trim($matches[4]),
                'nome' => trim($matches[5])
            );
        }
    }
    
    // ========================================
    // ETAPA 4: Preparar resposta
    // ========================================
    $resultado = array(
        'success' => true,
        'dados' => array(
            'id' => $dadosFibra['id'] ?? '',
            'nome' => $dadosFibra['nome'] ?? '',
            'mac' => $dadosFibra['mac'] ?? 'N/A',
            'ponid' => $ponid,
            'onu_numero' => $onu_numero,
            'id_transmissor' => $id_transmissor,
            'ip' => $ip_olt,
            'nome_olt' => $descricao_olt,
            'ftth_porta' => $dadosFibra['ftth_porta'] ?? 'N/A',
            'id_caixa_ftth' => $dadosFibra['id_caixa_ftth'] ?? 'N/A'
        ),
        'resultado_olt' => $resultado_olt,
        'onus' => $onus,
        'total_onus' => count($onus),
        'onus_up' => count(array_filter($onus, function($o) { return $o['status'] === 'Up'; })),
        'onus_down' => count(array_filter($onus, function($o) { return $o['status'] === 'Down'; }))
    );
    
    echo json_encode($resultado);
    
} catch (Exception $e) {
    echo json_encode(array('success' => false, 'message' => $e->getMessage()));
}
?>
