<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $clienteId = $_POST['cliente_id'] ?? null;
    $mensagem = $_POST['mensagem'] ?? null;
    $idContratoKit = $_POST['id_contrato_kit'] ?? null;

    if (!$clienteId || !$mensagem) {
        throw new Exception('ID do cliente ou mensagem não fornecidos');
    }

    $dados = array(
        'tipo' => 'C', // C = Chamado
        'id_assunto' => '42', // Assunto padrão para Core3Business
        'id_cliente' => $clienteId,
        'id_filial' => '11', // Filial padrão
        'prioridade' => 'A', // A = Alta
        'melhor_horario_agenda' => 'Q', // Q = Qualquer horário
        'setor' => '5', // Setor padrão para Core3Business
        'mensagem' => $mensagem,
        'status' => 'A', // A = Aberto
        'origem_cadastro' => 'P', // P = Portal do Cliente
        'origem_endereco' => 'CC', // CC = Endereço do Contrato
        'origem_endereco_estrutura' => 'E', // E = Estrutura
        'id_cidade' => '', // Cidade padrão do cliente
    );

    // Adicionar id_contrato_kit se fornecido
    if ($idContratoKit) {
        $dados['id_contrato_kit'] = $idContratoKit;
    }

    $api->post('su_oss_chamado', $dados);
    $retorno = $api->getRespostaConteudo(false);

    echo json_encode(['success' => true, 'data' => $retorno, 'message' => 'Chamado de suporte criado com sucesso']);

} catch (Exception $e) {
    error_log('Erro na API de abrir suporte Core3Business: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
