<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $id_almox = $input['id_almox'] ?? '';
    
    if (empty($id_almox)) {
        echo json_encode([
            'success' => false,
            'message' => 'ID do almoxarifado não informado'
        ]);
        exit;
    }
    
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;
    
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    // Buscar estoque de produtos do almoxarifado
    $params = array(
        'qtype' => 'estoque_produtos_almox_filial.id',
        'query' => '1',
        'oper' => '>=',
        'page' => '1',
        'rp' => '2000',
        'sortname' => 'estoque_produtos_almox_filial.id',
        'sortorder' => 'desc',
        'grid_param' => '[{"TB":"estoque_produtos_almox_filial.id_almox", "OP" : "=", "P" : "' . $id_almox . '"}]'
    );
    
    $api->get('estoque_produtos_almox_filial', $params);
    $retorno = $api->getRespostaConteudo(false);
    $data = json_decode($retorno, true);
    
    if (isset($data['registros'])) {
        // Filtrar apenas produtos com saldo > 0
        $produtosDisponiveis = array_filter($data['registros'], function($produto) {
            return floatval($produto['saldo']) > 0;
        });
        
        // Reindexar array
        $produtosDisponiveis = array_values($produtosDisponiveis);
        
        echo json_encode([
            'success' => true,
            'produtos' => $produtosDisponiveis,
            'total' => count($produtosDisponiveis),
            'id_almox' => $id_almox
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Nenhum produto encontrado'
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
