<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $id_contrato = $input['id_contrato'] ?? '';
    
    if (empty($id_contrato)) {
        echo json_encode([
            'success' => false,
            'message' => 'ID do contrato não informado'
        ]);
        exit;
    }
    
    $host = 'https://app.core3.com.br/webservice/v1';
    $token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
    $selfSigned = true;
    
    $api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);
    
    // Buscar comodatos do contrato (últimos 30 dias para garantir)
    $dataInicio = date('Y-m-d', strtotime('-30 days'));
    
    $params = array(
        'qtype' => 'cliente_contrato_comodato.id_contrato',
        'query' => $id_contrato,
        'oper' => '=',
        'page' => '1',
        'rp' => '100',
        'sortname' => 'cliente_contrato_comodato.id',
        'sortorder' => 'desc',
        'grid_param' => '[{"TB":"cliente_contrato_comodato.data", "OP" : ">=", "P" : "' . $dataInicio . '"}]'
    );
    
    $api->get('cliente_contrato_comodato', $params);
    $retorno = $api->getRespostaConteudo(false);
    $data = json_decode($retorno, true);
    
    $tem_comodato = isset($data['registros']) && count($data['registros']) > 0;
    
    error_log("📦 Verificar comodato - Contrato: $id_contrato - Tem: " . ($tem_comodato ? 'SIM' : 'NÃO') . " - Total: " . (isset($data['registros']) ? count($data['registros']) : 0));
    
    echo json_encode([
        'success' => true,
        'tem_comodato' => $tem_comodato,
        'total_comodatos' => $tem_comodato ? count($data['registros']) : 0,
        'id_contrato' => $id_contrato,
        'data_filtro' => $dataInicio
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
