<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $idLogin = $_POST['id_login'] ?? null;

    if (!$idLogin) {
        throw new Exception('ID do login não fornecido');
    }

    // Primeiro: Buscar o id_cliente_fibra usando o id_login
    $paramsFibra = array(
        'qtype' => 'radpop_radio_cliente_fibra.id_login',
        'query' => $idLogin,
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'radpop_radio_cliente_fibra.id',
        'sortorder' => 'desc'
    );

    $api->get('radpop_radio_cliente_fibra', $paramsFibra);
    $retornoFibra = $api->getRespostaConteudo(false);
    
    $dadosFibra = json_decode($retornoFibra, true);
    
    if (!$dadosFibra || !isset($dadosFibra['registros']) || empty($dadosFibra['registros'])) {
        throw new Exception('Cliente fibra não encontrado para este login');
    }
    
    $idClienteFibra = $dadosFibra['registros'][0]['id'];
    
    // Segundo: Buscar o status da ONU usando o id_cliente_fibra
    $paramsOnu = array(
        'id' => $idClienteFibra
    );
    
    $api->post('botao_rel_22991', $paramsOnu);
    $retornoOnu = $api->getRespostaConteudo(false);
    
    // Tentar fazer parse do HTML retornado
    $html = $retornoOnu;
    
    // Debug: salvar HTML para análise
    error_log('HTML retornado: ' . substr($html, 0, 1000));
    
    // Extrair informações específicas do HTML
    $mac = '';
    $macLan = '';
    $sinalRx = '';
    $sinalTx = '';
    $distance = '';
    $operationalState = '';
    $lastUpdate = '';
    $name = '';
    $gponInfo = '';
    $onuOnline = '';
    
    // Padrões para extrair dados do HTML
    if (preg_match('/Mac: MSTCFFF2E336/', $html, $matches)) {
        $mac = 'MSTCFFF2E336';
    }
    
    if (preg_match('/Mac lan: ([A-Fa-f0-9:]+)/', $html, $matches)) {
        $macLan = trim($matches[1]);
    }
    
    if (preg_match('/Sinal Rx: ([0-9.-]+)/', $html, $matches)) {
        $sinalRx = trim($matches[1]);
    }
    
    if (preg_match('/Sinal Tx: ([0-9.-]+)/', $html, $matches)) {
        $sinalTx = trim($matches[1]);
    }
    
    if (preg_match('/Distance: ([0-9.-]+)/', $html, $matches)) {
        $distance = trim($matches[1]);
    }
    
    if (preg_match('/Operational state: ([A-Za-z]+)/', $html, $matches)) {
        $operationalState = trim($matches[1]);
    }
    
    if (preg_match('/Last updated: ([0-9-:\s]+UTC-3)/', $html, $matches)) {
        $lastUpdate = trim($matches[1]);
    }
    
    if (preg_match('/Name: ([^<]+)/', $html, $matches)) {
        $name = trim(strip_tags($matches[1]));
    }
    
    if (preg_match('/Gpon Information[:\s]+([^<]+)/', $html, $matches)) {
        $gponInfo = trim(strip_tags($matches[1]));
    }
    
    if (preg_match('/Onu online: ([0-9]+)/', $html, $matches)) {
        $onuOnline = trim($matches[1]);
    }
    
    // Retornar dados estruturados
    $dadosEstruturados = array(
        'mac' => $mac,
        'mac_lan' => $macLan,
        'sinal_rx' => $sinalRx,
        'sinal_tx' => $sinalTx,
        'distance' => $distance,
        'operational_state' => $operationalState,
        'last_update' => $lastUpdate,
        'name' => $name,
        'gpon_information' => $gponInfo,
        'onu_online' => $onuOnline,
        'id_cliente_fibra' => $idClienteFibra
    );
    
    echo json_encode([
        'success' => true, 
        'data' => $dadosEstruturados,
        'message' => 'Status ONU obtido com sucesso'
    ]);

} catch (Exception $e) {
    error_log('Erro ao consultar status ONU: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
