<?php
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="contrato.pdf"');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Lidar com requisições OPTIONS (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

//requerindo arquivo do webservice
require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1'; //IP do seu sistema
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d'; // token do usuário API
$selfSigned = true;
//true para certificado auto assinado (Certificado SSL - true para HTTPS ; false para HTTP)
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    // Verificar se foi enviado o ID do contrato
    $contratoId = $_GET['contrato_id'] ?? null;
    
    if (!$contratoId) {
        throw new Exception('ID do contrato não fornecido');
    }
    
    // Parâmetros para obter o contrato
    $params = array(
        'id' => $contratoId // ID do contrato
    );
    
    $api->get('cliente_contrato_imprimir_contrato_17678', $params);
    $retorno = $api->getRespostaConteudo(false); //false para json | true para array
    
    // Decodificar o base64 e enviar como PDF
    $pdfBase64 = $retorno;
    $pdfData = base64_decode($pdfBase64);
    
    // Definir headers para PDF
    header('Content-Length: ' . strlen($pdfData));
    header('Cache-Control: no-cache, must-revalidate');
    header('Pragma: no-cache');
    
    // Enviar o PDF
    echo $pdfData;
    
} catch (Exception $e) {
    http_response_code(500);
    header('Content-Type: text/plain');
    echo 'Erro ao obter contrato: ' . $e->getMessage();
}
?>
