<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $loginId = $_POST['login_id'] ?? null;
    $dataInicial = $_POST['data_inicial'] ?? null;
    $dataFinal = $_POST['data_final'] ?? null;

    if (!$loginId) {
        throw new Exception('ID do login não fornecido');
    }

    $gridParam = array();
    
    if ($dataInicial) {
        $gridParam[] = array('TB' => 'radusuarios_consumo_d.data', 'OP' => '>=', 'P' => $dataInicial);
    }
    
    if ($dataFinal) {
        $gridParam[] = array('TB' => 'radusuarios_consumo_d.data', 'OP' => '<=', 'P' => $dataFinal);
    }

    $params = array(
        'qtype' => 'radusuarios_consumo_d.id_login',
        'query' => $loginId,
        'oper' => '=',
        'page' => '1',
        'rp' => '1000',
        'sortname' => 'radusuarios_consumo_d.data',
        'sortorder' => 'desc'
    );
    
    if (!empty($gridParam)) {
        $params['grid_param'] = json_encode($gridParam);
    }

    $api->get('radusuarios_consumo_d', $params);
    $retorno = $api->getRespostaConteudo(false);

    echo json_encode(['success' => true, 'data' => $retorno, 'message' => 'Consumo diário obtido com sucesso']);

} catch (Exception $e) {
    error_log('Erro ao buscar consumo diário: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
