<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Configurações da API EFI PIX
$client_id = 'Client_Id_fa3b44ec67109bb5173cabeb7e73c50da9056595';
$client_secret = 'Client_Secret_dca55fea80685f8ce4201a4f7e2a8cd75c76e129';
$base_url = 'https://pix.api.efipay.com.br';
$certificate_path = __DIR__ . '/certificates/certificado-novo.pem';

// Configurações do IXC para baixa de fatura
$ixc_base_url = 'https://app.core3.com.br'; // Domínio real do IXC
$ixc_token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9'; // Token real do IXC

// Função para dar baixa na fatura via IXC
function darBaixaFaturaIXC($fatura_data, $pix_valor = null) {
    global $ixc_base_url, $ixc_token;
    
    try {
        // Usar o valor real do PIX se fornecido, senão usar valor da fatura
        $valor_recebido = $pix_valor ?? ($fatura_data['valor_aberto'] ?? $fatura_data['valor']);
        
        
        // Preparar dados para baixa da fatura (formato completo IXC)
        $baixa_data = [
            "filial" => $fatura_data['filial_id'] ?? "11",
            "filial_label" => "Filial " . ($fatura_data['filial_id'] ?? "11"),
            "id_receber" => $fatura_data['id'] ?? "",
            "id_receber_label" => $fatura_data['documento'] ?? "",
            "conta_" => $fatura_data['id_conta'] ?? "174",
            "conta__label" => "Conta PIX",
            "id_conta_class_finan_a" => "",
            "id_conta_class_finan_a_label" => "",
            "tipo_recebimento" => "P", // P para PIX
            "cheque_banco" => "",
            "cheque_numero" => "",
            "cheque_nome" => "",
            "cheque_predatado" => "",
            "id_conta" => $fatura_data['id_conta'] ?? "174",
            "data" => date('d/m/Y'),
            "documento" => $fatura_data['documento'] ?? "",
            "pdesconto" => "0.000",
            "vdesconto" => "0,00",
            "id_motivo_desconto" => "",
            "id_motivo_desconto_label" => "",
            "pacrescimo" => "0.000",
            "vacrescimo" => "0,00",
            "valor_parcela" => number_format($valor_recebido, 2, ',', '.'),
            "credito" => number_format($valor_recebido, 2, ',', '.'),
            "valor_total_recebido" => number_format($valor_recebido, 2, ',', '.'),
            "valor_recebido_dinheiro" => "",
            "valor_troco" => "",
            "valor_total_juros_multa" => "0,00",
            "valor_total_areceber" => number_format($valor_recebido, 2, ',', '.'),
            "historico" => "Pagamento PIX confirmado automaticamente",
            "tipo_r" => "T", // T para Transferência
            "tipo_lanc" => "R", // R para Recebimento
            "filial_id" => $fatura_data['filial_id'] ?? "11"
        ];
        
        
        // Fazer requisição para API do IXC
        
        $curl = curl_init();
        
        curl_setopt_array($curl, [
            CURLOPT_URL => $ixc_base_url . '/webservice/v1/fn_areceber_recebimentos_baixas_novo',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($baixa_data),
            CURLOPT_USERPWD => $ixc_token, // Basic Auth com user:password
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Accept: application/json'
            ],
        ]);
        
        $response = curl_exec($curl);
        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $curl_error = curl_error($curl);
        
        curl_close($curl);
        
        
        if ($curl_error) {
            throw new Exception("Erro cURL: " . $curl_error);
        }
        
        if ($http_code !== 200) {
            throw new Exception("Erro HTTP: " . $http_code . " - Resposta: " . $response);
        }
        
        $result = json_decode($response, true);
        
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Erro ao decodificar JSON: " . json_last_error_msg());
        }
        
        return [
            'success' => true,
            'http_code' => $http_code,
            'response' => $result,
            'message' => 'Baixa da fatura realizada com sucesso'
        ];
        
    } catch (Exception $e) {
        error_log("IXC Baixa - Erro: " . $e->getMessage());
        return [
            'success' => false,
            'error' => $e->getMessage(),
            'message' => 'Erro ao dar baixa na fatura'
        ];
    }
}

// Função para obter token de acesso - SEGUINDO EXEMPLO OFICIAL EFI
function getAccessToken($client_id, $client_secret, $certificate_path) {
    $autorizacao = base64_encode($client_id . ":" . $client_secret);
    
    $curl = curl_init();
    
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://pix.api.efipay.com.br/oauth/token", // Produção
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => '{"grant_type": "client_credentials"}',
        CURLOPT_SSLCERT => $certificate_path, // Caminho do certificado
        CURLOPT_SSLKEY => $certificate_path, // Caminho da chave privada
        CURLOPT_SSLCERTPASSWD => "",
        CURLOPT_SSLKEYPASSWD => "",
        CURLOPT_HTTPHEADER => array(
            "Authorization: Basic $autorizacao",
            "Content-Type: application/json"
        ),
    ));
    
    $response = curl_exec($curl);
    $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $error = curl_error($curl);
    
    curl_close($curl);
    
    if ($error) {
        error_log("Erro cURL: " . $error);
        return ['error' => 'Erro na comunicação: ' . $error];
    }
    
    if ($http_code !== 200) {
        error_log("HTTP Error: " . $http_code . " - " . $response);
        return ['error' => 'Erro HTTP: ' . $http_code, 'response' => $response];
    }
    
    return json_decode($response, true);
}

// Função para criar cobrança PIX
function createPixCharge($access_token, $fatura_data, $certificate_path) {
    $url = 'https://pix.api.efipay.com.br/v2/cob';
    
    // Preparar dados da cobrança
    $charge_data = [
        'calendario' => [
            'expiracao' => 3600 // 1 hora
        ],
        'valor' => [
            'original' => number_format($fatura_data['valor'], 2, '.', '')
        ],
        'chave' => $fatura_data['chave'],
        'solicitacaoPagador' => $fatura_data['descricao']
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Accept-Encoding: identity',
        'Authorization: Bearer ' . $access_token
    ]);
    
    // Configurar certificado
    curl_setopt($ch, CURLOPT_SSLCERT, $certificate_path);
    curl_setopt($ch, CURLOPT_SSLKEY, $certificate_path);
    curl_setopt($ch, CURLOPT_SSLCERTPASSWD, '');
    curl_setopt($ch, CURLOPT_SSLKEYPASSWD, '');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    
    $data = json_encode($charge_data);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        error_log("Erro cURL na cobrança: " . $error);
        return ['error' => 'Erro na comunicação: ' . $error];
    }
    
    if ($http_code !== 201) {
        error_log("HTTP Error na cobrança: " . $http_code . " - " . $response);
        return ['error' => 'Erro HTTP: ' . $http_code, 'response' => $response];
    }
    
    $result = json_decode($response, true);
    
    return $result;
}

// Função para gerar QR Code
function generateQRCode($access_token, $txid, $certificate_path) {
    $url = 'https://pix.api.efipay.com.br/v2/qrcode/' . $txid;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept-Encoding: identity',
        'Authorization: Bearer ' . $access_token
    ]);
    
    // Configurar certificado
    curl_setopt($ch, CURLOPT_SSLCERT, $certificate_path);
    curl_setopt($ch, CURLOPT_SSLKEY, $certificate_path);
    curl_setopt($ch, CURLOPT_SSLCERTPASSWD, '');
    curl_setopt($ch, CURLOPT_SSLKEYPASSWD, '');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        error_log("Erro cURL no QR Code: " . $error);
        return ['error' => 'Erro na comunicação: ' . $error];
    }
    
    if ($http_code !== 200) {
        error_log("HTTP Error no QR Code: " . $http_code . " - " . $response);
        return ['error' => 'Erro HTTP: ' . $http_code];
    }
    
    return json_decode($response, true);
}

// Processar requisição
$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'test_auth':
        // Testar apenas autenticação
        $token_result = getAccessToken($client_id, $client_secret, $certificate_path);
        echo json_encode($token_result);
        break;
        
    case 'create_pix_charge':
        $fatura_data = json_decode($_POST['fatura_data'], true);
        
        if (!$fatura_data) {
            echo json_encode(['error' => 'Dados da fatura não fornecidos']);
            exit;
        }
        
        // Obter token de acesso
        $token_result = getAccessToken($client_id, $client_secret, $certificate_path);
        
        if (isset($token_result['error'])) {
            echo json_encode($token_result);
            exit;
        }
        
        $access_token = $token_result['access_token'];
        
        // Criar cobrança PIX
        $charge_result = createPixCharge($access_token, $fatura_data, $certificate_path);
        
        if (isset($charge_result['error'])) {
            echo json_encode($charge_result);
            exit;
        }
        
        // Retornar resultado completo
        echo json_encode([
            'success' => true,
            'txid' => $charge_result['txid'],
            'status' => $charge_result['status'],
            'valor' => $charge_result['valor']['original'],
            'chave' => $charge_result['chave'],
            'solicitacaoPagador' => $charge_result['solicitacaoPagador'],
            'pixCopiaECola' => $charge_result['pixCopiaECola'],
            'location' => $charge_result['location'],
            'expires_at' => $charge_result['calendario']['criacao']
        ]);
        break;
        
    case 'check_payment':
        $txid = $_POST['txid'] ?? '';
        
        if (!$txid) {
            echo json_encode(['error' => 'TXID não fornecido']);
            exit;
        }
        
        // Obter token de acesso
        $token_result = getAccessToken($client_id, $client_secret, $certificate_path);
        
        if (isset($token_result['error'])) {
            echo json_encode($token_result);
            exit;
        }
        
        $access_token = $token_result['access_token'];
        
        // Consultar cobrança
        $url = 'https://pix.api.efipay.com.br/v2/cob/' . $txid;
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Accept-Encoding: identity',
            'Authorization: Bearer ' . $access_token
        ]);
        
        // Configurar certificado
        curl_setopt($ch, CURLOPT_SSLCERT, $certificate_path);
        curl_setopt($ch, CURLOPT_SSLKEY, $certificate_path);
        curl_setopt($ch, CURLOPT_SSLCERTPASSWD, '');
        curl_setopt($ch, CURLOPT_SSLKEYPASSWD, '');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);
        
        if ($error) {
            echo json_encode(['error' => 'Erro na comunicação: ' . $error]);
            exit;
        }
        
        if ($http_code !== 200) {
            echo json_encode(['error' => 'Erro HTTP: ' . $http_code]);
            exit;
        }
        
        $result = json_decode($response, true);
        
        // Verificar se há pagamentos PIX
        $paid = false;
        if (isset($result['pix']) && is_array($result['pix']) && count($result['pix']) > 0) {
            $paid = true;
            
            // Se pagamento confirmado, dar baixa na fatura via IXC
            if ($paid && isset($_POST['fatura_data'])) {
                
                $fatura_data = json_decode($_POST['fatura_data'], true);
                if ($fatura_data) {
                    
                    // Extrair valor real do PIX dos dados de pagamento
                    $pix_valor = null;
                    if (isset($result['pix']) && is_array($result['pix']) && count($result['pix']) > 0) {
                        $pix_valor = $result['pix'][0]['valor'] ?? null;
                    }
                    
                    
                    $baixa_result = darBaixaFaturaIXC($fatura_data, $pix_valor);
                }
            }
        }
        
        echo json_encode([
            'success' => true,
            'status' => $result['status'] ?? 'ATIVA',
            'paid' => $paid,
            'pix_data' => $result['pix'] ?? []
        ]);
        break;
        
    default:
        echo json_encode(['error' => 'Ação não especificada']);
        break;
}
?>