<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, ixcsoft');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require(__DIR__ . DIRECTORY_SEPARATOR . 'WebserviceClient.php');

$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:e6dd49bd36efd72ac97b5e2abeb2fb09dbb081a597a7b2dd19d82926bb2f73a9';
$selfSigned = true;
$api = new IXCsoft\WebserviceClient($host, $token, $selfSigned);

try {
    $chamadoId = $_POST['chamado_id'] ?? null;

    if (!$chamadoId) {
        throw new Exception('ID do chamado não fornecido');
    }

    $params = array(
        'qtype' => 'su_oss_chamado_mensagem.id_chamado',
        'query' => $chamadoId,
        'oper' => '=',
        'page' => '1',
        'rp' => '1000',
        'sortname' => 'su_oss_chamado_mensagem.id',
        'sortorder' => 'desc'
    );

    $api->get('su_oss_chamado_mensagem', $params);
    $retorno = $api->getRespostaConteudo(false);

    echo json_encode(['success' => true, 'data' => $retorno, 'message' => 'Mensagens do chamado recuperadas com sucesso']);

} catch (Exception $e) {
    error_log("Erro na API de mensagens do chamado: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
