<?php
// Sistema de envio de e-mail via SMTP com autenticação
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Função para log
function writeEmailLog($message) {
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[{$timestamp}] {$message}\n";
    file_put_contents('/tmp/email_log.txt', $log_entry, FILE_APPEND | LOCK_EX);
    error_log($message);
}

try {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'recuperar-senha') {
        $email = $_POST['email'] ?? '';
        $nome = $_POST['nome'] ?? 'Cliente';
        $senha = $_POST['senha'] ?? '';
        $telefone = $_POST['telefone'] ?? '';
        
        if (empty($email) || empty($senha)) {
            throw new Exception('E-mail e senha são obrigatórios');
        }
        
        writeEmailLog("=== INICIANDO ENVIO DE E-MAIL SMTP ===");
        writeEmailLog("Destinatário: " . $email);
        writeEmailLog("Nome: " . $nome);
        writeEmailLog("Senha: " . $senha);
        
        // Configurações SMTP
        $smtp_host = 'milo.cactus.net.br';
        $smtp_port = 465; // SSL direto
        $smtp_username = 'atendimento@core3chip.com.br';
        $smtp_password = 'A@9025dfsty';
        
        // Criar o e-mail
        $subject = 'Recuperação de Senha Core3Business';
        
        // E-mail em HTML
        $html_body = "
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset='UTF-8'>
            <style>
                body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background-color: #f5f5f5; }
                .container { max-width: 600px; margin: 0 auto; background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
                .header { background: linear-gradient(135deg, #2563eb, #1d4ed8); color: white; padding: 30px; text-align: center; }
                .content { padding: 30px; }
                .logo { font-size: 24px; font-weight: bold; margin-bottom: 10px; }
                .message { font-size: 16px; line-height: 1.6; color: #333; margin-bottom: 20px; }
                .password-box { background: #f8fafc; border: 2px solid #e2e8f0; border-radius: 8px; padding: 20px; text-align: center; margin: 20px 0; }
                .password { font-size: 24px; font-weight: bold; color: #2563eb; font-family: monospace; }
                .footer { background: #1f2937; color: white; padding: 20px; text-align: center; font-size: 14px; }
                .warning { background: #fef2f2; border: 1px solid #fecaca; border-radius: 6px; padding: 15px; margin: 20px 0; color: #dc2626; }
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <div class='logo'>📱 CORE3BUSINESS</div>
                    <div>A operadora que entende você</div>
                </div>
                
                <div class='content'>
                    <h2>Olá {$nome}!</h2>
                    
                    <div class='message'>
                        Você solicitou a recuperação de sua senha de acesso ao app Core3Business:
                    </div>
                    
                    <div class='password-box'>
                        <div>Sua senha é:</div>
                        <div class='password'>{$senha}</div>
                    </div>
                    
                    <div class='message'>
                        <strong>Atenciosamente,<br>Core3Business</strong>
                    </div>
                    
                    <div class='warning'>
                        <strong>⚠️ Importante:</strong><br>
                        Se você não solicitou a recuperação desta senha, entre em contato com nosso suporte no WhatsApp no número (75) 3023-7350<br>
                        <strong>Core3Business - A operadora que entende você!</strong>
                    </div>
                </div>
                
                <div class='footer'>
                    <div>Core3Business - Sistema de Recuperação de Senha</div>
                    <div>Enviado em " . date('d/m/Y H:i:s') . "</div>
                </div>
            </div>
        </body>
        </html>";
        
        // E-mail em texto simples
        $text_body = "
CORE3BUSINESS - A operadora que entende você

Olá {$nome}!

Você solicitou a recuperação de sua senha de acesso ao app Core3Business:

Sua senha é: {$senha}

Atenciosamente,
Core3Business

IMPORTANTE: Se você não solicitou a recuperação desta senha, entre em contato com nosso suporte no WhatsApp no número (75) 3023-7350

Core3Business - A operadora que entende você!

Enviado em " . date('d/m/Y H:i:s');
        
        // Usar SwiftMailer ou implementação SMTP simples
        $result = sendEmailSMTP($smtp_host, $smtp_port, $smtp_username, $smtp_password, $email, $subject, $html_body, $text_body, 'Core3Business <atendimento@core3chip.com.br>');
        
        if ($result) {
            echo json_encode([
                'success' => true,
                'message' => 'E-mail enviado com sucesso via SMTP',
                'email' => $email,
                'timestamp' => date('Y-m-d H:i:s')
            ]);
        } else {
            throw new Exception('Falha ao enviar e-mail via SMTP');
        }
        
    } elseif ($action === 'test') {
        echo json_encode([
            'success' => true,
            'message' => 'Serviço SMTP OK',
            'smtp_host' => 'milo.cactus.net.br',
            'smtp_port' => 587,
            'timestamp' => date('Y-m-d H:i:s')
        ]);
    } else {
        throw new Exception('Ação não especificada');
    }
    
} catch (Exception $e) {
    writeEmailLog("ERRO: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}

// Função para ler resposta SMTP completa
function readSMTPResponse($socket) {
    $response = '';
    while (($line = fgets($socket, 512)) !== false) {
        $response .= trim($line) . "\n";
        if (preg_match('/^\d{3}\s/', $line)) {
            break;
        }
    }
    return trim($response);
}

// Função para enviar e-mail via SMTP com socket
function sendEmailSMTP($host, $port, $username, $password, $to, $subject, $html_body, $text_body, $from) {
    writeEmailLog("Iniciando conexão SMTP: {$host}:{$port}");
    
    try {
        // Conectar via SSL direto
        $context = stream_context_create([
            "ssl" => [
                "verify_peer" => false,
                "verify_peer_name" => false,
            ],
        ]);
        
        $socket = stream_socket_client(
            "ssl://{$host}:{$port}",
            $errno,
            $errstr,
            30,
            STREAM_CLIENT_CONNECT,
            $context
        );
        
        if (!$socket) {
            writeEmailLog("ERRO: Falha ao conectar SSL: {$errstr} ({$errno})");
            return false;
        }
        
        writeEmailLog("Conectado ao SMTP via SSL");
        
        // Ler resposta inicial
        $response = fgets($socket, 512);
        writeEmailLog("Resposta inicial: " . trim($response));
        
        // EHLO
        fputs($socket, "EHLO localhost\r\n");
        $response = readSMTPResponse($socket);
        writeEmailLog("EHLO: " . $response);
        
        // AUTH LOGIN
        fputs($socket, "AUTH LOGIN\r\n");
        $response = readSMTPResponse($socket);
        writeEmailLog("AUTH LOGIN: " . $response);
        
        // Username
        fputs($socket, base64_encode($username) . "\r\n");
        $response = readSMTPResponse($socket);
        writeEmailLog("Username: " . $response);
        
        // Password
        fputs($socket, base64_encode($password) . "\r\n");
        $response = readSMTPResponse($socket);
        writeEmailLog("Password: " . $response);
        
        if (strpos($response, '235') === false) {
            writeEmailLog("ERRO: Falha na autenticação: " . $response);
            fclose($socket);
            return false;
        }
        writeEmailLog("Autenticação bem-sucedida");
        
        // MAIL FROM
        fputs($socket, "MAIL FROM:<atendimento@core3chip.com.br>\r\n");
        $response = readSMTPResponse($socket);
        writeEmailLog("MAIL FROM: " . $response);
        
        // RCPT TO
        fputs($socket, "RCPT TO:<{$to}>\r\n");
        $response = readSMTPResponse($socket);
        writeEmailLog("RCPT TO: " . $response);
        
        // DATA
        fputs($socket, "DATA\r\n");
        $response = readSMTPResponse($socket);
        writeEmailLog("DATA: " . $response);
        
        // Criar mensagem MIME
        $boundary = "boundary_" . md5(time());
        $email_data = "Subject: {$subject}\r\n";
        $email_data .= "From: {$from}\r\n";
        $email_data .= "To: {$to}\r\n";
        $email_data .= "MIME-Version: 1.0\r\n";
        $email_data .= "Content-Type: multipart/alternative; boundary=\"{$boundary}\"\r\n";
        $email_data .= "\r\n";
        
        // Parte texto
        $email_data .= "--{$boundary}\r\n";
        $email_data .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $email_data .= "\r\n";
        $email_data .= $text_body . "\r\n\r\n";
        
        // Parte HTML
        $email_data .= "--{$boundary}\r\n";
        $email_data .= "Content-Type: text/html; charset=UTF-8\r\n";
        $email_data .= "\r\n";
        $email_data .= $html_body . "\r\n\r\n";
        
        $email_data .= "--{$boundary}--\r\n";
        $email_data .= "\r\n.\r\n";
        
        fputs($socket, $email_data);
        $response = readSMTPResponse($socket);
        writeEmailLog("E-mail enviado: " . $response);
        
        // QUIT
        fputs($socket, "QUIT\r\n");
        fclose($socket);
        
        if (strpos($response, '250') !== false) {
            writeEmailLog("E-mail enviado com sucesso para: {$to}");
            return true;
        } else {
            writeEmailLog("ERRO: Falha no envio: " . $response);
            return false;
        }
        
    } catch (Exception $e) {
        writeEmailLog("ERRO SMTP: " . $e->getMessage());
        if (isset($socket) && $socket) {
            fclose($socket);
        }
        return false;
    }
}
?>
