#!/bin/bash

echo "📤 Iniciando upload para o servidor remoto..."
echo "=============================================="

# Configurações do servidor
SERVER_IP="192.168.2.16"
SERVER_PORT="60111"
SERVER_USER="root"
SERVER_PATH="/var/www/sistema"

# Lista de arquivos essenciais para o sistema
ARQUIVOS_ESSENCIAIS=(
    "login.php"
    "index.php"
    ".htaccess"
    "config_servidor_remoto.php"
    "confApi.php"
    "WebserviceClient.php"
    "mapeamento-planos.php"
    "buscar-plano.php"
    "consultar-ixc.php"
    "inserir-contrato-ixc.php"
    "consumos.php"
    "linhas.php"
    "cadastro.php"
    "consulta.php"
    "teste_bloqueio.php"
    "cron_config.txt"
)

# Lista de arquivos de documentação (opcional)
ARQUIVOS_DOCS=(
    "README.md"
    "INSTRUCOES.md"
    "COMO-TESTAR.md"
)

echo "📋 Passo 1: Verificando arquivos locais..."
for arquivo in "${ARQUIVOS_ESSENCIAIS[@]}"; do
    if [ -f "$arquivo" ]; then
        echo "✅ $arquivo encontrado"
    else
        echo "❌ $arquivo NÃO encontrado"
    fi
done

echo ""
echo "📋 Passo 2: Criando arquivo de configuração do servidor..."
# Renomear config_servidor_remoto.php para config.php no servidor
echo "✅ config_servidor_remoto.php será renomeado para config.php no servidor"

echo ""
echo "📋 Passo 3: Fazendo upload dos arquivos..."
echo "🌐 Servidor: $SERVER_USER@$SERVER_IP:$SERVER_PORT"
echo "📁 Destino: $SERVER_PATH"

# Criar diretório temporário para organizar os arquivos
TEMP_DIR="temp_upload_$(date +%s)"
mkdir -p "$TEMP_DIR"

# Copiar arquivos essenciais
for arquivo in "${ARQUIVOS_ESSENCIAIS[@]}"; do
    if [ -f "$arquivo" ]; then
        cp "$arquivo" "$TEMP_DIR/"
        echo "📁 Copiado: $arquivo"
    fi
done

# Copiar arquivos de documentação
for arquivo in "${ARQUIVOS_DOCS[@]}"; do
    if [ -f "$arquivo" ]; then
        cp "$arquivo" "$TEMP_DIR/"
        echo "📁 Copiado: $arquivo"
    fi
done

# Renomear config_servidor_remoto.php para config.php
if [ -f "$TEMP_DIR/config_servidor_remoto.php" ]; then
    mv "$TEMP_DIR/config_servidor_remoto.php" "$TEMP_DIR/config.php"
    echo "🔄 Renomeado: config_servidor_remoto.php → config.php"
fi

echo ""
echo "📋 Passo 4: Compactando arquivos..."
tar -czf sistema_completo.tar.gz -C "$TEMP_DIR" .
echo "✅ Arquivo compactado: sistema_completo.tar.gz"

echo ""
echo "📋 Passo 5: Enviando para o servidor..."
scp -P "$SERVER_PORT" sistema_completo.tar.gz "$SERVER_USER@$SERVER_IP:/tmp/"

if [ $? -eq 0 ]; then
    echo "✅ Upload concluído com sucesso!"
    
    echo ""
    echo "📋 Passo 6: Executando no servidor..."
    ssh -p "$SERVER_PORT" "$SERVER_USER@$SERVER_IP" << 'EOF'
        echo "🔧 Descompactando arquivos..."
        cd /var/www/sistema
        tar -xzf /tmp/sistema_completo.tar.gz
        rm -f /tmp/sistema_completo.tar.gz
        
        echo "🔧 Ajustando permissões..."
        chown -R www-data:www-data /var/www/sistema
        chmod -R 755 /var/www/sistema
        
        echo "🔧 Verificando arquivos..."
        ls -la /var/www/sistema/
        
        echo "🔧 Testando configuração..."
        php -f config.php
        
        echo "🎉 Sistema instalado com sucesso!"
        echo "🌐 URL: http://192.168.2.16/sistema"
EOF
else
    echo "❌ Erro no upload!"
    exit 1
fi

echo ""
echo "🧹 Limpeza..."
rm -rf "$TEMP_DIR"
rm -f sistema_completo.tar.gz

echo ""
echo "=============================================="
echo "🎉 Upload e instalação concluídos!"
echo "🌐 Acesse: http://192.168.2.16/sistema"
echo "=============================================="
