<?php
// Teste simples da API IXC
require_once 'confApi.php';

echo "<h2>🧪 Teste da API IXC</h2>";

try {
    // Teste 1: Listar clientes
    echo "<h3>1. Listando clientes...</h3>";
    $api->get('cliente', ['page' => '1', 'rp' => '5']);
    $response = $api->getRespostaConteudo(false);
    $data = json_decode($response, true);
    
    echo "<pre>";
    print_r($data);
    echo "</pre>";
    
    // Teste 2: Buscar por CPF/CNPJ (usando o CPF que está sendo testado)
    echo "<h3>2. Buscando por CPF/CNPJ...</h3>";
    
    // Aplicar máscara como no consulta.php
    $cpf_teste = '04435315521'; // CPF sem máscara
    $query = $cpf_teste;
    if (strlen($cpf_teste) === 11) {
        $query = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $cpf_teste);
    }
    
    echo "<p><strong>CPF Original:</strong> $cpf_teste</p>";
    echo "<p><strong>CPF com Máscara:</strong> $query</p>";
    
    $params = array(
        'qtype' => 'cliente.cnpj_cpf',
        'query' => $query, // CPF com máscara
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'cliente.id',
        'sortorder' => 'desc',
        'grid_param' => json_encode([
            ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
        ])
    );
    
    $api->get('cliente', $params);
    $response2 = $api->getRespostaConteudo(false);
    $data2 = json_decode($response2, true);
    
    echo "<pre>";
    print_r($data2);
    echo "</pre>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Erro: " . $e->getMessage() . "</p>";
}
?>
