<?php
// Teste da API de consulta
header('Content-Type: application/json');

echo "<h2>🧪 Teste da API de Consulta</h2>";

// Testar com ID 1
$url = "http://localhost:8000/consulta.php?id=1";
echo "<p><strong>Testando:</strong> $url</p>";

$response = file_get_contents($url);
echo "<p><strong>Resposta:</strong></p>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

// Verificar se é JSON válido
$data = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "<p style='color: green;'>✅ JSON válido!</p>";
    echo "<p><strong>Estrutura dos dados:</strong></p>";
    echo "<pre>" . print_r($data, true) . "</pre>";
} else {
    echo "<p style='color: red;'>❌ Erro no JSON: " . json_last_error_msg() . "</p>";
}
?>



