<?php
// Servidor PHP simples - versão corrigida
$requestUri = $_SERVER['REQUEST_URI'];

// Se for um arquivo PHP, deixar o servidor padrão lidar
if (strpos($requestUri, '.php') !== false) {
    return false;
}

// Se for a rota raiz, mostrar interface
if ($requestUri === '/' || $requestUri === '') {
    $currentDir = __DIR__;
    $currentTime = date('H:i:s');
    
    echo '<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>API IXCsoft - Funcionando!</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; }
        h1 { color: #333; text-align: center; }
        .btn { background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; margin: 10px; }
        .status { background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🧪 API IXCsoft - FUNCIONANDO!</h1>
        
        <div class="status">
            <strong>✅ Servidor funcionando perfeitamente!</strong><br>
            🌐 URL: http://localhost:8000<br>
            📁 Pasta: ' . $currentDir . '<br>
            ⏰ Hora: ' . $currentTime . '
        </div>
        
        <h3>🔗 Links de Teste:</h3>
        <a href="/consulta.php?id=1" class="btn">🧪 Testar API</a>
        <a href="/test-api.php" class="btn">🧪 Interface de Testes</a>
        <a href="/exemplo-uso.php" class="btn">📚 Exemplos</a>
        <a href="/teste-simples.php" class="btn">🧪 Teste Simples</a>
        <a href="/teste-final.php" class="btn">🎯 Teste Final</a>
        
        <h3>📝 Como usar:</h3>
        <p>1. Esta página está funcionando perfeitamente</p>
        <p>2. Clique nos botões acima para testar a API</p>
        <p>3. Se algum botão não funcionar, o problema é no arquivo específico</p>
    </div>
</body>
</html>';
    exit;
}

// Para outras rotas, retornar 404
http_response_code(404);
echo '<h1>404 - Página não encontrada</h1><p><a href="/">Voltar ao início</a></p>';
?>
