<?php
// proxy-img.php: Proxy para baixar imagens externas e contornar CORS
if (!isset($_GET['url']) || empty($_GET['url'])) {
    http_response_code(400);
    echo 'URL não informada.';
    exit;
}
$url = $_GET['url'];
// Validação básica para evitar SSRF
if (!preg_match('/^https?:\/\//', $url)) {
    http_response_code(400);
    echo 'URL inválida.';
    exit;
}
$opts = [
    "http" => [
        "method" => "GET",
        "header" => "User-Agent: Mozilla/5.0\r\nAccept: image/png,image/*,*/*;q=0.8\r\n"
    ]
];
$context = stream_context_create($opts);
$data = @file_get_contents($url, false, $context);
if ($data === false) {
    http_response_code(404);
    echo 'Não foi possível baixar a imagem.';
    exit;
}
header('Content-Type: image/png');
echo $data;
?>

