<?php
// Core3Chip - Consulta Avançada de Cliente Boramvno
$currentTime = date('H:i:s');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consultar Cliente - Core3Chip</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body { min-height: 100vh; background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%); display: flex; align-items: center; justify-content: center; font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif; margin: 0; }
        .container { background: rgba(255,255,255,0.97); border-radius: 32px; box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18), 0 1.5px 8px 0 rgba(16,185,129,0.10); padding: 56px 40px 48px 40px; max-width: 520px; width: 100%; display: flex; flex-direction: column; align-items: center; gap: 36px; position: relative; }
        .logo-img { width: 195px; height: 130px; object-fit: contain; object-position: center; margin-bottom: 12px; filter: drop-shadow(0 4px 24px #2563eb33); background: transparent; border-radius: 18px; }
        .search-section { width: 100%; background: #f1f5f9; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-bottom: 10px; }
        .search-title h2 { font-size: 1.3rem; font-weight: 700; color: #2563eb; margin: 0 0 4px 0; }
        .search-title p { font-size: 1rem; color: #64748b; margin: 0 0 18px 0; }
        .search-form { display: flex; flex-direction: column; gap: 14px; }
        .form-group { display: flex; flex-direction: column; gap: 6px; }
        .form-label { font-size: 0.98rem; color: #1e293b; font-weight: 500; }
        .form-input { padding: 12px 14px; border-radius: 8px; border: 1.5px solid #cbd5e1; font-size: 1.08rem; outline: none; transition: border 0.2s; }
        .form-input:focus { border: 1.5px solid #2563eb; }
        .search-btn { padding: 13px 0; border: none; border-radius: 10px; font-size: 1.08rem; font-weight: 600; color: #fff; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10); cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 10px; transition: background 0.2s, transform 0.2s, box-shadow 0.2s; outline: none; letter-spacing: 0.5px; }
        .search-btn .material-icons { font-size: 1.3em; vertical-align: middle; }
        .search-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); transform: translateY(-2px) scale(1.03); box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13); }
        .loading { display: none; align-items: center; flex-direction: column; gap: 10px; margin: 18px 0; }
        .spinner { width: 32px; height: 32px; border: 4px solid #e0e7ef; border-top: 4px solid #2563eb; border-radius: 50%; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .error-message, .success-message { display: none; margin: 10px 0 0 0; padding: 10px 18px; border-radius: 8px; font-size: 1.02rem; font-weight: 500; }
        .error-message { background: #fee2e2; color: #b91c1c; border: 1.5px solid #f87171; }
        .success-message { background: #d1fae5; color: #065f46; border: 1.5px solid #10b981; }
        .results-section { width: 100%; background: #f8fafc; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-top: 10px; }
        .results-title { font-size: 1.15rem; font-weight: 700; color: #2563eb; margin: 0 0 18px 0; }
        .client-form { width: 100%; }
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 14px 18px; }
        .form-field { display: flex; flex-direction: column; gap: 4px; }
        .field-label { font-size: 0.97rem; color: #1e293b; font-weight: 500; }
        .field-value { padding: 10px 10px; border-radius: 7px; border: 1.2px solid #cbd5e1; font-size: 1.01rem; outline: none; background: #fff; color: #222; transition: border 0.2s; }
        .field-value:focus { border: 1.2px solid #2563eb; }
        .back-btn { position: absolute; top: 18px; left: 18px; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); color: #fff; border: none; border-radius: 8px; padding: 10px 18px; font-size: 1rem; font-weight: 600; display: flex; align-items: center; gap: 8px; box-shadow: 0 2px 8px 0 rgba(37,99,235,0.10); cursor: pointer; transition: background 0.2s, box-shadow 0.2s; z-index: 10; }
        .back-btn .material-icons { font-size: 1.2em; }
        .back-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); box-shadow: 0 6px 18px 0 rgba(16,185,129,0.13); }
        @media (max-width: 700px) { .container { padding: 24px 4px 18px 4px; border-radius: 18px; } .logo-img { width: 130px; height: 91px; } .form-grid { grid-template-columns: 1fr; } .back-btn { top: 8px; left: 8px; padding: 8px 12px; font-size: 0.95rem; } }
    </style>
</head>
<body>
    <div class="container">
        <button onclick="window.location.href='index.php'" class="back-btn">
            <span class="material-icons">arrow_back</span> Voltar
        </button>
        <header class="header">
            <div class="menu-bar">
                <div class="logo-area">
                    <img src="chip.png" alt="Logo" class="logo-img" />
                </div>
            </div>
        </header>
        <div style="position:absolute;top:18px;right:24px;z-index:100;">
    <a href="logout.php" style="background:linear-gradient(90deg,#e11d48 0%,#f87171 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #e11d4811;display:flex;align-items:center;gap:8px;font-size:1.05em;">
        <span class="material-icons" style="font-size:1.2em;">logout</span> Sair
    </a>
</div>
        <div class="search-section">
            <div class="search-title">
                <h2>🔍 Consultar Cliente Boramvno</h2>
                <p>Digite o CPF ou CNPJ do cliente para consultar na base Boramvno</p>
            </div>
            <form class="search-form" id="searchForm">
                <div class="form-group" style="flex-direction: row; gap: 18px; align-items: center; margin-bottom: 8px;">
                    <label style="font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px;">
                        <input type="radio" name="searchType" id="searchCpf" value="cpf" checked style="accent-color:#2563eb; margin-right:4px;"> CPF/CNPJ
                    </label>
                    <label style="font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px;">
                        <input type="radio" name="searchType" id="searchPhone" value="phone" style="accent-color:#2563eb; margin-right:4px;"> Telefone
                    </label>
                </div>
                <div class="form-group">
                    <label class="form-label" id="mainInputLabel">CPF ou CNPJ</label>
                    <input type="text" class="form-input" id="documentInput" placeholder="Digite CPF ou CNPJ (máscara automática)" required>
                </div>
                <button type="submit" class="search-btn" id="searchBtn">
                    <span class="material-icons">search</span>
                    Consultar Cliente
                </button>
            </form>
        </div>
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p>Consultando dados do cliente...</p>
        </div>
        <div class="error-message" id="errorMessage"></div>
        <div class="success-message" id="successMessage"></div>
        <div class="results-section" id="resultsSection" style="display:none;">
            <h2 class="results-title">📊 Dados do Cliente Boramvno</h2>
            <div class="client-form">
                <form id="clientForm">
                    <div class="form-grid">
                        <div class="form-field">
                            <label class="field-label">🆔 ID</label>
                            <input class="field-value" id="clientId" name="clientId" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">👤 Nome</label>
                            <input class="field-value" id="clientName" name="clientName" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📄 CPF/CNPJ</label>
                            <input class="field-value" id="clientDocument" name="clientDocument" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📧 Email</label>
                            <input class="field-value" id="clientEmail" name="clientEmail" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📱 Telefone</label>
                            <input class="field-value" id="clientPhone" name="clientPhone" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🎂 Data de Nascimento</label>
                            <input class="field-value" id="clientBirthDate" name="clientBirthDate" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📍 Endereço</label>
                            <input class="field-value" id="clientAddress" name="clientAddress" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🔢 Número</label>
                            <input class="field-value" id="clientNumber" name="clientNumber" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏘️ Bairro</label>
                            <input class="field-value" id="clientNeighborhood" name="clientNeighborhood" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏙️ Cidade</label>
                            <input class="field-value" id="clientCity" name="clientCity" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🌍 Estado</label>
                            <input class="field-value" id="clientState" name="clientState" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📮 CEP</label>
                            <input class="field-value" id="clientZipCode" name="clientZipCode" type="text" value="-" />
                        </div>
                    </div>
                    <!-- Botão de atualizar removido -->
                </form>
            </div>
        </div>
        <!-- Seção de Ativação de nova linha -->
        <div class="results-section" style="margin-top:32px;">
            <h2 class="results-title">📲 Ativação de nova linha</h2>
            <div style="display:flex; gap:24px; align-items:center; margin-bottom:18px;">
                <label style="font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px;">
                    <input type="radio" name="tipoChip" id="chipFisico" value="fisico" checked style="accent-color:#2563eb; margin-right:4px;"> Consultar chip
                </label>
            </div>
            <form id="formAtivacao" style="display:flex; gap:14px; align-items:center;">
                <input type="text" id="iccidInput" class="form-input" placeholder="Digite o ICCID do chip" maxlength="22" style="width:220px;">
                <button type="button" class="search-btn" id="consultarChipBtn" style="min-width:160px;">
                    <span class="material-icons">search</span>
                    Consultar chip
                </button>
            </form>
            <div id="chipResult" style="margin-top:18px;"></div>
        </div>
        <!-- Formulário para finalizar carrinho -->
        <div class="results-section" style="margin-top:32px;">
            <h2 class="results-title">🧾 Finalizar Carrinho (Billet Combo)</h2>
            <form id="finalizarCarrinhoForm" style="display:flex; gap:14px; align-items:center; flex-wrap:wrap;">
                <input type="text" id="cartIdFinalizar" class="form-input" placeholder="Digite o cartId do carrinho" style="width:260px;">
                <button type="button" class="search-btn" id="finalizarCarrinhoBtn" style="min-width:160px;">
                    <span class="material-icons">done_all</span>
                    Finalizar
                </button>
            </form>
            <div id="finalizarCarrinhoResult" style="margin-top:18px;"></div>
        </div>
    </div>
    <script>
    // Máscara CPF/CNPJ igual ao cadastro.php
    function applyCPFMask(value) {
        return value.replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d{1,2})$/, '$1-$2');
    }
    function applyCNPJMask(value) {
        return value.replace(/(\d{2})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1/$2')
            .replace(/(\d{4})(\d{1,2})$/, '$1-$2');
    }
    const documentInput = document.getElementById('documentInput');
    const searchCpf = document.getElementById('searchCpf');
    const searchPhone = document.getElementById('searchPhone');
    const mainInputLabel = document.getElementById('mainInputLabel');
    searchCpf.addEventListener('change', function() {
        if (searchCpf.checked) {
            mainInputLabel.textContent = 'CPF ou CNPJ';
            documentInput.value = '';
            documentInput.placeholder = 'Digite CPF ou CNPJ (máscara automática)';
            documentInput.maxLength = 18;
            documentInput.type = 'text';
        }
    });
    searchPhone.addEventListener('change', function() {
        if (searchPhone.checked) {
            mainInputLabel.textContent = 'Telefone (11 dígitos)';
            documentInput.value = '';
            documentInput.placeholder = 'Digite o número (ex: 75999006002)';
            documentInput.maxLength = 11;
            documentInput.type = 'tel';
        }
    });
    documentInput.addEventListener('input', function(e) {
        if (searchCpf.checked) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length <= 11) {
                e.target.value = applyCPFMask(value);
            } else if (value.length <= 14) {
                e.target.value = applyCNPJMask(value);
            } else {
                e.target.value = value;
            }
        } else {
            // Telefone: só números, máximo 11 dígitos
            e.target.value = e.target.value.replace(/\D/g, '').slice(0, 11);
        }
    });
    // Consulta Boramvno
    const searchForm = document.getElementById('searchForm');
    const loading = document.getElementById('loading');
    const errorMessage = document.getElementById('errorMessage');
    const successMessage = document.getElementById('successMessage');
    const resultsSection = document.getElementById('resultsSection');
    searchForm.addEventListener('submit', function(e) {
        e.preventDefault();
        errorMessage.style.display = 'none';
        successMessage.style.display = 'none';
        loading.style.display = 'flex';
        resultsSection.style.display = 'none';
        let url = '';
        let documentValue = documentInput.value.replace(/\D/g, '');
        if (searchCpf.checked) {
            url = 'consultar-subscriber.php?document=' + encodeURIComponent(documentValue);
        } else {
            // Telefone: adiciona 55 automaticamente
            if (documentValue.length !== 11) {
                loading.style.display = 'none';
                errorMessage.textContent = 'Digite um número de telefone válido com 11 dígitos.';
                errorMessage.style.display = 'block';
                return;
            }
            url = 'consultar-subscriber.php?msisdn=55' + encodeURIComponent(documentValue);
        }
        fetch(url)
            .then(response => response.json())
            .then(data => {
                loading.style.display = 'none';
                if (data.error || data.detail) {
                    errorMessage.textContent = 'Erro: ' + (data.detail || data.error);
                    errorMessage.style.display = 'block';
                    return;
                }
                // Preencher campos (mantém igual)
                const cliente = data;
                window.__ultimoClienteConsultado = cliente;
                document.getElementById('clientId').value = cliente.subscriberId || '-';
                document.getElementById('clientName').value = cliente.name || '-';
                document.getElementById('clientDocument').value = cliente.document || '-';
                document.getElementById('clientEmail').value = cliente.email || '-';
                document.getElementById('clientPhone').value = cliente.phone || cliente.msisdn || '-';
                document.getElementById('clientBirthDate').value = cliente.birthDate || '-';
                document.getElementById('clientAddress').value = cliente.street || '-';
                document.getElementById('clientNumber').value = cliente.number || '-';
                document.getElementById('clientNeighborhood').value = cliente.neighborhood || '-';
                document.getElementById('clientCity').value = cliente.city || '-';
                document.getElementById('clientState').value = cliente.uf || '-';
                document.getElementById('clientZipCode').value = cliente.zipcode || '-';
                // Exibir campos extras se existirem
                let extraFields = '';
                if (cliente.msisdn) extraFields += `<div class='form-field'><label class='field-label'>MSISDN</label><input class='field-value' type='text' value='${cliente.msisdn}' readonly></div>`;
                if (cliente.plan) extraFields += `<div class='form-field'><label class='field-label'>Plano</label><input class='field-value' type='text' value='${cliente.plan}' readonly></div>`;
                if (typeof cliente.active !== 'undefined') extraFields += `<div class='form-field'><label class='field-label'>Ativo</label><input class='field-value' type='text' value='${cliente.active ? 'Sim' : 'Não'}' readonly></div>`;
                if (cliente.createdBy) extraFields += `<div class='form-field'><label class='field-label'>Criado por</label><input class='field-value' type='text' value='${cliente.createdBy.name} (${cliente.createdBy.email})' readonly></div>`;
                if (cliente.updatedBy) extraFields += `<div class='form-field'><label class='field-label'>Atualizado por</label><input class='field-value' type='text' value='${cliente.updatedBy.name} (${cliente.updatedBy.email})' readonly></div>`;
                if (cliente.updateDate) extraFields += `<div class='form-field'><label class='field-label'>Data Atualização</label><input class='field-value' type='text' value='${cliente.updateDate}' readonly></div>`;
                if (cliente.creationDate) extraFields += `<div class='form-field'><label class='field-label'>Data Criação</label><input class='field-value' type='text' value='${cliente.creationDate}' readonly></div>`;
                if (cliente.idSubscriberExternal) extraFields += `<div class='form-field'><label class='field-label'>ID Externo</label><input class='field-value' type='text' value='${cliente.idSubscriberExternal}' readonly></div>`;
                // Adiciona campos extras ao final do form
                const formGrid = document.querySelector('.form-grid');
                if (formGrid && extraFields) {
                  formGrid.insertAdjacentHTML('beforeend', extraFields);
                }
                
                // === CONSULTA IXC ===
                // Executar consulta IXC para obter cliente.id
                const documentValue = documentInput.value.replace(/\D/g, '');
                if (searchCpf.checked && documentValue) {
                    // Adicionar campo para mostrar o resultado IXC
                    const ixField = document.createElement('div');
                    ixField.className = 'form-field';
                    ixField.style.gridColumn = '1 / -1';
                    ixField.style.marginTop = '20px';
                    ixField.style.padding = '15px';
                    ixField.style.background = '#f0f9ff';
                    ixField.style.border = '2px solid #0ea5e9';
                    ixField.style.borderRadius = '10px';
                    ixField.innerHTML = `
                        <label class="field-label" style="color: #0ea5e9; font-weight: 700; display: flex; align-items: center; gap: 8px;">
                            <span class="material-icons" style="font-size: 1.2em;">business</span>
                            Consulta IXC - Aguardando...
                        </label>
                        <div id="ixcResult" style="margin-top: 10px; font-size: 0.95rem; color: #64748b;">
                            <div class="spinner" style="width: 20px; height: 20px; border-width: 2px; margin: 0 auto;"></div>
                            Consultando cliente no sistema IXC...
                        </div>
                    `;
                    
                    if (formGrid) {
                        formGrid.appendChild(ixField);
                    }
                    
                    // Fazer consulta IXC
                    fetch('consultar-ixc.php?document=' + encodeURIComponent(documentValue))
                        .then(response => response.json())
                        .then(ixcData => {
                            const ixcResult = document.getElementById('ixcResult');
                            
                            if (ixcData.success) {
                                // Armazenar cliente.id em variável global
                                window.__clienteIdIXC = ixcData.cliente_id;
                                
                                // Log no console para verificação
                                console.log('✅ Cliente IXC encontrado!');
                                console.log('📋 window.__clienteIdIXC =', window.__clienteIdIXC);
                                console.log('🔍 Dados completos:', ixcData);
                                
                                // Mostrar resultado com sucesso
                                ixcResult.innerHTML = `
                                    <div style="color: #059669; font-weight: 600; display: flex; align-items: center; gap: 8px; margin-bottom: 8px;">
                                        <span class="material-icons" style="color: #10b981;">check_circle</span>
                                        Cliente encontrado no IXC!
                                    </div>
                                    <div style="background: #ecfdf5; padding: 10px; border-radius: 8px; border-left: 4px solid #10b981;">
                                        <strong>ID IXC:</strong> <span style="color: #059669; font-family: monospace; font-size: 1.1em;">${ixcData.cliente_id}</span><br>
                                        <strong>Nome:</strong> ${ixcData.cliente_nome}<br>
                                        <strong>CPF/CNPJ:</strong> ${ixcData.cliente_cnpj_cpf}
                                    </div>
                                    <div style="margin-top: 10px; padding: 8px 12px; background: #dbeafe; border-radius: 6px; font-size: 0.9rem; color: #1e40af;">
                                        <strong>Variável armazenada:</strong> <code>window.__clienteIdIXC = ${ixcData.cliente_id}</code>
                                    </div>
                                `;
                                
                                // Atualizar o label do campo
                                const ixLabel = ixField.querySelector('.field-label');
                                ixLabel.innerHTML = `
                                    <span class="material-icons" style="font-size: 1.2em;">business</span>
                                    Consulta IXC - ✅ Cliente Encontrado
                                `;
                                ixLabel.style.color = '#059669';
                                
                            } else {
                                // Cliente não encontrado
                                window.__clienteIdIXC = null;
                                
                                // Log no console para verificação
                                console.log('❌ Cliente IXC não encontrado');
                                console.log('📋 window.__clienteIdIXC =', window.__clienteIdIXC);
                                console.log('🔍 Erro:', ixcData.error);
                                
                                ixcResult.innerHTML = `
                                    <div style="color: #dc2626; font-weight: 600; display: flex; align-items: center; gap: 8px; margin-bottom: 8px;">
                                        <span class="material-icons" style="color: #ef4444;">error</span>
                                        Cliente não encontrado no IXC
                                    </div>
                                    <div style="background: #fef2f2; padding: 10px; border-radius: 8px; border-left: 4px solid #ef4444;">
                                        <strong>Erro:</strong> ${ixcData.error}<br>
                                        <strong>CPF/CNPJ consultado:</strong> ${documentValue}
                                    </div>
                                    <div style="margin-top: 10px; padding: 8px 12px; background: #fef3c7; border-radius: 6px; font-size: 0.9rem; color: #92400e;">
                                        <strong>Variável armazenada:</strong> <code>window.__clienteIdIXC = null</code>
                                    </strong>
                                `;
                                
                                // Atualizar o label do campo
                                const ixLabel = ixField.querySelector('.field-label');
                                ixLabel.innerHTML = `
                                    <span class="material-icons" style="font-size: 1.2em;">business</span>
                                    Consulta IXC - ❌ Cliente Não Encontrado
                                `;
                                ixLabel.style.color = '#dc2626';
                            }
                        })
                        .catch(ixcError => {
                            // Erro na consulta IXC
                            window.__clienteIdIXC = null;
                            
                            // Log no console para verificação
                            console.log('💥 Erro na consulta IXC');
                            console.log('📋 window.__clienteIdIXC =', window.__clienteIdIXC);
                            console.log('🔍 Erro:', ixcError.message);
                            
                            const ixcResult = document.getElementById('ixcResult');
                            ixcResult.innerHTML = `
                                <div style="color: #dc2626; font-weight: 600; display: flex; align-items: center; gap: 8px; margin-bottom: 8px;">
                                    <span class="material-icons" style="color: #ef4444;">error</span>
                                    Erro na consulta IXC
                                </div>
                                <div style="background: #fef2f2; padding: 10px; border-radius: 8px; border-left: 4px solid #ef4444;">
                                    <strong>Erro:</strong> ${ixcError.message}<br>
                                    <strong>CPF/CNPJ consultado:</strong> ${documentValue}
                                </div>
                                <div style="margin-top: 10px; padding: 8px 12px; background: #fef3c7; border-radius: 6px; font-size: 0.9rem; color: #92400e;">
                                    <strong>Variável armazenada:</strong> <code>window.__clienteIdIXC = null</code>
                                </div>
                            `;
                            
                            // Atualizar o label do campo
                            const ixLabel = ixField.querySelector('.field-label');
                            ixLabel.innerHTML = `
                                <span class="material-icons" style="font-size: 1.2em;">business</span>
                                Consulta IXC - ❌ Erro na Consulta
                            `;
                            ixLabel.style.color = '#dc2626';
                        });
                }
                
                resultsSection.style.display = 'block';
            })
            .catch(err => {
                loading.style.display = 'none';
                errorMessage.textContent = 'Erro ao consultar cliente: ' + err.message;
                errorMessage.style.display = 'block';
            });
    });
    // --- Variáveis globais para operação complexa ---
    window.__planoIdBoramvno = null;        // ID do plano Boramvno escolhido
    window.__planoIdIXC = null;             // Código do plano IXC correspondente
    window.__msisdnFinalizado = null;       // MSISDN retornado pela API de finalização
    window.__accountIdBoramvno = null;      // AccountId retornado pela API de subscriber
    
    // --- Ativação de nova linha ---
    // Remover variáveis e listeners do E-sim
    // Sempre usar rota de chip físico
    const iccidInput = document.getElementById('iccidInput');
    const consultarChipBtn = document.getElementById('consultarChipBtn');
    const chipResult = document.getElementById('chipResult');
    consultarChipBtn.addEventListener('click', function() {
        chipResult.innerHTML = '';
        const iccid = iccidInput.value.trim();
        if (!iccid) {
            chipResult.innerHTML = '<span style="color:#e11d48;">Digite o ICCID do chip.</span>';
            return;
        }
        consultarChipBtn.disabled = true;
        consultarChipBtn.innerHTML = '<span class="material-icons">hourglass_top</span>Consultando...';
        let rota = `/api/Subscriber/${iccid}/iccid`;
        // Exemplo de chamada AJAX (ajuste para seu backend se necessário)
        const fetchOptions = {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            }
        };
        fetch('proxy-chip.php?rota=' + encodeURIComponent(rota), fetchOptions)
            .then(async response => {
                const text = await response.text();
                let data;
                try {
                    data = JSON.parse(text);
                } catch (e) {
                    if (text.includes('<form') && text.includes('login')) {
                        window.location.href = 'login.php';
                        return;
                    }
                    chipResult.innerHTML = '<span style="color:#e11d48;">Sessão expirada ou erro inesperado. Faça login novamente.</span>';
                    consultarChipBtn.disabled = false;
                    consultarChipBtn.innerHTML = '<span class="material-icons">search</span>Consultar chip';
                    return;
                }
                return data;
            })
            .then(data => {
                if (!data) return;
                consultarChipBtn.disabled = false;
                consultarChipBtn.innerHTML = '<span class="material-icons">search</span>Consultar chip';
                if (data.error || data.detail) {
                    chipResult.innerHTML = `<span style='color:#e11d48;'>Erro: ${data.detail || data.error}</span>`;
                } else if (data.status === 'AVAILABLE' || data.status === 'IN_USE') {
                    let corMsg = '#2563eb';
                    if (data.status === 'IN_USE') corMsg = '#e11d48';
                    chipResult.innerHTML = `
                    <div id="chipBox" style="background:#fff;border:2px solid #10b981;padding:28px 18px 24px 18px;border-radius:18px;box-shadow:0 2px 16px #10b98122;display:flex;flex-direction:column;align-items:center;gap:14px;max-width:440px;margin:0 auto;">
                        <img src="chip.png" alt="Chip" style="width:120px;height:80px;object-fit:contain;margin-bottom:2px;" />
                        <div style="font-size:1.18em;font-weight:700;margin-bottom:2px;color:${corMsg};">Chip ${data.status === 'AVAILABLE' ? 'disponível para uso!' : 'já está em uso.'}</div>
                        <div style="color:#222;font-size:1em;margin-top:2px;">
                            <b>ICCID:</b> ${data.iccid}<br>
                            <b>IMSI:</b> ${data.imsi || '-'}<br>
                            <b>Tipo:</b> ${data.iccicType || '-'}<br>
                            <b>Status:</b> ${data.status}<br>
                            <b>Criado em:</b> ${data.createdAt ? new Date(data.createdAt).toLocaleString('pt-BR') : '-'}
                        </div>
                        ${data.qrCodeUrl ? `
                        <div id="qrcodeCard" style="margin:18px 0 0 0;display:flex;flex-direction:column;align-items:center;gap:8px;">
                            <div style="background:#f1f5f9;border:2.5px solid #2563eb;border-radius:18px;padding:18px;display:flex;flex-direction:column;align-items:center;">
                                <img id="qrcodeImg" src="${data.qrCodeUrl}" alt="QR Code" style="width:180px;height:180px;object-fit:contain;display:block;" />
                            </div>
                            <div style="font-size:1.08em;color:#2563eb;font-weight:600;margin-top:8px;">Use este QR Code para ativar sua linha</div>
                            <button id="baixarQrPdfBtn" style="margin-top:6px;background:linear-gradient(90deg,#2563eb 0%,#10b981 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #2563eb11;display:flex;align-items:center;gap:8px;font-size:1.05em;border:none;cursor:pointer;">
                                <span class="material-icons" style="font-size:1.2em;">download</span> Baixar QR Code (PDF)
                            </button>
                        </div>
                        ` : ''}
                        <button id='escolherPlanosBtn' class='search-btn' style='margin-top:18px;min-width:180px;'><span class='material-icons'>list</span>Escolher planos</button>
                        <div id='planosContainer'></div>
                    </div>`;
                    // PDF download handler
                    setTimeout(() => {
                        const btnPdf = document.getElementById('baixarQrPdfBtn');
                        if (btnPdf) {
                            btnPdf.onclick = async function() {
                                btnPdf.disabled = true;
                                btnPdf.innerHTML = '<span class="material-icons">hourglass_top</span>Gerando PNG...';
                                // Carregar imagens como base64
                                async function toBase64Fetch(url, label) {
                                    try {
                                        console.log('Iniciando fetch de', label, url);
                                        const controller = new AbortController();
                                        const timeout = setTimeout(() => controller.abort(), 8000);
                                        const response = await fetch(url, {mode: 'cors', signal: controller.signal});
                                        clearTimeout(timeout);
                                        if (!response.ok) throw new Error('Erro ao baixar imagem: ' + response.status);
                                        const blob = await response.blob();
                                        return new Promise((resolve, reject) => {
                                            const reader = new FileReader();
                                            reader.onloadend = () => { console.log('Base64 pronto de', label); resolve(reader.result); };
                                            reader.onerror = (e) => { console.error('Erro FileReader', label, e); reject(e); };
                                            reader.readAsDataURL(blob);
                                        });
                                    } catch (err) {
                                        console.error('Falha ao carregar imagem', label, err);
                                        throw new Error('Falha ao carregar imagem ' + label + ': ' + err.message);
                                    }
                                }
                                const qrUrl = document.getElementById('qrcodeImg')?.src;
                                const bgUrl = 'layout_chip.png';
                                let qrBase64 = qrUrl;
                                let bgBase64 = bgUrl;
                                try { qrBase64 = await toBase64Fetch('proxy-img.php?url=' + encodeURIComponent(qrUrl), 'QR Code'); } catch(e){
                                    btnPdf.disabled = false;
                                    btnPdf.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    alert('Erro ao carregar o QR Code: ' + e.message);
                                    return;
                                }
                                try { bgBase64 = await toBase64Fetch(bgUrl, 'Layout'); } catch(e){
                                    btnPdf.disabled = false;
                                    btnPdf.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    alert('Erro ao carregar o layout: ' + e.message);
                                    return;
                                }
                                // Criar canvas
                                const bgImg = new window.Image();
                                bgImg.onload = function() {
                                    const canvas = document.createElement('canvas');
                                    canvas.width = bgImg.width;
                                    canvas.height = bgImg.height;
                                    const ctx = canvas.getContext('2d');
                                    ctx.drawImage(bgImg, 0, 0, bgImg.width, bgImg.height);
                                    // Sobrepor o QR Code na posição correta (ajuste conforme necessário)
                                    const qrImg = new window.Image();
                                    qrImg.onload = function() {
                                        // Posição e tamanho do QR Code (ajuste fino para encaixar no celular)
                                        const qrW = 300;
                                        const qrH = 300;
                                        const qrX = 580;
                                        const qrY = 700;
                                        ctx.drawImage(qrImg, qrX, qrY, qrW, qrH);
                                        // Baixar PNG
                                        const link = document.createElement('a');
                                        link.href = canvas.toDataURL('image/png');
                                        link.download = 'qrcode_esim.png';
                                        link.click();
                                        btnPdf.disabled = false;
                                        btnPdf.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    };
                                    qrImg.onerror = function(e) {
                                        btnPdf.disabled = false;
                                        btnPdf.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                        alert('Erro ao carregar a imagem do QR Code para o canvas.');
                                    };
                                    qrImg.src = qrBase64;
                                };
                                bgImg.onerror = function(e) {
                                    btnPdf.disabled = false;
                                    btnPdf.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    alert('Erro ao carregar a imagem de fundo para o canvas.');
                                };
                                bgImg.src = bgBase64;
                            };
                        }
                    }, 200);
                    // Adiciona evento ao botão Escolher Planos
                    setTimeout(() => {
                        const escolherPlanosBtn = document.getElementById('escolherPlanosBtn');
                        const planosContainer = document.getElementById('planosContainer');
                        if (escolherPlanosBtn) {
                            escolherPlanosBtn.addEventListener('click', function() {
                                escolherPlanosBtn.disabled = true;
                                escolherPlanosBtn.innerHTML = '<span class="material-icons">hourglass_top</span>Carregando...';
                                // Pega o ICCID do input
                                const iccid = iccidInput.value.trim();
                                const urlPlanos = 'proxy-chip.php?rota=' + encodeURIComponent(`/api/Plan/Activation?Type=Pos&Iccid=${iccid}`);
                                fetch(urlPlanos)
                                    .then(resp => resp.json())
                                    .then(planos => {
                                        escolherPlanosBtn.style.display = 'none';
                                        if (!Array.isArray(planos) && planos.data) planos = planos.data;
                                        if (!Array.isArray(planos)) {
                                            planosContainer.innerHTML = '<span style="color:#e11d48;">Nenhum plano encontrado.</span>';
                                            return;
                                        }
                                        // Criar dropdown de planos
                                        let dropdown = `<div style='margin-top:18px;width:100%;max-width:340px;'>
                                            <label for='planoDropdown' style='font-weight:600;color:#2563eb;margin-bottom:6px;display:block;'>Escolha um plano:</label>
                                            <select id='planoDropdown' class='form-input' style='width:100%;font-size:1.08em;padding:12px 14px;border-radius:8px;border:1.5px solid #cbd5e1;'>
                                                <option value='' disabled selected>Selecione um plano</option>`;
                                        planos.forEach((plano, idx) => {
                                            let valor = plano.value || plano.price || '-';
                                            if (!isNaN(valor) && valor !== '-') {
                                                valor = (parseFloat(valor)/100).toFixed(2).replace('.', ',');
                                            }
                                            dropdown += `<option value='${plano.idPlanExternal || plano.planId || plano.id}'>${plano.name || plano.planName || 'Plano'} - R$ ${valor}</option>`;
                                        });
                                        dropdown += `</select></div>`;
                                        planosContainer.innerHTML = dropdown;
                                        // Evento para mostrar DDDs após escolha do plano
                                        const planoDropdown = document.getElementById('planoDropdown');
                                        if (planoDropdown) {
                                            planoDropdown.addEventListener('change', function() {
                                                // Remove dropdown anterior de DDD se existir
                                                let dddDropdownDiv = document.getElementById('dddDropdownDiv');
                                                if (dddDropdownDiv) dddDropdownDiv.remove();
                                                // Buscar DDDs
                                                fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Cart/DDD'))
                                                    .then(resp => resp.json())
                                                    .then(ddds => {
                                                        if (!Array.isArray(ddds) && ddds.data) ddds = ddds.data;
                                                        if (!Array.isArray(ddds)) {
                                                            planosContainer.insertAdjacentHTML('beforeend', '<span id="dddDropdownDiv" style="color:#e11d48;">Nenhum DDD encontrado.</span>');
                                                            return;
                                                        }
                                                        let dddDropdown = `<div id='dddDropdownDiv' style='margin-top:18px;width:100%;max-width:340px;'>
                                                            <label for='dddDropdown' style='font-weight:600;color:#2563eb;margin-bottom:6px;display:block;'>Escolha o DDD:</label>
                                                            <select id='dddDropdown' class='form-input' style='width:100%;font-size:1.08em;padding:12px 14px;border-radius:8px;border:1.5px solid #cbd5e1;'>
                                                                <option value='' disabled selected>Selecione o DDD</option>`;
                                                        ddds.forEach((ddd, idx) => {
                                                            dddDropdown += `<option value='${ddd.id || ddd.DDD || ddd}'>${ddd.name || ddd.DDD || ddd}</option>`;
                                                        });
                                                        dddDropdown += `</select></div>`;
                                                        planosContainer.insertAdjacentHTML('beforeend', dddDropdown);
                                                        // Adicionar campos extras após DDD
                                                        let extraFields = `<div id='extraFieldsDiv' style='margin-top:18px;width:100%;max-width:340px;display:flex;flex-direction:column;gap:10px;'>
                                                            <label style='font-weight:600;color:#2563eb;display:flex;align-items:center;gap:8px;'>
                                                                <input type='checkbox' id='portabilidadeCheck' style='accent-color:#2563eb;'> Portabilidade?
                                                            </label>
                                                            <label id='msisdnLabel' style='font-weight:600;color:#2563eb;display:none;'>Número a ser portado:
                                                                <input type='text' id='msisdnInput' class='form-input' placeholder='Ex: 5511981913040' value='' style='margin-top:4px;width:100%;'>
                                                            </label>
                                                        </div>`;
                                                        planosContainer.insertAdjacentHTML('beforeend', extraFields);
                                                        // --- CORREÇÃO FINAL VISIBILIDADE MSISDN ---
                                                        (function() {
                                                            const portabilidadeCheck = document.getElementById('portabilidadeCheck');
                                                            const msisdnLabel = document.getElementById('msisdnLabel');
                                                            const msisdnInput = document.getElementById('msisdnInput');
                                                            if (portabilidadeCheck && msisdnLabel && msisdnInput) {
                                                                function atualizarMsisdn() {
                                                                    if (portabilidadeCheck.checked) {
                                                                        msisdnLabel.style.display = 'block';
                                                                        msisdnInput.disabled = false;
                                                                    } else {
                                                                        msisdnLabel.style.display = 'none';
                                                                        msisdnInput.value = '';
                                                                        msisdnInput.disabled = true;
                                                                    }
                                                                }
                                                                portabilidadeCheck.addEventListener('change', atualizarMsisdn);
                                                                atualizarMsisdn();
                                                            }
                                                        })();
                                                        // Adicionar botão Criar ativação
                                                        let ativacaoBtnDiv = document.getElementById('ativacaoBtnDiv');
                                                        if (ativacaoBtnDiv) ativacaoBtnDiv.remove();
                                                        planosContainer.insertAdjacentHTML('beforeend', `<div id='ativacaoBtnDiv' style='margin-top:18px;'><button id='criarAtivacaoBtn' class='search-btn' style='min-width:180px;'><span class='material-icons'>bolt</span>Criar ativação</button><div id='ativacaoResult' style='margin-top:18px;'></div></div>`);
                                                        // Evento do botão
                                                        setTimeout(() => {
                                                            const criarAtivacaoBtn = document.getElementById('criarAtivacaoBtn');
                                                            const ativacaoResult = document.getElementById('ativacaoResult');
                                                            const planoDropdown = document.getElementById('planoDropdown');
                                                            const dddDropdown = document.getElementById('dddDropdown');
                                                            const portabilidadeCheck = document.getElementById('portabilidadeCheck');
                                                            const msisdnLabel = document.getElementById('msisdnLabel');
                                                            const msisdnInput = document.getElementById('msisdnInput');
                                                            if (criarAtivacaoBtn && planoDropdown && dddDropdown && portabilidadeCheck && msisdnLabel && msisdnInput) {
                                                                criarAtivacaoBtn.addEventListener('click', function() {
                                                                    ativacaoResult.innerHTML = '';
                                                                    criarAtivacaoBtn.disabled = true;
                                                                    criarAtivacaoBtn.innerHTML = '<span class="material-icons">hourglass_top</span>Criando...';
                                                                    // Obter dados
                                                                    const iccid = iccidInput.value.trim();
                                                                    const planoId = planoDropdown.value;
                                                                    const dddId = dddDropdown.value;
                                                                    
                                                                    // Salvar ID do plano Boramvno escolhido
                                                                    window.__planoIdBoramvno = planoId;
                                                                    
                                                                    // Buscar código IXC correspondente na tabela de mapeamento
                                                                    if (window.__planoIdBoramvno) {
                                                                        console.log('🔍 Buscando plano IXC para:', window.__planoIdBoramvno);
                                                                        fetch('buscar-plano.php?acao=buscar&plano_boramvno=' + encodeURIComponent(window.__planoIdBoramvno))
                                                                            .then(response => {
                                                                                console.log('📡 Resposta da API buscar-plano:', response.status, response.statusText);
                                                                                if (!response.ok) {
                                                                                    throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                                                                                }
                                                                                return response.json();
                                                                            })
                                                                            .then(data => {
                                                                                console.log('📋 Dados recebidos da API:', data);
                                                                                if (data.success && data.codigo_ixc) {
                                                                                    window.__planoIdIXC = data.codigo_ixc;
                                                                                    console.log('✅ Plano IXC encontrado:', window.__planoIdIXC);
                                                                                } else {
                                                                                    console.log('⚠️ Plano IXC não encontrado para:', window.__planoIdBoramvno);
                                                                                    console.log('📋 Resposta da API:', data);
                                                                                    window.__planoIdIXC = null;
                                                                                }
                                                                            })
                                                                            .catch(error => {
                                                                                console.error('❌ Erro ao buscar plano IXC:', error);
                                                                                window.__planoIdIXC = null;
                                                                            });
                                                                    } else {
                                                                        console.log('⚠️ window.__planoIdBoramvno não está definido');
                                                                    }
                                                                    const formIdSubscriberExternal = document.getElementById('clientId');
                                                                    let idSubscriberExternal = '';
                                                                    if (window.__ultimoClienteConsultado && window.__ultimoClienteConsultado.idSubscriberExternal) {
                                                                        idSubscriberExternal = window.__ultimoClienteConsultado.idSubscriberExternal;
                                                                    } else if (formIdSubscriberExternal && formIdSubscriberExternal.value && formIdSubscriberExternal.value !== '-') {
                                                                        idSubscriberExternal = formIdSubscriberExternal.value;
                                                                    }
                                                                    console.log('DEBUG idSubscriberExternal:', idSubscriberExternal);
                                                                    // Validações antes de enviar
                                                                    const guidRegex = /^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/;
                                                                    if (!iccid || iccid.length < 18 || iccid.length > 22) {
                                                                        ativacaoResult.innerHTML = '<span style="color:#e11d48;">ICCID inválido. Deve conter entre 18 e 22 dígitos.</span>';
                                                                        criarAtivacaoBtn.disabled = false;
                                                                        criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                        return;
                                                                    }
                                                                    if (!planoId || !guidRegex.test(planoId)) {
                                                                        ativacaoResult.innerHTML = '<span style="color:#e11d48;">Plano inválido. Selecione um plano válido.</span>';
                                                                        criarAtivacaoBtn.disabled = false;
                                                                        criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                        return;
                                                                    }
                                                                    // Validação do idSubscriberExternal
                                                                    if (!idSubscriberExternal || !guidRegex.test(idSubscriberExternal)) {
                                                                        ativacaoResult.innerHTML = '<span style="color:#e11d48;">ID do cliente inválido (idSubscriberExternal): ' + idSubscriberExternal + '</span>';
                                                                        criarAtivacaoBtn.disabled = false;
                                                                        criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                        return;
                                                                    }
                                                                    if (!dddId) {
                                                                        ativacaoResult.innerHTML = '<span style="color:#e11d48;">Selecione o DDD.</span>';
                                                                        criarAtivacaoBtn.disabled = false;
                                                                        criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                        return;
                                                                    }
                                                                    if (!idSubscriberExternal || !guidRegex.test(idSubscriberExternal)) {
                                                                        ativacaoResult.innerHTML = '<span style="color:#e11d48;">ID do cliente inválido (idSubscriberExternal): ' + idSubscriberExternal + '</span>';
                                                                        criarAtivacaoBtn.disabled = false;
                                                                        criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                        return;
                                                                    }
                                                                    // Montar payload
                                                                    const isPortabilidade = portabilidadeCheck && portabilidadeCheck.checked;
                                                                    const payload = {
                                                                        ddd: dddId,
                                                                        iccid: iccid,
                                                                        planId: planoId,
                                                                        clientId: idSubscriberExternal
                                                                    };
                                                                    if (isPortabilidade) {
                                                                        payload.msisdn = msisdnInput.value.trim();
                                                                        payload.planType = 'Pos';
                                                                    }
                                                                    // Mensagem de confirmação estilizada
                                                                    let resumo = `<div style='margin-bottom:8px;'><b>DDD:</b> ${payload.ddd}<br><b>ICCID:</b> ${payload.iccid}<br><b>Plano:</b> ${payload.planId}<br><b>Cliente:</b> ${payload.clientId}<br>`;
                                                                    if (isPortabilidade) {
                                                                        resumo += `<b>MSISDN:</b> ${payload.msisdn}<br><b>Portabilidade:</b> Sim`;
                                                                    } else {
                                                                        resumo += `<b>Portabilidade:</b> Não`;
                                                                    }
                                                                    resumo += `</div>`;
                                                                    criarAtivacaoBtn.disabled = true;
                                                                    showConfirmModal(resumo).then((confirmado) => {
                                                                        if (!confirmado) {
                                                                            criarAtivacaoBtn.disabled = false;
                                                                            criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                            return;
                                                                        }
                                                                        fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Cart/subscription'), {
                                                                            method: 'POST',
                                                                            headers: { 'Content-Type': 'application/json' },
                                                                            body: JSON.stringify(payload)
                                                                        })
                                                                        .then(resp => resp.json())
                                                                        .then(data => {
                                                                            criarAtivacaoBtn.disabled = false;
                                                                            criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                            if (data && data.error) {
                                                                                ativacaoResult.innerHTML = `<span style='color:#e11d48;'>Erro do backend: ${data.error}<br>Detalhe: ${data.detail || ''}</span>`;
                                                                            } else if (data && data.cartId) {
                                                                                ativacaoResult.innerHTML = `
                                                                                    <div style='background:#d1fae5;border:2px solid #10b981;padding:24px 18px;border-radius:16px;box-shadow:0 2px 12px #10b98122;display:flex;flex-direction:column;align-items:center;gap:10px;max-width:420px;margin:0 auto;'>
                                                                                        <span class="material-icons" style="color:#10b981;font-size:3em;">check_circle</span>
                                                                                        <div style="font-size:1.2em;font-weight:600;color:#065f46;">Ativação realizada com sucesso!</div>
                                                                                        <div style="color:#222;font-size:1em;margin-top:6px;">
                                                                                            <b>cartId:</b> <span style='color:#2563eb;'>${data.cartId}</span>
                                                                                        </div>
                                                                                    </div>`;
                                                                                // Preencher automaticamente o campo do form de finalizar carrinho
                                                                                const cartIdInput = document.getElementById('cartIdFinalizar');
                                                                                if (cartIdInput) cartIdInput.value = data.cartId;
                                                                            } else {
                                                                                ativacaoResult.innerHTML = `<div style='margin-bottom:8px;font-size:0.98em;color:#2563eb;'><b>ClientId utilizado (idSubscriberExternal):</b> ${idSubscriberExternal}</div><pre style='background:#f1f5f9;padding:12px 16px;border-radius:8px;color:#222;font-size:1em;'>${JSON.stringify(data, null, 2)}</pre>`;
                                                                            }
                                                                        })
                                                                        .catch(err => {
                                                                            criarAtivacaoBtn.disabled = false;
                                                                            criarAtivacaoBtn.innerHTML = '<span class="material-icons">bolt</span>Criar ativação';
                                                                            ativacaoResult.innerHTML = `<span style='color:#e11d48;'>Erro ao criar ativação: ${err.message}</span>`;
                                                                        });
                                                                    });
                                                                });
                                                            }
                                                        }, 100);
                                                    })
                                                    .catch(err => {
                                                        planosContainer.insertAdjacentHTML('beforeend', `<span id='dddDropdownDiv' style='color:#e11d48;'>Erro ao buscar DDDs: ${err.message}</span>`);
                                                    });
                                            });
                                        }
                                    })
                                    .catch(err => {
                                        escolherPlanosBtn.style.display = 'none';
                                        planosContainer.innerHTML = `<span style='color:#e11d48;'>Erro ao buscar planos: ${err.message}</span>`;
                                    });
                            });
                        }
                    }, 100);
                } else {
                    chipResult.innerHTML = `
                    <div style=\"background:#fef3c7;border:2px solid #f59e42;padding:24px 18px;border-radius:16px;box-shadow:0 2px 12px #f59e4222;display:flex;flex-direction:column;align-items:center;gap:10px;max-width:420px;margin:0 auto;\">
                        <span class=\"material-icons\" style=\"color:#f59e42;font-size:3em;\">info</span>
                        <div style=\"font-size:1.2em;font-weight:600;color:#b45309;\">Chip já está em uso.</div>
                        <div style=\"color:#222;font-size:1em;margin-top:6px;\">
                            <b>ICCID:</b> ${data.iccid}<br>
                            <b>IMSI:</b> ${data.imsi || '-'}<br>
                            <b>Tipo:</b> ${data.iccicType || '-'}<br>
                            <b>Status:</b> ${data.status}<br>
                            ${data.qrCodeUrl ? `<b>QR Code:</b> <a href='${data.qrCodeUrl}' target='_blank'>Visualizar</a><br>` : ''}
                            <b>Criado em:</b> ${data.createdAt ? new Date(data.createdAt).toLocaleString('pt-BR') : '-'}
                        </div>
                    </div>`;
                }
            })
            .catch(err => {
                consultarChipBtn.disabled = false;
                consultarChipBtn.innerHTML = '<span class="material-icons">search</span>Consultar chip';
                chipResult.innerHTML = `<span style='color:#e11d48;'>Erro ao consultar chip: ${err.message}</span>`;
            });
    });
    // Finalizar carrinho BilletCombo
    document.getElementById('finalizarCarrinhoBtn').addEventListener('click', async function() {
        const cartId = document.getElementById('cartIdFinalizar').value.trim();
        const resultDiv = document.getElementById('finalizarCarrinhoResult');
        resultDiv.innerHTML = '';
        if (!cartId || cartId.length < 10) {
            resultDiv.innerHTML = '<span style="color:#e11d48;">Digite um cartId válido.</span>';
            return;
        }
        
        // Verificar se temos todos os dados necessários para a operação complexa
        if (!window.__clienteIdIXC) {
            resultDiv.innerHTML = '<span style="color:#e11d48;">❌ Cliente IXC não encontrado. Consulte um cliente primeiro.</span>';
            return;
        }
        
        if (!window.__planoIdIXC) {
            resultDiv.innerHTML = '<span style="color:#e11d48;">❌ Plano IXC não encontrado. Escolha um plano primeiro.</span>';
            return;
        }
        document.getElementById('finalizarCarrinhoBtn').disabled = true;
        document.getElementById('finalizarCarrinhoBtn').innerHTML = '<span class="material-icons">hourglass_top</span>Finalizando...';
        try {
            // === PASSO 1: Finalizar carrinho Boramvno ===
            console.log('🔄 PASSO 1: Finalizando carrinho Boramvno...');
            const rota = `/api/Cart/subscription/${cartId}/BilletCombo`;
            const response = await fetch('proxy-chip.php?rota=' + encodeURIComponent(rota), {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' }
            });
            
            const data = await response.json();
            
            if (data && data.error) {
                throw new Error(`Erro ao finalizar: ${data.error} - ${data.detail || ''}`);
            }
            
            // Salvar MSISDN da resposta
            if (data.msisdn) {
                window.__msisdnFinalizado = data.msisdn;
                console.log('✅ MSISDN salvo:', window.__msisdnFinalizado);
            }
            
            // === PASSO 2: Obter AccountId do Boramvno ===
            console.log('🔄 PASSO 2: Obtendo AccountId do Boramvno...');
            console.log('🔍 Dados completos da resposta de ativação:', data);
            
            // Primeiro, tentar obter accountId diretamente da resposta de ativação
            let accountIdDaResposta = null;
            if (data && typeof data === 'object') {
                const possibleAccountIds = [
                    data.accountId,
                    data.id,
                    data.subscriberId,
                    data.account_id,
                    data.subscriber_id
                ];
                
                accountIdDaResposta = possibleAccountIds.find(id => id && id !== 'null' && id !== 'undefined');
                
                if (accountIdDaResposta) {
                    console.log('🎉 AccountId encontrado diretamente na resposta de ativação:', accountIdDaResposta);
                    window.__accountIdBoramvno = accountIdDaResposta;
                } else {
                    console.log('⚠️ AccountId não encontrado na resposta de ativação. Tentando API...');
                }
            }
            
            // Se não encontrou na resposta, buscar via API com retry inteligente
            if (!accountIdDaResposta && window.__msisdnFinalizado) {
                console.log('🔄 Buscando AccountId via API Subscription/Details com retry inteligente...');
                
                // Retry com intervalos crescentes para dar tempo da linha ficar disponível
                const intervalos = [5000, 10000, 15000, 20000, 25000, 30000]; // 5s, 10s, 15s, 20s, 25s, 30s
                let accountIdEncontrado = null;
                
                for (let tentativa = 1; tentativa <= intervalos.length; tentativa++) {
                    console.log(`🔄 Tentativa ${tentativa}/${intervalos.length} - Aguardando ${intervalos[tentativa-1]/1000}s...`);
                    
                    try {
                        const subscriberResponse = await fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/${window.__msisdnFinalizado}/details`));
                        console.log(`📡 Tentativa ${tentativa} - Status:`, subscriberResponse.status, subscriberResponse.statusText);
                        
                        if (!subscriberResponse.ok) {
                            throw new Error(`HTTP ${subscriberResponse.status}: ${subscriberResponse.statusText}`);
                        }
                        
                        const subscriberData = await subscriberResponse.json();
                        console.log(`📋 Tentativa ${tentativa} - Dados:`, subscriberData);
                        
                        if (subscriberData && !subscriberData.error && subscriberData.accountId) {
                            console.log(`✅ AccountId encontrado na tentativa ${tentativa}:`, subscriberData.accountId);
                            accountIdEncontrado = subscriberData.accountId;
                            break; // Sair do loop quando encontrar
                        } else if (subscriberData && subscriberData.error) {
                            console.log(`⚠️ Tentativa ${tentativa} - Erro:`, subscriberData.error);
                            
                            if (subscriberData.http_code === 404) {
                                console.log(`⏳ Linha ainda não disponível (404). Aguardando próxima tentativa...`);
                            }
                        }
                    } catch (error) {
                        console.error(`❌ Tentativa ${tentativa} - Erro:`, error.message);
                    }
                    
                    // Aguardar antes da próxima tentativa (exceto na última)
                    if (tentativa < intervalos.length) {
                        console.log(`⏳ Aguardando ${intervalos[tentativa]/1000}s para próxima tentativa...`);
                        await new Promise(resolve => setTimeout(resolve, intervalos[tentativa]));
                    }
                }
                
                if (accountIdEncontrado) {
                    console.log('🎉 AccountId obtido com sucesso após retry:', accountIdEncontrado);
                    window.__accountIdBoramvno = accountIdEncontrado;
                } else {
                    console.log('⚠️ AccountId não foi encontrado após todas as tentativas');
                    console.log('💡 A linha pode precisar de mais tempo para ficar disponível');
                }
            }
            
            // Resumo final do AccountId
            if (window.__accountIdBoramvno) {
                console.log('🎯 AccountId final obtido:', window.__accountIdBoramvno);
            } else {
                console.log('⚠️ Nenhum AccountId foi encontrado (nem na resposta nem via API)');
            }
            
            // === PASSO 3: Inserir contrato no IXC ===
            console.log('🔄 PASSO 3: Inserindo contrato no IXC...');
            console.log('🔍 Dados para contrato IXC:', {
                clienteId: window.__clienteIdIXC,
                planoId: window.__planoIdIXC,
                accountId: window.__accountIdBoramvno,
                accountIdType: typeof window.__accountIdBoramvno,
                accountIdValid: window.__accountIdBoramvno && window.__accountIdBoramvno !== 'null' && window.__accountIdBoramvno !== 'undefined'
            });
            
            // Verificar se temos dados válidos
            if (!window.__clienteIdIXC) {
                console.log('⚠️ Cliente IXC não encontrado');
            }
            if (!window.__planoIdIXC) {
                console.log('⚠️ Plano IXC não encontrado');
            }
            if (!window.__accountIdBoramvno || window.__accountIdBoramvno === 'null' || window.__accountIdBoramvno === 'undefined') {
                console.log('⚠️ AccountId inválido ou não encontrado');
            }
            
            if (window.__clienteIdIXC && window.__planoIdIXC) {
                try {
                    const contratoResponse = await fetch('inserir-contrato-ixc.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({
                            idCliente: window.__clienteIdIXC,
                            idPlanoVenda: window.__planoIdIXC,
                            accountId: window.__accountIdBoramvno || 'N/A'
                        })
                    });
                    
                    if (!contratoResponse.ok) {
                        throw new Error(`HTTP ${contratoResponse.status}: ${contratoResponse.statusText}`);
                    }
                    
                    const contratoData = await contratoResponse.json();
                    console.log('✅ Resposta contrato IXC:', contratoData);
                    
                    if (contratoData.success) {
                        console.log('🎉 Contrato IXC inserido com sucesso!');
                    } else {
                        console.log('⚠️ Contrato IXC não foi inserido:', contratoData.error);
                    }
                } catch (error) {
                    console.error('❌ Erro ao inserir contrato IXC:', error);
                    console.log('⚠️ Continuando sem inserir contrato IXC...');
                }
            } else {
                console.log('⚠️ Dados insuficientes para inserir contrato IXC:', {
                    temClienteId: !!window.__clienteIdIXC,
                    temPlanoId: !!window.__planoIdIXC
                });
            }
            
            // === MENSAGEM DE SUCESSO ===
            document.getElementById('finalizarCarrinhoBtn').disabled = false;
            document.getElementById('finalizarCarrinhoBtn').innerHTML = '<span class="material-icons">done_all</span>Finalizar';
            
            let html = `<div style='background:#d1fae5;border:2px solid #10b981;padding:18px 14px;border-radius:12px;box-shadow:0 2px 12px #10b98122;display:flex;flex-direction:column;align-items:center;gap:10px;max-width:420px;margin:0 auto;'>`;
            html += `<span class="material-icons" style="color:#22c55e;font-size:4em;animation:pop 0.5s cubic-bezier(.68,-0.55,.27,1.55);margin-bottom:8px;">emoji_events</span>`;
            html += `<div style="font-size:1.2em;font-weight:700;color:#065f46;">Operação Completa com Sucesso!</div>`;
            html += `<div style='width:100%;text-align:left;font-size:1.08em;color:#222;margin-top:8px;'>`;
            if (data.iccid) html += `<b>ICCID:</b> <span style='color:#2563eb;'>${data.iccid}</span><br>`;
            if (data.msisdn) html += `<b>MSISDN:</b> <span style='color:#2563eb;'>${data.msisdn}</span><br>`;
            if (typeof data.isPortability !== 'undefined') html += `<b>Portabilidade:</b> ${data.isPortability ? 'Sim' : 'Não'}<br>`;
            if (typeof data.statusPayment !== 'undefined') html += `<b>Pagamento:</b> ${data.statusPayment ? 'Aprovado' : 'Pendente'}<br>`;
            html += `<b>Cliente IXC:</b> <span style='color:#2563eb;'>${window.__clienteIdIXC}</span><br>`;
            html += `<b>Plano IXC:</b> <span style='color:#2563eb;'>${window.__planoIdIXC}</span><br>`;
            if (window.__accountIdBoramvno) html += `<b>AccountId:</b> <span style='color:#2563eb;'>${window.__accountIdBoramvno}</span><br>`;
            html += `<div style="margin-top:12px;padding:8px 12px;background:#dbeafe;border-radius:6px;font-size:0.9rem;color:#1e40af;">`;
            html += `<strong>✅ Operação Complexa Concluída:</strong><br>`;
            html += `• Boramvno: Linha ativada<br>`;
            html += `• IXC: Contrato inserido<br>`;
            html += `• Mapeamento: Plano ${window.__planoIdBoramvno} → ${window.__planoIdIXC}`;
            html += `</div>`;
            
            if (data.eSimQrCodeUrl) {
                html += `<div style="margin-top:18px;display:flex;flex-direction:column;align-items:center;gap:8px;">
                    <div style="background:#f1f5f9;border:2.5px solid #10b981;border-radius:18px;padding:18px;display:flex:flex-direction:column;align-items:center;">
                        <img id="esimQrCodeImg" src="${data.eSimQrCodeUrl}" alt="QR Code E-SIM" style="width:180px;height:180px;object-fit:contain;display:block;" />
                    </div>
                    <div style="font-size:1.08em;color:#10b981;font-weight:600;margin-top:8px;">Use este QR Code para ativar sua linha E-SIM</div>
                    <button id="baixarEsimQrBtn" style="margin-top:6px;background:linear-gradient(90deg,#10b981 0%,#2563eb 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #10b98111;display:flex:align-items:center;gap:8px;font-size:1.05em;border:none;cursor:pointer;">
                        <span class="material-icons" style="font-size:1.2em;">download</span> Baixar QR Code (PNG)
                    </button>
                </div>`;
            }
            html += `</div></div>`;
            resultDiv.innerHTML = html;
            
            // Adicionar funcionalidade de download do QR Code E-SIM
            if (data.eSimQrCodeUrl) {
                    setTimeout(() => {
                        const btnEsimQr = document.getElementById('baixarEsimQrBtn');
                        if (btnEsimQr) {
                            btnEsimQr.onclick = async function() {
                                btnEsimQr.disabled = true;
                                btnEsimQr.innerHTML = '<span class="material-icons">hourglass_top</span>Gerando PNG...';
                                
                                // Carregar imagens como base64
                                async function toBase64Fetch(url, label) {
                                    try {
                                        console.log('Iniciando fetch de', label, url);
                                        const controller = new AbortController();
                                        const timeout = setTimeout(() => controller.abort(), 8000);
                                        const response = await fetch(url, {mode: 'cors', signal: controller.signal});
                                        clearTimeout(timeout);
                                        if (!response.ok) throw new Error('Erro ao baixar imagem: ' + response.status);
                                        const blob = await response.blob();
                                        return new Promise((resolve, reject) => {
                                            const reader = new FileReader();
                                            reader.onloadend = () => { console.log('Base64 pronto de', label); resolve(reader.result); };
                                            reader.onerror = (e) => { console.error('Erro FileReader', label, e); reject(e); };
                                            reader.readAsDataURL(blob);
                                        });
                                    } catch (err) {
                                        console.error('Falha ao carregar imagem', label, err);
                                        throw new Error('Falha ao carregar imagem ' + label + ': ' + err.message);
                                    }
                                }
                                
                                const qrUrl = document.getElementById('esimQrCodeImg')?.src;
                                const bgUrl = 'layout_chip.png';
                                let qrBase64 = qrUrl;
                                let bgBase64 = bgUrl;
                                
                                try { 
                                    qrBase64 = await toBase64Fetch('proxy-img.php?url=' + encodeURIComponent(qrUrl), 'QR Code E-SIM'); 
                                } catch(e){
                                    btnEsimQr.disabled = false;
                                    btnEsimQr.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    alert('Erro ao carregar o QR Code: ' + e.message);
                                    return;
                                }
                                
                                try { 
                                    bgBase64 = await toBase64Fetch(bgUrl, 'Layout'); 
                                } catch(e){
                                    btnEsimQr.disabled = false;
                                    btnEsimQr.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    alert('Erro ao carregar o layout: ' + e.message);
                                    return;
                                }
                                
                                // Criar canvas
                                const bgImg = new window.Image();
                                bgImg.onload = function() {
                                    const canvas = document.createElement('canvas');
                                    canvas.width = bgImg.width;
                                    canvas.height = bgImg.height;
                                    const ctx = canvas.getContext('2d');
                                    ctx.drawImage(bgImg, 0, 0, bgImg.width, bgImg.height);
                                    
                                    // Sobrepor o QR Code na posição correta
                                    const qrImg = new window.Image();
                                    qrImg.onload = function() {
                                        // Posição e tamanho do QR Code (mesma posição do chip físico)
                                        const qrW = 300;
                                        const qrH = 300;
                                        const qrX = 580;
                                        const qrY = 700;
                                        ctx.drawImage(qrImg, qrX, qrY, qrW, qrH);
                                        
                                        // Baixar PNG
                                        const link = document.createElement('a');
                                        link.href = canvas.toDataURL('image/png');
                                        link.download = 'qrcode_esim_finalizado.png';
                                        link.click();
                                        
                                        btnEsimQr.disabled = false;
                                        btnEsimQr.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    };
                                    
                                    qrImg.onerror = function(e) {
                                        btnEsimQr.disabled = false;
                                        btnEsimQr.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                        alert('Erro ao carregar a imagem do QR Code para o canvas.');
                                    };
                                    qrImg.src = qrBase64;
                                };
                                
                                bgImg.onerror = function(e) {
                                    btnEsimQr.disabled = false;
                                    btnEsimQr.innerHTML = '<span class="material-icons">download</span> Baixar QR Code (PNG)';
                                    alert('Erro ao carregar a imagem de fundo para o canvas.');
                                };
                                bgImg.src = bgBase64;
                            };
                        }
                    }, 200);
                }
            
        } catch (error) {
            console.error('❌ Erro na operação complexa:', error);
            document.getElementById('finalizarCarrinhoBtn').disabled = false;
            document.getElementById('finalizarCarrinhoBtn').innerHTML = '<span class="material-icons">done_all</span>Finalizar';
            
            resultDiv.innerHTML = `<div style='background:#fee2e2;border:2px solid #ef4444;padding:18px 14px;border-radius:12px;box-shadow:0 2px 12px #ef444422;display:flex;flex-direction:column;align-items:center;gap:10px;max-width:420px;margin:0 auto;'>
                <span class="material-icons" style="color:#ef4444;font-size:4em;">error</span>
                <div style="font-size:1.2em;font-weight:700;color:#991b1b;">Erro na Operação</div>
                <div style="color:#7f1d1d;text-align:center;font-size:1em;">${error.message}</div>
            </div>`;
        }
    });
    </script>
    <!-- Adicione o HTML do modal no final do body (antes do </body>): -->
    <div id="confirmModal" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.35);z-index:9999;align-items:center;justify-content:center;">
      <div style="background:#fff;border-radius:18px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18);padding:32px 28px;max-width:380px;width:90vw;display:flex;flex-direction:column;align-items:center;gap:18px;">
        <div id="confirmModalTitle" style="font-size:1.18em;font-weight:700;color:#2563eb;margin-bottom:6px;">Confirme os dados da ativação</div>
        <div id="confirmModalContent" style="font-size:1.05em;color:#222;text-align:left;width:100%;"></div>
        <div style="display:flex;gap:18px;margin-top:10px;">
          <button id="confirmModalCancel" style="padding:10px 22px;border:none;border-radius:8px;background:#e11d48;color:#fff;font-weight:600;font-size:1em;cursor:pointer;">Cancelar</button>
          <button id="confirmModalOk" style="padding:10px 22px;border:none;border-radius:8px;background:linear-gradient(90deg,#2563eb 0%,#10b981 100%);color:#fff;font-weight:600;font-size:1em;cursor:pointer;">Confirmar</button>
        </div>
      </div>
    </div>
    <script>
    // Função para mostrar o modal
    function showConfirmModal(resumo) {
      return new Promise((resolve) => {
        const modal = document.getElementById('confirmModal');
        const content = document.getElementById('confirmModalContent');
        const btnOk = document.getElementById('confirmModalOk');
        const btnCancel = document.getElementById('confirmModalCancel');
        content.innerHTML = resumo;
        modal.style.display = 'flex';
        function close(result) {
          modal.style.display = 'none';
          btnOk.removeEventListener('click', okHandler);
          btnCancel.removeEventListener('click', cancelHandler);
          resolve(result);
        }
        function okHandler() { close(true); }
        function cancelHandler() { close(false); }
        btnOk.addEventListener('click', okHandler);
        btnCancel.addEventListener('click', cancelHandler);
      });
    }
    </script>
</body>
</html>
