#!/bin/bash

echo "🚀 INSTALAÇÃO AUTOMÁTICA DO SISTEMA CORE3CHIP"
echo "=============================================="
echo "Servidor: 192.168.2.16"
echo "Data: $(date)"
echo ""

# 1. Atualizar sistema
echo "📦 PASSO 1: Atualizando repositórios..."
apt-get update -y
if [ $? -eq 0 ]; then
    echo "✅ Repositórios atualizados com sucesso!"
else
    echo "❌ Erro ao atualizar repositórios"
    exit 1
fi

# 2. Instalar extensões PHP
echo ""
echo "🔧 PASSO 2: Instalando extensões PHP..."
apt-get install -y php7.4-curl php7.4-xml php7.4-mbstring php7.4-mysql php7.4-json
if [ $? -eq 0 ]; then
    echo "✅ Extensões PHP instaladas com sucesso!"
else
    echo "❌ Erro ao instalar extensões PHP"
    exit 1
fi

# 3. Criar diretórios do sistema
echo ""
echo "📁 PASSO 3: Criando diretórios do sistema..."
mkdir -p /var/www/html/sistema
mkdir -p /var/www/html/sistema/logs
chown -R www-data:www-data /var/www/html/sistema
chmod -R 755 /var/www/html/sistema
chmod -R 777 /var/www/html/sistema/logs
echo "✅ Diretórios criados e configurados!"

# 4. Verificar extensões PHP instaladas
echo ""
echo "✅ PASSO 4: Verificando extensões PHP..."
php -m | grep -E "(curl|xml|mbstring|mysql|json)"
echo "✅ Extensões verificadas!"

# 5. Verificar serviços
echo ""
echo "🔍 PASSO 5: Verificando serviços..."
echo "Status do Apache2:"
systemctl status apache2 --no-pager | head -5
echo ""
echo "Status do MySQL:"
systemctl status mysql --no-pager | head -5

# 6. Configurar banco de dados
echo ""
echo "🗄️ PASSO 6: Configurando banco de dados..."
mysql -e "CREATE DATABASE IF NOT EXISTS ixcprovedor;"
mysql -e "USE ixcprovedor; SHOW TABLES;" 2>/dev/null || echo "Banco criado com sucesso!"

# 7. Criar arquivo de configuração
echo ""
echo "⚙️ PASSO 7: Criando arquivo de configuração..."
cat > /var/www/html/sistema/config.php << 'EOF'
<?php
// Configuração de Produção - Sistema Core3Chip
define('DB_HOST', 'localhost');
define('DB_NAME', 'ixcprovedor');
define('DB_USER', 'root');
define('DB_PASS', '');

// Configurações IXC
define('IXC_HOST', 'https://app.core3.com.br/webservice/v1');
define('IXC_TOKEN', '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d');

// Configurações do Sistema
define('SISTEMA_URL', 'http://192.168.2.16/sistema');
define('SISTEMA_PATH', '/var/www/html/sistema');
define('LOGS_PATH', '/var/www/html/sistema/logs');

// Configurações de Timezone
date_default_timezone_set('America/Sao_Paulo');

// Configurações de Debug
define('DEBUG_MODE', false);
define('LOG_LEVEL', 'INFO');

echo "✅ Configuração de produção carregada!";
?>
EOF

echo "✅ Arquivo de configuração criado!"

# 8. Configurar cron automático
echo ""
echo "⏰ PASSO 8: Configurando cron automático..."
(crontab -l 2>/dev/null; echo "0 6 * * * /usr/bin/php /var/www/html/sistema/teste_bloqueio.php >> /var/log/desativacao_recorrencia.log 2>&1") | crontab -
echo "✅ Cron configurado para executar às 06:00 diariamente!"

# 9. Resumo final
echo ""
echo "🎉 INSTALAÇÃO CONCLUÍDA COM SUCESSO!"
echo "====================================="
echo "📁 Sistema instalado em: /var/www/html/sistema"
echo "📝 Logs em: /var/www/html/sistema/logs"
echo "🌐 Acesse: http://192.168.2.16/sistema"
echo "⏰ Cron configurado para execução automática"
echo ""
echo "📋 PRÓXIMOS PASSOS:"
echo "1. Upload dos arquivos do sistema"
echo "2. Configurar permissões finais"
echo "3. Testar sistema completo"
echo ""
echo "✅ Servidor configurado e pronto para receber os arquivos!"

