#!/bin/bash

echo "🚀 INSTALAÇÃO SEM REPOSITÓRIOS EXTERNOS"
echo "======================================"

# 1. Verificar o que já está instalado
echo "🔍 Verificando extensões PHP já instaladas..."
php -m | grep -E "(curl|xml|mbstring|mysql|json)"

# 2. Criar diretórios do sistema
echo ""
echo "📁 Criando diretórios do sistema..."
mkdir -p /var/www/html/sistema
mkdir -p /var/www/html/sistema/logs
chown -R www-data:www-data /var/www/html/sistema
chmod -R 755 /var/www/html/sistema
chmod -R 777 /var/www/html/sistema/logs
echo "✅ Diretórios criados!"

# 3. Configurar banco de dados
echo ""
echo "🗄️ Configurando banco de dados..."
mysql -e "CREATE DATABASE IF NOT EXISTS ixcprovedor;"
echo "✅ Banco de dados criado!"

# 4. Configurar cron automático
echo ""
echo "⏰ Configurando cron automático..."
(crontab -l 2>/dev/null; echo "0 6 * * * /usr/bin/php /var/www/html/sistema/teste_bloqueio.php >> /var/log/desativacao_recorrencia.log 2>&1") | crontab -
echo "✅ Cron configurado!"

# 5. Verificar serviços
echo ""
echo "🔍 Verificando serviços..."
systemctl status apache2 --no-pager | head -5
echo ""
systemctl status mysql --no-pager | head -5

echo ""
echo "🎉 INSTALAÇÃO CONCLUÍDA!"
echo "📁 Sistema em: /var/www/html/sistema"
echo "📝 Logs em: /var/www/html/sistema/logs"
echo "🌐 Acesse: http://192.168.2.16/sistema"
echo ""
echo "⚠️ NOTA: Algumas extensões PHP podem não estar disponíveis"
echo "💡 O sistema funcionará com as extensões já instaladas"

