<?php
header('Content-Type: application/json');

// Incluir configurações da API IXC
require_once 'confApi.php';

try {
    // Verificar se é uma requisição POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método não permitido. Use POST.');
    }
    
    // Obter dados do corpo da requisição
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Dados inválidos no corpo da requisição');
    }
    
    // Validar campos obrigatórios
    $idCliente = $input['idCliente'] ?? null;
    $idPlanoVenda = $input['idPlanoVenda'] ?? null;
    $accountId = $input['accountId'] ?? null;
    
    if (!$idCliente) {
        throw new Exception('idCliente é obrigatório');
    }
    
    if (!$idPlanoVenda) {
        throw new Exception('idPlanoVenda é obrigatório');
    }
    
    // Função para inserir contrato no IXC
    function addContrato($idCliente, $idPlanoVenda, $accountId) {
        global $api;
        
        $desc_plano_venda = "COMBO LINHA CORE3CHIP";
        $data_atual = date('d/m/Y');
        
        $dados = array(
            'tipo' => 'I',
            'id_cliente' => "$idCliente",
            'id_vd_contrato' => "$idPlanoVenda",
            'descricao_aux_plano_venda' => '',
            'contrato' => "$desc_plano_venda",
            'id_tipo_contrato' => '93',
            'id_modelo' => '14',
            'assinatura_digital' => 'N',
            'integracao_assinatura_digital' => 'P',
            'liberacao_bloqueio_manual' => 'P',
            'id_filial' => '11',
            'indicacao_contrato_id' => '',
            'data_assinatura' => '',
            'data_ativacao' => "$data_atual",
            'data' => "$data_atual",
            'data_renovacao' => '',
            'pago_ate_data' => '',
            'status' => 'A',
            'status_internet' => 'A',
            'status_velocidade' => 'N',
            'tipo_produtos_plano' => 'P',
            'motivo_inclusao' => 'I',
            'id_indexador_reajuste' => '',
            'url_assinatura_digital' => '',
            'token_assinatura_digital' => '',
            'id_tipo_documento' => '501',
            'id_carteira_cobranca' => '30',
            'id_vendedor' => '1',
            'moeda' => '',
            'comissao' => '',
            'cc_previsao' => 'P',
            'tipo_cobranca' => 'P',
            'renovacao_automatica' => 'N',
            'gerar_finan_assin_digital_contrato' => 'P',
            'base_geracao_tipo_doc' => 'P',
            'id_contrato_principal' => '',
            'num_parcelas_atraso' => '',
            'nf_info_adicionais' => '',
            'credit_card_recorrente_bandeira_cartao' => '',
            'credit_card_recorrente_token' => '',
            'ids_contratos_recorrencia' => '',
            'tipo_doc_opc' => '',
            'tipo_doc_opc2' => '',
            'tipo_doc_opc3' => '',
            'tipo_doc_opc4' => '',
            'id_tipo_doc_ativ' => '',
            'id_produto_ativ' => '',
            'taxa_instalacao' => '0.00',
            'id_cond_pag_ativ' => '',
            'id_responsavel' => '390',
            'id_vendedor_ativ' => '',
            'ativacao_numero_parcelas' => '',
            'ativacao_vencimentos' => '',
            'btn_nf_ativacao' => '',
            'ativacao_valor_parcela' => '',
            'fidelidade' => '',
            'data_expiracao' => '',
            'dica_data_expiracao' => '',
            'desconto_fidelidade' => '0.00',
            'id_instalador' => '',
            'taxa_improdutiva' => '',
            'venc_personalizado' => '',
            'com_entrada' => '',
            'dia_fixo_vencimento' => '',
            'tipo_condicao_pag' => '',
            'bloqueio_automatico' => 'N',
            'nao_bloquear_ate' => '',
            'aviso_atraso' => 'N',
            'nao_avisar_ate' => '',
            'desbloqueio_confianca' => 'P',
            'desbloqueio_confianca_ativo' => 'N',
            'restricao_auto_desbloqueio' => 'N',
            'motivo_restricao_auto_desbloq' => '',
            'obs' => '',
            'nao_susp_parc_ate' => '',
            'liberacao_suspensao_parcial' => 'P',
            'utilizando_auto_libera_susp_parc' => 'N',
            'restricao_auto_libera_susp_parcial' => 'N',
            'motivo_restri_auto_libera_parc' => '',
            'contrato_suspenso' => 'N',
            'data_inicial_suspensao' => '',
            'data_final_suspensao' => '',
            'data_acesso_desativado' => '',
            'data_cancelamento' => '',
            'id_responsavel_cancelamento' => '',
            'motivo_cancelamento' => '',
            'motivo_adicional' => '',
            'concorrente_mot_adicional' => '',
            'dica_motivo_adicional_cliente_contrato' => '',
            'obs_cancelamento' => '',
            'data_negativacao' => '',
            'id_responsavel_negativacao' => '',
            'protocolo_negativacao' => '',
            'id_motivo_negativacao' => '',
            'obs_negativacao' => '',
            'data_desistencia' => '',
            'id_responsavel_desistencia' => '',
            'motivo_desistencia' => '',
            'obs_desistencia' => '',
            'obs_contrato' => '',
            'alerta_contrato' => '',
            'imp_realizado' => 'S',
            'imp_inicial' => '',
            'imp_carteira' => 'N',
            'imp_importacao' => 'N',
            'imp_treinamento' => 'N',
            'imp_rede' => 'N',
            'imp_bkp' => 'N',
            'imp_obs' => "$accountId",
            'imp_final' => '',
            'imp_status' => 'A',
            'imp_motivo' => '',
            'dt_ult_bloq_auto' => '',
            'dt_ult_bloq_manual' => '',
            'dt_ult_finan_atraso' => '',
            'dt_ult_des_bloq_conf' => '',
            'dt_ult_liberacao_susp_parc' => '',
            'dt_ult_ativacao' => '',
            'dt_utl_negativacao' => '',
            'dt_ult_desiste' => '',
            'data_cadastro_sistema' => '',
            'ultima_atualizacao' => 'CURRENT_TIMESTAMP',
            'data_retomada_contrato' => 'NULL',
            'endereco_padrao_cliente' => 'S',
            'endereco_padrao_alert' => '',
            'id_condominio' => '',
            'condominio_novo' => '',
            'bloco' => '',
            'bloco_novo' => '',
            'apartamento' => '',
            'apartamento_novo' => '',
            'cep' => '',
            'cep_novo' => '',
            'endereco' => '',
            'endereco_novo' => '',
            'numero' => '',
            'numero_novo' => '',
            'bairro' => '',
            'bairro_novo' => '',
            'cidade' => '',
            'cidade_novo' => '',
            'complemento' => '',
            'complemento_novo' => '',
            'referencia' => '',
            'referencia_novo' => '',
            'latitude' => '',
            'latitude_novo' => '',
            'longitude' => '',
            'longitude_novo' => '',
            'avalista_1' => '',
            'avalista_2' => '',
            'testemunha_assinatura_digital' => '',
            'document_photo' => 'P',
            'selfie_photo' => 'P'
        );
        
        // Fazer a inserção via API IXC
        $api->post('cliente_contrato', $dados);
        $retorno = $api->getRespostaConteudo(false);
        
        return $retorno;
    }
    
    // Executar a inserção
    $resultado = addContrato($idCliente, $idPlanoVenda, $accountId);
    
    // Decodificar resposta
    $data = json_decode($resultado, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        // Se não for JSON válido, pode ser uma resposta de sucesso simples
        echo json_encode([
            'success' => true,
            'message' => 'Contrato inserido com sucesso no IXC',
            'raw_response' => $resultado,
            'dados_enviados' => [
                'idCliente' => $idCliente,
                'idPlanoVenda' => $idPlanoVenda,
                'accountId' => $accountId
            ]
        ]);
    } else {
        // Resposta JSON válida
        echo json_encode([
            'success' => true,
            'message' => 'Contrato inserido com sucesso no IXC',
            'response' => $data,
            'dados_enviados' => [
                'idCliente' => $idCliente,
                'idPlanoVenda' => $idPlanoVenda,
                'accountId' => $accountId
            ]
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Erro ao inserir contrato no IXC: ' . $e->getMessage(),
        'dados_recebidos' => $input ?? null
    ]);
}
?>
