<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

file_put_contents('api.log', date('Y-m-d H:i:s') . " - INICIO ABSOLUTO\n", FILE_APPEND);
// Lê o JSON enviado pelo frontend
$input = file_get_contents('php://input');
file_put_contents('api.log', date('Y-m-d H:i:s') . " - INPUT: $input\n", FILE_APPEND);
$data = json_decode($input, true);
if (!$data) {
    file_put_contents('api.log', date('Y-m-d H:i:s') . " - JSON inválido\n", FILE_APPEND);
    http_response_code(400);
    echo json_encode(['error' => 'Dados de cliente inválidos ou ausentes.']);
    exit;
}
// Configurações de autenticação (igual ao bora.php)
$baseUrl = 'https://app.boramvno.com.br/appapi';
$email    = 'andre@core3.com.br';
$password = 'C@du290713!';
$auth = base64_encode("$email:$password");
file_put_contents('api.log', date('Y-m-d H:i:s') . " - Autenticando...\n", FILE_APPEND);
// 1. Autenticação básica para obter token
$ch = curl_init($baseUrl . '/api/Authentication/basic');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Basic $auth",
    "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, '{}');
$authResponse = curl_exec($ch);
$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$header = substr($authResponse, 0, $headerSize);
$body   = substr($authResponse, $headerSize);
curl_close($ch);
file_put_contents('api.log', date('Y-m-d H:i:s') . " - Auth response: $body\n", FILE_APPEND);
$authResult = json_decode($body, true);
$token = null;
if (isset($authResult['token'])) {
    $token = $authResult['token'];
} else if (preg_match('/x-access-token:\s*(.+)/i', $header, $matches)) {
    $token = trim($matches[1]);
}
if (!$token) {
    file_put_contents('api.log', date('Y-m-d H:i:s') . " - Falha ao autenticar\n", FILE_APPEND);
    http_response_code(401);
    echo json_encode(['error' => 'Falha ao autenticar na API Boramvno.']);
    exit;
}
file_put_contents('api.log', date('Y-m-d H:i:s') . " - Token OK\n", FILE_APPEND);
// 2. Envia o POST para a API Boramvno
$ch2 = curl_init($baseUrl . '/api/Subscriber');
curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch2, CURLOPT_POST, true);
curl_setopt($ch2, CURLOPT_HEADER, false);
curl_setopt($ch2, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $token",
    "Content-Type: application/json"
]);
curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch2, CURLOPT_TIMEOUT, 20);
file_put_contents('api.log', date('Y-m-d H:i:s') . " - Enviando para API: " . json_encode($data) . "\n", FILE_APPEND);
$response = curl_exec($ch2);
$httpCode = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
$error = curl_error($ch2);
curl_close($ch2);
file_put_contents('api.log', date('Y-m-d H:i:s') . " - API response: $response | HTTP: $httpCode | cURL error: $error\n", FILE_APPEND);
if ($error) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro ao enviar para API Boramvno: ' . $error]);
    exit;
}
http_response_code($httpCode);
if ($response) {
    echo $response;
} else {
    if ($httpCode < 200 || $httpCode >= 300) {
        echo json_encode(['error' => 'Resposta vazia da API Boramvno', 'httpCode' => $httpCode]);
    } else {
        echo json_encode(['success' => true]);
    }
}
file_put_contents('api.log', date('Y-m-d H:i:s') . " - FIM\n", FILE_APPEND);
