#!/bin/bash

echo "🚀 INICIANDO SERVIDOR PHP - SOLUÇÃO DEFINITIVA!"
echo "================================================"
echo ""

# Verificar se PHP está instalado
if ! command -v php &> /dev/null; then
    echo "❌ ERRO: PHP não está instalado!"
    echo "Instale o PHP primeiro: brew install php"
    exit 1
fi

# Verificar se a porta 8000 está livre
if lsof -Pi :8000 -sTCP:LISTEN -t >/dev/null ; then
    echo "⚠️  Porta 8000 já está em uso. Parando processos..."
    pkill -f "php -S localhost:8000"
    sleep 2
fi

echo "✅ PHP encontrado: $(php -v | head -n1)"
echo "✅ Porta 8000 liberada"
echo ""

echo "🎯 INICIANDO SERVIDOR CORRETO..."
echo "📝 COMANDO: php -S localhost:8000"
echo ""

echo "🌐 SERVIDOR INICIADO!"
echo "📱 Abra no navegador: http://localhost:8000"
echo "🔗 Página principal: http://localhost:8000/index.php"
echo "🧪 Teste API: http://localhost:8000/consulta.php?id=1"
echo ""

echo "⏹️  Para parar: Ctrl+C"
echo ""

# Iniciar servidor
php -S localhost:8000



