<?php
// Debug detalhado da consulta IXC
require_once 'confApi.php';

echo "<h2>🔍 Debug Detalhado da Consulta IXC</h2>";

try {
    // CPF de teste
    $cpf_teste = '04435315521';
    
    echo "<h3>📋 Dados de Entrada</h3>";
    echo "<p><strong>CPF Original:</strong> $cpf_teste</p>";
    
    // Aplicar máscara como no consulta.php
    $query = $cpf_teste;
    if (strlen($cpf_teste) === 11) {
        $query = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $cpf_teste);
    }
    
    echo "<p><strong>CPF com Máscara:</strong> $query</p>";
    
    // Parâmetros da consulta
    $params = array(
        'qtype' => 'cliente.cnpj_cpf',
        'query' => $query,
        'oper' => '=',
        'page' => '1',
        'rp' => '20',
        'sortname' => 'cliente.id',
        'sortorder' => 'desc',
        'grid_param' => json_encode([
            ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
        ])
    );
    
    echo "<h3>📤 Parâmetros Enviados</h3>";
    echo "<pre>";
    print_r($params);
    echo "</pre>";
    
    // Fazer a consulta
    echo "<h3>🔄 Executando Consulta...</h3>";
    $api->get('cliente', $params);
    $retorno = $api->getRespostaConteudo(false);
    
    echo "<h3>📥 Resposta Bruta da API</h3>";
    echo "<pre>";
    echo htmlspecialchars($retorno);
    echo "</pre>";
    
    // Decodificar JSON
    $data = json_decode($retorno, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo "<h3>❌ Erro no JSON</h3>";
        echo "<p>Erro: " . json_last_error_msg() . "</p>";
        echo "<p>JSON Last Error: " . json_last_error() . "</p>";
    } else {
        echo "<h3>📊 Dados Decodificados</h3>";
        echo "<pre>";
        print_r($data);
        echo "</pre>";
        
        // Verificar estrutura
        echo "<h3>🔍 Análise da Estrutura</h3>";
        
        if (isset($data['rows'])) {
            echo "<p>✅ Campo 'rows' encontrado</p>";
            echo "<p>Quantidade de registros: " . count($data['rows']) . "</p>";
            
            if (count($data['rows']) > 0) {
                $primeiro = $data['rows'][0];
                echo "<p>✅ Primeiro registro:</p>";
                echo "<pre>";
                print_r($primeiro);
                echo "</pre>";
                
                // Verificar campos disponíveis
                echo "<p>📋 Campos disponíveis no primeiro registro:</p>";
                echo "<ul>";
                foreach ($primeiro as $campo => $valor) {
                    echo "<li><strong>$campo:</strong> " . (is_string($valor) ? htmlspecialchars($valor) : print_r($valor, true)) . "</li>";
                }
                echo "</ul>";
                
                // Verificar se tem ID
                $clienteId = $primeiro['id'] ?? $primeiro['cliente.id'] ?? $primeiro['cliente_id'] ?? null;
                if ($clienteId) {
                    echo "<p>✅ <strong>ID do Cliente encontrado:</strong> $clienteId</p>";
                } else {
                    echo "<p>❌ <strong>ID do Cliente NÃO encontrado</strong></p>";
                    echo "<p>Campos relacionados ao ID:</p>";
                    echo "<ul>";
                    if (isset($primeiro['id'])) echo "<li>id: " . $primeiro['id'] . "</li>";
                    if (isset($primeiro['cliente.id'])) echo "<li>cliente.id: " . $primeiro['cliente.id'] . "</li>";
                    if (isset($primeiro['cliente_id'])) echo "<li>cliente_id: " . $primeiro['cliente_id'] . "</li>";
                    echo "</ul>";
                }
            } else {
                echo "<p>❌ Campo 'rows' está vazio</p>";
            }
        } else {
            echo "<p>❌ Campo 'rows' NÃO encontrado</p>";
            echo "<p>Campos disponíveis na resposta:</p>";
            echo "<ul>";
            foreach ($data as $campo => $valor) {
                echo "<li><strong>$campo:</strong> " . (is_string($valor) ? htmlspecialchars($valor) : print_r($valor, true)) . "</li>";
            }
            echo "</ul>";
        }
    }
    
} catch (Exception $e) {
    echo "<h3>💥 Erro</h3>";
    echo "<p style='color: red;'>" . $e->getMessage() . "</p>";
    echo "<p><strong>Arquivo:</strong> " . $e->getFile() . "</p>";
    echo "<p><strong>Linha:</strong> " . $e->getLine() . "</p>";
}
?>
