# CuidaMais.vc - Landing Page

Uma landing page moderna e responsiva para a plataforma de cuidados de saúde CuidaMais.vc, construída com Next.js, TypeScript, Tailwind CSS e Shadcn/ui.

## 🚀 Tecnologias Utilizadas

- **Next.js 14** - Framework React com App Router
- **TypeScript** - Tipagem estática
- **Tailwind CSS** - Framework CSS utilitário
- **Shadcn/ui** - Componentes UI modernos
- **Lucide React** - Ícones
- **Radix UI** - Componentes acessíveis

## 📋 Pré-requisitos

- Node.js (versão 18 ou superior)
- npm ou yarn

## 🛠️ Instalação

1. Clone o repositório:
```bash
git clone <url-do-repositorio>
cd cuidamais-landing
```

2. Instale as dependências:
```bash
npm install
# ou
yarn install
```

3. Execute o servidor de desenvolvimento:
```bash
npm run dev
# ou
yarn dev
```

4. Abra [http://localhost:3000](http://localhost:3000) no seu navegador.

## 📁 Estrutura do Projeto

```
cuidamais-landing/
├── src/
│   ├── app/
│   │   ├── globals.css
│   │   ├── layout.tsx
│   │   └── page.tsx
│   ├── components/
│   │   └── ui/
│   │       ├── button.tsx
│   │       └── card.tsx
│   └── lib/
│       └── utils.ts
├── public/
├── package.json
├── tailwind.config.js
├── tsconfig.json
└── README.md
```

## 🎨 Características da Landing Page

### Seções Incluídas:

1. **Header** - Navegação principal com logo e menu
2. **Hero Section** - Apresentação principal do produto
3. **Features** - Benefícios e diferenciais do CuidaMais.vc
4. **Testimonials** - Depoimentos de clientes
5. **Pricing** - Planos e preços
6. **CTA** - Call-to-action principal
7. **Footer** - Informações de contato e links

### Design Features:

- ✅ Design responsivo (mobile-first)
- ✅ Gradientes e cores modernas
- ✅ Animações suaves
- ✅ Componentes reutilizáveis
- ✅ Acessibilidade (ARIA labels)
- ✅ SEO otimizado
- ✅ Performance otimizada

## 🚀 Scripts Disponíveis

- `npm run dev` - Inicia o servidor de desenvolvimento
- `npm run build` - Cria a build de produção
- `npm run start` - Inicia o servidor de produção
- `npm run lint` - Executa o linter

## 📱 Responsividade

A landing page é totalmente responsiva e funciona perfeitamente em:
- 📱 Dispositivos móveis
- 📱 Tablets
- 💻 Desktops
- 🖥️ Telas grandes

## 🎯 Otimizações

- **Performance**: Imagens otimizadas e lazy loading
- **SEO**: Meta tags e estrutura semântica
- **Acessibilidade**: Componentes acessíveis com Radix UI
- **UX**: Navegação intuitiva e CTAs claros

## 📞 Suporte

Para dúvidas ou sugestões, entre em contato:
- Email: contato@cuidamais.vc
- Telefone: (11) 99999-9999

---

Desenvolvido com ❤️ para o CuidaMais.vc 