"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/@floating-ui";
exports.ids = ["vendor-chunks/@floating-ui"];
exports.modules = {

/***/ "(ssr)/./node_modules/@floating-ui/core/dist/floating-ui.core.mjs":
/*!******************************************************************!*\
  !*** ./node_modules/@floating-ui/core/dist/floating-ui.core.mjs ***!
  \******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   arrow: () => (/* binding */ arrow),\n/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),\n/* harmony export */   computePosition: () => (/* binding */ computePosition),\n/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),\n/* harmony export */   flip: () => (/* binding */ flip),\n/* harmony export */   hide: () => (/* binding */ hide),\n/* harmony export */   inline: () => (/* binding */ inline),\n/* harmony export */   limitShift: () => (/* binding */ limitShift),\n/* harmony export */   offset: () => (/* binding */ offset),\n/* harmony export */   rectToClientRect: () => (/* reexport safe */ _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect),\n/* harmony export */   shift: () => (/* binding */ shift),\n/* harmony export */   size: () => (/* binding */ size)\n/* harmony export */ });\n/* harmony import */ var _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ \"(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs\");\n\n\nfunction computeCoordsFromPlacement(_ref, placement, rtl) {\n    let { reference, floating } = _ref;\n    const sideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);\n    const alignmentAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);\n    const alignLength = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(alignmentAxis);\n    const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n    const isVertical = sideAxis === \"y\";\n    const commonX = reference.x + reference.width / 2 - floating.width / 2;\n    const commonY = reference.y + reference.height / 2 - floating.height / 2;\n    const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;\n    let coords;\n    switch(side){\n        case \"top\":\n            coords = {\n                x: commonX,\n                y: reference.y - floating.height\n            };\n            break;\n        case \"bottom\":\n            coords = {\n                x: commonX,\n                y: reference.y + reference.height\n            };\n            break;\n        case \"right\":\n            coords = {\n                x: reference.x + reference.width,\n                y: commonY\n            };\n            break;\n        case \"left\":\n            coords = {\n                x: reference.x - floating.width,\n                y: commonY\n            };\n            break;\n        default:\n            coords = {\n                x: reference.x,\n                y: reference.y\n            };\n    }\n    switch((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement)){\n        case \"start\":\n            coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);\n            break;\n        case \"end\":\n            coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);\n            break;\n    }\n    return coords;\n}\n/**\n * Computes the `x` and `y` coordinates that will place the floating element\n * next to a given reference element.\n *\n * This export does not have any `platform` interface logic. You will need to\n * write one for the platform you are using Floating UI with.\n */ const computePosition = async (reference, floating, config)=>{\n    const { placement = \"bottom\", strategy = \"absolute\", middleware = [], platform } = config;\n    const validMiddleware = middleware.filter(Boolean);\n    const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));\n    let rects = await platform.getElementRects({\n        reference,\n        floating,\n        strategy\n    });\n    let { x, y } = computeCoordsFromPlacement(rects, placement, rtl);\n    let statefulPlacement = placement;\n    let middlewareData = {};\n    let resetCount = 0;\n    for(let i = 0; i < validMiddleware.length; i++){\n        const { name, fn } = validMiddleware[i];\n        const { x: nextX, y: nextY, data, reset } = await fn({\n            x,\n            y,\n            initialPlacement: placement,\n            placement: statefulPlacement,\n            strategy,\n            middlewareData,\n            rects,\n            platform,\n            elements: {\n                reference,\n                floating\n            }\n        });\n        x = nextX != null ? nextX : x;\n        y = nextY != null ? nextY : y;\n        middlewareData = {\n            ...middlewareData,\n            [name]: {\n                ...middlewareData[name],\n                ...data\n            }\n        };\n        if (reset && resetCount <= 50) {\n            resetCount++;\n            if (typeof reset === \"object\") {\n                if (reset.placement) {\n                    statefulPlacement = reset.placement;\n                }\n                if (reset.rects) {\n                    rects = reset.rects === true ? await platform.getElementRects({\n                        reference,\n                        floating,\n                        strategy\n                    }) : reset.rects;\n                }\n                ({ x, y } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));\n            }\n            i = -1;\n        }\n    }\n    return {\n        x,\n        y,\n        placement: statefulPlacement,\n        strategy,\n        middlewareData\n    };\n};\n/**\n * Resolves with an object of overflow side offsets that determine how much the\n * element is overflowing a given clipping boundary on each side.\n * - positive = overflowing the boundary by that number of pixels\n * - negative = how many pixels left before it will overflow\n * - 0 = lies flush with the boundary\n * @see https://floating-ui.com/docs/detectOverflow\n */ async function detectOverflow(state, options) {\n    var _await$platform$isEle;\n    if (options === void 0) {\n        options = {};\n    }\n    const { x, y, platform, rects, elements, strategy } = state;\n    const { boundary = \"clippingAncestors\", rootBoundary = \"viewport\", elementContext = \"floating\", altBoundary = false, padding = 0 } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n    const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);\n    const altContext = elementContext === \"floating\" ? \"reference\" : \"floating\";\n    const element = elements[altBoundary ? altContext : elementContext];\n    const clippingClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(await platform.getClippingRect({\n        element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating)),\n        boundary,\n        rootBoundary,\n        strategy\n    }));\n    const rect = elementContext === \"floating\" ? {\n        x,\n        y,\n        width: rects.floating.width,\n        height: rects.floating.height\n    } : rects.reference;\n    const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));\n    const offsetScale = await (platform.isElement == null ? void 0 : platform.isElement(offsetParent)) ? await (platform.getScale == null ? void 0 : platform.getScale(offsetParent)) || {\n        x: 1,\n        y: 1\n    } : {\n        x: 1,\n        y: 1\n    };\n    const elementClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({\n        elements,\n        rect,\n        offsetParent,\n        strategy\n    }) : rect);\n    return {\n        top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,\n        bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,\n        left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,\n        right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x\n    };\n}\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * @see https://floating-ui.com/docs/arrow\n */ const arrow = (options)=>({\n        name: \"arrow\",\n        options,\n        async fn (state) {\n            const { x, y, placement, rects, platform, elements, middlewareData } = state;\n            // Since `element` is required, we don't Partial<> the type.\n            const { element, padding = 0 } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state) || {};\n            if (element == null) {\n                return {};\n            }\n            const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);\n            const coords = {\n                x,\n                y\n            };\n            const axis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);\n            const length = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(axis);\n            const arrowDimensions = await platform.getDimensions(element);\n            const isYAxis = axis === \"y\";\n            const minProp = isYAxis ? \"top\" : \"left\";\n            const maxProp = isYAxis ? \"bottom\" : \"right\";\n            const clientProp = isYAxis ? \"clientHeight\" : \"clientWidth\";\n            const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];\n            const startDiff = coords[axis] - rects.reference[axis];\n            const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));\n            let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;\n            // DOM platform can return `window` as the `offsetParent`.\n            if (!clientSize || !await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent))) {\n                clientSize = elements.floating[clientProp] || rects.floating[length];\n            }\n            const centerToReference = endDiff / 2 - startDiff / 2;\n            // If the padding is large enough that it causes the arrow to no longer be\n            // centered, modify the padding so that it is centered.\n            const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;\n            const minPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[minProp], largestPossiblePadding);\n            const maxPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[maxProp], largestPossiblePadding);\n            // Make sure the arrow doesn't overflow the floating element if the center\n            // point is outside the floating element's bounds.\n            const min$1 = minPadding;\n            const max = clientSize - arrowDimensions[length] - maxPadding;\n            const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;\n            const offset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min$1, center, max);\n            // If the reference is small enough that the arrow's padding causes it to\n            // to point to nothing for an aligned placement, adjust the offset of the\n            // floating element itself. To ensure `shift()` continues to take action,\n            // a single reset is performed when this is true.\n            const shouldAddOffset = !middlewareData.arrow && (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) != null && center !== offset && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;\n            const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max : 0;\n            return {\n                [axis]: coords[axis] + alignmentOffset,\n                data: {\n                    [axis]: offset,\n                    centerOffset: center - offset - alignmentOffset,\n                    ...shouldAddOffset && {\n                        alignmentOffset\n                    }\n                },\n                reset: shouldAddOffset\n            };\n        }\n    });\nfunction getPlacementList(alignment, autoAlignment, allowedPlacements) {\n    const allowedPlacementsSortedByAlignment = alignment ? [\n        ...allowedPlacements.filter((placement)=>(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment),\n        ...allowedPlacements.filter((placement)=>(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) !== alignment)\n    ] : allowedPlacements.filter((placement)=>(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === placement);\n    return allowedPlacementsSortedByAlignment.filter((placement)=>{\n        if (alignment) {\n            return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment || (autoAlignment ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAlignmentPlacement)(placement) !== placement : false);\n        }\n        return true;\n    });\n}\n/**\n * Optimizes the visibility of the floating element by choosing the placement\n * that has the most space available automatically, without needing to specify a\n * preferred placement. Alternative to `flip`.\n * @see https://floating-ui.com/docs/autoPlacement\n */ const autoPlacement = function(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    return {\n        name: \"autoPlacement\",\n        options,\n        async fn (state) {\n            var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;\n            const { rects, middlewareData, placement, platform, elements } = state;\n            const { crossAxis = false, alignment, allowedPlacements = _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements, autoAlignment = true, ...detectOverflowOptions } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n            const placements$1 = alignment !== undefined || allowedPlacements === _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;\n            const overflow = await detectOverflow(state, detectOverflowOptions);\n            const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;\n            const currentPlacement = placements$1[currentIndex];\n            if (currentPlacement == null) {\n                return {};\n            }\n            const alignmentSides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));\n            // Make `computeCoords` start from the right place.\n            if (placement !== currentPlacement) {\n                return {\n                    reset: {\n                        placement: placements$1[0]\n                    }\n                };\n            }\n            const currentOverflows = [\n                overflow[(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(currentPlacement)],\n                overflow[alignmentSides[0]],\n                overflow[alignmentSides[1]]\n            ];\n            const allOverflows = [\n                ...((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || [],\n                {\n                    placement: currentPlacement,\n                    overflows: currentOverflows\n                }\n            ];\n            const nextPlacement = placements$1[currentIndex + 1];\n            // There are more placements to check.\n            if (nextPlacement) {\n                return {\n                    data: {\n                        index: currentIndex + 1,\n                        overflows: allOverflows\n                    },\n                    reset: {\n                        placement: nextPlacement\n                    }\n                };\n            }\n            const placementsSortedByMostSpace = allOverflows.map((d)=>{\n                const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d.placement);\n                return [\n                    d.placement,\n                    alignment && crossAxis ? // Check along the mainAxis and main crossAxis side.\n                    d.overflows.slice(0, 2).reduce((acc, v)=>acc + v, 0) : // Check only the mainAxis.\n                    d.overflows[0],\n                    d.overflows\n                ];\n            }).sort((a, b)=>a[1] - b[1]);\n            const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter((d)=>d[2].slice(0, // Aligned placements should not check their opposite crossAxis\n                // side.\n                (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d[0]) ? 2 : 3).every((v)=>v <= 0));\n            const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];\n            if (resetPlacement !== placement) {\n                return {\n                    data: {\n                        index: currentIndex + 1,\n                        overflows: allOverflows\n                    },\n                    reset: {\n                        placement: resetPlacement\n                    }\n                };\n            }\n            return {};\n        }\n    };\n};\n/**\n * Optimizes the visibility of the floating element by flipping the `placement`\n * in order to keep it in view when the preferred placement(s) will overflow the\n * clipping boundary. Alternative to `autoPlacement`.\n * @see https://floating-ui.com/docs/flip\n */ const flip = function(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    return {\n        name: \"flip\",\n        options,\n        async fn (state) {\n            var _middlewareData$arrow, _middlewareData$flip;\n            const { placement, middlewareData, rects, initialPlacement, platform, elements } = state;\n            const { mainAxis: checkMainAxis = true, crossAxis: checkCrossAxis = true, fallbackPlacements: specifiedFallbackPlacements, fallbackStrategy = \"bestFit\", fallbackAxisSideDirection = \"none\", flipAlignment = true, ...detectOverflowOptions } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n            // If a reset by the arrow was caused due to an alignment offset being\n            // added, we should skip any logic now since `flip()` has already done its\n            // work.\n            // https://github.com/floating-ui/floating-ui/issues/2549#issuecomment-1719601643\n            if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {\n                return {};\n            }\n            const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n            const initialSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(initialPlacement);\n            const isBasePlacement = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(initialPlacement) === initialPlacement;\n            const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));\n            const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [\n                (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositePlacement)(initialPlacement)\n            ] : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getExpandedPlacements)(initialPlacement));\n            const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== \"none\";\n            if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {\n                fallbackPlacements.push(...(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxisPlacements)(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));\n            }\n            const placements = [\n                initialPlacement,\n                ...fallbackPlacements\n            ];\n            const overflow = await detectOverflow(state, detectOverflowOptions);\n            const overflows = [];\n            let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];\n            if (checkMainAxis) {\n                overflows.push(overflow[side]);\n            }\n            if (checkCrossAxis) {\n                const sides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(placement, rects, rtl);\n                overflows.push(overflow[sides[0]], overflow[sides[1]]);\n            }\n            overflowsData = [\n                ...overflowsData,\n                {\n                    placement,\n                    overflows\n                }\n            ];\n            // One or more sides is overflowing.\n            if (!overflows.every((side)=>side <= 0)) {\n                var _middlewareData$flip2, _overflowsData$filter;\n                const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;\n                const nextPlacement = placements[nextIndex];\n                if (nextPlacement) {\n                    const ignoreCrossAxisOverflow = checkCrossAxis === \"alignment\" ? initialSideAxis !== (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(nextPlacement) : false;\n                    if (!ignoreCrossAxisOverflow || // We leave the current main axis only if every placement on that axis\n                    // overflows the main axis.\n                    overflowsData.every((d)=>(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement) === initialSideAxis ? d.overflows[0] > 0 : true)) {\n                        // Try next placement and re-run the lifecycle.\n                        return {\n                            data: {\n                                index: nextIndex,\n                                overflows: overflowsData\n                            },\n                            reset: {\n                                placement: nextPlacement\n                            }\n                        };\n                    }\n                }\n                // First, find the candidates that fit on the mainAxis side of overflow,\n                // then find the placement that fits the best on the main crossAxis side.\n                let resetPlacement = (_overflowsData$filter = overflowsData.filter((d)=>d.overflows[0] <= 0).sort((a, b)=>a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;\n                // Otherwise fallback.\n                if (!resetPlacement) {\n                    switch(fallbackStrategy){\n                        case \"bestFit\":\n                            {\n                                var _overflowsData$filter2;\n                                const placement = (_overflowsData$filter2 = overflowsData.filter((d)=>{\n                                    if (hasFallbackAxisSideDirection) {\n                                        const currentSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement);\n                                        return currentSideAxis === initialSideAxis || // Create a bias to the `y` side axis due to horizontal\n                                        // reading directions favoring greater width.\n                                        currentSideAxis === \"y\";\n                                    }\n                                    return true;\n                                }).map((d)=>[\n                                        d.placement,\n                                        d.overflows.filter((overflow)=>overflow > 0).reduce((acc, overflow)=>acc + overflow, 0)\n                                    ]).sort((a, b)=>a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];\n                                if (placement) {\n                                    resetPlacement = placement;\n                                }\n                                break;\n                            }\n                        case \"initialPlacement\":\n                            resetPlacement = initialPlacement;\n                            break;\n                    }\n                }\n                if (placement !== resetPlacement) {\n                    return {\n                        reset: {\n                            placement: resetPlacement\n                        }\n                    };\n                }\n            }\n            return {};\n        }\n    };\n};\nfunction getSideOffsets(overflow, rect) {\n    return {\n        top: overflow.top - rect.height,\n        right: overflow.right - rect.width,\n        bottom: overflow.bottom - rect.height,\n        left: overflow.left - rect.width\n    };\n}\nfunction isAnySideFullyClipped(overflow) {\n    return _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.sides.some((side)=>overflow[side] >= 0);\n}\n/**\n * Provides data to hide the floating element in applicable situations, such as\n * when it is not in the same clipping context as the reference element.\n * @see https://floating-ui.com/docs/hide\n */ const hide = function(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    return {\n        name: \"hide\",\n        options,\n        async fn (state) {\n            const { rects } = state;\n            const { strategy = \"referenceHidden\", ...detectOverflowOptions } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n            switch(strategy){\n                case \"referenceHidden\":\n                    {\n                        const overflow = await detectOverflow(state, {\n                            ...detectOverflowOptions,\n                            elementContext: \"reference\"\n                        });\n                        const offsets = getSideOffsets(overflow, rects.reference);\n                        return {\n                            data: {\n                                referenceHiddenOffsets: offsets,\n                                referenceHidden: isAnySideFullyClipped(offsets)\n                            }\n                        };\n                    }\n                case \"escaped\":\n                    {\n                        const overflow = await detectOverflow(state, {\n                            ...detectOverflowOptions,\n                            altBoundary: true\n                        });\n                        const offsets = getSideOffsets(overflow, rects.floating);\n                        return {\n                            data: {\n                                escapedOffsets: offsets,\n                                escaped: isAnySideFullyClipped(offsets)\n                            }\n                        };\n                    }\n                default:\n                    {\n                        return {};\n                    }\n            }\n        }\n    };\n};\nfunction getBoundingRect(rects) {\n    const minX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map((rect)=>rect.left));\n    const minY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map((rect)=>rect.top));\n    const maxX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map((rect)=>rect.right));\n    const maxY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map((rect)=>rect.bottom));\n    return {\n        x: minX,\n        y: minY,\n        width: maxX - minX,\n        height: maxY - minY\n    };\n}\nfunction getRectsByLine(rects) {\n    const sortedRects = rects.slice().sort((a, b)=>a.y - b.y);\n    const groups = [];\n    let prevRect = null;\n    for(let i = 0; i < sortedRects.length; i++){\n        const rect = sortedRects[i];\n        if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {\n            groups.push([\n                rect\n            ]);\n        } else {\n            groups[groups.length - 1].push(rect);\n        }\n        prevRect = rect;\n    }\n    return groups.map((rect)=>(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(rect)));\n}\n/**\n * Provides improved positioning for inline reference elements that can span\n * over multiple lines, such as hyperlinks or range selections.\n * @see https://floating-ui.com/docs/inline\n */ const inline = function(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    return {\n        name: \"inline\",\n        options,\n        async fn (state) {\n            const { placement, elements, rects, platform, strategy } = state;\n            // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a\n            // ClientRect's bounds, despite the event listener being triggered. A\n            // padding of 2 seems to handle this issue.\n            const { padding = 2, x, y } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n            const nativeClientRects = Array.from(await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference)) || []);\n            const clientRects = getRectsByLine(nativeClientRects);\n            const fallback = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(nativeClientRects));\n            const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);\n            function getBoundingClientRect() {\n                // There are two rects and they are disjoined.\n                if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {\n                    // Find the first rect in which the point is fully inside.\n                    return clientRects.find((rect)=>x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;\n                }\n                // There are 2 or more connected rects.\n                if (clientRects.length >= 2) {\n                    if ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === \"y\") {\n                        const firstRect = clientRects[0];\n                        const lastRect = clientRects[clientRects.length - 1];\n                        const isTop = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === \"top\";\n                        const top = firstRect.top;\n                        const bottom = lastRect.bottom;\n                        const left = isTop ? firstRect.left : lastRect.left;\n                        const right = isTop ? firstRect.right : lastRect.right;\n                        const width = right - left;\n                        const height = bottom - top;\n                        return {\n                            top,\n                            bottom,\n                            left,\n                            right,\n                            width,\n                            height,\n                            x: left,\n                            y: top\n                        };\n                    }\n                    const isLeftSide = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === \"left\";\n                    const maxRight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...clientRects.map((rect)=>rect.right));\n                    const minLeft = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...clientRects.map((rect)=>rect.left));\n                    const measureRects = clientRects.filter((rect)=>isLeftSide ? rect.left === minLeft : rect.right === maxRight);\n                    const top = measureRects[0].top;\n                    const bottom = measureRects[measureRects.length - 1].bottom;\n                    const left = minLeft;\n                    const right = maxRight;\n                    const width = right - left;\n                    const height = bottom - top;\n                    return {\n                        top,\n                        bottom,\n                        left,\n                        right,\n                        width,\n                        height,\n                        x: left,\n                        y: top\n                    };\n                }\n                return fallback;\n            }\n            const resetRects = await platform.getElementRects({\n                reference: {\n                    getBoundingClientRect\n                },\n                floating: elements.floating,\n                strategy\n            });\n            if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {\n                return {\n                    reset: {\n                        rects: resetRects\n                    }\n                };\n            }\n            return {};\n        }\n    };\n};\nconst originSides = /*#__PURE__*/ new Set([\n    \"left\",\n    \"top\"\n]);\n// For type backwards-compatibility, the `OffsetOptions` type was also\n// Derivable.\nasync function convertValueToCoords(state, options) {\n    const { placement, platform, elements } = state;\n    const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));\n    const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n    const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);\n    const isVertical = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === \"y\";\n    const mainAxisMulti = originSides.has(side) ? -1 : 1;\n    const crossAxisMulti = rtl && isVertical ? -1 : 1;\n    const rawValue = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n    // eslint-disable-next-line prefer-const\n    let { mainAxis, crossAxis, alignmentAxis } = typeof rawValue === \"number\" ? {\n        mainAxis: rawValue,\n        crossAxis: 0,\n        alignmentAxis: null\n    } : {\n        mainAxis: rawValue.mainAxis || 0,\n        crossAxis: rawValue.crossAxis || 0,\n        alignmentAxis: rawValue.alignmentAxis\n    };\n    if (alignment && typeof alignmentAxis === \"number\") {\n        crossAxis = alignment === \"end\" ? alignmentAxis * -1 : alignmentAxis;\n    }\n    return isVertical ? {\n        x: crossAxis * crossAxisMulti,\n        y: mainAxis * mainAxisMulti\n    } : {\n        x: mainAxis * mainAxisMulti,\n        y: crossAxis * crossAxisMulti\n    };\n}\n/**\n * Modifies the placement by translating the floating element along the\n * specified axes.\n * A number (shorthand for `mainAxis` or distance), or an axes configuration\n * object may be passed.\n * @see https://floating-ui.com/docs/offset\n */ const offset = function(options) {\n    if (options === void 0) {\n        options = 0;\n    }\n    return {\n        name: \"offset\",\n        options,\n        async fn (state) {\n            var _middlewareData$offse, _middlewareData$arrow;\n            const { x, y, placement, middlewareData } = state;\n            const diffCoords = await convertValueToCoords(state, options);\n            // If the placement is the same and the arrow caused an alignment offset\n            // then we don't need to change the positioning coordinates.\n            if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {\n                return {};\n            }\n            return {\n                x: x + diffCoords.x,\n                y: y + diffCoords.y,\n                data: {\n                    ...diffCoords,\n                    placement\n                }\n            };\n        }\n    };\n};\n/**\n * Optimizes the visibility of the floating element by shifting it in order to\n * keep it in view when it will overflow the clipping boundary.\n * @see https://floating-ui.com/docs/shift\n */ const shift = function(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    return {\n        name: \"shift\",\n        options,\n        async fn (state) {\n            const { x, y, placement } = state;\n            const { mainAxis: checkMainAxis = true, crossAxis: checkCrossAxis = false, limiter = {\n                fn: (_ref)=>{\n                    let { x, y } = _ref;\n                    return {\n                        x,\n                        y\n                    };\n                }\n            }, ...detectOverflowOptions } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n            const coords = {\n                x,\n                y\n            };\n            const overflow = await detectOverflow(state, detectOverflowOptions);\n            const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));\n            const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);\n            let mainAxisCoord = coords[mainAxis];\n            let crossAxisCoord = coords[crossAxis];\n            if (checkMainAxis) {\n                const minSide = mainAxis === \"y\" ? \"top\" : \"left\";\n                const maxSide = mainAxis === \"y\" ? \"bottom\" : \"right\";\n                const min = mainAxisCoord + overflow[minSide];\n                const max = mainAxisCoord - overflow[maxSide];\n                mainAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, mainAxisCoord, max);\n            }\n            if (checkCrossAxis) {\n                const minSide = crossAxis === \"y\" ? \"top\" : \"left\";\n                const maxSide = crossAxis === \"y\" ? \"bottom\" : \"right\";\n                const min = crossAxisCoord + overflow[minSide];\n                const max = crossAxisCoord - overflow[maxSide];\n                crossAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, crossAxisCoord, max);\n            }\n            const limitedCoords = limiter.fn({\n                ...state,\n                [mainAxis]: mainAxisCoord,\n                [crossAxis]: crossAxisCoord\n            });\n            return {\n                ...limitedCoords,\n                data: {\n                    x: limitedCoords.x - x,\n                    y: limitedCoords.y - y,\n                    enabled: {\n                        [mainAxis]: checkMainAxis,\n                        [crossAxis]: checkCrossAxis\n                    }\n                }\n            };\n        }\n    };\n};\n/**\n * Built-in `limiter` that will stop `shift()` at a certain point.\n */ const limitShift = function(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    return {\n        options,\n        fn (state) {\n            const { x, y, placement, rects, middlewareData } = state;\n            const { offset = 0, mainAxis: checkMainAxis = true, crossAxis: checkCrossAxis = true } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n            const coords = {\n                x,\n                y\n            };\n            const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);\n            const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);\n            let mainAxisCoord = coords[mainAxis];\n            let crossAxisCoord = coords[crossAxis];\n            const rawOffset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(offset, state);\n            const computedOffset = typeof rawOffset === \"number\" ? {\n                mainAxis: rawOffset,\n                crossAxis: 0\n            } : {\n                mainAxis: 0,\n                crossAxis: 0,\n                ...rawOffset\n            };\n            if (checkMainAxis) {\n                const len = mainAxis === \"y\" ? \"height\" : \"width\";\n                const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;\n                const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;\n                if (mainAxisCoord < limitMin) {\n                    mainAxisCoord = limitMin;\n                } else if (mainAxisCoord > limitMax) {\n                    mainAxisCoord = limitMax;\n                }\n            }\n            if (checkCrossAxis) {\n                var _middlewareData$offse, _middlewareData$offse2;\n                const len = mainAxis === \"y\" ? \"width\" : \"height\";\n                const isOriginSide = originSides.has((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));\n                const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);\n                const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);\n                if (crossAxisCoord < limitMin) {\n                    crossAxisCoord = limitMin;\n                } else if (crossAxisCoord > limitMax) {\n                    crossAxisCoord = limitMax;\n                }\n            }\n            return {\n                [mainAxis]: mainAxisCoord,\n                [crossAxis]: crossAxisCoord\n            };\n        }\n    };\n};\n/**\n * Provides data that allows you to change the size of the floating element —\n * for instance, prevent it from overflowing the clipping boundary or match the\n * width of the reference element.\n * @see https://floating-ui.com/docs/size\n */ const size = function(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    return {\n        name: \"size\",\n        options,\n        async fn (state) {\n            var _state$middlewareData, _state$middlewareData2;\n            const { placement, rects, platform, elements } = state;\n            const { apply = ()=>{}, ...detectOverflowOptions } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);\n            const overflow = await detectOverflow(state, detectOverflowOptions);\n            const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);\n            const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);\n            const isYAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === \"y\";\n            const { width, height } = rects.floating;\n            let heightSide;\n            let widthSide;\n            if (side === \"top\" || side === \"bottom\") {\n                heightSide = side;\n                widthSide = alignment === (await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)) ? \"start\" : \"end\") ? \"left\" : \"right\";\n            } else {\n                widthSide = side;\n                heightSide = alignment === \"end\" ? \"top\" : \"bottom\";\n            }\n            const maximumClippingHeight = height - overflow.top - overflow.bottom;\n            const maximumClippingWidth = width - overflow.left - overflow.right;\n            const overflowAvailableHeight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(height - overflow[heightSide], maximumClippingHeight);\n            const overflowAvailableWidth = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(width - overflow[widthSide], maximumClippingWidth);\n            const noShift = !state.middlewareData.shift;\n            let availableHeight = overflowAvailableHeight;\n            let availableWidth = overflowAvailableWidth;\n            if ((_state$middlewareData = state.middlewareData.shift) != null && _state$middlewareData.enabled.x) {\n                availableWidth = maximumClippingWidth;\n            }\n            if ((_state$middlewareData2 = state.middlewareData.shift) != null && _state$middlewareData2.enabled.y) {\n                availableHeight = maximumClippingHeight;\n            }\n            if (noShift && !alignment) {\n                const xMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, 0);\n                const xMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.right, 0);\n                const yMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, 0);\n                const yMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.bottom, 0);\n                if (isYAxis) {\n                    availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, overflow.right));\n                } else {\n                    availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, overflow.bottom));\n                }\n            }\n            await apply({\n                ...state,\n                availableWidth,\n                availableHeight\n            });\n            const nextDimensions = await platform.getDimensions(elements.floating);\n            if (width !== nextDimensions.width || height !== nextDimensions.height) {\n                return {\n                    reset: {\n                        rects: true\n                    }\n                };\n            }\n            return {};\n        }\n    };\n};\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@floating-ui/core/dist/floating-ui.core.mjs\n");

/***/ }),

/***/ "(ssr)/./node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   arrow: () => (/* binding */ arrow),\n/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),\n/* harmony export */   autoUpdate: () => (/* binding */ autoUpdate),\n/* harmony export */   computePosition: () => (/* binding */ computePosition),\n/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),\n/* harmony export */   flip: () => (/* binding */ flip),\n/* harmony export */   getOverflowAncestors: () => (/* reexport safe */ _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors),\n/* harmony export */   hide: () => (/* binding */ hide),\n/* harmony export */   inline: () => (/* binding */ inline),\n/* harmony export */   limitShift: () => (/* binding */ limitShift),\n/* harmony export */   offset: () => (/* binding */ offset),\n/* harmony export */   platform: () => (/* binding */ platform),\n/* harmony export */   shift: () => (/* binding */ shift),\n/* harmony export */   size: () => (/* binding */ size)\n/* harmony export */ });\n/* harmony import */ var _floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/utils */ \"(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs\");\n/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @floating-ui/core */ \"(ssr)/./node_modules/@floating-ui/core/dist/floating-ui.core.mjs\");\n/* harmony import */ var _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils/dom */ \"(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs\");\n\n\n\n\nfunction getCssDimensions(element) {\n    const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element);\n    // In testing environments, the `width` and `height` properties are empty\n    // strings for SVG elements, returning NaN. Fallback to `0` in this case.\n    let width = parseFloat(css.width) || 0;\n    let height = parseFloat(css.height) || 0;\n    const hasOffset = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element);\n    const offsetWidth = hasOffset ? element.offsetWidth : width;\n    const offsetHeight = hasOffset ? element.offsetHeight : height;\n    const shouldFallback = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(width) !== offsetWidth || (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(height) !== offsetHeight;\n    if (shouldFallback) {\n        width = offsetWidth;\n        height = offsetHeight;\n    }\n    return {\n        width,\n        height,\n        $: shouldFallback\n    };\n}\nfunction unwrapElement(element) {\n    return !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? element.contextElement : element;\n}\nfunction getScale(element) {\n    const domElement = unwrapElement(element);\n    if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(domElement)) {\n        return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);\n    }\n    const rect = domElement.getBoundingClientRect();\n    const { width, height, $ } = getCssDimensions(domElement);\n    let x = ($ ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(rect.width) : rect.width) / width;\n    let y = ($ ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.round)(rect.height) : rect.height) / height;\n    // 0, NaN, or Infinity should always fallback to 1.\n    if (!x || !Number.isFinite(x)) {\n        x = 1;\n    }\n    if (!y || !Number.isFinite(y)) {\n        y = 1;\n    }\n    return {\n        x,\n        y\n    };\n}\nconst noOffsets = /*#__PURE__*/ (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);\nfunction getVisualOffsets(element) {\n    const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element);\n    if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isWebKit)() || !win.visualViewport) {\n        return noOffsets;\n    }\n    return {\n        x: win.visualViewport.offsetLeft,\n        y: win.visualViewport.offsetTop\n    };\n}\nfunction shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {\n    if (isFixed === void 0) {\n        isFixed = false;\n    }\n    if (!floatingOffsetParent || isFixed && floatingOffsetParent !== (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element)) {\n        return false;\n    }\n    return isFixed;\n}\nfunction getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {\n    if (includeScale === void 0) {\n        includeScale = false;\n    }\n    if (isFixedStrategy === void 0) {\n        isFixedStrategy = false;\n    }\n    const clientRect = element.getBoundingClientRect();\n    const domElement = unwrapElement(element);\n    let scale = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);\n    if (includeScale) {\n        if (offsetParent) {\n            if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(offsetParent)) {\n                scale = getScale(offsetParent);\n            }\n        } else {\n            scale = getScale(element);\n        }\n    }\n    const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);\n    let x = (clientRect.left + visualOffsets.x) / scale.x;\n    let y = (clientRect.top + visualOffsets.y) / scale.y;\n    let width = clientRect.width / scale.x;\n    let height = clientRect.height / scale.y;\n    if (domElement) {\n        const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(domElement);\n        const offsetWin = offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(offsetParent) ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(offsetParent) : offsetParent;\n        let currentWin = win;\n        let currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getFrameElement)(currentWin);\n        while(currentIFrame && offsetParent && offsetWin !== currentWin){\n            const iframeScale = getScale(currentIFrame);\n            const iframeRect = currentIFrame.getBoundingClientRect();\n            const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(currentIFrame);\n            const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;\n            const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;\n            x *= iframeScale.x;\n            y *= iframeScale.y;\n            width *= iframeScale.x;\n            height *= iframeScale.y;\n            x += left;\n            y += top;\n            currentWin = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(currentIFrame);\n            currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getFrameElement)(currentWin);\n        }\n    }\n    return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.rectToClientRect)({\n        width,\n        height,\n        x,\n        y\n    });\n}\n// If <html> has a CSS width greater than the viewport, then this will be\n// incorrect for RTL.\nfunction getWindowScrollBarX(element, rect) {\n    const leftScroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(element).scrollLeft;\n    if (!rect) {\n        return getBoundingClientRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element)).left + leftScroll;\n    }\n    return rect.left + leftScroll;\n}\nfunction getHTMLOffset(documentElement, scroll, ignoreScrollbarX) {\n    if (ignoreScrollbarX === void 0) {\n        ignoreScrollbarX = false;\n    }\n    const htmlRect = documentElement.getBoundingClientRect();\n    const x = htmlRect.left + scroll.scrollLeft - (ignoreScrollbarX ? 0 : // RTL <body> scrollbar.\n    getWindowScrollBarX(documentElement, htmlRect));\n    const y = htmlRect.top + scroll.scrollTop;\n    return {\n        x,\n        y\n    };\n}\nfunction convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {\n    let { elements, rect, offsetParent, strategy } = _ref;\n    const isFixed = strategy === \"fixed\";\n    const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(offsetParent);\n    const topLayer = elements ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTopLayer)(elements.floating) : false;\n    if (offsetParent === documentElement || topLayer && isFixed) {\n        return rect;\n    }\n    let scroll = {\n        scrollLeft: 0,\n        scrollTop: 0\n    };\n    let scale = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);\n    const offsets = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);\n    const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(offsetParent);\n    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {\n        if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeName)(offsetParent) !== \"body\" || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isOverflowElement)(documentElement)) {\n            scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(offsetParent);\n        }\n        if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(offsetParent)) {\n            const offsetRect = getBoundingClientRect(offsetParent);\n            scale = getScale(offsetParent);\n            offsets.x = offsetRect.x + offsetParent.clientLeft;\n            offsets.y = offsetRect.y + offsetParent.clientTop;\n        }\n    }\n    const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll, true) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);\n    return {\n        width: rect.width * scale.x,\n        height: rect.height * scale.y,\n        x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x + htmlOffset.x,\n        y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y + htmlOffset.y\n    };\n}\nfunction getClientRects(element) {\n    return Array.from(element.getClientRects());\n}\n// Gets the entire size of the scrollable document area, even extending outside\n// of the `<html>` and `<body>` rect bounds if horizontally scrollable.\nfunction getDocumentRect(element) {\n    const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element);\n    const scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(element);\n    const body = element.ownerDocument.body;\n    const width = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);\n    const height = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);\n    let x = -scroll.scrollLeft + getWindowScrollBarX(element);\n    const y = -scroll.scrollTop;\n    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(body).direction === \"rtl\") {\n        x += (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(html.clientWidth, body.clientWidth) - width;\n    }\n    return {\n        width,\n        height,\n        x,\n        y\n    };\n}\nfunction getViewportRect(element, strategy) {\n    const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element);\n    const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element);\n    const visualViewport = win.visualViewport;\n    let width = html.clientWidth;\n    let height = html.clientHeight;\n    let x = 0;\n    let y = 0;\n    if (visualViewport) {\n        width = visualViewport.width;\n        height = visualViewport.height;\n        const visualViewportBased = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isWebKit)();\n        if (!visualViewportBased || visualViewportBased && strategy === \"fixed\") {\n            x = visualViewport.offsetLeft;\n            y = visualViewport.offsetTop;\n        }\n    }\n    return {\n        width,\n        height,\n        x,\n        y\n    };\n}\nconst absoluteOrFixed = /*#__PURE__*/ new Set([\n    \"absolute\",\n    \"fixed\"\n]);\n// Returns the inner client rect, subtracting scrollbars if present.\nfunction getInnerBoundingClientRect(element, strategy) {\n    const clientRect = getBoundingClientRect(element, true, strategy === \"fixed\");\n    const top = clientRect.top + element.clientTop;\n    const left = clientRect.left + element.clientLeft;\n    const scale = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) ? getScale(element) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(1);\n    const width = element.clientWidth * scale.x;\n    const height = element.clientHeight * scale.y;\n    const x = left * scale.x;\n    const y = top * scale.y;\n    return {\n        width,\n        height,\n        x,\n        y\n    };\n}\nfunction getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {\n    let rect;\n    if (clippingAncestor === \"viewport\") {\n        rect = getViewportRect(element, strategy);\n    } else if (clippingAncestor === \"document\") {\n        rect = getDocumentRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element));\n    } else if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(clippingAncestor)) {\n        rect = getInnerBoundingClientRect(clippingAncestor, strategy);\n    } else {\n        const visualOffsets = getVisualOffsets(element);\n        rect = {\n            x: clippingAncestor.x - visualOffsets.x,\n            y: clippingAncestor.y - visualOffsets.y,\n            width: clippingAncestor.width,\n            height: clippingAncestor.height\n        };\n    }\n    return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.rectToClientRect)(rect);\n}\nfunction hasFixedPositionAncestor(element, stopNode) {\n    const parentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(element);\n    if (parentNode === stopNode || !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(parentNode) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(parentNode)) {\n        return false;\n    }\n    return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(parentNode).position === \"fixed\" || hasFixedPositionAncestor(parentNode, stopNode);\n}\n// A \"clipping ancestor\" is an `overflow` element with the characteristic of\n// clipping (or hiding) child elements. This returns all clipping ancestors\n// of the given element up the tree.\nfunction getClippingElementAncestors(element, cache) {\n    const cachedResult = cache.get(element);\n    if (cachedResult) {\n        return cachedResult;\n    }\n    let result = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors)(element, [], false).filter((el)=>(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(el) && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeName)(el) !== \"body\");\n    let currentContainingBlockComputedStyle = null;\n    const elementIsFixed = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).position === \"fixed\";\n    let currentNode = elementIsFixed ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(element) : element;\n    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block\n    while((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(currentNode) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(currentNode)){\n        const computedStyle = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(currentNode);\n        const currentNodeIsContaining = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isContainingBlock)(currentNode);\n        if (!currentNodeIsContaining && computedStyle.position === \"fixed\") {\n            currentContainingBlockComputedStyle = null;\n        }\n        const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === \"static\" && !!currentContainingBlockComputedStyle && absoluteOrFixed.has(currentContainingBlockComputedStyle.position) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isOverflowElement)(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);\n        if (shouldDropCurrentNode) {\n            // Drop non-containing blocks.\n            result = result.filter((ancestor)=>ancestor !== currentNode);\n        } else {\n            // Record last containing block for next iteration.\n            currentContainingBlockComputedStyle = computedStyle;\n        }\n        currentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(currentNode);\n    }\n    cache.set(element, result);\n    return result;\n}\n// Gets the maximum area that the element is visible in due to any number of\n// clipping ancestors.\nfunction getClippingRect(_ref) {\n    let { element, boundary, rootBoundary, strategy } = _ref;\n    const elementClippingAncestors = boundary === \"clippingAncestors\" ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTopLayer)(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);\n    const clippingAncestors = [\n        ...elementClippingAncestors,\n        rootBoundary\n    ];\n    const firstClippingAncestor = clippingAncestors[0];\n    const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor)=>{\n        const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);\n        accRect.top = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(rect.top, accRect.top);\n        accRect.right = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.min)(rect.right, accRect.right);\n        accRect.bottom = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.min)(rect.bottom, accRect.bottom);\n        accRect.left = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(rect.left, accRect.left);\n        return accRect;\n    }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));\n    return {\n        width: clippingRect.right - clippingRect.left,\n        height: clippingRect.bottom - clippingRect.top,\n        x: clippingRect.left,\n        y: clippingRect.top\n    };\n}\nfunction getDimensions(element) {\n    const { width, height } = getCssDimensions(element);\n    return {\n        width,\n        height\n    };\n}\nfunction getRectRelativeToOffsetParent(element, offsetParent, strategy) {\n    const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(offsetParent);\n    const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(offsetParent);\n    const isFixed = strategy === \"fixed\";\n    const rect = getBoundingClientRect(element, true, isFixed, offsetParent);\n    let scroll = {\n        scrollLeft: 0,\n        scrollTop: 0\n    };\n    const offsets = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);\n    // If the <body> scrollbar appears on the left (e.g. RTL systems). Use\n    // Firefox with layout.scrollbar.side = 3 in about:config to test this.\n    function setLeftRTLScrollbarOffset() {\n        offsets.x = getWindowScrollBarX(documentElement);\n    }\n    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {\n        if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeName)(offsetParent) !== \"body\" || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isOverflowElement)(documentElement)) {\n            scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getNodeScroll)(offsetParent);\n        }\n        if (isOffsetParentAnElement) {\n            const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);\n            offsets.x = offsetRect.x + offsetParent.clientLeft;\n            offsets.y = offsetRect.y + offsetParent.clientTop;\n        } else if (documentElement) {\n            setLeftRTLScrollbarOffset();\n        }\n    }\n    if (isFixed && !isOffsetParentAnElement && documentElement) {\n        setLeftRTLScrollbarOffset();\n    }\n    const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.createCoords)(0);\n    const x = rect.left + scroll.scrollLeft - offsets.x - htmlOffset.x;\n    const y = rect.top + scroll.scrollTop - offsets.y - htmlOffset.y;\n    return {\n        x,\n        y,\n        width: rect.width,\n        height: rect.height\n    };\n}\nfunction isStaticPositioned(element) {\n    return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).position === \"static\";\n}\nfunction getTrueOffsetParent(element, polyfill) {\n    if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).position === \"fixed\") {\n        return null;\n    }\n    if (polyfill) {\n        return polyfill(element);\n    }\n    let rawOffsetParent = element.offsetParent;\n    // Firefox returns the <html> element as the offsetParent if it's non-static,\n    // while Chrome and Safari return the <body> element. The <body> element must\n    // be used to perform the correct calculations even if the <html> element is\n    // non-static.\n    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element) === rawOffsetParent) {\n        rawOffsetParent = rawOffsetParent.ownerDocument.body;\n    }\n    return rawOffsetParent;\n}\n// Gets the closest ancestor positioned element. Handles some edge cases,\n// such as table ancestors and cross browser bugs.\nfunction getOffsetParent(element, polyfill) {\n    const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getWindow)(element);\n    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTopLayer)(element)) {\n        return win;\n    }\n    if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {\n        let svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(element);\n        while(svgOffsetParent && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(svgOffsetParent)){\n            if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement)(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {\n                return svgOffsetParent;\n            }\n            svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getParentNode)(svgOffsetParent);\n        }\n        return win;\n    }\n    let offsetParent = getTrueOffsetParent(element, polyfill);\n    while(offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isTableElement)(offsetParent) && isStaticPositioned(offsetParent)){\n        offsetParent = getTrueOffsetParent(offsetParent, polyfill);\n    }\n    if (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isLastTraversableNode)(offsetParent) && isStaticPositioned(offsetParent) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isContainingBlock)(offsetParent)) {\n        return win;\n    }\n    return offsetParent || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getContainingBlock)(element) || win;\n}\nconst getElementRects = async function(data) {\n    const getOffsetParentFn = this.getOffsetParent || getOffsetParent;\n    const getDimensionsFn = this.getDimensions;\n    const floatingDimensions = await getDimensionsFn(data.floating);\n    return {\n        reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),\n        floating: {\n            x: 0,\n            y: 0,\n            width: floatingDimensions.width,\n            height: floatingDimensions.height\n        }\n    };\n};\nfunction isRTL(element) {\n    return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getComputedStyle)(element).direction === \"rtl\";\n}\nconst platform = {\n    convertOffsetParentRelativeRectToViewportRelativeRect,\n    getDocumentElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement,\n    getClippingRect,\n    getOffsetParent,\n    getElementRects,\n    getClientRects,\n    getDimensions,\n    getScale,\n    isElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.isElement,\n    isRTL\n};\nfunction rectsAreEqual(a, b) {\n    return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;\n}\n// https://samthor.au/2021/observing-dom/\nfunction observeMove(element, onMove) {\n    let io = null;\n    let timeoutId;\n    const root = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getDocumentElement)(element);\n    function cleanup() {\n        var _io;\n        clearTimeout(timeoutId);\n        (_io = io) == null || _io.disconnect();\n        io = null;\n    }\n    function refresh(skip, threshold) {\n        if (skip === void 0) {\n            skip = false;\n        }\n        if (threshold === void 0) {\n            threshold = 1;\n        }\n        cleanup();\n        const elementRectForRootMargin = element.getBoundingClientRect();\n        const { left, top, width, height } = elementRectForRootMargin;\n        if (!skip) {\n            onMove();\n        }\n        if (!width || !height) {\n            return;\n        }\n        const insetTop = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(top);\n        const insetRight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(root.clientWidth - (left + width));\n        const insetBottom = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(root.clientHeight - (top + height));\n        const insetLeft = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.floor)(left);\n        const rootMargin = -insetTop + \"px \" + -insetRight + \"px \" + -insetBottom + \"px \" + -insetLeft + \"px\";\n        const options = {\n            rootMargin,\n            threshold: (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.max)(0, (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_1__.min)(1, threshold)) || 1\n        };\n        let isFirstUpdate = true;\n        function handleObserve(entries) {\n            const ratio = entries[0].intersectionRatio;\n            if (ratio !== threshold) {\n                if (!isFirstUpdate) {\n                    return refresh();\n                }\n                if (!ratio) {\n                    // If the reference is clipped, the ratio is 0. Throttle the refresh\n                    // to prevent an infinite loop of updates.\n                    timeoutId = setTimeout(()=>{\n                        refresh(false, 1e-7);\n                    }, 1000);\n                } else {\n                    refresh(false, ratio);\n                }\n            }\n            if (ratio === 1 && !rectsAreEqual(elementRectForRootMargin, element.getBoundingClientRect())) {\n                // It's possible that even though the ratio is reported as 1, the\n                // element is not actually fully within the IntersectionObserver's root\n                // area anymore. This can happen under performance constraints. This may\n                // be a bug in the browser's IntersectionObserver implementation. To\n                // work around this, we compare the element's bounding rect now with\n                // what it was at the time we created the IntersectionObserver. If they\n                // are not equal then the element moved, so we refresh.\n                refresh();\n            }\n            isFirstUpdate = false;\n        }\n        // Older browsers don't support a `document` as the root and will throw an\n        // error.\n        try {\n            io = new IntersectionObserver(handleObserve, {\n                ...options,\n                // Handle <iframe>s\n                root: root.ownerDocument\n            });\n        } catch (_e) {\n            io = new IntersectionObserver(handleObserve, options);\n        }\n        io.observe(element);\n    }\n    refresh(true);\n    return cleanup;\n}\n/**\n * Automatically updates the position of the floating element when necessary.\n * Should only be called when the floating element is mounted on the DOM or\n * visible on the screen.\n * @returns cleanup function that should be invoked when the floating element is\n * removed from the DOM or hidden from the screen.\n * @see https://floating-ui.com/docs/autoUpdate\n */ function autoUpdate(reference, floating, update, options) {\n    if (options === void 0) {\n        options = {};\n    }\n    const { ancestorScroll = true, ancestorResize = true, elementResize = typeof ResizeObserver === \"function\", layoutShift = typeof IntersectionObserver === \"function\", animationFrame = false } = options;\n    const referenceEl = unwrapElement(reference);\n    const ancestors = ancestorScroll || ancestorResize ? [\n        ...referenceEl ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors)(referenceEl) : [],\n        ...(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getOverflowAncestors)(floating)\n    ] : [];\n    ancestors.forEach((ancestor)=>{\n        ancestorScroll && ancestor.addEventListener(\"scroll\", update, {\n            passive: true\n        });\n        ancestorResize && ancestor.addEventListener(\"resize\", update);\n    });\n    const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;\n    let reobserveFrame = -1;\n    let resizeObserver = null;\n    if (elementResize) {\n        resizeObserver = new ResizeObserver((_ref)=>{\n            let [firstEntry] = _ref;\n            if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {\n                // Prevent update loops when using the `size` middleware.\n                // https://github.com/floating-ui/floating-ui/issues/1740\n                resizeObserver.unobserve(floating);\n                cancelAnimationFrame(reobserveFrame);\n                reobserveFrame = requestAnimationFrame(()=>{\n                    var _resizeObserver;\n                    (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);\n                });\n            }\n            update();\n        });\n        if (referenceEl && !animationFrame) {\n            resizeObserver.observe(referenceEl);\n        }\n        resizeObserver.observe(floating);\n    }\n    let frameId;\n    let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;\n    if (animationFrame) {\n        frameLoop();\n    }\n    function frameLoop() {\n        const nextRefRect = getBoundingClientRect(reference);\n        if (prevRefRect && !rectsAreEqual(prevRefRect, nextRefRect)) {\n            update();\n        }\n        prevRefRect = nextRefRect;\n        frameId = requestAnimationFrame(frameLoop);\n    }\n    update();\n    return ()=>{\n        var _resizeObserver2;\n        ancestors.forEach((ancestor)=>{\n            ancestorScroll && ancestor.removeEventListener(\"scroll\", update);\n            ancestorResize && ancestor.removeEventListener(\"resize\", update);\n        });\n        cleanupIo == null || cleanupIo();\n        (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();\n        resizeObserver = null;\n        if (animationFrame) {\n            cancelAnimationFrame(frameId);\n        }\n    };\n}\n/**\n * Resolves with an object of overflow side offsets that determine how much the\n * element is overflowing a given clipping boundary on each side.\n * - positive = overflowing the boundary by that number of pixels\n * - negative = how many pixels left before it will overflow\n * - 0 = lies flush with the boundary\n * @see https://floating-ui.com/docs/detectOverflow\n */ const detectOverflow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.detectOverflow;\n/**\n * Modifies the placement by translating the floating element along the\n * specified axes.\n * A number (shorthand for `mainAxis` or distance), or an axes configuration\n * object may be passed.\n * @see https://floating-ui.com/docs/offset\n */ const offset = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.offset;\n/**\n * Optimizes the visibility of the floating element by choosing the placement\n * that has the most space available automatically, without needing to specify a\n * preferred placement. Alternative to `flip`.\n * @see https://floating-ui.com/docs/autoPlacement\n */ const autoPlacement = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.autoPlacement;\n/**\n * Optimizes the visibility of the floating element by shifting it in order to\n * keep it in view when it will overflow the clipping boundary.\n * @see https://floating-ui.com/docs/shift\n */ const shift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.shift;\n/**\n * Optimizes the visibility of the floating element by flipping the `placement`\n * in order to keep it in view when the preferred placement(s) will overflow the\n * clipping boundary. Alternative to `autoPlacement`.\n * @see https://floating-ui.com/docs/flip\n */ const flip = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.flip;\n/**\n * Provides data that allows you to change the size of the floating element —\n * for instance, prevent it from overflowing the clipping boundary or match the\n * width of the reference element.\n * @see https://floating-ui.com/docs/size\n */ const size = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.size;\n/**\n * Provides data to hide the floating element in applicable situations, such as\n * when it is not in the same clipping context as the reference element.\n * @see https://floating-ui.com/docs/hide\n */ const hide = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.hide;\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * @see https://floating-ui.com/docs/arrow\n */ const arrow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.arrow;\n/**\n * Provides improved positioning for inline reference elements that can span\n * over multiple lines, such as hyperlinks or range selections.\n * @see https://floating-ui.com/docs/inline\n */ const inline = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.inline;\n/**\n * Built-in `limiter` that will stop `shift()` at a certain point.\n */ const limitShift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.limitShift;\n/**\n * Computes the `x` and `y` coordinates that will place the floating element\n * next to a given reference element.\n */ const computePosition = (reference, floating, options)=>{\n    // This caches the expensive `getClippingElementAncestors` function so that\n    // multiple lifecycle resets re-use the same result. It only lives for a\n    // single call. If other functions become expensive, we can add them as well.\n    const cache = new Map();\n    const mergedOptions = {\n        platform,\n        ...options\n    };\n    const platformWithCache = {\n        ...mergedOptions.platform,\n        _c: cache\n    };\n    return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_2__.computePosition)(reference, floating, {\n        ...mergedOptions,\n        platform: platformWithCache\n    });\n};\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs\n");

/***/ }),

/***/ "(ssr)/./node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.mjs":
/*!****************************************************************************!*\
  !*** ./node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.mjs ***!
  \****************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   arrow: () => (/* binding */ arrow),\n/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),\n/* harmony export */   autoUpdate: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.autoUpdate),\n/* harmony export */   computePosition: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.computePosition),\n/* harmony export */   detectOverflow: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.detectOverflow),\n/* harmony export */   flip: () => (/* binding */ flip),\n/* harmony export */   getOverflowAncestors: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__.getOverflowAncestors),\n/* harmony export */   hide: () => (/* binding */ hide),\n/* harmony export */   inline: () => (/* binding */ inline),\n/* harmony export */   limitShift: () => (/* binding */ limitShift),\n/* harmony export */   offset: () => (/* binding */ offset),\n/* harmony export */   platform: () => (/* reexport safe */ _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.platform),\n/* harmony export */   shift: () => (/* binding */ shift),\n/* harmony export */   size: () => (/* binding */ size),\n/* harmony export */   useFloating: () => (/* binding */ useFloating)\n/* harmony export */ });\n/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/dom */ \"(ssr)/./node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs\");\n/* harmony import */ var _floating_ui_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/dom */ \"(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ \"(ssr)/./node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js\");\n/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-dom */ \"(ssr)/./node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react-dom.js\");\n\n\n\n\n\nvar isClient = typeof document !== \"undefined\";\nvar noop = function noop() {};\nvar index = isClient ? react__WEBPACK_IMPORTED_MODULE_2__.useLayoutEffect : noop;\n// Fork of `fast-deep-equal` that only does the comparisons we need and compares\n// functions\nfunction deepEqual(a, b) {\n    if (a === b) {\n        return true;\n    }\n    if (typeof a !== typeof b) {\n        return false;\n    }\n    if (typeof a === \"function\" && a.toString() === b.toString()) {\n        return true;\n    }\n    let length;\n    let i;\n    let keys;\n    if (a && b && typeof a === \"object\") {\n        if (Array.isArray(a)) {\n            length = a.length;\n            if (length !== b.length) return false;\n            for(i = length; i-- !== 0;){\n                if (!deepEqual(a[i], b[i])) {\n                    return false;\n                }\n            }\n            return true;\n        }\n        keys = Object.keys(a);\n        length = keys.length;\n        if (length !== Object.keys(b).length) {\n            return false;\n        }\n        for(i = length; i-- !== 0;){\n            if (!({}).hasOwnProperty.call(b, keys[i])) {\n                return false;\n            }\n        }\n        for(i = length; i-- !== 0;){\n            const key = keys[i];\n            if (key === \"_owner\" && a.$$typeof) {\n                continue;\n            }\n            if (!deepEqual(a[key], b[key])) {\n                return false;\n            }\n        }\n        return true;\n    }\n    return a !== a && b !== b;\n}\nfunction getDPR(element) {\n    if (true) {\n        return 1;\n    }\n    const win = element.ownerDocument.defaultView || window;\n    return win.devicePixelRatio || 1;\n}\nfunction roundByDPR(element, value) {\n    const dpr = getDPR(element);\n    return Math.round(value * dpr) / dpr;\n}\nfunction useLatestRef(value) {\n    const ref = react__WEBPACK_IMPORTED_MODULE_2__.useRef(value);\n    index(()=>{\n        ref.current = value;\n    });\n    return ref;\n}\n/**\n * Provides data to position a floating element.\n * @see https://floating-ui.com/docs/useFloating\n */ function useFloating(options) {\n    if (options === void 0) {\n        options = {};\n    }\n    const { placement = \"bottom\", strategy = \"absolute\", middleware = [], platform, elements: { reference: externalReference, floating: externalFloating } = {}, transform = true, whileElementsMounted, open } = options;\n    const [data, setData] = react__WEBPACK_IMPORTED_MODULE_2__.useState({\n        x: 0,\n        y: 0,\n        strategy,\n        placement,\n        middlewareData: {},\n        isPositioned: false\n    });\n    const [latestMiddleware, setLatestMiddleware] = react__WEBPACK_IMPORTED_MODULE_2__.useState(middleware);\n    if (!deepEqual(latestMiddleware, middleware)) {\n        setLatestMiddleware(middleware);\n    }\n    const [_reference, _setReference] = react__WEBPACK_IMPORTED_MODULE_2__.useState(null);\n    const [_floating, _setFloating] = react__WEBPACK_IMPORTED_MODULE_2__.useState(null);\n    const setReference = react__WEBPACK_IMPORTED_MODULE_2__.useCallback((node)=>{\n        if (node !== referenceRef.current) {\n            referenceRef.current = node;\n            _setReference(node);\n        }\n    }, []);\n    const setFloating = react__WEBPACK_IMPORTED_MODULE_2__.useCallback((node)=>{\n        if (node !== floatingRef.current) {\n            floatingRef.current = node;\n            _setFloating(node);\n        }\n    }, []);\n    const referenceEl = externalReference || _reference;\n    const floatingEl = externalFloating || _floating;\n    const referenceRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(null);\n    const floatingRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(null);\n    const dataRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(data);\n    const hasWhileElementsMounted = whileElementsMounted != null;\n    const whileElementsMountedRef = useLatestRef(whileElementsMounted);\n    const platformRef = useLatestRef(platform);\n    const openRef = useLatestRef(open);\n    const update = react__WEBPACK_IMPORTED_MODULE_2__.useCallback(()=>{\n        if (!referenceRef.current || !floatingRef.current) {\n            return;\n        }\n        const config = {\n            placement,\n            strategy,\n            middleware: latestMiddleware\n        };\n        if (platformRef.current) {\n            config.platform = platformRef.current;\n        }\n        (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.computePosition)(referenceRef.current, floatingRef.current, config).then((data)=>{\n            const fullData = {\n                ...data,\n                // The floating element's position may be recomputed while it's closed\n                // but still mounted (such as when transitioning out). To ensure\n                // `isPositioned` will be `false` initially on the next open, avoid\n                // setting it to `true` when `open === false` (must be specified).\n                isPositioned: openRef.current !== false\n            };\n            if (isMountedRef.current && !deepEqual(dataRef.current, fullData)) {\n                dataRef.current = fullData;\n                react_dom__WEBPACK_IMPORTED_MODULE_3__.flushSync(()=>{\n                    setData(fullData);\n                });\n            }\n        });\n    }, [\n        latestMiddleware,\n        placement,\n        strategy,\n        platformRef,\n        openRef\n    ]);\n    index(()=>{\n        if (open === false && dataRef.current.isPositioned) {\n            dataRef.current.isPositioned = false;\n            setData((data)=>({\n                    ...data,\n                    isPositioned: false\n                }));\n        }\n    }, [\n        open\n    ]);\n    const isMountedRef = react__WEBPACK_IMPORTED_MODULE_2__.useRef(false);\n    index(()=>{\n        isMountedRef.current = true;\n        return ()=>{\n            isMountedRef.current = false;\n        };\n    }, []);\n    index(()=>{\n        if (referenceEl) referenceRef.current = referenceEl;\n        if (floatingEl) floatingRef.current = floatingEl;\n        if (referenceEl && floatingEl) {\n            if (whileElementsMountedRef.current) {\n                return whileElementsMountedRef.current(referenceEl, floatingEl, update);\n            }\n            update();\n        }\n    }, [\n        referenceEl,\n        floatingEl,\n        update,\n        whileElementsMountedRef,\n        hasWhileElementsMounted\n    ]);\n    const refs = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(()=>({\n            reference: referenceRef,\n            floating: floatingRef,\n            setReference,\n            setFloating\n        }), [\n        setReference,\n        setFloating\n    ]);\n    const elements = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(()=>({\n            reference: referenceEl,\n            floating: floatingEl\n        }), [\n        referenceEl,\n        floatingEl\n    ]);\n    const floatingStyles = react__WEBPACK_IMPORTED_MODULE_2__.useMemo(()=>{\n        const initialStyles = {\n            position: strategy,\n            left: 0,\n            top: 0\n        };\n        if (!elements.floating) {\n            return initialStyles;\n        }\n        const x = roundByDPR(elements.floating, data.x);\n        const y = roundByDPR(elements.floating, data.y);\n        if (transform) {\n            return {\n                ...initialStyles,\n                transform: \"translate(\" + x + \"px, \" + y + \"px)\",\n                ...getDPR(elements.floating) >= 1.5 && {\n                    willChange: \"transform\"\n                }\n            };\n        }\n        return {\n            position: strategy,\n            left: x,\n            top: y\n        };\n    }, [\n        strategy,\n        transform,\n        elements.floating,\n        data.x,\n        data.y\n    ]);\n    return react__WEBPACK_IMPORTED_MODULE_2__.useMemo(()=>({\n            ...data,\n            update,\n            refs,\n            elements,\n            floatingStyles\n        }), [\n        data,\n        update,\n        refs,\n        elements,\n        floatingStyles\n    ]);\n}\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * This wraps the core `arrow` middleware to allow React refs as the element.\n * @see https://floating-ui.com/docs/arrow\n */ const arrow$1 = (options)=>{\n    function isRef(value) {\n        return ({}).hasOwnProperty.call(value, \"current\");\n    }\n    return {\n        name: \"arrow\",\n        options,\n        fn (state) {\n            const { element, padding } = typeof options === \"function\" ? options(state) : options;\n            if (element && isRef(element)) {\n                if (element.current != null) {\n                    return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.arrow)({\n                        element: element.current,\n                        padding\n                    }).fn(state);\n                }\n                return {};\n            }\n            if (element) {\n                return (0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.arrow)({\n                    element,\n                    padding\n                }).fn(state);\n            }\n            return {};\n        }\n    };\n};\n/**\n * Modifies the placement by translating the floating element along the\n * specified axes.\n * A number (shorthand for `mainAxis` or distance), or an axes configuration\n * object may be passed.\n * @see https://floating-ui.com/docs/offset\n */ const offset = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.offset)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Optimizes the visibility of the floating element by shifting it in order to\n * keep it in view when it will overflow the clipping boundary.\n * @see https://floating-ui.com/docs/shift\n */ const shift = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.shift)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Built-in `limiter` that will stop `shift()` at a certain point.\n */ const limitShift = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.limitShift)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Optimizes the visibility of the floating element by flipping the `placement`\n * in order to keep it in view when the preferred placement(s) will overflow the\n * clipping boundary. Alternative to `autoPlacement`.\n * @see https://floating-ui.com/docs/flip\n */ const flip = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.flip)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Provides data that allows you to change the size of the floating element —\n * for instance, prevent it from overflowing the clipping boundary or match the\n * width of the reference element.\n * @see https://floating-ui.com/docs/size\n */ const size = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.size)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Optimizes the visibility of the floating element by choosing the placement\n * that has the most space available automatically, without needing to specify a\n * preferred placement. Alternative to `flip`.\n * @see https://floating-ui.com/docs/autoPlacement\n */ const autoPlacement = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.autoPlacement)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Provides data to hide the floating element in applicable situations, such as\n * when it is not in the same clipping context as the reference element.\n * @see https://floating-ui.com/docs/hide\n */ const hide = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.hide)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Provides improved positioning for inline reference elements that can span\n * over multiple lines, such as hyperlinks or range selections.\n * @see https://floating-ui.com/docs/inline\n */ const inline = (options, deps)=>({\n        ...(0,_floating_ui_dom__WEBPACK_IMPORTED_MODULE_0__.inline)(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n/**\n * Provides data to position an inner element of the floating element so that it\n * appears centered to the reference element.\n * This wraps the core `arrow` middleware to allow React refs as the element.\n * @see https://floating-ui.com/docs/arrow\n */ const arrow = (options, deps)=>({\n        ...arrow$1(options),\n        options: [\n            options,\n            deps\n        ]\n    });\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@floating-ui/react-dom/dist/floating-ui.react-dom.mjs\n");

/***/ }),

/***/ "(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs":
/*!************************************************************************!*\
  !*** ./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs ***!
  \************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   getComputedStyle: () => (/* binding */ getComputedStyle),\n/* harmony export */   getContainingBlock: () => (/* binding */ getContainingBlock),\n/* harmony export */   getDocumentElement: () => (/* binding */ getDocumentElement),\n/* harmony export */   getFrameElement: () => (/* binding */ getFrameElement),\n/* harmony export */   getNearestOverflowAncestor: () => (/* binding */ getNearestOverflowAncestor),\n/* harmony export */   getNodeName: () => (/* binding */ getNodeName),\n/* harmony export */   getNodeScroll: () => (/* binding */ getNodeScroll),\n/* harmony export */   getOverflowAncestors: () => (/* binding */ getOverflowAncestors),\n/* harmony export */   getParentNode: () => (/* binding */ getParentNode),\n/* harmony export */   getWindow: () => (/* binding */ getWindow),\n/* harmony export */   isContainingBlock: () => (/* binding */ isContainingBlock),\n/* harmony export */   isElement: () => (/* binding */ isElement),\n/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),\n/* harmony export */   isLastTraversableNode: () => (/* binding */ isLastTraversableNode),\n/* harmony export */   isNode: () => (/* binding */ isNode),\n/* harmony export */   isOverflowElement: () => (/* binding */ isOverflowElement),\n/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot),\n/* harmony export */   isTableElement: () => (/* binding */ isTableElement),\n/* harmony export */   isTopLayer: () => (/* binding */ isTopLayer),\n/* harmony export */   isWebKit: () => (/* binding */ isWebKit)\n/* harmony export */ });\nfunction hasWindow() {\n    return \"undefined\" !== \"undefined\";\n}\nfunction getNodeName(node) {\n    if (isNode(node)) {\n        return (node.nodeName || \"\").toLowerCase();\n    }\n    // Mocked nodes in testing environments may not be instances of Node. By\n    // returning `#document` an infinite loop won't occur.\n    // https://github.com/floating-ui/floating-ui/issues/2317\n    return \"#document\";\n}\nfunction getWindow(node) {\n    var _node$ownerDocument;\n    return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;\n}\nfunction getDocumentElement(node) {\n    var _ref;\n    return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;\n}\nfunction isNode(value) {\n    if (!hasWindow()) {\n        return false;\n    }\n    return value instanceof Node || value instanceof getWindow(value).Node;\n}\nfunction isElement(value) {\n    if (!hasWindow()) {\n        return false;\n    }\n    return value instanceof Element || value instanceof getWindow(value).Element;\n}\nfunction isHTMLElement(value) {\n    if (!hasWindow()) {\n        return false;\n    }\n    return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;\n}\nfunction isShadowRoot(value) {\n    if (!hasWindow() || typeof ShadowRoot === \"undefined\") {\n        return false;\n    }\n    return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;\n}\nconst invalidOverflowDisplayValues = /*#__PURE__*/ new Set([\n    \"inline\",\n    \"contents\"\n]);\nfunction isOverflowElement(element) {\n    const { overflow, overflowX, overflowY, display } = getComputedStyle(element);\n    return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !invalidOverflowDisplayValues.has(display);\n}\nconst tableElements = /*#__PURE__*/ new Set([\n    \"table\",\n    \"td\",\n    \"th\"\n]);\nfunction isTableElement(element) {\n    return tableElements.has(getNodeName(element));\n}\nconst topLayerSelectors = [\n    \":popover-open\",\n    \":modal\"\n];\nfunction isTopLayer(element) {\n    return topLayerSelectors.some((selector)=>{\n        try {\n            return element.matches(selector);\n        } catch (_e) {\n            return false;\n        }\n    });\n}\nconst transformProperties = [\n    \"transform\",\n    \"translate\",\n    \"scale\",\n    \"rotate\",\n    \"perspective\"\n];\nconst willChangeValues = [\n    \"transform\",\n    \"translate\",\n    \"scale\",\n    \"rotate\",\n    \"perspective\",\n    \"filter\"\n];\nconst containValues = [\n    \"paint\",\n    \"layout\",\n    \"strict\",\n    \"content\"\n];\nfunction isContainingBlock(elementOrCss) {\n    const webkit = isWebKit();\n    const css = isElement(elementOrCss) ? getComputedStyle(elementOrCss) : elementOrCss;\n    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block\n    // https://drafts.csswg.org/css-transforms-2/#individual-transforms\n    return transformProperties.some((value)=>css[value] ? css[value] !== \"none\" : false) || (css.containerType ? css.containerType !== \"normal\" : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== \"none\" : false) || !webkit && (css.filter ? css.filter !== \"none\" : false) || willChangeValues.some((value)=>(css.willChange || \"\").includes(value)) || containValues.some((value)=>(css.contain || \"\").includes(value));\n}\nfunction getContainingBlock(element) {\n    let currentNode = getParentNode(element);\n    while(isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)){\n        if (isContainingBlock(currentNode)) {\n            return currentNode;\n        } else if (isTopLayer(currentNode)) {\n            return null;\n        }\n        currentNode = getParentNode(currentNode);\n    }\n    return null;\n}\nfunction isWebKit() {\n    if (typeof CSS === \"undefined\" || !CSS.supports) return false;\n    return CSS.supports(\"-webkit-backdrop-filter\", \"none\");\n}\nconst lastTraversableNodeNames = /*#__PURE__*/ new Set([\n    \"html\",\n    \"body\",\n    \"#document\"\n]);\nfunction isLastTraversableNode(node) {\n    return lastTraversableNodeNames.has(getNodeName(node));\n}\nfunction getComputedStyle(element) {\n    return getWindow(element).getComputedStyle(element);\n}\nfunction getNodeScroll(element) {\n    if (isElement(element)) {\n        return {\n            scrollLeft: element.scrollLeft,\n            scrollTop: element.scrollTop\n        };\n    }\n    return {\n        scrollLeft: element.scrollX,\n        scrollTop: element.scrollY\n    };\n}\nfunction getParentNode(node) {\n    if (getNodeName(node) === \"html\") {\n        return node;\n    }\n    const result = // Step into the shadow DOM of the parent of a slotted node.\n    node.assignedSlot || // DOM Element detected.\n    node.parentNode || // ShadowRoot detected.\n    isShadowRoot(node) && node.host || // Fallback.\n    getDocumentElement(node);\n    return isShadowRoot(result) ? result.host : result;\n}\nfunction getNearestOverflowAncestor(node) {\n    const parentNode = getParentNode(node);\n    if (isLastTraversableNode(parentNode)) {\n        return node.ownerDocument ? node.ownerDocument.body : node.body;\n    }\n    if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {\n        return parentNode;\n    }\n    return getNearestOverflowAncestor(parentNode);\n}\nfunction getOverflowAncestors(node, list, traverseIframes) {\n    var _node$ownerDocument2;\n    if (list === void 0) {\n        list = [];\n    }\n    if (traverseIframes === void 0) {\n        traverseIframes = true;\n    }\n    const scrollableAncestor = getNearestOverflowAncestor(node);\n    const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);\n    const win = getWindow(scrollableAncestor);\n    if (isBody) {\n        const frameElement = getFrameElement(win);\n        return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);\n    }\n    return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));\n}\nfunction getFrameElement(win) {\n    return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs\n");

/***/ }),

/***/ "(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs":
/*!********************************************************************!*\
  !*** ./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs ***!
  \********************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   alignments: () => (/* binding */ alignments),\n/* harmony export */   clamp: () => (/* binding */ clamp),\n/* harmony export */   createCoords: () => (/* binding */ createCoords),\n/* harmony export */   evaluate: () => (/* binding */ evaluate),\n/* harmony export */   expandPaddingObject: () => (/* binding */ expandPaddingObject),\n/* harmony export */   floor: () => (/* binding */ floor),\n/* harmony export */   getAlignment: () => (/* binding */ getAlignment),\n/* harmony export */   getAlignmentAxis: () => (/* binding */ getAlignmentAxis),\n/* harmony export */   getAlignmentSides: () => (/* binding */ getAlignmentSides),\n/* harmony export */   getAxisLength: () => (/* binding */ getAxisLength),\n/* harmony export */   getExpandedPlacements: () => (/* binding */ getExpandedPlacements),\n/* harmony export */   getOppositeAlignmentPlacement: () => (/* binding */ getOppositeAlignmentPlacement),\n/* harmony export */   getOppositeAxis: () => (/* binding */ getOppositeAxis),\n/* harmony export */   getOppositeAxisPlacements: () => (/* binding */ getOppositeAxisPlacements),\n/* harmony export */   getOppositePlacement: () => (/* binding */ getOppositePlacement),\n/* harmony export */   getPaddingObject: () => (/* binding */ getPaddingObject),\n/* harmony export */   getSide: () => (/* binding */ getSide),\n/* harmony export */   getSideAxis: () => (/* binding */ getSideAxis),\n/* harmony export */   max: () => (/* binding */ max),\n/* harmony export */   min: () => (/* binding */ min),\n/* harmony export */   placements: () => (/* binding */ placements),\n/* harmony export */   rectToClientRect: () => (/* binding */ rectToClientRect),\n/* harmony export */   round: () => (/* binding */ round),\n/* harmony export */   sides: () => (/* binding */ sides)\n/* harmony export */ });\n/**\n * Custom positioning reference element.\n * @see https://floating-ui.com/docs/virtual-elements\n */ const sides = [\n    \"top\",\n    \"right\",\n    \"bottom\",\n    \"left\"\n];\nconst alignments = [\n    \"start\",\n    \"end\"\n];\nconst placements = /*#__PURE__*/ sides.reduce((acc, side)=>acc.concat(side, side + \"-\" + alignments[0], side + \"-\" + alignments[1]), []);\nconst min = Math.min;\nconst max = Math.max;\nconst round = Math.round;\nconst floor = Math.floor;\nconst createCoords = (v)=>({\n        x: v,\n        y: v\n    });\nconst oppositeSideMap = {\n    left: \"right\",\n    right: \"left\",\n    bottom: \"top\",\n    top: \"bottom\"\n};\nconst oppositeAlignmentMap = {\n    start: \"end\",\n    end: \"start\"\n};\nfunction clamp(start, value, end) {\n    return max(start, min(value, end));\n}\nfunction evaluate(value, param) {\n    return typeof value === \"function\" ? value(param) : value;\n}\nfunction getSide(placement) {\n    return placement.split(\"-\")[0];\n}\nfunction getAlignment(placement) {\n    return placement.split(\"-\")[1];\n}\nfunction getOppositeAxis(axis) {\n    return axis === \"x\" ? \"y\" : \"x\";\n}\nfunction getAxisLength(axis) {\n    return axis === \"y\" ? \"height\" : \"width\";\n}\nconst yAxisSides = /*#__PURE__*/ new Set([\n    \"top\",\n    \"bottom\"\n]);\nfunction getSideAxis(placement) {\n    return yAxisSides.has(getSide(placement)) ? \"y\" : \"x\";\n}\nfunction getAlignmentAxis(placement) {\n    return getOppositeAxis(getSideAxis(placement));\n}\nfunction getAlignmentSides(placement, rects, rtl) {\n    if (rtl === void 0) {\n        rtl = false;\n    }\n    const alignment = getAlignment(placement);\n    const alignmentAxis = getAlignmentAxis(placement);\n    const length = getAxisLength(alignmentAxis);\n    let mainAlignmentSide = alignmentAxis === \"x\" ? alignment === (rtl ? \"end\" : \"start\") ? \"right\" : \"left\" : alignment === \"start\" ? \"bottom\" : \"top\";\n    if (rects.reference[length] > rects.floating[length]) {\n        mainAlignmentSide = getOppositePlacement(mainAlignmentSide);\n    }\n    return [\n        mainAlignmentSide,\n        getOppositePlacement(mainAlignmentSide)\n    ];\n}\nfunction getExpandedPlacements(placement) {\n    const oppositePlacement = getOppositePlacement(placement);\n    return [\n        getOppositeAlignmentPlacement(placement),\n        oppositePlacement,\n        getOppositeAlignmentPlacement(oppositePlacement)\n    ];\n}\nfunction getOppositeAlignmentPlacement(placement) {\n    return placement.replace(/start|end/g, (alignment)=>oppositeAlignmentMap[alignment]);\n}\nconst lrPlacement = [\n    \"left\",\n    \"right\"\n];\nconst rlPlacement = [\n    \"right\",\n    \"left\"\n];\nconst tbPlacement = [\n    \"top\",\n    \"bottom\"\n];\nconst btPlacement = [\n    \"bottom\",\n    \"top\"\n];\nfunction getSideList(side, isStart, rtl) {\n    switch(side){\n        case \"top\":\n        case \"bottom\":\n            if (rtl) return isStart ? rlPlacement : lrPlacement;\n            return isStart ? lrPlacement : rlPlacement;\n        case \"left\":\n        case \"right\":\n            return isStart ? tbPlacement : btPlacement;\n        default:\n            return [];\n    }\n}\nfunction getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {\n    const alignment = getAlignment(placement);\n    let list = getSideList(getSide(placement), direction === \"start\", rtl);\n    if (alignment) {\n        list = list.map((side)=>side + \"-\" + alignment);\n        if (flipAlignment) {\n            list = list.concat(list.map(getOppositeAlignmentPlacement));\n        }\n    }\n    return list;\n}\nfunction getOppositePlacement(placement) {\n    return placement.replace(/left|right|bottom|top/g, (side)=>oppositeSideMap[side]);\n}\nfunction expandPaddingObject(padding) {\n    return {\n        top: 0,\n        right: 0,\n        bottom: 0,\n        left: 0,\n        ...padding\n    };\n}\nfunction getPaddingObject(padding) {\n    return typeof padding !== \"number\" ? expandPaddingObject(padding) : {\n        top: padding,\n        right: padding,\n        bottom: padding,\n        left: padding\n    };\n}\nfunction rectToClientRect(rect) {\n    const { x, y, width, height } = rect;\n    return {\n        width,\n        height,\n        top: y,\n        left: x,\n        right: x + width,\n        bottom: y + height,\n        x,\n        y\n    };\n}\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs\n");

/***/ })

};
;