<?php session_start(); if (!isset($_SESSION['bora_email']) || !isset($_SESSION['bora_password'])) { header('Location: login.php'); exit; } ?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consultar Consumos - Core3Chip</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body { min-height: 100vh; background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%); display: flex; align-items: center; justify-content: center; font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif; margin: 0; }
        .container { background: rgba(255,255,255,0.97); border-radius: 32px; box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18), 0 1.5px 8px 0 rgba(16,185,129,0.10); padding: 56px 40px 48px 40px; max-width: 520px; width: 100%; display: flex; flex-direction: column; align-items: center; gap: 36px; position: relative; }
        .logo-img { width: 195px; height: 130px; object-fit: contain; object-position: center; margin-bottom: 12px; filter: drop-shadow(0 4px 24px #2563eb33); background: transparent; border-radius: 18px; }
        .main-title { font-size: 1.3rem; font-weight: 700; color: #2563eb; margin-bottom: 8px; }
        .form-section { width: 100%; background: #f1f5f9; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-bottom: 10px; }
        .form-group { display: flex; flex-direction: column; gap: 10px; margin-bottom: 18px; }
        .form-label { font-size: 0.98rem; color: #1e293b; font-weight: 500; }
        .form-input { padding: 12px 14px; border-radius: 8px; border: 1.5px solid #cbd5e1; font-size: 1.08rem; outline: none; transition: border 0.2s; width: 100%; }
        .form-input:focus { border: 1.5px solid #2563eb; }
        .radio-group { display: flex; gap: 18px; align-items: center; margin-bottom: 8px; }
        .radio-label { font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px; }
        .consultar-btn { padding: 13px 0; border: none; border-radius: 10px; font-size: 1.08rem; font-weight: 600; color: #fff; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10); cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 10px; transition: background 0.2s, transform 0.2s, box-shadow 0.2s; outline: none; letter-spacing: 0.5px; min-width: 160px; }
        .consultar-btn .material-icons { font-size: 1.3em; vertical-align: middle; }
        .consultar-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); transform: translateY(-2px) scale(1.03); box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13); }
        .error-message, .success-message { display: none; margin: 10px 0 0 0; padding: 10px 18px; border-radius: 8px; font-size: 1.02rem; font-weight: 500; }
        .error-message { background: #fee2e2; color: #b91c1c; border: 1.5px solid #f87171; }
        .success-message { background: #d1fae5; color: #065f46; border: 1.5px solid #10b981; }
        .results-section { width: 100%; background: #f8fafc; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-top: 10px; }
        .results-title { font-size: 1.15rem; font-weight: 700; color: #2563eb; margin: 0 0 18px 0; }
        .logout-btn { position:absolute;top:18px;right:24px;z-index:100; background:linear-gradient(90deg,#e11d48 0%,#f87171 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #e11d4811;display:flex;align-items:center;gap:8px;font-size:1.05em; }
        .logout-btn .material-icons { font-size:1.2em; }
    </style>
</head>
<body>
    <div class="container">
        <a href="logout.php" class="logout-btn"><span class="material-icons">logout</span> Sair</a>
        <a href="index.php" style="position:absolute;top:18px;left:24px;z-index:100; background:linear-gradient(90deg,#2563eb 0%,#10b981 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #2563eb11;display:flex;align-items:center;gap:8px;font-size:1.05em;"><span class="material-icons" style="font-size:1.2em;">arrow_back</span> Voltar</a>
        <img src="chip.png" alt="Logo" class="logo-img" />
        <div class="main-title">🔍 Consultar Consumos da Linha</div>
        <div class="form-section">
            <form id="consumoForm" style="display:flex;flex-direction:column;gap:18px;">
                <div class="form-group">
                    <label class="form-label" for="linhaInput">Número da linha</label>
                    <input class="form-input" type="text" id="linhaInput" placeholder="Digite o número (ex: 11999999999)" maxlength="11" required />
                </div>
                <div class="radio-group">
                    <label class="radio-label"><input type="radio" name="tipoConsulta" value="plano" checked style="accent-color:#2563eb; margin-right:4px;"> Consumo do plano</label>
                    <label class="radio-label"><input type="radio" name="tipoConsulta" value="total" style="accent-color:#2563eb; margin-right:4px;"> Consumo total</label>
                    <label class="radio-label"><input type="radio" name="tipoConsulta" value="historico" style="accent-color:#2563eb; margin-right:4px;"> Download histórico</label>
                    <label class="radio-label"><input type="radio" name="tipoConsulta" value="detalhes" style="accent-color:#2563eb; margin-right:4px;"> Dados da linha</label>
                </div>
                <div id="dataCampos" style="display:none;flex-direction:row;gap:12px;align-items:center;">
                    <div class="form-group" style="margin-bottom:0;">
                        <label class="form-label" for="dataInicial">Data inicial</label>
                        <input class="form-input" type="text" id="dataInicial" placeholder="DD-MM-AAAA" maxlength="10" pattern="\d{2}-\d{2}-\d{4}" />
                    </div>
                    <div class="form-group" style="margin-bottom:0;">
                        <label class="form-label" for="dataFinal">Data final</label>
                        <input class="form-input" type="text" id="dataFinal" placeholder="DD-MM-AAAA" maxlength="10" pattern="\d{2}-\d{2}-\d{4}" />
                    </div>
                </div>
                <button type="submit" class="consultar-btn"><span class="material-icons">search</span> Consultar</button>
            </form>
            <div class="error-message" id="errorMessage"></div>
            <div class="success-message" id="successMessage"></div>
        </div>
        <div class="results-section" id="resultsSection" style="display:none;"></div>
    </div>
    <script>
    const consumoForm = document.getElementById('consumoForm');
    const linhaInput = document.getElementById('linhaInput');
    const errorMessage = document.getElementById('errorMessage');
    const successMessage = document.getElementById('successMessage');
    const resultsSection = document.getElementById('resultsSection');
    const radioHistorico = document.querySelector('input[value="historico"]');
    const dataCampos = document.getElementById('dataCampos');
    const dataInicial = document.getElementById('dataInicial');
    const dataFinal = document.getElementById('dataFinal');
    const radios = document.querySelectorAll('input[name="tipoConsulta"]');
    radios.forEach(radio => {
        radio.addEventListener('change', function() {
            if (radioHistorico.checked) {
                dataCampos.style.display = 'flex';
            } else {
                dataCampos.style.display = 'none';
            }
        });
    });
    consumoForm.addEventListener('submit', function(e) {
        e.preventDefault();
        errorMessage.style.display = 'none';
        successMessage.style.display = 'none';
        resultsSection.style.display = 'none';
        let numero = linhaInput.value.replace(/\D/g, '');
        if (numero.length !== 11) {
            errorMessage.textContent = 'Digite um número válido com 11 dígitos.';
            errorMessage.style.display = 'block';
            return;
        }
        const identifier = '55' + numero;
        const tipo = document.querySelector('input[name="tipoConsulta"]:checked').value;
        let rota = '';
        let fetchOptions = { method: 'GET' };
        if (tipo === 'plano') {
            // Buscar o identifier do form
            let numero = linhaInput.value.replace(/\D/g, '');
            const identifier = '55' + numero;
            resultsSection.innerHTML = '<div class="spinner" style="margin:18px auto;"></div> <span style="color:#2563eb;">Consultando...</span>';
            resultsSection.style.display = 'block';
            // Fazer as duas requisições em paralelo
            Promise.all([
                fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/${identifier}/consumption`)).then(r => r.json()),
                fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/${identifier}/details`)).then(r => r.json())
            ]).then(([data, details]) => {
                // --- NOVO LAYOUT EM MODAL COM DADOS DO CLIENTE ---
                const plano = data.plan || data.plano || {};
                const ligacoes = data.voice || data.ligacoes || {};
                const sms = data.sms || {};
                const dados = data.data || data.dados || {};
                // Dados do cliente (do details)
                const nomeCliente = details.name || '-';
                // Máscara CPF/CNPJ
                let cpfCnpj = details.document || '-';
                if (/^\d{11}$/.test(cpfCnpj)) {
                    cpfCnpj = cpfCnpj.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, '$1.$2.$3-$4');
                } else if (/^\d{14}$/.test(cpfCnpj)) {
                    cpfCnpj = cpfCnpj.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/, '$1.$2.$3/$4-$5');
                }
                const imsi = details.imsi || '-';
                // Máscara telefone
                let msisdn = details.msisdn || '-';
                if (/^55\d{11}$/.test(msisdn)) {
                    msisdn = msisdn.replace(/^(\d{2})(\d{2})(\d{5})(\d{4})$/, '+$1 ($2)$3-$4');
                }
                const tipoChip = details.iccidType || '-';
                let telAlt = details.telefoneAlternativo || details.telefone_alternativo || '-';
                if (/^55\d{11}$/.test(telAlt)) {
                    telAlt = telAlt.replace(/^(\d{2})(\d{2})(\d{5})(\d{4})$/, '+$1 ($2)$3-$4');
                }
                const iccid = details.iccid || '-';
                // Endereço
                let endereco = '-';
                const logradouro = details.logradouro || details.endereco || details.address || '';
                const numero = details.numero || details.number || '';
                const bairro = details.bairro || details.neighborhood || '';
                const cidade = details.cidade || details.city || '';
                const uf = details.uf || details.state || '';
                const cep = details.cep || details.zipcode || '';
                if (logradouro || numero || bairro || cidade || uf || cep) {
                    endereco = `${logradouro}${numero ? ', ' + numero : ''}${bairro ? ' - ' + bairro : ''}${cidade ? ', ' + cidade : ''}${uf ? ' / ' + uf : ''}${cep ? ' - CEP: ' + cep : ''}`.replace(/^,\s*/, '');
                }
                // Valores fictícios caso não existam
                const totalDados = dados.total || 50 * 1024; // MB
                const usadoDados = dados.used || 43.62; // MB
                const disponivelDados = totalDados - usadoDados;
                const totalSms = sms.total || 100;
                const usadoSms = sms.used || 0;
                const disponivelSms = totalSms - usadoSms;
                const totalLig = ligacoes.total || 1000;
                const usadoLig = ligacoes.used || 0;
                const disponivelLig = totalLig - usadoLig;
                let percent = totalDados ? ((usadoDados / totalDados) * 100).toFixed(2) : 0;
                // Overlay + Modal
                let modalHtml = `
                <div id='modalOverlay' style='position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.55);z-index:9999;display:flex;align-items:center;justify-content:center;'>
                    <div id='modalConsumo' style='background:#fff;border-radius:22px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18),0 1.5px 8px 0 rgba(16,185,129,0.10);padding:0;max-width:1100px;width:98vw;max-height:92vh;overflow:hidden;position:relative;display:flex;flex-direction:row;gap:0;'>
                        <div style='flex:2;min-width:340px;padding:32px 28px 28px 28px;overflow-y:auto;'>
                            <button id='fecharModalConsumo' style='position:absolute;top:18px;right:18px;background:transparent;border:none;font-size:2em;color:#64748b;cursor:pointer;'><span class='material-icons'>close</span></button>
                            <div style='font-size:1.25em;font-weight:700;color:#2563eb;margin-bottom:8px;'>Planos Vigentes</div>
                            <div style='display:flex;align-items:center;gap:18px;margin-bottom:12px;flex-wrap:wrap;'>
                                <span style='background:#10b981;color:#fff;padding:4px 18px;border-radius:16px;font-weight:600;'>Ativo</span>
                                <span style='color:#64748b;font-size:1.05em;'>PLANO CELULAR 50GB - <b>${usadoDados} MB</b> utilizados de <b>${(totalDados/1024).toFixed(2)} GB</b> (${percent}%)</span>
                                <span style='color:#64748b;font-size:0.98em;'>Válido até: <b>17/09/2025</b></span>
                            </div>
                            <div style='width:100%;height:12px;background:#f1f5f9;border-radius:8px;margin-bottom:18px;'><div style='height:100%;background:linear-gradient(90deg,#2563eb 0%,#10b981 100%);border-radius:8px;width:${percent}%;'></div></div>
                            <div style='display:flex;gap:18px;margin-bottom:18px;flex-wrap:wrap;'>
                                <div style='flex:1 1 180px;background:#1e40af;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>call</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>Ligações</div><div>Disponível: <b>${disponivelLig} Min</b></div></div>
                                <div style='flex:1 1 180px;background:#059669;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>sms</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>SMS</div><div>Disponível: <b>${disponivelSms} SMS</b></div></div>
                                <div style='flex:1 1 180px;background:#be123c;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>signal_cellular_4g</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>Dados Móveis</div><div>Disponível: <b>${(disponivelDados/1024).toFixed(2)} GB</b></div></div>
                            </div>
                            <div style='font-size:1.18em;font-weight:700;color:#222;margin:18px 0 8px 0;'>Consumo Atual</div>
                            <div style='display:flex;gap:38px;justify-content:center;margin-bottom:18px;'>
                                <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#1e40af;height:${totalLig?((usadoLig/totalLig)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoLig} Min<br>Consumido(s)</div></div>
                                <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#059669;height:${totalSms?((usadoSms/totalSms)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoSms} SMS<br>Consumido(s)</div></div>
                                <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#be123c;height:${totalDados?((usadoDados/totalDados)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoDados} MB<br>Consumido(s)</div></div>
                            </div>
                            <div style='display:flex;gap:24px;margin-top:18px;flex-wrap:wrap;'>
                                <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Próxima recorrência:</b> 17/09/2025</div>
                                <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Forma de pagamento:</b> Boleto Combado</div>
                                <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Status:</b> Ativo</div>
                            </div>
                        </div>
                        <div style='flex:1;min-width:320px;background:#f8fafc;border-radius:0 22px 22px 0;padding:32px 24px 24px 24px;display:flex;flex-direction:column;gap:10px;align-items:center;overflow-y:auto;'>
                            <div style='width:80px;height:80px;background:#2563eb22;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:2.5em;font-weight:700;color:#2563eb;margin-bottom:8px;'>${nomeCliente.split(' ').map(n=>n[0]).join('').substring(0,2).toUpperCase()}</div>
                            <div style='font-size:1.13em;font-weight:700;color:#2563eb;margin-bottom:8px;text-align:center;'>${nomeCliente}</div>
                            <div style='width:100%;display:flex;flex-direction:column;gap:6px;'>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>CPF/CNPJ:</span><span style='color:#222;'>${cpfCnpj}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>IMSI:</span><span style='color:#222;'>${imsi}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Número:</span><span style='color:#222;'>${msisdn}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Tipo de Chip:</span><span style='color:#222;'>${tipoChip}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Telefone Alternativo:</span><span style='color:#222;'>${telAlt}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>ICCID:</span><span style='color:#222;'>${iccid}</span></div>
                            </div>
                            <img src='chip.png' alt='Chip' style='width:220px;height:140px;object-fit:contain;margin-top:18px;' />
                        </div>
                    </div>
                </div>`;
                // Adiciona o modal ao body
                const modalDiv = document.createElement('div');
                modalDiv.innerHTML = modalHtml;
                document.body.appendChild(modalDiv);
                // Fechar modal
                setTimeout(() => {
                    const fecharBtn = document.getElementById('fecharModalConsumo');
                    const overlay = document.getElementById('modalOverlay');
                    if (fecharBtn && overlay) {
                        fecharBtn.onclick = () => { overlay.parentNode.remove(); };
                        overlay.onclick = (e) => { if (e.target === overlay) overlay.parentNode.remove(); };
                    }
                }, 100);
                resultsSection.innerHTML = '';
                resultsSection.style.display = 'none';
            });
            return;
        } else if (tipo === 'total') {
            // Buscar o identifier do form
            let numero = linhaInput.value.replace(/\D/g, '');
            const identifier = '55' + numero;
            resultsSection.innerHTML = '<div class="spinner" style="margin:18px auto;"></div> <span style="color:#2563eb;">Consultando...</span>';
            resultsSection.style.display = 'block';
            // Fazer as duas requisições em paralelo
            Promise.all([
                fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/${identifier}/consumption/all`)).then(r => r.json()),
                fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/${identifier}/details`)).then(r => r.json())
            ]).then(([data, details]) => {
                // --- LAYOUT EM MODAL IGUAL AO CONSUMO DO PLANO ---
                const plano = data.plan || data.plano || {};
                const ligacoes = data.voice || data.ligacoes || {};
                const sms = data.sms || {};
                const dados = data.data || data.dados || {};
                // Dados do cliente (do details)
                const nomeCliente = details.name || '-';
                let cpfCnpj = details.document || '-';
                if (/^\d{11}$/.test(cpfCnpj)) {
                    cpfCnpj = cpfCnpj.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, '$1.$2.$3-$4');
                } else if (/^\d{14}$/.test(cpfCnpj)) {
                    cpfCnpj = cpfCnpj.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/, '$1.$2.$3/$4-$5');
                }
                const imsi = details.imsi || '-';
                let msisdn = details.msisdn || '-';
                if (/^55\d{11}$/.test(msisdn)) {
                    msisdn = msisdn.replace(/^(\d{2})(\d{2})(\d{5})(\d{4})$/, '+$1 ($2)$3-$4');
                }
                const tipoChip = details.iccidType || '-';
                let telAlt = details.telefoneAlternativo || details.telefone_alternativo || '-';
                if (/^55\d{11}$/.test(telAlt)) {
                    telAlt = telAlt.replace(/^(\d{2})(\d{2})(\d{5})(\d{4})$/, '+$1 ($2)$3-$4');
                }
                const iccid = details.iccid || '-';
                // Endereço removido, exibe chip.png
                // Valores fictícios caso não existam
                const totalDados = dados.total || 50 * 1024; // MB
                const usadoDados = dados.used || 43.62; // MB
                const disponivelDados = totalDados - usadoDados;
                const totalSms = sms.total || 100;
                const usadoSms = sms.used || 0;
                const disponivelSms = totalSms - usadoSms;
                const totalLig = ligacoes.total || 1000;
                const usadoLig = ligacoes.used || 0;
                const disponivelLig = totalLig - usadoLig;
                let percent = totalDados ? ((usadoDados / totalDados) * 100).toFixed(2) : 0;
                // Overlay + Modal
                let modalHtml = `
                <div id='modalOverlay' style='position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.55);z-index:9999;display:flex;align-items:center;justify-content:center;'>
                    <div id='modalConsumo' style='background:#fff;border-radius:22px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18),0 1.5px 8px 0 rgba(16,185,129,0.10);padding:0;max-width:1100px;width:98vw;max-height:92vh;overflow:hidden;position:relative;display:flex;flex-direction:row;gap:0;'>
                        <div style='flex:2;min-width:340px;padding:32px 28px 28px 28px;overflow-y:auto;'>
                            <button id='fecharModalConsumo' style='position:absolute;top:18px;right:18px;background:transparent;border:none;font-size:2em;color:#64748b;cursor:pointer;'><span class='material-icons'>close</span></button>
                            <div style='font-size:1.25em;font-weight:700;color:#2563eb;margin-bottom:8px;'>Consumo Total</div>
                            <div style='display:flex;align-items:center;gap:18px;margin-bottom:12px;flex-wrap:wrap;'>
                                <span style='background:#10b981;color:#fff;padding:4px 18px;border-radius:16px;font-weight:600;'>Ativo</span>
                                <span style='color:#64748b;font-size:1.05em;'>PLANO CELULAR 50GB - <b>${usadoDados} MB</b> utilizados de <b>${(totalDados/1024).toFixed(2)} GB</b> (${percent}%)</span>
                                <span style='color:#64748b;font-size:0.98em;'>Válido até: <b>17/09/2025</b></span>
                            </div>
                            <div style='width:100%;height:12px;background:#f1f5f9;border-radius:8px;margin-bottom:18px;'><div style='height:100%;background:linear-gradient(90deg,#2563eb 0%,#10b981 100%);border-radius:8px;width:${percent}%;'></div></div>
                            <div style='display:flex;gap:18px;margin-bottom:18px;flex-wrap:wrap;'>
                                <div style='flex:1 1 180px;background:#1e40af;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>call</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>Ligações</div><div>Disponível: <b>${disponivelLig} Min</b></div></div>
                                <div style='flex:1 1 180px;background:#059669;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>sms</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>SMS</div><div>Disponível: <b>${disponivelSms} SMS</b></div></div>
                                <div style='flex:1 1 180px;background:#be123c;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>signal_cellular_4g</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>Dados Móveis</div><div>Disponível: <b>${(disponivelDados/1024).toFixed(2)} GB</b></div></div>
                            </div>
                            <div style='font-size:1.18em;font-weight:700;color:#222;margin:18px 0 8px 0;'>Consumo Atual</div>
                            <div style='display:flex;gap:38px;justify-content:center;margin-bottom:18px;'>
                                <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#1e40af;height:${totalLig?((usadoLig/totalLig)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoLig} Min<br>Consumido(s)</div></div>
                                <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#059669;height:${totalSms?((usadoSms/totalSms)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoSms} SMS<br>Consumido(s)</div></div>
                                <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#be123c;height:${totalDados?((usadoDados/totalDados)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoDados} MB<br>Consumido(s)</div></div>
                            </div>
                            <div style='display:flex;gap:24px;margin-top:18px;flex-wrap:wrap;'>
                                <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Próxima recorrência:</b> 17/09/2025</div>
                                <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Forma de pagamento:</b> Boleto Combado</div>
                                <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Status:</b> Ativo</div>
                            </div>
                        </div>
                        <div style='flex:1;min-width:320px;background:#f8fafc;border-radius:0 22px 22px 0;padding:32px 24px 24px 24px;display:flex;flex-direction:column;gap:10px;align-items:center;overflow-y:auto;'>
                            <div style='width:80px;height:80px;background:#2563eb22;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:2.5em;font-weight:700;color:#2563eb;margin-bottom:8px;'>${nomeCliente.split(' ').map(n=>n[0]).join('').substring(0,2).toUpperCase()}</div>
                            <div style='font-size:1.13em;font-weight:700;color:#2563eb;margin-bottom:8px;text-align:center;'>${nomeCliente}</div>
                            <div style='width:100%;display:flex;flex-direction:column;gap:6px;'>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>CPF/CNPJ:</span><span style='color:#222;'>${cpfCnpj}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>IMSI:</span><span style='color:#222;'>${imsi}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Número:</span><span style='color:#222;'>${msisdn}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Tipo de Chip:</span><span style='color:#222;'>${tipoChip}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Telefone Alternativo:</span><span style='color:#222;'>${telAlt}</span></div>
                                <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>ICCID:</span><span style='color:#222;'>${iccid}</span></div>
                            </div>
                            <img src='chip.png' alt='Chip' style='width:220px;height:140px;object-fit:contain;margin-top:18px;' />
                        </div>
                    </div>
                </div>`;
                // Adiciona o modal ao body
                const modalDiv = document.createElement('div');
                modalDiv.innerHTML = modalHtml;
                document.body.appendChild(modalDiv);
                // Fechar modal
                setTimeout(() => {
                    const fecharBtn = document.getElementById('fecharModalConsumo');
                    const overlay = document.getElementById('modalOverlay');
                    if (fecharBtn && overlay) {
                        fecharBtn.onclick = () => { overlay.parentNode.remove(); };
                        overlay.onclick = (e) => { if (e.target === overlay) overlay.parentNode.remove(); };
                    }
                }, 100);
                resultsSection.innerHTML = '';
                resultsSection.style.display = 'none';
            });
            return;
        } else if (tipo === 'detalhes') {
            rota = `/api/Subscription/${identifier}/details`;
        } else {
            // Download histórico: GET com datas na query string, rota /historic/document
            const di = dataInicial.value.trim();
            const df = dataFinal.value.trim();
            if (!/^\d{2}-\d{2}-\d{4}$/.test(di) || !/^\d{2}-\d{2}-\d{4}$/.test(df)) {
                errorMessage.textContent = 'Preencha as datas no formato DD-MM-AAAA.';
                errorMessage.style.display = 'block';
                return;
            }
            const diParts = di.split('-');
            const dfParts = df.split('-');
            const dateInitial = `${diParts[2]}-${diParts[1]}-${diParts[0]}`;
            const dateFinal = `${dfParts[2]}-${dfParts[1]}-${dfParts[0]}`;
            rota = `/api/Subscription/${identifier}/historic/document?DateInitials=${encodeURIComponent(dateInitial)}&DateFinal=${encodeURIComponent(dateFinal)}&Data=true&Voice=true&Sms=true`;
            fetchOptions = { method: 'GET' };
        }
        resultsSection.innerHTML = '<div class="spinner" style="margin:18px auto;"></div> <span style="color:#2563eb;">Consultando...</span>';
        resultsSection.style.display = 'block';
        fetch('proxy-chip.php?rota=' + encodeURIComponent(rota), fetchOptions)
            .then(async response => {
                const contentType = response.headers.get('Content-Type');
                if (contentType && contentType.includes('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')) {
                    // Baixar arquivo XLSX
                    const blob = await response.blob();
                    const url = window.URL.createObjectURL(blob);
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = `historico_${linhaInput.value}_${dataInicial.value}_a_${dataFinal.value}.xlsx`;
                    document.body.appendChild(a);
                    a.click();
                    setTimeout(() => {
                        window.URL.revokeObjectURL(url);
                        a.remove();
                    }, 100);
                    resultsSection.innerHTML = `
                        <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #2563eb22;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:12px;">
                            <span class="material-icons" style="font-size:2.5em;color:#10b981;">check_circle</span>
                            <div style="font-weight:700;color:#2563eb;font-size:1.15em;">Download concluído!</div>
                            <div style="color:#222;font-size:1.05em;">O arquivo <b>historico_${linhaInput.value}_${dataInicial.value}_a_${dataFinal.value}.xlsx</b> foi baixado com sucesso.<br>Abra no Excel ou programa compatível para visualizar o histórico detalhado.</div>
                        </div>
                    `;
                    resultsSection.style.display = 'block';
                    return;
                }
                const status = response.status;
                const statusText = response.statusText;
                const text = await response.text();
                let data;
                try {
                    data = JSON.parse(text);
                } catch (e) {
                    if (text.includes('<form') && text.includes('login')) {
                        window.location.href = 'login.php';
                        return;
                    }
                    errorMessage.textContent = `Erro inesperado (HTTP ${status}): ${text}`;
                    errorMessage.style.display = 'block';
                    resultsSection.style.display = 'none';
                    return;
                }
                // Se a resposta for erro, mostrar detalhes
                if (data && (data.error || data.detail || data.message)) {
                    let msg = data.detail || data.error || data.message;
                    errorMessage.textContent = `Erro (HTTP ${status}): ` + msg;
                    errorMessage.style.display = 'block';
                    resultsSection.style.display = 'none';
                    return;
                }
                // Se não houver dados e não for 2xx, mostrar texto bruto
                if (status < 200 || status >= 300) {
                    errorMessage.textContent = `Erro (HTTP ${status}): ${text}`;
                    errorMessage.style.display = 'block';
                    resultsSection.style.display = 'none';
                    return;
                }
                return data;
            })
            .then(data => {
                if (!data) return;
                resultsSection.innerHTML = '';
                if (data.error || data.detail) {
                    errorMessage.textContent = 'Erro: ' + (data.detail || data.error);
                    errorMessage.style.display = 'block';
                    resultsSection.style.display = 'none';
                    return;
                }
                // Formatação elegante para Consumo do plano e Consumo total
                if (tipo === 'plano') {
                    // --- NOVO LAYOUT EM MODAL COM DADOS DO CLIENTE ---
                    // Extrair dados principais do JSON
                    const plano = data.plan || data.plano || {};
                    const ligacoes = data.voice || data.ligacoes || {};
                    const sms = data.sms || {};
                    const dados = data.data || data.dados || {};
                    // Dados do cliente
                    const nomeCliente = data.name || '-';
                    // Máscara CPF/CNPJ
                    let cpfCnpj = data.document || '-';
                    if (/^\d{11}$/.test(cpfCnpj)) {
                        cpfCnpj = cpfCnpj.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, '$1.$2.$3-$4');
                    } else if (/^\d{14}$/.test(cpfCnpj)) {
                        cpfCnpj = cpfCnpj.replace(/(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})/, '$1.$2.$3/$4-$5');
                    }
                    const imsi = data.imsi || '-';
                    // Máscara telefone
                    let msisdn = data.msisdn || '-';
                    if (/^55\d{11}$/.test(msisdn)) {
                        msisdn = msisdn.replace(/^(\d{2})(\d{2})(\d{5})(\d{4})$/, '+$1 ($2)$3-$4');
                    }
                    const tipoChip = data.iccidType || '-';
                    let telAlt = data.telefoneAlternativo || data.telefone_alternativo || '-';
                    if (/^55\d{11}$/.test(telAlt)) {
                        telAlt = telAlt.replace(/^(\d{2})(\d{2})(\d{5})(\d{4})$/, '+$1 ($2)$3-$4');
                    }
                    const iccid = data.iccid || '-';
                    // Endereço
                    let endereco = '-';
                    const logradouro = data.logradouro || data.endereco || data.address || '';
                    const numero = data.numero || data.number || '';
                    const bairro = data.bairro || data.neighborhood || '';
                    const cidade = data.cidade || data.city || '';
                    const uf = data.uf || data.state || '';
                    const cep = data.cep || data.zipcode || '';
                    if (logradouro || numero || bairro || cidade || uf || cep) {
                        endereco = `${logradouro}${numero ? ', ' + numero : ''}${bairro ? ' - ' + bairro : ''}${cidade ? ', ' + cidade : ''}${uf ? ' / ' + uf : ''}${cep ? ' - CEP: ' + cep : ''}`.replace(/^,\s*/, '');
                    }
                    // Valores fictícios caso não existam
                    const totalDados = dados.total || 50 * 1024; // MB
                    const usadoDados = dados.used || 43.62; // MB
                    const disponivelDados = totalDados - usadoDados;
                    const totalSms = sms.total || 100;
                    const usadoSms = sms.used || 0;
                    const disponivelSms = totalSms - usadoSms;
                    const totalLig = ligacoes.total || 1000;
                    const usadoLig = ligacoes.used || 0;
                    const disponivelLig = totalLig - usadoLig;
                    let percent = totalDados ? ((usadoDados / totalDados) * 100).toFixed(2) : 0;
                    // Overlay + Modal
                    let modalHtml = `
                    <div id='modalOverlay' style='position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.55);z-index:9999;display:flex;align-items:center;justify-content:center;'>
                        <div id='modalConsumo' style='background:#fff;border-radius:22px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18),0 1.5px 8px 0 rgba(16,185,129,0.10);padding:0;max-width:1100px;width:98vw;max-height:92vh;overflow:hidden;position:relative;display:flex;flex-direction:row;gap:0;'>
                            <div style='flex:2;min-width:340px;padding:32px 28px 28px 28px;overflow-y:auto;'>
                                <button id='fecharModalConsumo' style='position:absolute;top:18px;right:18px;background:transparent;border:none;font-size:2em;color:#64748b;cursor:pointer;'><span class='material-icons'>close</span></button>
                                <div style='font-size:1.25em;font-weight:700;color:#2563eb;margin-bottom:8px;'>Planos Vigentes</div>
                                <div style='display:flex;align-items:center;gap:18px;margin-bottom:12px;flex-wrap:wrap;'>
                                    <span style='background:#10b981;color:#fff;padding:4px 18px;border-radius:16px;font-weight:600;'>Ativo</span>
                                    <span style='color:#64748b;font-size:1.05em;'>PLANO CELULAR 50GB - <b>${usadoDados} MB</b> utilizados de <b>${(totalDados/1024).toFixed(2)} GB</b> (${percent}%)</span>
                                    <span style='color:#64748b;font-size:0.98em;'>Válido até: <b>17/09/2025</b></span>
                                </div>
                                <div style='width:100%;height:12px;background:#f1f5f9;border-radius:8px;margin-bottom:18px;'><div style='height:100%;background:linear-gradient(90deg,#2563eb 0%,#10b981 100%);border-radius:8px;width:${percent}%;'></div></div>
                                <div style='display:flex;gap:18px;margin-bottom:18px;flex-wrap:wrap;'>
                                    <div style='flex:1 1 180px;background:#1e40af;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>call</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>Ligações</div><div>Disponível: <b>${disponivelLig} Min</b></div></div>
                                    <div style='flex:1 1 180px;background:#059669;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>sms</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>SMS</div><div>Disponível: <b>${disponivelSms} SMS</b></div></div>
                                    <div style='flex:1 1 180px;background:#be123c;color:#fff;border-radius:12px;padding:18px 10px;display:flex;flex-direction:column;align-items:center;min-width:150px;'><span class='material-icons' style='font-size:2em;'>signal_cellular_4g</span><div style='font-size:1.1em;font-weight:600;margin:6px 0;'>Dados Móveis</div><div>Disponível: <b>${(disponivelDados/1024).toFixed(2)} GB</b></div></div>
                                </div>
                                <div style='font-size:1.18em;font-weight:700;color:#222;margin:18px 0 8px 0;'>Consumo Atual</div>
                                <div style='display:flex;gap:38px;justify-content:center;margin-bottom:18px;'>
                                    <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#1e40af;height:${totalLig?((usadoLig/totalLig)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoLig} Min<br>Consumido(s)</div></div>
                                    <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#059669;height:${totalSms?((usadoSms/totalSms)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoSms} SMS<br>Consumido(s)</div></div>
                                    <div style='display:flex;flex-direction:column;align-items:center;'><div style='height:120px;width:22px;background:#f1f5f9;border-radius:8px;display:flex;align-items:flex-end;'><div style='width:100%;background:#be123c;height:${totalDados?((usadoDados/totalDados)*100):0}%;border-radius:8px;'></div></div><div style='margin-top:8px;font-size:0.98em;'>${usadoDados} MB<br>Consumido(s)</div></div>
                                </div>
                                <div style='display:flex;gap:24px;margin-top:18px;flex-wrap:wrap;'>
                                    <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Próxima recorrência:</b> 17/09/2025</div>
                                    <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Forma de pagamento:</b> Boleto Combado</div>
                                    <div style='background:#f1f5f9;border-radius:10px;padding:12px 18px;min-width:180px;'><b>Status:</b> Ativo</div>
                                </div>
                            </div>
                            <div style='flex:1;min-width:320px;background:#f8fafc;border-radius:0 22px 22px 0;padding:32px 24px 24px 24px;display:flex;flex-direction:column;gap:10px;align-items:center;overflow-y:auto;'>
                                <div style='width:80px;height:80px;background:#2563eb22;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:2.5em;font-weight:700;color:#2563eb;margin-bottom:8px;'>${nomeCliente.split(' ').map(n=>n[0]).join('').substring(0,2).toUpperCase()}</div>
                                <div style='font-size:1.13em;font-weight:700;color:#2563eb;margin-bottom:8px;text-align:center;'>${nomeCliente}</div>
                                <div style='width:100%;display:flex;flex-direction:column;gap:6px;'>
                                    <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>CPF/CNPJ:</span><span style='color:#222;'>${cpfCnpj}</span></div>
                                    <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>IMSI:</span><span style='color:#222;'>${imsi}</span></div>
                                    <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Número:</span><span style='color:#222;'>${msisdn}</span></div>
                                    <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Tipo de Chip:</span><span style='color:#222;'>${tipoChip}</span></div>
                                    <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>Telefone Alternativo:</span><span style='color:#222;'>${telAlt}</span></div>
                                    <div style='display:flex;justify-content:space-between;'><span style='color:#64748b;font-weight:600;'>ICCID:</span><span style='color:#222;'>${iccid}</span></div>
                                </div>
                            </div>
                        </div>
                    </div>`;
                    // Adiciona o modal ao body
                    const modalDiv = document.createElement('div');
                    modalDiv.innerHTML = modalHtml;
                    document.body.appendChild(modalDiv);
                    // Fechar modal
                    setTimeout(() => {
                        const fecharBtn = document.getElementById('fecharModalConsumo');
                        const overlay = document.getElementById('modalOverlay');
                        if (fecharBtn && overlay) {
                            fecharBtn.onclick = () => { overlay.parentNode.remove(); };
                            overlay.onclick = (e) => { if (e.target === overlay) overlay.parentNode.remove(); };
                        }
                    }, 100);
                    resultsSection.innerHTML = '';
                    resultsSection.style.display = 'none';
                    return;
                }
                // Formatação elegante para Dados da linha
                if (tipo === 'detalhes') {
                    // Buscar planId apenas em recurrence.planId
                    let planId = null;
                    if (data.recurrence && data.recurrence.planId) {
                        planId = data.recurrence.planId;
                    } else if (data['recurrence'] && data['recurrence'].planId) {
                        planId = data['recurrence'].planId;
                    }
                    // 2. Objeto Recorrência (diferentes capitalizações)
                    if ((!planId || planId === '-') && data.Recorrência && data.Recorrência.planId) {
                        planId = data.Recorrência.planId;
                    }
                    if ((!planId || planId === '-') && data['Recorrência'] && data['Recorrência'].planId) {
                        planId = data['Recorrência'].planId;
                    }
                    if ((!planId || planId === '-') && data['recorrencia'] && data['recorrencia'].planId) {
                        planId = data['recorrencia'].planId;
                    }
                    // 3. Busca profunda em todos os objetos/arrays
                    function deepFindPlanId(obj) {
                        if (!obj || typeof obj !== 'object') return null;
                        if (obj.planId) return obj.planId;
                        for (const k in obj) {
                            if (typeof obj[k] === 'object') {
                                const found = deepFindPlanId(obj[k]);
                                if (found) return found;
                            }
                        }
                        return null;
                    }
                    if (!planId || planId === '-') {
                        const found = deepFindPlanId(data);
                        if (found) planId = found;
                    }
                    const fieldLabels = {
                        typeDocument: 'Tipo de Documento',
                        name: 'Nome',
                        document: 'Documento',
                        msisdn: 'Celular',
                        iccid: 'NChip',
                        iccidType: 'Tipo Chip',
                        activationDate: 'Data Ativacao',
                        activeBilletCombo: 'Boleto',
                        plan: 'Plano atual',
                        recurrence: 'Recorrência',
                        // outros campos podem ser adicionados aqui
                    };
                    function renderValue(val) {
                        if (val === null || val === undefined || val === '') return '-';
                        if (typeof val === 'object') {
                            let html = '<table style="margin:4px 0 4px 0;padding-left:8px;border-left:2px solid #e0e7ef;font-size:0.97em;background:#f8fafc;border-radius:6px;">';
                            for (const k in val) {
                                if (val[k] !== null && val[k] !== undefined && val[k] !== '') {
                                    html += `<tr><td style='padding:4px 4px;font-weight:600;color:#64748b;'>${fieldLabels[k] || k}</td><td style='padding:4px 4px;'>${renderValue(val[k])}</td></tr>`;
                                }
                            }
                            html += '</table>';
                            return html;
                        }
                        return val;
                    }
                    let html = `<div style='background:#fff;border-radius:14px;box-shadow:0 2px 12px #2563eb22;padding:18px 10px;max-width:520px;margin:0 auto;'>`;
                    html += `<div style='font-weight:700;color:#2563eb;font-size:1.05em;margin-bottom:10px;display:flex;align-items:center;gap:8px;'><span class='material-icons' style='font-size:1.2em;'>info</span>Dados da linha</div>`;
                    if (data && typeof data === 'object') {
                        html += `<table style='width:100%;border-collapse:collapse;font-size:1em;'>`;
                        for (const key in data) {
                            if (['mvno','mobileOperator'].includes(key)) continue;
                            if (data[key] !== null && data[key] !== undefined && data[key] !== '') {
                                html += `<tr><td style='padding:7px 4px;font-weight:600;color:#2563eb;'>${fieldLabels[key] || key}</td><td style='padding:7px 4px;'>${renderValue(data[key])}</td></tr>`;
                            }
                        }
                        html += `</table>`;
                    } else {
                        html += `<div style='color:#b91c1c;'>Nenhum dado encontrado.</div>`;
                    }
                    html += `</div>`;
                    // Botão Executar e opções de recorrência
                    if (data && data.msisdn && (data.accountId || data.id || data.subscriberId)) {
                        const accountId = data.accountId || data.id || data.subscriberId;
                        html += `<div style='margin-top:22px;display:flex;flex-direction:column;align-items:center;gap:10px;'>
                            <div style='color:#64748b;font-size:0.98em;margin-bottom:2px;'><b>AccountId:</b> <span style='font-family:monospace;'>${accountId}</span></div>
                            <div style='color:#64748b;font-size:0.98em;margin-bottom:2px;'><b>ClientId:</b> <span style='font-family:monospace;'>${data.subscriberId || accountId}</span></div>
                            <div style='color:#64748b;font-size:0.98em;margin-bottom:2px;'><b>PlanId:</b> <span style='font-family:monospace;'>${planId || '-'}</span></div>
                            <div style='display:flex;gap:18px;margin-bottom:8px;'>
                                <label style='font-weight:600;color:#2563eb;display:flex;align-items:center;gap:4px;'><input type='radio' name='recorrenciaOpt' value='ativar' checked style='accent-color:#10b981;'> Ativar recorrência</label>
                                <label style='font-weight:600;color:#e11d48;display:flex;align-items:center;gap:4px;'><input type='radio' name='recorrenciaOpt' value='desativar' style='accent-color:#e11d48;'> Desativar recorrência</label>
                            </div>
                            <button id='alterarPlanoBtn' class='consultar-btn' style='background:linear-gradient(90deg,#f59e42 0%,#2563eb 100%);color:#fff;gap:8px;'><span class='material-icons'>swap_horiz</span>Executar</button>
                        </div>`;
                    }
                    resultsSection.innerHTML = html;
                    resultsSection.style.display = 'block';
                    // Adicionar listener ao botão
                    if (data && data.msisdn && (data.accountId || data.id || data.subscriberId)) {
                        setTimeout(() => {
                            const alterarPlanoBtn = document.getElementById('alterarPlanoBtn');
                            if (alterarPlanoBtn) {
                                alterarPlanoBtn.onclick = function() {
                                    // Garante que o elemento de resultado existe
                                    let resultadoAlterarPlano = document.getElementById('resultadoAlterarPlano');
                                    if (!resultadoAlterarPlano) {
                                        resultadoAlterarPlano = document.createElement('div');
                                        resultadoAlterarPlano.id = 'resultadoAlterarPlano';
                                        if (alterarPlanoBtn && alterarPlanoBtn.parentNode) {
                                            alterarPlanoBtn.parentNode.appendChild(resultadoAlterarPlano);
                                        } else {
                                            resultsSection.appendChild(resultadoAlterarPlano);
                                        }
                                    }
                                    alterarPlanoBtn.disabled = true;
                                    alterarPlanoBtn.innerHTML = '<span class="material-icons">hourglass_top</span>Executando...';
                                    // Verificar opção escolhida
                                    const opt = document.querySelector('input[name="recorrenciaOpt"]:checked').value;
                                    const enabledValue = (opt === 'ativar');
                                    const accountId = data.accountId || data.id || data.subscriberId;
                                    // Buscar os dados atuais de recorrência
                                    fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/${accountId}/recurrence`), {
                                        method: 'GET',
                                        headers: { 'Content-Type': 'application/json' }
                                    })
                                    .then(resp => resp.text())
                                    .then(async (text) => {
                                        let respData;
                                        try { respData = text ? JSON.parse(text) : {}; } catch(e) { respData = text; }
                                        if (!respData || typeof respData !== 'object' || Array.isArray(respData)) {
                                            throw new Error('Retorno inesperado da API: ' + text);
                                        }
                                        // Verificar se é ativar ou desativar recorrência
                                        if (opt === 'ativar') {
                                            // Para ativar recorrência, usar rota específica
                                            const msisdn = data.msisdn;
                                            
                                            try {
                                                // 1. Primeiro, chamar /api/Subscription/reactivation/{msisdn} para obter dados do plano
                                                const resp1 = await fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/reactivation/${msisdn}`), {
                                                    method: 'GET',
                                                    headers: { 'Content-Type': 'application/json' }
                                                });
                                                
                                                const data1 = await resp1.json();
                                                
                                                if (data1.error || data1.http_code >= 400) {
                                                    throw new Error(data1.error || data1.message || 'Erro ao consultar dados do plano');
                                                }
                                                
                                                // 2. Extrair dados da resposta
                                                const planName = data1.planName || 'Plano não informado';
                                                const planValue = data1.planValue || 0;
                                                const recurrencePaymentType = data1.recurrencePaymentType || 'Não informado';
                                                
                                                // 3. Mostrar popup elegante com dados do plano
                                                const popupHtml = `
                                                    <div id="popupOverlay" style="position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.55);z-index:9999;display:flex;align-items:center;justify-content:center;">
                                                        <div id="popupConfirmacao" style="background:#fff;border-radius:18px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18);padding:32px;max-width:520px;width:90vw;text-align:center;">
                                                            <div style="font-size:2.5em;color:#10b981;margin-bottom:16px;">
                                                                <span class="material-icons">refresh</span>
                                                            </div>
                                                            <div style="font-size:1.4em;font-weight:700;color:#2563eb;margin-bottom:16px;">
                                                                Confirmar Reativação
                                                            </div>
                                                            
                                                            <!-- Dados do Plano -->
                                                            <div style="background:#f8fafc;border-radius:12px;padding:20px;margin-bottom:24px;border:1px solid #e2e8f0;">
                                                                <div style="font-weight:600;color:#2563eb;margin-bottom:12px;font-size:1.1em;">Dados do Plano</div>
                                                                <div style="display:flex;flex-direction:column;gap:8px;text-align:left;">
                                                                    <div style="display:flex;justify-content:space-between;">
                                                                        <span style="color:#64748b;font-weight:500;">Nome do Plano:</span>
                                                                        <span style="color:#222;font-weight:600;">${planName}</span>
                                                                    </div>
                                                                    <div style="display:flex;justify-content:space-between;">
                                                                        <span style="color:#64748b;font-weight:500;">Valor:</span>
                                                                        <span style="color:#10b981;font-weight:600;">R$ ${(planValue / 100).toFixed(2)}</span>
                                                                    </div>
                                                                    <div style="display:flex;justify-content:space-between;">
                                                                        <span style="color:#64748b;font-weight:500;">Tipo de Pagamento:</span>
                                                                        <span style="color:#222;font-weight:600;">${recurrencePaymentType}</span>
                                                                    </div>
                                                                    <div style="display:flex;justify-content:space-between;">
                                                                        <span style="color:#64748b;font-weight:500;">Número:</span>
                                                                        <span style="color:#222;font-weight:600;">${msisdn}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            
                                                            <div style="color:#64748b;font-size:1.05em;margin-bottom:24px;line-height:1.5;">
                                                                Deseja confirmar a reativação da recorrência com estes dados?
                                                            </div>
                                                            
                                                            <div style="display:flex;gap:12px;justify-content:center;">
                                                                <button id="btnCancelarReativacao" style="background:#f1f5f9;color:#64748b;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                                                                    Cancelar
                                                                </button>
                                                                <button id="btnConfirmarReativacao" style="background:linear-gradient(90deg,#10b981 0%,#2563eb 100%);color:#fff;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                                                                    Confirmar
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                `;
                                                
                                                // Adicionar popup ao body
                                                const popupDiv = document.createElement('div');
                                                popupDiv.innerHTML = popupHtml;
                                                document.body.appendChild(popupDiv);
                                                
                                                // Event listeners para os botões
                                                document.getElementById('btnCancelarReativacao').onclick = () => {
                                                    document.getElementById('popupOverlay').remove();
                                                    alterarPlanoBtn.disabled = false;
                                                    alterarPlanoBtn.innerHTML = '<span class="material-icons">swap_horiz</span>Executar';
                                                };
                                                
                                                document.getElementById('btnConfirmarReativacao').onclick = async () => {
                                                    // Desabilitar botões durante o processo
                                                    document.getElementById('btnConfirmarReativacao').disabled = true;
                                                    document.getElementById('btnConfirmarReativacao').innerHTML = '<span class="material-icons">hourglass_top</span>Processando...';
                                                    
                                                    try {
                                                        // 4. Chamar /api/Subscription/reactivation para confirmar reativação
                                                        const resp2 = await fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Subscription/reactivation'), {
                                                            method: 'POST',
                                                            headers: { 'Content-Type': 'application/json' },
                                                            body: JSON.stringify({
                                                                msisdn: msisdn,
                                                                recurrencePaymentType: recurrencePaymentType
                                                            })
                                                        });
                                                        
                                                        const data2 = await resp2.json();
                                                        
                                                        // Debug: mostrar resposta completa
                                                        console.log('Resposta da API de reativação:', data2);
                                                        
                                                        if (data2.error || data2.http_code >= 400) {
                                                            throw new Error(data2.error || data2.message || 'Erro ao confirmar reativação');
                                                        }
                                                        
                                                        // 5. Verificar se a operação foi bem-sucedida
                                                        if (data2.success && data2.http_code === 204) {
                                                            // Operação bem-sucedida, mas sem cartId
                                                            // Vamos mostrar sucesso e parar aqui
                                                            resultadoAlterarPlano.innerHTML = `
                                                                <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #10b98122;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:12px;">
                                                                    <span class="material-icons" style="font-size:2.5em;color:#10b981;">check_circle</span>
                                                                    <div style="font-weight:700;color:#10b981;font-size:1.15em;">Reativação Concluída!</div>
                                                                    <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                        A recorrência foi reativada com sucesso!<br><br>
                                                                        <div style="background:#f8fafc;border-radius:8px;padding:16px;margin:8px 0;text-align:left;">
                                                                            <b>Detalhes da Operação:</b><br>
                                                                            <b>Status:</b> ${data2.message || 'Processado com sucesso'}<br>
                                                                            <b>HTTP Code:</b> ${data2.http_code}<br>
                                                                            <b>MSISDN:</b> ${msisdn}<br>
                                                                            <b>Resultado:</b> Operação concluída sem necessidade de carrinho
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            `;
                                                            
                                                            // Fechar popup
                                                            document.getElementById('popupOverlay').remove();
                                                            return;
                                                        }
                                                        
                                                        // Se chegou até aqui, tentar extrair cartId (para compatibilidade)
                                                        const cartId = data2.cartId;
                                                        if (!cartId) {
                                                            // Se não tem cartId mas a operação foi bem-sucedida, mostrar sucesso
                                                            if (data2.success) {
                                                                resultadoAlterarPlano.innerHTML = `
                                                                    <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #10b98122;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:12px;">
                                                                        <span class="material-icons" style="font-size:2.5em;color:#10b981;">check_circle</span>
                                                                        <div style="font-weight:700;color:#10b981;font-size:1.15em;">Reativação Concluída!</div>
                                                                        <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                            A recorrência foi reativada com sucesso!<br><br>
                                                                            <div style="background:#f8fafc;border-radius:8px;padding:16px;margin:8px 0;text-align:left;">
                                                                                <b>Detalhes da Operação:</b><br>
                                                                                <b>Status:</b> ${data2.message || 'Processado com sucesso'}<br>
                                                                                <b>HTTP Code:</b> ${data2.http_code || 'N/A'}<br>
                                                                                <b>MSISDN:</b> ${msisdn}<br>
                                                                                <b>Resultado:</b> Operação concluída
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                `;
                                                                
                                                                // Fechar popup
                                                                document.getElementById('popupOverlay').remove();
                                                                return;
                                                            }
                                                            throw new Error('CartId não encontrado na resposta');
                                                        }
                                                        
                                                        // 6. Chamar automaticamente /api/Cart/subscription/{cartId}/billetCombo
                                                        const resp3 = await fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Cart/subscription/${cartId}/billetCombo`), {
                                                            method: 'POST',
                                                            headers: { 'Content-Type': 'application/json' }
                                                        });
                                                        
                                                        const data3 = await resp3.json();
                                                        
                                                        if (data3.error || data3.http_code >= 400) {
                                                            throw new Error(data3.error || data3.message || 'Erro ao processar carrinho');
                                                        }
                                                        
                                                        // Sucesso! Mostrar resultado
                                                        resultadoAlterarPlano.innerHTML = `
                                                            <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #10b98122;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:12px;">
                                                                <span class="material-icons" style="font-size:2.5em;color:#10b981;">check_circle</span>
                                                                <div style="font-weight:700;color:#10b981;font-size:1.15em;">Reativação Concluída!</div>
                                                                <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                    A recorrência foi reativada com sucesso!<br><br>
                                                                    <div style="background:#f8fafc;border-radius:8px;padding:16px;margin:8px 0;text-align:left;">
                                                                        <b>Detalhes da Operação:</b><br>
                                                                        <b>CartId:</b> ${cartId}<br>
                                                                        <b>ClientId:</b> ${data2.clientId || 'N/A'}<br>
                                                                        <b>PlanId:</b> ${data2.planId || 'N/A'}<br>
                                                                        <b>MSISDN:</b> ${data2.msisdn || msisdn}<br>
                                                                        <b>Status:</b> Processado com sucesso
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        `;
                                                        
                                                        // Fechar popup
                                                        document.getElementById('popupOverlay').remove();
                                                        
                                                    } catch (error) {
                                                        // Erro - mostrar mensagem
                                                        resultadoAlterarPlano.innerHTML = `
                                                            <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #b91c1c22;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:12px;">
                                                                <span class="material-icons" style="font-size:2.5em;color:#b91c1c;">error</span>
                                                                <div style="font-weight:700;color:#b91c1c;font-size:1.15em;">Erro na Reativação</div>
                                                                <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                    ${error.message}
                                                                </div>
                                                            </div>
                                                        `;
                                                        
                                                        // Fechar popup
                                                        document.getElementById('popupOverlay').remove();
                                                    }
                                                    
                                                    // Reabilitar botão principal
                                                    alterarPlanoBtn.disabled = false;
                                                    alterarPlanoBtn.innerHTML = '<span class="material-icons">swap_horiz</span>Executar';
                                                };
                                                
                                                return 'Popup de confirmação exibido. Aguarde a confirmação do usuário.';
                                                
                                            } catch (error) {
                                                // Erro na consulta inicial
                                                resultadoAlterarPlano.innerHTML = `
                                                    <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #b91c1c22;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:12px;">
                                                        <span class="material-icons" style="font-size:2.5em;color:#b91c1c;">error</span>
                                                        <div style="font-weight:700;color:#b91c1c;font-size:1.15em;">Erro na Consulta</div>
                                                        <div style="color:#222;font-size:1.05em;text-align:center;">
                                                            ${error.message}
                                                        </div>
                                                    </div>
                                                `;
                                                
                                                alterarPlanoBtn.disabled = false;
                                                alterarPlanoBtn.innerHTML = '<span class="material-icons">swap_horiz</span>Executar';
                                                
                                                return 'Erro na consulta inicial';
                                            }
                                            
                                        } else {
                                            // Para desativar recorrência, usar método original
                                            const putBody = {
                                                enabled: false,
                                                recurrenceType: 'BILLET'
                                            };
                                            
                                            // Função para tentar métodos em sequência
                                            const tentarMetodos = async () => {
                                                const metodos = ['PUT', 'PATCH', 'POST'];
                                                let resultado = '';
                                                
                                                // Mostrar informações de debug de forma elegante
                                                const debugInfo = `
                                                    <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #e11d4822;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:16px;">
                                                        <div style="display:flex;align-items:center;gap:12px;">
                                                            <span class="material-icons" style="font-size:2.2em;color:#e11d48;">block</span>
                                                            <div style="font-weight:700;color:#e11d48;font-size:1.2em;">Desativando Recorrência</div>
                                                        </div>
                                                        
                                                        <!-- Informações da Operação -->
                                                        <div style="background:#fef2f2;border:1px solid #fecaca;border-radius:12px;padding:18px;width:100%;margin-bottom:8px;">
                                                            <div style="font-weight:600;color:#dc2626;margin-bottom:12px;font-size:1.05em;display:flex;align-items:center;gap:8px;">
                                                                <span class="material-icons" style="font-size:1.1em;">info</span>
                                                                Detalhes da Operação
                                                            </div>
                                                            <div style="display:flex;flex-direction:column;gap:8px;font-size:0.98em;">
                                                                <div style="display:flex;justify-content:space-between;">
                                                                    <span style="color:#7f1d1d;font-weight:500;">URL da API:</span>
                                                                    <span style="color:#dc2626;font-family:monospace;font-size:0.9em;">/api/Subscription/${accountId}/recurrence</span>
                                                                </div>
                                                                <div style="display:flex;justify-content:space-between;">
                                                                    <span style="color:#7f1d1d;font-weight:500;">Account ID:</span>
                                                                    <span style="color:#dc2626;font-family:monospace;font-size:0.9em;">${accountId}</span>
                                                                </div>
                                                                <div style="display:flex;justify-content:space-between;">
                                                                    <span style="color:#7f1d1d;font-weight:500;">Payload:</span>
                                                                    <span style="color:#dc2626;font-family:monospace;font-size:0.9em;">enabled: false, recurrenceType: "BILLET"</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!-- Status da Operação -->
                                                        <div style="background:#f0f9ff;border:1px solid #bae6fd;border-radius:12px;padding:16px;width:100%;margin-bottom:8px;">
                                                            <div style="font-weight:600;color:#0369a1;margin-bottom:10px;font-size:1.05em;display:flex;align-items:center;gap:8px;">
                                                                <span class="material-icons" style="font-size:1.1em;">sync</span>
                                                                Status da Operação
                                                            </div>
                                                            <div id="statusOperacao" style="color:#0c4a6e;font-size:0.98em;">
                                                                Iniciando tentativas de desativação...
                                                            </div>
                                                        </div>
                                                        
                                                        <!-- Resultados das Tentativas -->
                                                        <div id="resultadosTentativas" style="width:100%;">
                                                            <!-- Resultados serão inseridos aqui -->
                                                        </div>
                                                    </div>
                                                `;
                                                
                                                // Adicionar o debug elegante ao resultado
                                                resultado += debugInfo;
                                                
                                                // Atualizar o HTML inicial
                                                resultadoAlterarPlano.innerHTML = resultado;
                                                
                                                // Array para armazenar resultados das tentativas
                                                const resultados = [];
                                                
                                                for (let i = 0; i < metodos.length; i++) {
                                                    const metodo = metodos[i];
                                                    
                                                    // Atualizar status
                                                    document.getElementById('statusOperacao').innerHTML = `
                                                        <span style="color:#0369a1;font-weight:600;">Tentando método <b>${metodo}</b>...</span>
                                                    `;
                                                    
                                                    try {
                                                        let resp = await fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Subscription/${accountId}/recurrence`), {
                                                            method: metodo,
                                                            headers: { 'Content-Type': 'application/json', 'accept': '*/*' },
                                                            body: JSON.stringify(putBody)
                                                        });
                                                        let text = await resp.text();
                                                        let obj;
                                                        try { obj = text ? JSON.parse(text) : {}; } catch(e) { obj = text; }
                                                        
                                                        // Criar resultado elegante para esta tentativa
                                                        const resultadoTentativa = `
                                                            <div style="background:${obj && obj.http_code === 405 ? '#fef3c7' : '#dcfce7'};border:1px solid ${obj && obj.http_code === 405 ? '#fbbf24' : '#22c55e'};border-radius:10px;padding:16px;margin-bottom:12px;">
                                                                <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
                                                                    <div style="display:flex;align-items:center;gap:8px;">
                                                                        <span class="material-icons" style="font-size:1.2em;color:${obj && obj.http_code === 405 ? '#f59e0b' : '#16a34a'};">
                                                                            ${obj && obj.http_code === 405 ? 'warning' : 'check_circle'}
                                                                        </span>
                                                                        <span style="font-weight:600;color:${obj && obj.http_code === 405 ? '#92400e' : '#166534'};font-size:1.05em;">
                                                                            Método ${metodo}
                                                                        </span>
                                                                    </div>
                                                                    <span style="background:${obj && obj.http_code === 405 ? '#fef3c7' : '#dcfce7'};color:${obj && obj.http_code === 405 ? '#92400e' : '#166534'};padding:4px 8px;border-radius:6px;font-size:0.85em;font-weight:600;border:1px solid ${obj && obj.http_code === 405 ? '#fbbf24' : '#22c55e'};">
                                                                        ${obj && obj.http_code === 405 ? 'Não Suportado' : 'Sucesso'}
                                                                    </span>
                                                                </div>
                                                                <div style="background:#fff;border-radius:8px;padding:12px;font-family:monospace;font-size:0.9em;color:#374151;max-height:120px;overflow-y:auto;">
                                                                    ${typeof obj === 'object' ? JSON.stringify(obj, null, 2) : obj}
                                                                </div>
                                                            </div>
                                                        `;
                                                        
                                                        resultados.push(resultadoTentativa);
                                                        
                                                        // Atualizar resultados em tempo real
                                                        document.getElementById('resultadosTentativas').innerHTML = resultados.join('');
                                                        
                                                        // Se não for 405, parar as tentativas
                                                        if (!(obj && obj.http_code === 405)) {
                                                            // Atualizar status para sucesso
                                                            document.getElementById('statusOperacao').innerHTML = `
                                                                <span style="color:#16a34a;font-weight:600;">
                                                                    <span class="material-icons" style="font-size:1.1em;vertical-align:middle;">check_circle</span>
                                                                    Desativação concluída com sucesso usando método ${metodo}!
                                                                </span>
                                                            `;
                                                            
                                                            // Ocultar detalhes da operação e mostrar apenas sucesso
                                                            setTimeout(() => {
                                                                resultadoAlterarPlano.innerHTML = `
                                                                    <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #10b98122;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:16px;">
                                                                        <span class="material-icons" style="font-size:2.5em;color:#10b981;">check_circle</span>
                                                                        <div style="font-weight:700;color:#10b981;font-size:1.2em;">Recorrência Desativada!</div>
                                                                        <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                            A recorrência foi desativada com sucesso!<br><br>
                                                                            <div style="background:#f8fafc;border-radius:8px;padding:16px;margin:8px 0;text-align:left;">
                                                                                <b>Detalhes da Operação:</b><br>
                                                                                <b>Método Utilizado:</b> ${metodo}<br>
                                                                                <b>Status:</b> ${obj.message || 'Processado com sucesso'}<br>
                                                                                <b>HTTP Code:</b> ${obj.http_code}<br>
                                                                                <b>Resultado:</b> Operação concluída com sucesso
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <!-- Botão para alterar plano -->
                                                                        <button id="btnAlterarPlano" style="background:linear-gradient(90deg,#2563eb 0%,#7c3aed 100%);color:#fff;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;margin-top:16px;">
                                                                            <span class="material-icons" style="margin-right:8px;">swap_horiz</span>
                                                                            Alterar Plano do Cliente
                                                                        </button>
                                                                    </div>
                                                                `;
                                                                
                                                                // Adicionar event listener para o botão de alterar plano
                                                                document.getElementById('btnAlterarPlano').onclick = async () => {
                                                                    // Capturar MSISDN do formulário e formatar corretamente
                                                                    let msisdn = document.getElementById('linhaInput').value;
                                                                    
                                                                    if (!msisdn) {
                                                                        alert('Número da linha não encontrado. Por favor, consulte a linha primeiro.');
                                                                        return;
                                                                    }
                                                                    
                                                                    // Formatar MSISDN: remover caracteres não numéricos e adicionar prefixo 55 se necessário
                                                                    msisdn = msisdn.replace(/\D/g, ''); // Remove caracteres não numéricos
                                                                    
                                                                    if (msisdn.length === 11) {
                                                                        // Se tem 11 dígitos, adicionar prefixo 55
                                                                        msisdn = '55' + msisdn;
                                                                    } else if (msisdn.length === 13 && msisdn.startsWith('55')) {
                                                                        // Se já tem 13 dígitos com prefixo 55, manter
                                                                        msisdn = msisdn;
                                                                    } else if (msisdn.length !== 13) {
                                                                        alert('Número da linha deve ter 11 dígitos (ex: 11999999999) ou 13 dígitos com prefixo 55.');
                                                                        return;
                                                                    }
                                                                    
                                                                    console.log('📱 MSISDN original:', document.getElementById('linhaInput').value);
                                                                    console.log('📱 MSISDN formatado:', msisdn);
                                                                    
                                                                    // Mostrar popup de alteração de plano
                                                                    const popupAlterarPlano = `
                                                                        <div id="popupOverlayAlterarPlano" style="position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.55);z-index:9999;display:flex;align-items:center;justify-content:center;">
                                                                            <div id="popupAlterarPlano" style="background:#fff;border-radius:18px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18);padding:32px;max-width:600px;width:90vw;text-align:center;">
                                                                                <div style="font-size:2.5em;color:#2563eb;margin-bottom:16px;">
                                                                                    <span class="material-icons">swap_horiz</span>
                                                                                </div>
                                                                                <div style="font-size:1.4em;font-weight:700;color:#2563eb;margin-bottom:16px;">
                                                                                    Alterar Plano do Cliente
                                                                                </div>
                                                                                
                                                                                <div style="color:#64748b;font-size:1.05em;margin-bottom:24px;line-height:1.5;">
                                                                                    Deseja alterar o plano do cliente ${msisdn}?
                                                                                </div>
                                                                                
                                                                                <div style="display:flex;gap:12px;justify-content:center;">
                                                                                    <button id="btnCancelarAlterarPlano" style="background:#f1f5f9;color:#64748b;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                                                                                        Cancelar
                                                                                    </button>
                                                                                    <button id="btnConfirmarAlterarPlano" style="background:linear-gradient(90deg,#10b981 0%,#2563eb 100%);color:#fff;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                                                                                        Alterar Plano
                                                                                    </button>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    `;
                                                                    
                                                                    const popupDiv = document.createElement('div');
                                                                    popupDiv.innerHTML = popupAlterarPlano;
                                                                    document.body.appendChild(popupDiv);
                                                                    
                                                                    // Event listeners para os botões
                                                                    document.getElementById('btnCancelarAlterarPlano').onclick = () => {
                                                                        document.getElementById('popupOverlayAlterarPlano').remove();
                                                                    };
                                                                    
                                                                    document.getElementById('btnConfirmarAlterarPlano').onclick = async () => {
                                                                        // Desabilitar botões durante o processo
                                                                        document.getElementById('btnConfirmarAlterarPlano').disabled = true;
                                                                        document.getElementById('btnConfirmarAlterarPlano').innerHTML = '<span class="material-icons">hourglass_top</span>Carregando...';
                                                                        
                                                                        try {
                                                                            // 1. Chamar /api/Plan/Recharge para obter planos disponíveis
                                                                            // Tentar diferentes métodos HTTP para encontrar o correto
                                                                            const metodos = ['GET', 'POST', 'PUT', 'PATCH'];
                                                                            let respPlanos, dataPlanos;
                                                                            let metodoSucesso = null;
                                                                            
                                                                            console.log('🔍 Iniciando tentativas para API /api/Plan/Recharge...');
                                                                            console.log('📱 MSISDN:', msisdn);
                                                                            console.log('🏷️ Type:', 'Pos');
                                                                            
                                                                            for (let i = 0; i < metodos.length; i++) {
                                                                                const metodo = metodos[i];
                                                                                
                                                                                try {
                                                                                    console.log(`🔄 Tentativa ${i + 1}: Método ${metodo}`);
                                                                                    
                                                                                    if (metodo === 'GET') {
                                                                                        // Para GET, enviar parâmetros na URL conforme exemplo da API
                                                                                        const params = new URLSearchParams({
                                                                                            Msisdn: msisdn,  // Maiúsculo conforme API
                                                                                            Type: 'Pos'      // Maiúsculo e valor correto
                                                                                        });
                                                                                        const url = `proxy-chip.php?rota=${encodeURIComponent(`/api/Plan/Recharge?${params}`)}`;
                                                                                        console.log(`🌐 URL GET:`, url);
                                                                                        
                                                                                        respPlanos = await fetch(url, {
                                                                                            method: 'GET',
                                                                                            headers: { 'accept': 'application/json' }  // Header correto da API
                                                                                        });
                                                                                    } else {
                                                                                        // Para outros métodos, enviar no body
                                                                                        const url = `proxy-chip.php?rota=${encodeURIComponent('/api/Plan/Recharge')}`;
                                                                                        const body = JSON.stringify({
                                                                                            Msisdn: msisdn,  // Maiúsculo conforme API
                                                                                            Type: 'Pos'      // Maiúsculo e valor correto
                                                                                        });
                                                                                        
                                                                                        console.log(`🌐 URL ${metodo}:`, url);
                                                                                        console.log(`📦 Body:`, body);
                                                                                        
                                                                                        respPlanos = await fetch(url, {
                                                                                            method: metodo,
                                                                                            headers: { 'Content-Type': 'application/json' },
                                                                                            body: body
                                                                                        });
                                                                                    }
                                                                                    
                                                                                    console.log(`📡 Resposta ${metodo}:`, respPlanos.status, respPlanos.statusText);
                                                                                    
                                                                                    const text = await respPlanos.text();
                                                                                    console.log(`📄 Resposta bruta:`, text);
                                                                                    
                                                                                    try {
                                                                                        dataPlanos = JSON.parse(text);
                                                                                        console.log(`📊 Dados parseados:`, dataPlanos);
                                                                                    } catch (parseError) {
                                                                                        console.log(`❌ Erro ao fazer parse JSON:`, parseError);
                                                                                        dataPlanos = { error: 'Resposta não é JSON válido', raw: text };
                                                                                    }
                                                                                    
                                                                                    // Verificar se é erro 405
                                                                                    if (dataPlanos.error && dataPlanos.http_code === 405) {
                                                                                        console.log(`⚠️ Método ${metodo} retornou 405, tentando próximo...`);
                                                                                        continue;
                                                                                    }
                                                                                    
                                                                                    // Se chegou até aqui, método funcionou
                                                                                    metodoSucesso = metodo;
                                                                                    console.log(`✅ Método ${metodo} funcionou!`);
                                                                                    break;
                                                                                    
                                                                                } catch (error) {
                                                                                    console.log(`❌ Erro com método ${metodo}:`, error);
                                                                                    continue;
                                                                                }
                                                                            }
                                                                            
                                                                            // Verificar se algum método funcionou
                                                                            if (!metodoSucesso) {
                                                                                throw new Error(`Todos os métodos HTTP (${metodos.join(', ')}) retornaram erro 405. A API pode não estar implementada ou aceitar apenas métodos diferentes.`);
                                                                            }
                                                                            
                                                                            console.log(`🎯 Método de sucesso: ${metodoSucesso}`);
                                                                            
                                                                            // Verificar se há erro na resposta final
                                                                            if (dataPlanos.error && dataPlanos.http_code >= 400) {
                                                                                throw new Error(`Erro ${dataPlanos.http_code}: ${dataPlanos.error || dataPlanos.message || 'Erro desconhecido'}`);
                                                                            }
                                                                            
                                                                            // 2. Mostrar dropdown com planos disponíveis
                                                                            
                                                                            // Logs para debugging dos dados dos planos
                                                                            console.log('📊 Dados dos planos recebidos:', dataPlanos);
                                                                            console.log('📊 Tipo dos dados:', typeof dataPlanos);
                                                                            console.log('📊 É array?', Array.isArray(dataPlanos));
                                                                            if (Array.isArray(dataPlanos)) {
                                                                                console.log('📊 Quantidade de planos:', dataPlanos.length);
                                                                                
                                                                                // Log detalhado dos primeiros 3 planos para não sobrecarregar o console
                                                                                const planosParaLog = dataPlanos.slice(0, 3);
                                                                                planosParaLog.forEach((plano, index) => {
                                                                                    console.log(`📊 Plano ${index + 1}:`, plano);
                                                                                    console.log(`📊 Plano ${index + 1} - id:`, plano.id);
                                                                                    console.log(`📊 Plano ${index + 1} - planId:`, plano.planId);
                                                                                    console.log(`📊 Plano ${index + 1} - name:`, plano.name);
                                                                                    console.log(`📊 Plano ${index + 1} - planName:`, plano.planName);
                                                                                    
                                                                                    // Log de TODOS os campos disponíveis no primeiro plano
                                                                                    if (index === 0) {
                                                                                        console.log('🔍 TODOS os campos disponíveis no primeiro plano:');
                                                                                        Object.keys(plano).forEach(key => {
                                                                                            console.log(`  - ${key}:`, plano[key]);
                                                                                        });
                                                                                    }
                                                                                });
                                                                                
                                                                                if (dataPlanos.length > 3) {
                                                                                    console.log(`📊 ... e mais ${dataPlanos.length - 3} planos`);
                                                                                }
                                                                            }
                                                                            
                                                                            const popupPlanos = `
                                                                                <div id="popupOverlayPlanos" style="position:fixed;top:0;left:0;width:100vw;height:100vh;background:rgba(30,41,59,0.55);z-index:9999;display:flex;align-items:center;justify-content:center;">
                                                                                    <div id="popupPlanos" style="background:#fff;border-radius:18px;box-shadow:0 8px 40px 0 rgba(37,99,235,0.18);padding:32px;max-width:600px;width:90vw;text-align:center;">
                                                                                        <div style="font-size:2.5em;color:#10b981;margin-bottom:16px;">
                                                                                            <span class="material-icons">list</span>
                                                                                        </div>
                                                                                        <div style="font-size:1.4em;font-weight:700;color:#10b981;margin-bottom:16px;">
                                                                                            Escolher Novo Plano
                                                                                        </div>
                                                                                        
                                                                                        <div style="color:#64748b;font-size:1.05em;margin-bottom:24px;line-height:1.5;">
                                                                                            Selecione o novo plano para o cliente ${msisdn}:
                                                                                        </div>
                                                                                        
                                                                                        <div style="margin-bottom:24px;">
                                                                                            <select id="selectPlano" style="width:100%;padding:12px;border:2px solid #e2e8f0;border-radius:10px;font-size:1.05em;background:#fff;">
                                                                                                <option value="">Selecione um plano...</option>
                                                                                                ${(() => {
                                                                                                    // Mapeamento robusto dos planos com logs
                                                                                                    if (!Array.isArray(dataPlanos)) {
                                                                                                        console.error('❌ dataPlanos não é um array:', dataPlanos);
                                                                                                        return '<option value="">Erro: Dados dos planos inválidos</option>';
                                                                                                    }
                                                                                                    
                                                                                                    if (dataPlanos.length === 0) {
                                                                                                        console.warn('⚠️ Nenhum plano disponível');
                                                                                                        return '<option value="">Nenhum plano disponível</option>';
                                                                                                    }
                                                                                                    
                                                                                                    console.log('🔄 Mapeando planos para dropdown...');
                                                                                                    const options = dataPlanos.map((plano, index) => {
                                                                                                        // Tentar diferentes campos para id - incluindo idPlanExternal
                                                                                                        const planId = plano.id || plano.planId || plano.Id || plano.PlanId || plano.uuid || plano.UUID || 
                                                                                                                     plano.plan_id || plano.planId || plano.planid || plano.PLANID || plano.PlanID ||
                                                                                                                     plano.guid || plano.GUID || plano.Guid || plano.planGuid || plano.plan_guid ||
                                                                                                                     plano.idPlanExternal || plano.idPlanExternal || plano.idplanexternal || plano.IDPLANEXTERNAL;
                                                                                                        
                                                                                                        const planName = plano.name || plano.planName || plano.Name || plano.PlanName || plano.title || plano.Title ||
                                                                                                                       plano.plan_name || plano.planName || plano.planname || plano.PLANNAME || plano.PlanName ||
                                                                                                                       plano.description || plano.Description || plano.desc || plano.Desc ||
                                                                                                                       plano.label || plano.Label;
                                                                                                        
                                                                                                        const planValue = plano.value || plano.planValue || plano.Value || plano.PlanValue || plano.price || plano.Price ||
                                                                                                                        plano.plan_value || plano.planValue || plano.planvalue || plano.PLANVALUE || plano.PlanValue ||
                                                                                                                        plano.cost || plano.Cost || plano.amount || plano.Amount || 0;
                                                                                                        
                                                                                                        console.log(`🔄 Plano ${index + 1} mapeado:`, {
                                                                                                            planId,
                                                                                                            planName,
                                                                                                            planValue,
                                                                                                            original: plano
                                                                                                        });
                                                                                                        
                                                                                                        if (!planId) {
                                                                                                            console.error(`❌ Plano ${index + 1} sem ID válido:`, plano);
                                                                                                            return `<option value="" disabled>Erro: Plano sem ID</option>`;
                                                                                                        }
                                                                                                        
                                                                                                        return `<option value="${planId}" data-nome="${planName}" data-valor="${planValue}">
                                                                                                            ${planName || 'Plano sem nome'} - R$ ${((planValue || 0) / 100).toFixed(2)}
                                                                                                        </option>`;
                                                                                                    });
                                                                                                    
                                                                                                    console.log('✅ Opções do dropdown criadas:', options);
                                                                                                    return options.join('');
                                                                                                })()}
                                                                                            </select>
                                                                                        </div>
                                                                                        
                                                                                        <div style="display:flex;gap:12px;justify-content:center;">
                                                                                            <button id="btnCancelarPlanos" style="background:#f1f5f9;color:#64748b;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                                                                                                Cancelar
                                                                                            </button>
                                                                                            <button id="btnConfirmarTroca" style="background:linear-gradient(90deg,#10b981 0%,#2563eb 100%);color:#fff;padding:12px 24px;border-radius:10px;font-weight:600;border:none;cursor:pointer;font-size:1.05em;">
                                                                                                Confirmar Troca
                                                                                            </button>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            `;
                                                                            
                                                                            // Fechar popup anterior
                                                                            document.getElementById('popupOverlayAlterarPlano').remove();
                                                                            
                                                                            // Mostrar popup de planos
                                                                            const popupPlanosDiv = document.createElement('div');
                                                                            popupPlanosDiv.innerHTML = popupPlanos;
                                                                            document.body.appendChild(popupPlanosDiv);
                                                                            
                                                                            // Event listeners para os botões
                                                                            document.getElementById('btnCancelarPlanos').onclick = () => {
                                                                                document.getElementById('popupOverlayPlanos').remove();
                                                                            };
                                                                            
                                                                            document.getElementById('btnConfirmarTroca').onclick = async () => {
                                                                                const planId = document.getElementById('selectPlano').value;
                                                                                
                                                                                console.log('🔍 PlanId capturado do dropdown:', planId);
                                                                                console.log('🔍 Tipo do planId:', typeof planId);
                                                                                
                                                                                if (!planId) {
                                                                                    alert('Por favor, selecione um plano.');
                                                                                    return;
                                                                                }
                                                                                
                                                                                // Validar se o planId é um GUID válido
                                                                                const guidRegex = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
                                                                                if (!guidRegex.test(planId)) {
                                                                                    console.error('❌ PlanId inválido:', planId);
                                                                                    alert('PlanId inválido. Por favor, selecione um plano válido.');
                                                                                    return;
                                                                                }
                                                                                
                                                                                console.log('✅ PlanId válido:', planId);
                                                                                
                                                                                // Desabilitar botão durante o processo
                                                                                document.getElementById('btnConfirmarTroca').disabled = true;
                                                                                document.getElementById('btnConfirmarTroca').innerHTML = '<span class="material-icons">hourglass_top</span>Processando...';
                                                                                
                                                                                try {
                                                                                    // 3. Chamar /api/Cart/recharge para criar carrinho
                                                                                    
                                                                                    // Preparar payload
                                                                                    const payload = {
                                                                                        clientId: (() => {
                                                                                            // Capturar o clientId da seção de dados da linha
                                                                                            const clientIdElement = document.querySelector('[style*="ClientId:"], [style*="clientId:"]');
                                                                                            if (clientIdElement) {
                                                                                                const text = clientIdElement.textContent;
                                                                                                const match = text.match(/ClientId:\s*([^\s]+)/i);
                                                                                                if (match) {
                                                                                                    return match[1];
                                                                                                }
                                                                                            }
                                                                                            // Fallback: usar o accountId se disponível
                                                                                            return accountId || 'N/A';
                                                                                        })(), // Capturar do contexto da página
                                                                                        msisdn: msisdn,
                                                                                        planId: planId,
                                                                                        expiresAt: '', // Deixar vazio para usar padrão do sistema
                                                                                        recurrence: {
                                                                                            paymentType: 'BILLET',
                                                                                            paymentId: 'string'
                                                                                        }
                                                                                    };
                                                                                    
                                                                                    console.log('📦 Payload completo para /api/Cart/recharge:', payload);
                                                                                    console.log('📦 Payload JSON:', JSON.stringify(payload, null, 2));
                                                                                    
                                                                                    const respCart = await fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Cart/recharge'), {
                                                                                        method: 'POST',
                                                                                        headers: { 'Content-Type': 'application/json' },
                                                                                        body: JSON.stringify(payload)
                                                                                    });
                                                                                    
                                                                                    const dataCart = await respCart.json();
                                                                                    
                                                                                    if (dataCart.error || respCart.status >= 400) {
                                                                                        throw new Error(dataCart.error || dataCart.message || 'Erro ao criar carrinho');
                                                                                    }
                                                                                    
                                                                                    const cartId = dataCart.cartId;
                                                                                    
                                                                                    if (!cartId) {
                                                                                        throw new Error('CartId não encontrado na resposta');
                                                                                    }
                                                                                    
                                                                                    // 4. Chamar automaticamente /api/Cart/recharge/{cartId}/BilletCombo
                                                                                    const respBillet = await fetch('proxy-chip.php?rota=' + encodeURIComponent(`/api/Cart/recharge/${cartId}/BilletCombo`), {
                                                                                        method: 'POST',
                                                                                        headers: { 'Content-Type': 'application/json' }
                                                                                    });
                                                                                    
                                                                                    const dataBillet = await respBillet.json();
                                                                                    
                                                                                    if (dataBillet.error || respBillet.status >= 400) {
                                                                                        throw new Error(dataBillet.error || dataBillet.message || 'Erro ao processar boleto');
                                                                                    }
                                                                                    
                                                                                    // Sucesso! Mostrar resultado
                                                                                    document.getElementById('popupOverlayPlanos').remove();
                                                                                    
                                                                                    resultadoAlterarPlano.innerHTML = `
                                                                                        <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #10b98122;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:16px;">
                                                                                            <span class="material-icons" style="font-size:2.5em;color:#10b981;">check_circle</span>
                                                                                            <div style="font-weight:700;color:#10b981;font-size:1.2em;">Plano Alterado com Sucesso!</div>
                                                                                            <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                                                O plano do cliente foi alterado com sucesso!<br><br>
                                                                                                <div style="background:#f8fafc;border-radius:8px;padding:16px;margin:8px 0;text-align:left;">
                                                                                                    <b>Detalhes da Operação:</b><br>
                                                                                                    <b>MSISDN:</b> ${msisdn}<br>
                                                                                                    <b>CartId:</b> ${cartId}<br>
                                                                                                    <b>Status:</b> Processado com sucesso
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    `;
                                                                    
                                                                } catch (error) {
                                                                    // Erro na troca de plano
                                                                    document.getElementById('popupOverlayPlanos').remove();
                                                                    
                                                                    resultadoAlterarPlano.innerHTML = `
                                                                        <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #b91c1c22;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:16px;">
                                                                            <span class="material-icons" style="font-size:2.5em;color:#b91c1c;">error</span>
                                                                            <div style="font-weight:700;color:#b91c1c;font-size:1.15em;">Erro na Alteração do Plano</div>
                                                                            <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                                ${error.message}
                                                                            </div>
                                                                        </div>
                                                                    `;
                                                                }
                                                            };
                                                                            
                                                                        } catch (error) {
                                                                            // Erro ao carregar planos
                                                                            document.getElementById('popupOverlayAlterarPlano').remove();
                                                                            
                                                                            resultadoAlterarPlano.innerHTML = `
                                                                                <div style="background:#fff;border-radius:14px;box-shadow:0 2px 12px #b91c1c22;padding:22px 18px;max-width:520px;margin:0 auto;display:flex;flex-direction:column;align-items:center;gap:16px;">
                                                                                    <span class="material-icons" style="font-size:2.5em;color:#b91c1c;">error</span>
                                                                                    <div style="font-weight:700;color:#b91c1c;font-size:1.15em;">Erro ao Carregar Planos</div>
                                                                                    <div style="color:#222;font-size:1.05em;text-align:center;">
                                                                                        ${error.message}
                                                                                    </div>
                                                                                </div>
                                                                            `;
                                                                        }
                                                                    };
                                                                    
                                                                };
                                                            }, 1500); // Aguardar 1.5s para mostrar o status de sucesso
                                                            
                                                            break;
                                                        }
                                                        
                                                        // Aguardar um pouco entre tentativas
                                                        await new Promise(resolve => setTimeout(resolve, 500));
                                                        
                                                    } catch (error) {
                                                        // Resultado de erro para esta tentativa
                                                        const resultadoErro = `
                                                            <div style="background:#fef2f2;border:1px solid #fecaca;border-radius:10px;padding:16px;margin-bottom:12px;">
                                                                <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px;">
                                                                    <div style="display:flex;align-items:center;gap:8px;">
                                                                        <span class="material-icons" style="font-size:1.2em;color:#dc2626;">error</span>
                                                                        <span style="font-weight:600;color:#dc2626;font-size:1.05em;">
                                                                            Método ${metodo}
                                                                        </span>
                                                                    </div>
                                                                    <span style="background:#fef2f2;color:#dc2626;padding:4px 8px;border-radius:6px;font-size:0.85em;font-weight:600;border:1px solid #fecaca;">
                                                                        Erro
                                                                    </span>
                                                                </div>
                                                                <div style="background:#fff;border-radius:8px;padding:12px;font-family:monospace;font-size:0.9em;color:#dc2626;max-height:120px;overflow-y:auto;">
                                                                    ${error.message}
                                                                </div>
                                                            </div>
                                                        `;
                                                        
                                                        resultados.push(resultadoErro);
                                                        document.getElementById('resultadosTentativas').innerHTML = resultados.join('');
                                                    }
                                                }
                                                
                                                // Se chegou até aqui sem sucesso, mostrar mensagem final
                                                if (resultados.length === metodos.length && resultados.every(r => r.includes('405'))) {
                                                    document.getElementById('statusOperacao').innerHTML = `
                                                        <span style="color:#dc2626;font-weight:600;">
                                                            <span class="material-icons" style="font-size:1.1em;vertical-align:middle;">error</span>
                                                            Nenhum método suportado para esta operação
                                                        </span>
                                                    `;
                                                }
                                                
                                                return resultado;
                                            };
                                        // Executar tentativas
                                        return tentarMetodos();
                                    }
                                    })
                                    .then(resultado => {
                                        alterarPlanoBtn.disabled = false;
                                        alterarPlanoBtn.innerHTML = '<span class="material-icons">swap_horiz</span>Executar';
                                        // Em todos os lugares, agora pode usar resultadoAlterarPlano.innerHTML sem recriar
                                        resultadoAlterarPlano.innerHTML = resultado;
                                    })
                                    .catch(err => {
                                        alterarPlanoBtn.disabled = false;
                                        alterarPlanoBtn.innerHTML = '<span class="material-icons">swap_horiz</span>Executar';
                                        // Em todos os lugares, agora pode usar resultadoAlterarPlano.innerHTML sem recriar
                                        resultadoAlterarPlano.innerHTML = `<div style='color:#b91c1c;'>Erro ao alterar recorrência: ${err.message}</div>`;
                                    });
                                };
                            }
                        }, 100);
                    }
                    return;
                }
                // Download histórico (não exibe nada aqui, pois já faz download)
                let html = `<div style='background:#fff;border-radius:14px;box-shadow:0 2px 12px #2563eb22;padding:18px 10px;max-width:520px;margin:0 auto;'>`;
                html += `<div style='font-weight:700;color:#2563eb;font-size:1.05em;margin-bottom:10px;display:flex;align-items:center;gap:8px;'><span class='material-icons' style='font-size:1.2em;'>data_usage</span>Resultado da consulta</div>`;
                html += `<pre style='font-size:0.98em;color:#222;background:#f1f5f9;padding:12px 16px;border-radius:8px;overflow-x:auto;'>${JSON.stringify(data, null, 2)}</pre>`;
                html += `</div>`;
                resultsSection.innerHTML = html;
                resultsSection.style.display = 'block';
            })
            .catch(err => {
                errorMessage.textContent = 'Erro ao consultar: ' + err.message;
                errorMessage.style.display = 'block';
                resultsSection.style.display = 'none';
            });
    });
    </script>
</body>
</html>
