<?php
// consultar-subscriber.php
session_start();
$baseUrl = 'https://app.boramvno.com.br/appapi';
if (!isset($_SESSION['bora_email']) || !isset($_SESSION['bora_password'])) {
    header('Location: login.php');
    exit;
}
$email = $_SESSION['bora_email'];
$password = $_SESSION['bora_password'];
$auth = base64_encode("$email:$password");

if (isset($_GET['msisdn'])) {
    $msisdn = preg_replace('/\D/', '', $_GET['msisdn']);
    if (!$msisdn) {
        http_response_code(400);
        echo json_encode(['error' => 'MSISDN não informado.']);
        exit;
    }
    // Autenticação
    $ch = curl_init($baseUrl . '/api/Authentication/basic');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Basic $auth",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, '{}');
    $authResponse = curl_exec($ch);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $header = substr($authResponse, 0, $headerSize);
    $body   = substr($authResponse, $headerSize);
    curl_close($ch);
    $authResult = json_decode($body, true);
    $token = null;
    if (isset($authResult['token'])) {
        $token = $authResult['token'];
    } else if (preg_match('/x-access-token:\s*(.+)/i', $header, $matches)) {
        $token = trim($matches[1]);
    }
    if (!$token) {
        http_response_code(401);
        echo json_encode(['error' => 'Falha ao autenticar na API Boramvno.']);
        exit;
    }
    // Consulta por MSISDN
    $url = $baseUrl . '/api/Subscriber/' . $msisdn . '/msisdn';
    $ch2 = curl_init($url);
    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch2, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $token",
        "Content-Type: application/json"
    ]);
    curl_setopt($ch2, CURLOPT_TIMEOUT, 20);
    $response = curl_exec($ch2);
    $httpCode = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
    $error = curl_error($ch2);
    curl_close($ch2);
    if ($error) {
        http_response_code(500);
        echo json_encode(['error' => 'Erro ao consultar API Boramvno: ' . $error]);
        exit;
    }
    http_response_code($httpCode);
    echo $response ? $response : json_encode(['error' => 'Resposta vazia da API Boramvno']);
    exit;
}
// Consulta padrão por CPF/CNPJ
$document = isset($_GET['document']) ? preg_replace('/\D/', '', $_GET['document']) : '';
if (!$document) {
    http_response_code(400);
    echo json_encode(['error' => 'Documento não informado.']);
    exit;
}
$ch = curl_init($baseUrl . '/api/Authentication/basic');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Basic $auth",
    "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, '{}');
$authResponse = curl_exec($ch);
$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$header = substr($authResponse, 0, $headerSize);
$body   = substr($authResponse, $headerSize);
curl_close($ch);
$authResult = json_decode($body, true);
$token = null;
if (isset($authResult['token'])) {
    $token = $authResult['token'];
} else if (preg_match('/x-access-token:\s*(.+)/i', $header, $matches)) {
    $token = trim($matches[1]);
}
if (!$token) {
    http_response_code(401);
    echo json_encode(['error' => 'Falha ao autenticar na API Boramvno.']);
    exit;
}
$url = $baseUrl . '/api/Subscriber/' . $document . '/document';
$ch2 = curl_init($url);
curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch2, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $token",
    "Content-Type: application/json"
]);
curl_setopt($ch2, CURLOPT_TIMEOUT, 20);
$response = curl_exec($ch2);
$httpCode = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
$error = curl_error($ch2);
curl_close($ch2);
if ($error) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro ao consultar API Boramvno: ' . $error]);
    exit;
}
http_response_code($httpCode);
echo $response ? $response : json_encode(['error' => 'Resposta vazia da API Boramvno']);
