<?php
// Core3Chip - Consulta Avançada de Cliente Boramvno
$currentTime = date('H:i:s');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consultar Cliente - Core3Chip</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body { min-height: 100vh; background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%); display: flex; align-items: center; justify-content: center; font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif; margin: 0; }
        .container { background: rgba(255,255,255,0.97); border-radius: 32px; box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18), 0 1.5px 8px 0 rgba(16,185,129,0.10); padding: 56px 40px 48px 40px; max-width: 520px; width: 100%; display: flex; flex-direction: column; align-items: center; gap: 36px; position: relative; }
        .logo-img { width: 195px; height: 130px; object-fit: contain; object-position: center; margin-bottom: 12px; filter: drop-shadow(0 4px 24px #2563eb33); background: transparent; border-radius: 18px; }
        .search-section { width: 100%; background: #f1f5f9; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-bottom: 10px; }
        .search-title h2 { font-size: 1.3rem; font-weight: 700; color: #2563eb; margin: 0 0 4px 0; }
        .search-title p { font-size: 1rem; color: #64748b; margin: 0 0 18px 0; }
        .search-form { display: flex; flex-direction: column; gap: 14px; }
        .form-group { display: flex; flex-direction: column; gap: 6px; }
        .form-label { font-size: 0.98rem; color: #1e293b; font-weight: 500; }
        .form-input { padding: 12px 14px; border-radius: 8px; border: 1.5px solid #cbd5e1; font-size: 1.08rem; outline: none; transition: border 0.2s; }
        .form-input:focus { border: 1.5px solid #2563eb; }
        .search-btn { padding: 13px 0; border: none; border-radius: 10px; font-size: 1.08rem; font-weight: 600; color: #fff; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10); cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 10px; transition: background 0.2s, transform 0.2s, box-shadow 0.2s; outline: none; letter-spacing: 0.5px; }
        .search-btn .material-icons { font-size: 1.3em; vertical-align: middle; }
        .search-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); transform: translateY(-2px) scale(1.03); box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13); }
        .loading { display: none; align-items: center; flex-direction: column; gap: 10px; margin: 18px 0; }
        .spinner { width: 32px; height: 32px; border: 4px solid #e0e7ef; border-top: 4px solid #2563eb; border-radius: 50%; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .error-message, .success-message { display: none; margin: 10px 0 0 0; padding: 10px 18px; border-radius: 8px; font-size: 1.02rem; font-weight: 500; }
        .error-message { background: #fee2e2; color: #b91c1c; border: 1.5px solid #f87171; }
        .success-message { background: #d1fae5; color: #065f46; border: 1.5px solid #10b981; }
        .results-section { width: 100%; background: #f8fafc; border-radius: 18px; padding: 24px 18px 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); margin-top: 10px; }
        .results-title { font-size: 1.15rem; font-weight: 700; color: #2563eb; margin: 0 0 18px 0; }
        .client-form { width: 100%; }
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 14px 18px; }
        .form-field { display: flex; flex-direction: column; gap: 4px; }
        .field-label { font-size: 0.97rem; color: #1e293b; font-weight: 500; }
        .field-value { padding: 10px 10px; border-radius: 7px; border: 1.2px solid #cbd5e1; font-size: 1.01rem; outline: none; background: #fff; color: #222; transition: border 0.2s; }
        .field-value:focus { border: 1.2px solid #2563eb; }
        .back-btn { position: absolute; top: 18px; left: 18px; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); color: #fff; border: none; border-radius: 8px; padding: 10px 18px; font-size: 1rem; font-weight: 600; display: flex; align-items: center; gap: 8px; box-shadow: 0 2px 8px 0 rgba(37,99,235,0.10); cursor: pointer; transition: background 0.2s, box-shadow 0.2s; z-index: 10; }
        .back-btn .material-icons { font-size: 1.2em; }
        .back-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); box-shadow: 0 6px 18px 0 rgba(16,185,129,0.13); }
        @media (max-width: 700px) { .container { padding: 24px 4px 18px 4px; border-radius: 18px; } .logo-img { width: 130px; height: 91px; } .form-grid { grid-template-columns: 1fr; } .back-btn { top: 8px; left: 8px; padding: 8px 12px; font-size: 0.95rem; } }
    </style>
</head>
<body>
    <div style="position:absolute;top:18px;right:24px;z-index:100;">
        <a href="logout.php" style="background:linear-gradient(90deg,#e11d48 0%,#f87171 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #e11d4811;display:flex;align-items:center;gap:8px;font-size:1.05em;">
            <span class="material-icons" style="font-size:1.2em;">logout</span> Sair
        </a>
    </div>
    <div class="container">
        <button onclick="window.location.href='index.php'" class="back-btn">
            <span class="material-icons">arrow_back</span> Voltar
        </button>
        <header class="header">
            <div class="menu-bar">
                <div class="logo-area">
                    <img src="chip.png" alt="Logo" class="logo-img" />
                </div>
            </div>
        </header>
        <div class="search-section">
            <div class="search-title">
                <h2>🔍 Consultar Cliente Boramvno</h2>
                <p>Digite o CPF ou CNPJ do cliente para consultar na base Boramvno</p>
            </div>
            <form class="search-form" id="searchForm">
                <div class="form-group" style="flex-direction: row; gap: 18px; align-items: center; margin-bottom: 8px;">
                    <label style="font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px;">
                        <input type="radio" name="searchType" id="searchCpf" value="cpf" checked style="accent-color:#2563eb; margin-right:4px;"> CPF/CNPJ
                    </label>
                    <label style="font-weight:600; color:#2563eb; display:flex; align-items:center; gap:4px;">
                        <input type="radio" name="searchType" id="searchPhone" value="phone" style="accent-color:#2563eb; margin-right:4px;"> Telefone
                    </label>
                </div>
                <div class="form-group">
                    <label class="form-label" id="mainInputLabel">CPF ou CNPJ</label>
                    <input type="text" class="form-input" id="documentInput" placeholder="Digite CPF ou CNPJ (máscara automática)" required>
                </div>
                <button type="submit" class="search-btn" id="searchBtn">
                    <span class="material-icons">search</span>
                    Consultar Cliente
                </button>
            </form>
        </div>
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p>Consultando dados do cliente...</p>
        </div>
        <div class="error-message" id="errorMessage"></div>
        <div class="success-message" id="successMessage"></div>
        <div class="results-section" id="resultsSection" style="display:none;">
            <h2 class="results-title">📊 Dados do Cliente Boramvno</h2>
            <div class="client-form">
                <form id="clientForm">
                    <div class="form-grid">
                        <div class="form-field">
                            <label class="field-label">🆔 ID</label>
                            <input class="field-value" id="clientId" name="clientId" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">👤 Nome</label>
                            <input class="field-value" id="clientName" name="clientName" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📄 CPF/CNPJ</label>
                            <input class="field-value" id="clientDocument" name="clientDocument" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📧 Email</label>
                            <input class="field-value" id="clientEmail" name="clientEmail" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📱 Telefone</label>
                            <input class="field-value" id="clientPhone" name="clientPhone" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🎂 Data de Nascimento</label>
                            <input class="field-value" id="clientBirthDate" name="clientBirthDate" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📍 Endereço</label>
                            <input class="field-value" id="clientAddress" name="clientAddress" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🔢 Número</label>
                            <input class="field-value" id="clientNumber" name="clientNumber" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏘️ Bairro</label>
                            <input class="field-value" id="clientNeighborhood" name="clientNeighborhood" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🏙️ Cidade</label>
                            <input class="field-value" id="clientCity" name="clientCity" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">🌍 Estado</label>
                            <input class="field-value" id="clientState" name="clientState" type="text" value="-" />
                        </div>
                        <div class="form-field">
                            <label class="field-label">📮 CEP</label>
                            <input class="field-value" id="clientZipCode" name="clientZipCode" type="text" value="-" />
                        </div>
                    </div>
                    <button type="button" class="search-btn" id="updateBtn" style="margin-top:24px;background:linear-gradient(90deg,#10b981 0%,#2563eb 100%);">
                        <span class="material-icons">save</span>
                        Atualizar Dados
                    </button>
                </form>
            </div>
        </div>
        <button type="button" class="search-btn" id="consultarLinhasBtn" style="margin-top:18px;background:linear-gradient(90deg,#2563eb 0%,#10b981 100%);width:100%;display:flex;align-items:center;justify-content:center;gap:10px;">
            <span class="material-icons">list_alt</span>
            Consultar linhas do cliente
        </button>
        <div id="linhasClienteResult" style="margin-top:18px;"></div>
    </div>
    <script>
    // Máscara CPF/CNPJ igual ao cadastro.php
    function applyCPFMask(value) {
        return value.replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d{1,2})$/, '$1-$2');
    }
    function applyCNPJMask(value) {
        return value.replace(/(\d{2})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1.$2')
            .replace(/(\d{3})(\d)/, '$1/$2')
            .replace(/(\d{4})(\d{1,2})$/, '$1-$2');
    }
    const documentInput = document.getElementById('documentInput');
    const searchCpf = document.getElementById('searchCpf');
    const searchPhone = document.getElementById('searchPhone');
    const mainInputLabel = document.getElementById('mainInputLabel');
    searchCpf.addEventListener('change', function() {
        if (searchCpf.checked) {
            mainInputLabel.textContent = 'CPF ou CNPJ';
            documentInput.value = '';
            documentInput.placeholder = 'Digite CPF ou CNPJ (máscara automática)';
            documentInput.maxLength = 18;
            documentInput.type = 'text';
        }
    });
    searchPhone.addEventListener('change', function() {
        if (searchPhone.checked) {
            mainInputLabel.textContent = 'Telefone (11 dígitos)';
            documentInput.value = '';
            documentInput.placeholder = 'Digite o número (ex: 75999006002)';
            documentInput.maxLength = 11;
            documentInput.type = 'tel';
        }
    });
    documentInput.addEventListener('input', function(e) {
        if (searchCpf.checked) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length <= 11) {
                e.target.value = applyCPFMask(value);
            } else if (value.length <= 14) {
                e.target.value = applyCNPJMask(value);
            } else {
                e.target.value = value;
            }
        } else {
            // Telefone: só números, máximo 11 dígitos
            e.target.value = e.target.value.replace(/\D/g, '').slice(0, 11);
        }
    });
    // Consulta Boramvno
    const searchForm = document.getElementById('searchForm');
    const loading = document.getElementById('loading');
    const errorMessage = document.getElementById('errorMessage');
    const successMessage = document.getElementById('successMessage');
    const resultsSection = document.getElementById('resultsSection');
    searchForm.addEventListener('submit', function(e) {
        e.preventDefault();
        errorMessage.style.display = 'none';
        successMessage.style.display = 'none';
        loading.style.display = 'flex';
        resultsSection.style.display = 'none';
        let url = '';
        let documentValue = documentInput.value.replace(/\D/g, '');
        if (searchCpf.checked) {
            url = 'consultar-subscriber.php?document=' + encodeURIComponent(documentValue);
        } else {
            // Telefone: adiciona 55 automaticamente
            if (documentValue.length !== 11) {
                loading.style.display = 'none';
                errorMessage.textContent = 'Digite um número de telefone válido com 11 dígitos.';
                errorMessage.style.display = 'block';
                return;
            }
            url = 'consultar-subscriber.php?msisdn=55' + encodeURIComponent(documentValue);
        }
        fetch(url)
            .then(async response => {
                const text = await response.text();
                let data;
                try {
                    data = JSON.parse(text);
                } catch (e) {
                    if (text.includes('<form') && text.includes('login')) {
                        window.location.href = 'login.php';
                        return;
                    }
                    errorMessage.textContent = 'Sessão expirada ou erro inesperado. Faça login novamente.';
                    errorMessage.style.display = 'block';
                    loading.style.display = 'none';
                    return;
                }
                return data;
            })
            .then(data => {
                if (!data) return;
                loading.style.display = 'none';
                if (data.error || data.detail) {
                    errorMessage.textContent = 'Erro: ' + (data.detail || data.error);
                    errorMessage.style.display = 'block';
                    return;
                }
                // Preencher campos (mantém igual)
                const cliente = data;
                document.getElementById('clientId').value = cliente.subscriberId || '-';
                document.getElementById('clientName').value = cliente.name || '-';
                document.getElementById('clientDocument').value = cliente.document || '-';
                document.getElementById('clientEmail').value = cliente.email || '-';
                document.getElementById('clientPhone').value = cliente.phone || cliente.msisdn || '-';
                document.getElementById('clientBirthDate').value = cliente.birthDate || '-';
                document.getElementById('clientAddress').value = cliente.street || '-';
                document.getElementById('clientNumber').value = cliente.number || '-';
                document.getElementById('clientNeighborhood').value = cliente.neighborhood || '-';
                document.getElementById('clientCity').value = cliente.city || '-';
                document.getElementById('clientState').value = cliente.uf || '-';
                document.getElementById('clientZipCode').value = cliente.zipcode || '-';
                // Exibir campos extras se existirem
                let extraFields = '';
                if (cliente.msisdn) extraFields += `<div class='form-field'><label class='field-label'>MSISDN</label><input class='field-value' type='text' value='${cliente.msisdn}' readonly></div>`;
                if (cliente.plan) extraFields += `<div class='form-field'><label class='field-label'>Plano</label><input class='field-value' type='text' value='${cliente.plan}' readonly></div>`;
                if (typeof cliente.active !== 'undefined') extraFields += `<div class='form-field'><label class='field-label'>Ativo</label><input class='field-value' type='text' value='${cliente.active ? 'Sim' : 'Não'}' readonly></div>`;
                if (cliente.createdBy) extraFields += `<div class='form-field'><label class='field-label'>Criado por</label><input class='field-value' type='text' value='${cliente.createdBy.name} (${cliente.createdBy.email})' readonly></div>`;
                if (cliente.updatedBy) extraFields += `<div class='form-field'><label class='field-label'>Atualizado por</label><input class='field-value' type='text' value='${cliente.updatedBy.name} (${cliente.updatedBy.email})' readonly></div>`;
                if (cliente.updateDate) extraFields += `<div class='form-field'><label class='field-label'>Data Atualização</label><input class='field-value' type='text' value='${cliente.updateDate}' readonly></div>`;
                if (cliente.creationDate) extraFields += `<div class='form-field'><label class='field-label'>Data Criação</label><input class='field-value' type='text' value='${cliente.creationDate}' readonly></div>`;
                if (cliente.idSubscriberExternal) extraFields += `<div class='form-field'><label class='field-label'>ID Externo</label><input class='field-value' type='text' value='${cliente.idSubscriberExternal}' readonly></div>`;
                // Adiciona campos extras ao final do form
                const formGrid = document.querySelector('.form-grid');
                if (formGrid && extraFields) {
                  formGrid.insertAdjacentHTML('beforeend', extraFields);
                }
                resultsSection.style.display = 'block';
            })
            .catch(err => {
                loading.style.display = 'none';
                errorMessage.textContent = 'Erro ao consultar cliente: ' + err.message;
                errorMessage.style.display = 'block';
            });
    });
    // Atualizar Dados
    const updateBtn = document.getElementById('updateBtn');
    if (updateBtn) {
        updateBtn.addEventListener('click', function() {
            errorMessage.style.display = 'none';
            successMessage.style.display = 'none';
            loading.style.display = 'flex';
            // Coletar dados do form
            const client = {
                id: document.getElementById('clientId').value,
                name: document.getElementById('clientName').value,
                document: document.getElementById('clientDocument').value.replace(/\D/g, ''),
                email: document.getElementById('clientEmail').value,
                phone: document.getElementById('clientPhone').value.replace(/\D/g, ''),
                birthDate: document.getElementById('clientBirthDate').value,
                street: document.getElementById('clientAddress').value,
                number: document.getElementById('clientNumber').value,
                neighborhood: document.getElementById('clientNeighborhood').value,
                city: document.getElementById('clientCity').value,
                uf: document.getElementById('clientState').value,
                zipcode: document.getElementById('clientZipCode').value.replace(/\D/g, ''),
                complement: '',
                reference: ''
            };
            // Validação de GUID
            const guidRegex = /^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/;
            if (!guidRegex.test(client.id)) {
                loading.style.display = 'none';
                errorMessage.textContent = 'ID do cliente inválido. Consulte o cliente antes de atualizar.';
                errorMessage.style.display = 'block';
                return;
            }
            fetch('atualizar-subscriber.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(client)
            })
            .then(async response => {
                let rawText = await response.text();
                console.log('Resposta bruta da API:', JSON.stringify(rawText));
                let data = {};
                try { data = JSON.parse(rawText); } catch (e) {}
                loading.style.display = 'none';
                errorMessage.style.display = 'none'; // limpa erro anterior
                // Verificação robusta para resposta vazia
                const isEmpty =
                    rawText === null ||
                    rawText === undefined ||
                    (typeof rawText === 'string' && (
                        rawText.trim() === '' ||
                        rawText.trim() === '{}' ||
                        rawText.trim() === 'null'
                    ));
                if (response.ok && isEmpty) {
                    successMessage.textContent = 'Dados atualizados com sucesso!';
                    successMessage.style.display = 'block';
                    const popup = document.createElement('div');
                    popup.style.position = 'fixed';
                    popup.style.top = '50%';
                    popup.style.left = '50%';
                    popup.style.transform = 'translate(-50%, -50%)';
                    popup.style.background = '#fff';
                    popup.style.border = '2px solid #10b981';
                    popup.style.borderRadius = '16px';
                    popup.style.boxShadow = '0 8px 32px 0 rgba(37,99,235,0.18)';
                    popup.style.padding = '32px 48px';
                    popup.style.zIndex = '9999';
                    popup.style.textAlign = 'center';
                    popup.innerHTML = `<span class='material-icons' style='color:#10b981;font-size:3em;'>check_circle</span><br><div style='font-size:1.2em;font-weight:600;margin-top:10px;'>Dados atualizados com sucesso!</div>`;
                    document.body.appendChild(popup);
                    setTimeout(() => { popup.remove(); }, 2500);
                    return;
                }
                if (!response.ok || data.error || data.detail) {
                    errorMessage.textContent = 'Erro ao atualizar: ' + (data.detail || data.error || rawText);
                    errorMessage.style.display = 'block';
                } else {
                    successMessage.textContent = 'Dados atualizados com sucesso!';
                    successMessage.style.display = 'block';
                }
            })
            .catch(err => {
                loading.style.display = 'none';
                errorMessage.textContent = 'Erro ao atualizar: ' + err.message;
                errorMessage.style.display = 'block';
            });
        });
    }
    // Adicionar JS ao final do script
    const consultarLinhasBtn = document.getElementById('consultarLinhasBtn');
    const linhasClienteResult = document.getElementById('linhasClienteResult');
    if (consultarLinhasBtn && linhasClienteResult) {
        consultarLinhasBtn.addEventListener('click', function() {
            linhasClienteResult.innerHTML = '';
            const doc = document.getElementById('clientDocument').value.replace(/\D/g, '');
            if (!doc || doc.length < 11) {
                linhasClienteResult.innerHTML = '<span style="color:#e11d48;">Consulte um cliente válido primeiro.</span>';
                return;
            }
            linhasClienteResult.innerHTML = '<div class="spinner" style="margin:18px auto;"></div> <span style="color:#2563eb;">Consultando linhas...</span>';
            fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Subscription/' + doc))
                .then(resp => resp.json())
                .then(data => {
                    linhasClienteResult.innerHTML = '';
                    if (!data || data.error || data.detail) {
                        linhasClienteResult.innerHTML = '<span style="color:#e11d48;">Erro: ' + (data.detail || data.error || 'Nenhum dado retornado') + '</span>';
                        return;
                    }
                    if (!Array.isArray(data)) data = data.data || data.results || [];
                    if (!Array.isArray(data) || data.length === 0) {
                        linhasClienteResult.innerHTML = '<span style="color:#64748b;">Nenhuma linha encontrada para este cliente.</span>';
                        return;
                    }
                    let html = `<div style='background:#fff;border-radius:14px;box-shadow:0 2px 12px #2563eb22;padding:18px 10px;max-width:520px;margin:0 auto;'>`;
                    html += `<div style='font-weight:700;color:#2563eb;font-size:1.05em;margin-bottom:10px;display:flex;align-items:center;gap:8px;'><span class='material-icons' style='font-size:1.2em;'>sim_card</span>Linhas do cliente</div>`;
                    html += `<div style='display:grid;grid-template-columns:repeat(auto-fit,minmax(210px,1fr));gap:12px 16px;'>`;
                    data.forEach(linha => {
                        html += `<div style='background:#f8fafc;border-radius:10px;padding:10px 10px;display:flex;flex-direction:column;gap:2px;font-size:0.97em;box-shadow:0 1px 4px #2563eb11;'>`;
                        if (linha.msisdn) html += `<div style='font-weight:600;color:#2563eb;font-size:0.98em;display:flex;align-items:center;gap:4px;'><span class='material-icons' style='font-size:1em;'>phone_iphone</span> ${linha.msisdn}</div>`;
                        if (linha.iccid) html += `<div><b>ICCID:</b> <span style='color:#222;'>${linha.iccid}</span></div>`;
                        if (linha.status) html += `<div><b>Status:</b> <span style='color:#10b981;'>${linha.status}</span></div>`;
                        if (linha.planName || linha.plan) html += `<div><b>Plano:</b> <span style='color:#222;'>${linha.planName || linha.plan}</span></div>`;
                        if (linha.createdAt) html += `<div><b>Data de Criação:</b> <span style='color:#222;'>${new Date(linha.createdAt).toLocaleString('pt-BR', {day:'2-digit',month:'2-digit',year:'numeric',hour:'2-digit',minute:'2-digit'})}</span></div>`;
                        if (linha.planExpiration) html += `<div><b>Expiração do Plano:</b> <span style='color:#222;'>${new Date(linha.planExpiration).toLocaleString('pt-BR', {day:'2-digit',month:'2-digit',year:'numeric',hour:'2-digit',minute:'2-digit'})}</span></div>`;
                        html += `</div>`;
                    });
                    html += `</div></div>`;
                    linhasClienteResult.innerHTML = html;
                });
        });
    }
    </script>
</body>
</html>