<?php
/**
 * Configuração do Servidor Remoto - Sistema Core3Chip
 * 
 * Este arquivo deve ser usado no servidor remoto para substituir o config.php
 * com as configurações corretas de produção.
 */

// Configurações do Banco de Dados MySQL
define('DB_HOST', '192.168.2.129');
define('DB_NAME', 'ixcprovedor');
define('DB_USER', 'root');
define('DB_PASS', 'C0r3@2018');

// Configurações IXC
define('IXC_HOST', 'https://app.core3.com.br/webservice/v1');
define('IXC_TOKEN', '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d');

// Configurações do Sistema
define('SISTEMA_URL', 'http://192.168.2.30/sistema');
define('SISTEMA_PATH', '/var/www/sistema');
define('LOGS_PATH', '/var/www/sistema/logs');

// Configurações de Timezone
date_default_timezone_set('America/Sao_Paulo');

// Configurações de Debug
define('DEBUG_MODE', false);
define('LOG_LEVEL', 'INFO');

// Configurações de API
define('API_TIMEOUT', 30);
define('API_RETRY_ATTEMPTS', 3);

// Configurações do ambiente
define('ENVIRONMENT', 'production');

// Configurações da API IXCsoft
$config = [
    'development' => [
        'host' => IXC_HOST,
        'token' => IXC_TOKEN,
        'selfSigned' => true,
        'timeout' => API_TIMEOUT,
        'debug' => true
    ],
    'staging' => [
        'host' => IXC_HOST,
        'token' => IXC_TOKEN,
        'selfSigned' => true,
        'timeout' => API_TIMEOUT,
        'debug' => true
    ],
    'production' => [
        'host' => IXC_HOST,
        'token' => IXC_TOKEN,
        'selfSigned' => false,
        'timeout' => API_TIMEOUT,
        'debug' => false
    ]
];

// Configurações do servidor
$serverConfig = [
    'host' => '192.168.2.30',
    'port' => 80,
    'cors' => true,
    'cors_origins' => ['*']
];

// Configurações de log
$logConfig = [
    'enabled' => true,
    'file' => LOGS_PATH . '/api.log',
    'level' => LOG_LEVEL
];

// Função para obter configuração atual
function getConfig($key = null) {
    global $config, $serverConfig, $logConfig;
    
    if ($key === 'server') {
        return $serverConfig;
    }
    
    if ($key === 'log') {
        return $logConfig;
    }
    
    $currentConfig = $config[ENVIRONMENT];
    
    if ($key === null) {
        return $currentConfig;
    }
    
    return isset($currentConfig[$key]) ? $currentConfig[$key] : null;
}

// Função para log
function logMessage($message, $level = 'INFO') {
    global $logConfig;
    
    if (!$logConfig['enabled']) {
        return;
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[$timestamp] [$level] $message" . PHP_EOL;
    
    if ($logConfig['file']) {
        // Criar diretório de logs se não existir
        $logDir = dirname($logConfig['file']);
        if (!is_dir($logDir)) {
            mkdir($logDir, 0755, true);
        }
        file_put_contents($logConfig['file'], $logEntry, FILE_APPEND | LOCK_EX);
    }
}

// Headers CORS
if ($serverConfig['cors']) {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit();
    }
}

// Log de inicialização
logMessage("API IXCsoft inicializada em ambiente: " . ENVIRONMENT, "INFO");

// Exportar configurações para uso global
$GLOBALS['api_config'] = getConfig();
$GLOBALS['server_config'] = $serverConfig;
$GLOBALS['log_config'] = $logConfig;

echo "✅ Configuração do servidor remoto carregada!\n";
echo "🌐 URL do Sistema: " . SISTEMA_URL . "\n";
echo "📁 Caminho: " . SISTEMA_PATH . "\n";
echo "📝 Logs: " . LOGS_PATH . "\n";
echo "🗄️ Banco: " . DB_HOST . "/" . DB_NAME . "\n";
echo "🖥️ Servidor: Ubuntu 22.04.5 LTS\n";
?>
