<?php
/**
 * Configuração centralizada da API IXCsoft
 * 
 * Este arquivo permite configurar diferentes ambientes (desenvolvimento, produção)
 * e centralizar todas as configurações em um só lugar.
 */

// Configurações do ambiente
define('ENVIRONMENT', 'development'); // development, staging, production

// Configurações da API IXCsoft
$config = [
    'development' => [
        'host' => 'https://app.core3.com.br/webservice/v1',
        'token' => '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d',
        'selfSigned' => true,
        'timeout' => 30,
        'debug' => true
    ],
    'staging' => [
        'host' => 'https://app.core3.com.br/webservice/v1',
        'token' => '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d',
        'selfSigned' => true,
        'timeout' => 30,
        'debug' => true
    ],
    'production' => [
        'host' => 'https://app.core3.com.br/webservice/v1',
        'token' => '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d',
        'selfSigned' => false,
        'timeout' => 60,
        'debug' => false
    ]
];

// Configurações do servidor
$serverConfig = [
    'host' => 'localhost',
    'port' => 8000,
    'cors' => true,
    'cors_origins' => ['*']
];

// Configurações de log
$logConfig = [
    'enabled' => true,
    'file' => 'api.log',
    'level' => 'INFO' // DEBUG, INFO, WARNING, ERROR
];

// Função para obter configuração atual
function getConfig($key = null) {
    global $config, $serverConfig, $logConfig;
    
    if ($key === 'server') {
        return $serverConfig;
    }
    
    if ($key === 'log') {
        return $logConfig;
    }
    
    $currentConfig = $config[ENVIRONMENT];
    
    if ($key === null) {
        return $currentConfig;
    }
    
    return isset($currentConfig[$key]) ? $currentConfig[$key] : null;
}

// Função para log
function logMessage($message, $level = 'INFO') {
    global $logConfig;
    
    if (!$logConfig['enabled']) {
        return;
    }
    
    $timestamp = date('Y-m-d H:i:s');
    $logEntry = "[$timestamp] [$level] $message" . PHP_EOL;
    
    if ($logConfig['file']) {
        file_put_contents($logConfig['file'], $logEntry, FILE_APPEND | LOCK_EX);
    }
    
    // Log apenas para arquivo, não para output
    // if (getConfig('debug')) {
    //     echo $logEntry;
    // }
}

// Configurações padrão do PHP
date_default_timezone_set('America/Bahia');

// Headers CORS
if ($serverConfig['cors']) {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit();
    }
}

// Log de inicialização
logMessage("API IXCsoft inicializada em ambiente: " . ENVIRONMENT, "INFO");

// Exportar configurações para uso global
$GLOBALS['api_config'] = getConfig();
$GLOBALS['server_config'] = $serverConfig;
$GLOBALS['log_config'] = $logConfig;
?>
