<?php
// Comparar minha implementação com consulta.php
echo "<h2>🔍 Comparando Implementações</h2>";

echo "<h3>1. Teste com consulta.php (que funciona)</h3>";
echo "<p>URL: consulta.php?id=04435315521</p>";

// Simular o que consulta.php faz
include_once("confApi.php");

$id_cliente = '04435315521';
$id_cliente = trim($id_cliente);
$qtype = 'cliente.cnpj_cpf';
$query = $id_cliente;

if (ctype_digit($id_cliente) && strlen($id_cliente) === 11) {
    $query = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $id_cliente);
}

echo "<p><strong>CPF Original:</strong> $id_cliente</p>";
echo "<p><strong>CPF com Máscara:</strong> $query</p>";

$params = array(
    'qtype' => $qtype,
    'query' => "$query",
    'oper' => '=',
    'page' => '1',
    'rp' => '20',
    'sortname' => 'cliente.id',
    'sortorder' => 'desc',
    'grid_param' => json_encode([
        ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
    ])
);

echo "<h4>Parâmetros enviados:</h4>";
echo "<pre>";
print_r($params);
echo "</pre>";

// Fazer a consulta
$api->get('cliente', $params);
$retorno = $api->getRespostaConteudo(false);

echo "<h4>Resposta da API:</h4>";
$data = json_decode($retorno, true);

if (isset($data['rows'])) {
    echo "<p>✅ <strong>Registros encontrados:</strong> " . count($data['rows']) . "</p>";
    if (count($data['rows']) > 0) {
        $cliente = $data['rows'][0];
        echo "<p>✅ <strong>Primeiro cliente:</strong></p>";
        echo "<pre>";
        print_r($cliente);
        echo "</pre>";
    }
} else {
    echo "<p>❌ <strong>Estrutura inesperada:</strong></p>";
    echo "<pre>";
    print_r($data);
    echo "</pre>";
}

echo "<hr>";

echo "<h3>2. Teste com minha implementação</h3>";
echo "<p>URL: consultar-ixc.php?document=04435315521</p>";

// Simular minha implementação
$document = '04435315521';
$query2 = $document;

if (strlen($document) === 11) {
    $query2 = preg_replace("/(\d{3})(\d{3})(\d{3})(\d{2})/", "$1.$2.$3-$4", $document);
}

echo "<p><strong>CPF Original:</strong> $document</p>";
echo "<p><strong>CPF com Máscara:</strong> $query2</p>";

$params2 = array(
    'qtype' => 'cliente.cnpj_cpf',
    'query' => $query2,
    'oper' => '=',
    'page' => '1',
    'rp' => '20',
    'sortname' => 'cliente.id',
    'sortorder' => 'desc',
    'grid_param' => json_encode([
        ['TB' => 'cliente.ativo', 'OP' => '=', 'P' => 'S']
    ])
);

echo "<h4>Parâmetros enviados:</h4>";
echo "<pre>";
print_r($params2);
echo "</pre>";

// Fazer a consulta
$api->get('cliente', $params2);
$retorno2 = $api->getRespostaConteudo(false);

echo "<h4>Resposta da API:</h4>";
$data2 = json_decode($retorno2, true);

if (isset($data2['rows'])) {
    echo "<p>✅ <strong>Registros encontrados:</strong> " . count($data2['rows']) . "</p>";
    if (count($data2['rows']) > 0) {
        $cliente2 = $data2['rows'][0];
        echo "<p>✅ <strong>Primeiro cliente:</strong></p>";
        echo "<pre>";
        print_r($cliente2);
        echo "</pre>";
    }
} else {
    echo "<p>❌ <strong>Estrutura inesperada:</strong></p>";
    echo "<pre>";
    print_r($data2);
    echo "</pre>";
}

echo "<hr>";

echo "<h3>3. Comparação</h3>";
echo "<p><strong>Parâmetros idênticos?</strong> " . ($params == $params2 ? '✅ Sim' : '❌ Não') . "</p>";
echo "<p><strong>Respostas idênticas?</strong> " . ($retorno === $retorno2 ? '✅ Sim' : '❌ Não') . "</p>";

if ($retorno !== $retorno2) {
    echo "<h4>Diferenças nas respostas:</h4>";
    echo "<p><strong>consulta.php:</strong></p>";
    echo "<pre>" . htmlspecialchars($retorno) . "</pre>";
    echo "<p><strong>consultar-ixc.php:</strong></p>";
    echo "<pre>" . htmlspecialchars($retorno2) . "</pre>";
}
?>
