<?php
// Configurações iniciais
$baseUrl = 'https://app.boramvno.com.br/appapi';
$email    = 'andre@core3.com.br';
$password = 'C@du290713!';
$cpf      = '12345678909'; // Somente números

// 1. Autenticação básica para obter token
$authUrl = $baseUrl . '/api/Authentication/basic';
$auth = base64_encode("$email:$password");

$ch = curl_init($authUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Basic $auth",
    "Content-Type: application/json"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, '{}');

$authResponse = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$header = substr($authResponse, 0, $headerSize);
$body   = substr($authResponse, $headerSize);
curl_close($ch);

// Decodifica o JSON do body
$authResult = json_decode($body, true);
$token = null;
$tokenSource = '';
if (isset($authResult['token'])) {
    $token = $authResult['token'];
    $tokenSource = 'JSON';
} else {
    // Tenta extrair do header x-access-token
    if (preg_match('/x-access-token:\s*(.+)/i', $header, $matches)) {
        $token = trim($matches[1]);
        $tokenSource = 'HEADER';
    }
}

// Início do HTML
header('Content-Type: text/html; charset=utf-8');
echo '<!DOCTYPE html><html lang="pt-BR"><head>';
echo '<meta charset="UTF-8">';
echo '<meta name="viewport" content="width=device-width, initial-scale=1.0">';
echo '<title>API Plan Activation - Material Design</title>';
echo '<link href="https://fonts.googleapis.com/css?family=Inter:400,600&display=swap" rel="stylesheet">';
echo '<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">';
echo '<style>
body { background: #f5f6fa; font-family: Inter, Arial, sans-serif; margin: 0; padding: 0; }
.container { max-width: 1100px; margin: 40px auto; padding: 24px; background: #fff; border-radius: 16px; box-shadow: 0 4px 24px rgba(0,0,0,0.09); }
h1 { text-align: center; color: #1976d2; font-weight: 600; margin-bottom: 32px; }
.cards { display: flex; flex-wrap: wrap; gap: 24px; justify-content: center; }
.card { background: #fff; border-radius: 12px; box-shadow: 0 2px 8px rgba(25, 118, 210, 0.10); padding: 24px 20px; min-width: 280px; max-width: 340px; flex: 1 1 320px; display: flex; flex-direction: column; transition: box-shadow .2s; position: relative; }
.card:hover { box-shadow: 0 6px 24px rgba(25, 118, 210, 0.18); }
.card-title { font-size: 1.25rem; color: #1976d2; font-weight: 700; margin-bottom: 14px; display: flex; align-items: center; gap: 8px; }
.card-content { color: #333; font-size: 1rem; margin-bottom: 8px; display: flex; align-items: center; gap: 8px; }
.card-label { color: #888; font-size: 0.97em; font-weight: 500; min-width: 90px; display: inline-block; }
.badge { display: inline-block; padding: 2px 10px; border-radius: 8px; font-size: 0.95em; font-weight: 600; margin-left: 6px; }
.badge-true { background: #c8e6c9; color: #256029; }
.badge-false { background: #ffcdd2; color: #b71c1c; }
.badge-status { background: #e3f2fd; color: #1976d2; }
.card-list { margin: 0 0 8px 0; padding-left: 24px; color: #444; font-size: 0.98em; }
.material-icons { font-size: 1.1em; vertical-align: middle; }
.details { margin: 24px 0 0 0; }
details summary { cursor: pointer; font-weight: 600; color: #1976d2; font-size: 1.1em; }
@media (max-width: 700px) { .container { padding: 8px; } .cards { gap: 12px; } .card { min-width: 90vw; max-width: 98vw; } }
</style>';
echo '</head><body>';
echo '<div class="container">';
echo '<h1><span class="material-icons" style="font-size:1.3em;vertical-align:-3px;">view_list</span> Planos Ativos (API Plan Activation)</h1>';

// Bloco de diagnóstico técnico colapsável
$diagnostico = "<details class='details'><summary>Diagnóstico Técnico</summary>";
$diagnostico .= "<pre style='font-size:0.98em; background:#f7f7fa; border-radius:8px; padding:12px; overflow-x:auto;'>";
$diagnostico .= "URL: $authUrl\n";
$diagnostico .= "Authorization header enviado: Basic $auth\n";
$diagnostico .= "Código HTTP: $httpCode\n";
$diagnostico .= "HEADERS:\n$header\n";
$diagnostico .= "BODY (JSON):\n$body\n\n";
if ($token) {
    $diagnostico .= "TOKEN ($tokenSource): $token\n\n";
}

// Segunda requisição
if ($token) {
    $planUrl = $baseUrl . "/api/Plan/Activation";
    $ch2 = curl_init($planUrl);
    curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch2, CURLOPT_HEADER, true);
    curl_setopt($ch2, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $token",
        "Content-Type: application/json"
    ]);
    $planResponse = curl_exec($ch2);
    $planHttpCode = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
    $planHeaderSize = curl_getinfo($ch2, CURLINFO_HEADER_SIZE);
    $planHeader = substr($planResponse, 0, $planHeaderSize);
    $planBody   = substr($planResponse, $planHeaderSize);
    curl_close($ch2);

    $diagnostico .= "---\nRequisição GET para /api/Plan/Activation\n";
    $diagnostico .= "Código HTTP: $planHttpCode\n";
    $diagnostico .= "HEADERS:\n$planHeader\n";
    $diagnostico .= "BODY (JSON):\n$planBody\n";
    $diagnostico .= "</pre></details>";
    echo $diagnostico;

    // Exibir cards elegantes com os dados do plano
    $planData = json_decode($planBody, true);
    if (is_array($planData) && count($planData) > 0) {
        echo '<div class="cards">';
        foreach ($planData as $plano) {
            echo '<div class="card">';
            // Título do card
            if (isset($plano['name'])) {
                echo '<div class="card-title"><span class="material-icons">credit_card</span> ' . htmlspecialchars($plano['name']) . '</div>';
            }
            foreach ($plano as $key => $value) {
                if ($key === 'name') continue;
                $icon = 'info';
                $badge = '';
                $label = htmlspecialchars(ucwords(str_replace('_',' ', $key)));
                $displayValue = '';
                // Ícones e badges por tipo de campo
                if (is_bool($value) || $value === true || $value === false || $value === 1 || $value === 0) {
                    $icon = $value ? 'check_circle' : 'cancel';
                    $badge = $value ? '<span class="badge badge-true">Ativo</span>' : '<span class="badge badge-false">Inativo</span>';
                    $displayValue = $value ? 'Sim' : 'Não';
                } elseif (stripos($key, 'status') !== false) {
                    $icon = 'verified_user';
                    $badge = '<span class="badge badge-status">' . htmlspecialchars($value) . '</span>';
                    $displayValue = htmlspecialchars($value);
                } elseif (stripos($key, 'date') !== false || stripos($key, 'data') !== false) {
                    $icon = 'event';
                    $displayValue = htmlspecialchars($value);
                } elseif (is_array($value)) {
                    $icon = 'list';
                    $displayValue = '<ul class="card-list">';
                    foreach ($value as $item) {
                        $displayValue .= '<li>' . htmlspecialchars(is_array($item) ? json_encode($item, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT) : $item) . '</li>';
                    }
                    $displayValue .= '</ul>';
                } else {
                    $displayValue = htmlspecialchars($value);
                }
                echo '<div class="card-content"><span class="material-icons">' . $icon . '</span> <span class="card-label">' . $label . ':</span> ' . $displayValue . ' ' . $badge . '</div>';
            }
            echo '</div>';
        }
        echo '</div>';
    } else {
        echo '<div style="color:#c00; text-align:center; margin:32px 0; font-size:1.1em;">Nenhum plano encontrado ou resposta inesperada da API.</div>';
    }

} else {
    $diagnostico .= "Falha ao obter token.\n";
    if (isset($authResult['message'])) {
        $diagnostico .= "Mensagem da API: " . $authResult['message'] . "\n";
    }
    $diagnostico .= "Resposta completa:\n" . print_r($authResult, true);
    $diagnostico .= "</pre></details>";
    echo $diagnostico;
    echo '<div style="color:#c00; text-align:center; margin:32px 0; font-size:1.1em;">Falha ao obter token. Veja o diagnóstico acima.</div>';
}
echo '</div></body></html>';
