<?php
$currentTime = date('H:i:s');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Andamento de Portabilidades - Core3Chip</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body { min-height: 100vh; background: linear-gradient(135deg, #0f2027 0%, #2c5364 100%); display: flex; align-items: center; justify-content: center; font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif; margin: 0; }
        .container { background: rgba(255,255,255,0.97); border-radius: 32px; box-shadow: 0 8px 40px 0 rgba(37,99,235,0.18), 0 1.5px 8px 0 rgba(16,185,129,0.10); padding: 56px 40px 48px 40px; max-width: 1400px; width: 99vw; display: flex; flex-direction: column; align-items: center; gap: 36px; position: relative; }
        .logo-img { width: 195px; height: 130px; object-fit: contain; object-position: center; margin-bottom: 12px; filter: drop-shadow(0 4px 24px #2563eb33); background: transparent; border-radius: 18px; }
        .back-btn { position: absolute; top: 18px; left: 18px; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); color: #fff; border: none; border-radius: 8px; padding: 10px 18px; font-size: 1rem; font-weight: 600; display: flex; align-items: center; gap: 8px; box-shadow: 0 2px 8px 0 rgba(37,99,235,0.10); cursor: pointer; transition: background 0.2s, box-shadow 0.2s; z-index: 10; }
        .back-btn .material-icons { font-size: 1.2em; }
        .back-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); box-shadow: 0 6px 18px 0 rgba(16,185,129,0.13); }
        .title { font-size: 2.2rem; font-weight: 700; color: #2563eb; margin: 0 0 8px 0; text-align: center; }
        .subtitle { font-size: 1.2rem; color: #64748b; margin: 0 0 18px 0; text-align: center; }
        .search-btn { padding: 16px 0; border: none; border-radius: 10px; font-size: 1.18rem; font-weight: 600; color: #fff; background: linear-gradient(90deg, #2563eb 0%, #10b981 100%); box-shadow: 0 2px 12px 0 rgba(37,99,235,0.10); cursor: pointer; display: flex; align-items: center; justify-content: center; gap: 10px; transition: background 0.2s, transform 0.2s, box-shadow 0.2s; outline: none; letter-spacing: 0.5px; min-width: 240px; margin: 0 auto; font-size: 1.15em; }
        .search-btn .material-icons { font-size: 1.3em; vertical-align: middle; }
        .search-btn:hover { background: linear-gradient(90deg, #10b981 0%, #2563eb 100%); transform: translateY(-2px) scale(1.03); box-shadow: 0 6px 24px 0 rgba(16,185,129,0.13); }
        .form-input { padding: 14px 16px; border-radius: 8px; border: 1.5px solid #cbd5e1; font-size: 1.15rem; outline: none; transition: border 0.2s; min-width: 180px; }
        .form-input:focus { border: 1.5px solid #2563eb; }
        .loading { display: none; align-items: center; flex-direction: column; gap: 10px; margin: 18px 0; }
        .spinner { width: 36px; height: 36px; border: 5px solid #e0e7ef; border-top: 5px solid #2563eb; border-radius: 50%; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .error-message { display: none; margin: 10px 0 0 0; padding: 12px 20px; border-radius: 8px; font-size: 1.12rem; font-weight: 500; background: #fee2e2; color: #b91c1c; border: 1.5px solid #f87171; }
        .grid-section { width: 100%; margin-top: 24px; }
        .port-grid { display: grid; grid-template-columns: 48px 1.5fr 1.1fr 1.2fr 1.2fr 1fr 1.2fr 2.2fr 120px; gap: 14px; background: #f8fafc; border-radius: 18px; padding: 18px 18px; box-shadow: 0 2px 12px 0 rgba(37,99,235,0.06); font-size: 0.98em; margin-top: 10px; align-items: center; }
        .port-grid .header { font-weight: 700; color: #fff; background: linear-gradient(90deg,#2563eb 0%,#10b981 100%); border-radius: 8px; padding: 10px 4px; text-align: center; letter-spacing: 0.5px; box-shadow: 0 1px 4px #2563eb22; font-size: 1em; }
        .port-grid .cell { background: #fff; border-radius: 8px; padding: 10px 4px; text-align: center; color: #222; box-shadow: 0 1px 4px #2563eb11; display: flex; align-items: center; justify-content: center; min-height: 38px; font-size: 1em; }
        .port-grid .cell.flag { background: transparent; box-shadow: none; padding: 0; }
        .port-grid .cell.flag input[type='checkbox'] { transform: scale(1.3); margin: 0; cursor: pointer; }
        .port-grid .cell.acao { background: transparent; box-shadow: none; padding: 0; }
        .port-grid .cell.acao button { margin: 0 auto; }
        .port-grid .cell.status { font-weight: 700; color: #fff; background: linear-gradient(90deg,#f59e42 0%,#f87171 100%); border-radius: 8px; }
        .port-grid .cell.status[data-status="CONCLUIDO"] { background: linear-gradient(90deg,#10b981 0%,#2563eb 100%); color: #fff; }
        .port-grid .cell.status[data-status="PENDENTE"] { background: linear-gradient(90deg,#f59e42 0%,#f87171 100%); color: #fff; }
        .port-grid .cell.status[data-status="ERRO"] { background: linear-gradient(90deg,#e11d48 0%,#f59e42 100%); color: #fff; }
        .port-grid .cell.previsao { font-weight: 600; color: #2563eb; }
        .port-grid .cell strong { color: #2563eb; }
        @media (max-width: 1400px) { .container { max-width: 99vw; } .port-grid { font-size: 0.95em; } }
        @media (max-width: 1100px) { .port-grid { grid-template-columns: 1.5fr 1.1fr 1.2fr 1.2fr 1fr 1.2fr; } }
        @media (max-width: 900px) { .port-grid { grid-template-columns: 1fr 1fr 1fr; font-size: 0.93em; } }
        @media (max-width: 600px) { .container { padding: 12px 2px 8px 2px; border-radius: 12px; } .logo-img { width: 110px; height: 60px; } .port-grid { grid-template-columns: 1fr; font-size: 0.91em; padding: 8px; } }
    </style>
</head>
<body>
    <div style="position:absolute;top:18px;right:24px;z-index:100;">
        <a href="logout.php" style="background:linear-gradient(90deg,#e11d48 0%,#f87171 100%);color:#fff;padding:10px 22px;border-radius:8px;font-weight:600;text-decoration:none;box-shadow:0 2px 8px #e11d4811;display:flex;align-items:center;gap:8px;font-size:1.05em;">
            <span class="material-icons" style="font-size:1.2em;">logout</span> Sair
        </a>
    </div>
    <div class="container">
        <button onclick="window.location.href='index.php'" class="back-btn">
            <span class="material-icons">arrow_back</span> Voltar
        </button>
        <img src="chip.png" alt="Logo" class="logo-img" />
        <div class="title">Andamento de Portabilidades</div>
        <div class="subtitle">Consulte todas as portabilidades em andamento no sistema</div>
        <div style="display:flex;flex-direction:column;gap:8px;width:100%;max-width:900px;margin-bottom:10px;align-items:center;">
            <div style="display:flex;gap:18px;flex-wrap:wrap;justify-content:center;width:100%;">
                <div style="display:flex;flex-direction:column;gap:4px;">
                    <label for="filtroDocumento" style="font-size:1.01em;color:#2563eb;font-weight:600;">Filtrar por CPF</label>
                    <input type="text" id="filtroDocumento" class="form-input" placeholder="Digite o CPF" style="max-width:180px;">
                </div>
                <div style="display:flex;flex-direction:column;gap:4px;">
                    <label for="filtroPmsisdn" style="font-size:1.01em;color:#2563eb;font-weight:600;">Filtrar por telefone</label>
                    <input type="text" id="filtroPmsisdn" class="form-input" placeholder="Digite o telefone" style="max-width:180px;">
                </div>
                <div style="align-self:flex-end;">
                    <button class="search-btn" id="consultarBtn"><span class="material-icons">search</span> Consultar portabilidades</button>
                </div>
            </div>
        </div>
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p>Consultando portabilidades...</p>
        </div>
        <div class="error-message" id="errorMessage"></div>
        <div class="grid-section" id="gridSection"></div>
    </div>
    <script>
    let allResults = [];
    const consultarBtn = document.getElementById('consultarBtn');
    const loading = document.getElementById('loading');
    const errorMessage = document.getElementById('errorMessage');
    const gridSection = document.getElementById('gridSection');
    const filtroPmsisdn = document.getElementById('filtroPmsisdn');
    const filtroDocumento = document.getElementById('filtroDocumento');
    function renderGrid(results) {
        if (!Array.isArray(results) || results.length === 0) {
            gridSection.innerHTML = '<div style="text-align:center;color:#64748b;font-size:1.1em;margin-top:18px;">Nenhuma portabilidade encontrada.</div>';
            return;
        }
        let grid = `<div class='port-grid'>`;
        grid += `<div class='header'></div><div class='header'>Nome</div><div class='header'>Documento</div><div class='header'>MSISDN</div><div class='header'>PMSISDN</div><div class='header'>Status</div><div class='header'>Previsão</div><div class='header'>Descrição</div><div class='header'></div>`;
        results.forEach((item, idx) => {
            const pmsisdn = item.pmsisdn || '';
            const idFlag = `flagPmsisdn_${idx}`;
            const idBtn = `btnCancelar_${idx}`;
            grid += `<div class='cell flag'><input type='checkbox' id='${idFlag}' data-pmsisdn='${pmsisdn}'></div>`;
            grid += `<div class='cell'>${item.name || '-'}</div>`;
            grid += `<div class='cell'>${item.document || '-'}</div>`;
            grid += `<div class='cell'>${item.msisdn || '-'}</div>`;
            grid += `<div class='cell'>${pmsisdn}</div>`;
            grid += `<div class='cell status' data-status='${item.status || ''}'>${item.status || '-'}</div>`;
            grid += `<div class='cell previsao'>${item.forecast ? new Date(item.forecast).toLocaleString('pt-BR') : '-'}</div>`;
            grid += `<div class='cell'>${item.description || '-'}</div>`;
            grid += `<div class='cell acao'><button id='${idBtn}' class='search-btn' style='display:none;padding:7px 14px;font-size:0.98em;min-width:unset;'><span class='material-icons' style='font-size:1.1em;'>cancel</span>Cancelar portabilidade</button></div>`;
        });
        grid += `</div>`;
        gridSection.innerHTML = grid;
        // Adicionar listeners para flags e botões
        results.forEach((item, idx) => {
            const idFlag = `flagPmsisdn_${idx}`;
            const idBtn = `btnCancelar_${idx}`;
            const flag = document.getElementById(idFlag);
            const btn = document.getElementById(idBtn);
            if (flag && btn) {
                flag.addEventListener('change', function() {
                    if (flag.checked) {
                        btn.style.display = 'inline-flex';
                    } else {
                        btn.style.display = 'none';
                    }
                });
                btn.addEventListener('click', function() {
                    const pmsisdn = flag.getAttribute('data-pmsisdn');
                    if (!pmsisdn) return;
                    btn.disabled = true;
                    btn.innerHTML = '<span class="material-icons">hourglass_top</span>Cancelando...';
                    fetch('proxy-chip.php?rota=' + encodeURIComponent('/api/Portability/' + pmsisdn), {
                        method: 'DELETE',
                        headers: { 'Content-Type': 'application/json' }
                    })
                    .then(resp => resp.text())
                    .then(text => {
                        let data;
                        try { data = text ? JSON.parse(text) : {}; } catch(e) { data = {}; }
                        btn.disabled = false;
                        btn.innerHTML = '<span class="material-icons">cancel</span>Cancelar portabilidade';
                        if (data.success || data.message) {
                            btn.innerHTML = '<span class="material-icons">check_circle</span>Cancelada!';
                            btn.style.background = 'linear-gradient(90deg,#10b981 0%,#2563eb 100%)';
                            setTimeout(() => { btn.style.display = 'none'; flag.checked = false; }, 1800);
                        } else {
                            btn.innerHTML = '<span class="material-icons">cancel</span>Cancelar portabilidade';
                            alert('Erro ao cancelar portabilidade: ' + (data.detail || data.error || 'Erro desconhecido'));
                        }
                    })
                    .catch(err => {
                        btn.disabled = false;
                        btn.innerHTML = '<span class="material-icons">cancel</span>Cancelar portabilidade';
                        alert('Erro ao cancelar portabilidade: ' + err.message);
                    });
                });
            }
        });
    }
    function filtrarGrid() {
        let pmsisdn = filtroPmsisdn.value.trim();
        let documento = filtroDocumento.value.trim();
        let filtrados = allResults.filter(item => {
            let ok = true;
            if (pmsisdn) ok = ok && (item.pmsisdn && item.pmsisdn.includes(pmsisdn));
            if (documento) ok = ok && (item.document && item.document.includes(documento));
            return ok;
        });
        renderGrid(filtrados);
    }
    filtroPmsisdn.addEventListener('input', filtrarGrid);
    filtroDocumento.addEventListener('input', filtrarGrid);
    consultarBtn.addEventListener('click', function() {
        errorMessage.style.display = 'none';
        gridSection.innerHTML = '';
        loading.style.display = 'flex';
        const url = 'proxy-chip.php?rota=' + encodeURIComponent('/api/Portability/List');
        fetch(url)
            .then(async response => {
                const text = await response.text();
                let data;
                try {
                    data = JSON.parse(text);
                } catch (e) {
                    if (text.includes('<form') && text.includes('login')) {
                        window.location.href = 'login.php';
                        return;
                    }
                    errorMessage.textContent = 'Sessão expirada ou erro inesperado. Faça login novamente.';
                    errorMessage.style.display = 'block';
                    loading.style.display = 'none';
                    return;
                }
                return data;
            })
            .then(data => {
                if (!data) return;
                loading.style.display = 'none';
                if (data.error || data.detail) {
                    errorMessage.textContent = 'Erro: ' + (data.detail || data.error);
                    errorMessage.style.display = 'block';
                    return;
                }
                allResults = Array.isArray(data.results) ? data.results : [];
                filtrarGrid();
            })
            .catch(err => {
                loading.style.display = 'none';
                errorMessage.textContent = 'Erro ao consultar portabilidades: ' + err.message;
                errorMessage.style.display = 'block';
            });
    });
    </script>
</body>
</html>
