# 🚀 API IXCsoft - Servidor de Teste

Este projeto contém uma API PHP para comunicação com o webservice IXCsoft, configurada para testes locais.

## 📁 Arquivos do Projeto

- **`confApi.php`** - Configuração da API (host, token, certificados)
- **`WebserviceClient.php`** - Cliente para comunicação com o webservice
- **`consulta.php`** - Endpoint para consultar clientes por ID
- **`server.php`** - Servidor PHP local para testes
- **`chip.png`** - Imagem do projeto

## 🛠️ Como Executar

### Opção 1: Servidor PHP Local (Recomendado)

1. **Abra o terminal** na pasta do projeto
2. **Execute o comando:**
   ```bash
   php -S localhost:8000 server.php
   ```
3. **Acesse no navegador:**
   ```
   http://localhost:8000
   ```

### Opção 2: Servidor Apache/Nginx

1. **Copie os arquivos** para a pasta do seu servidor web
2. **Acesse diretamente:**
   ```
   http://seu-servidor/consulta.php?id=1
   ```

## 🧪 Testando a API

### Endpoint Principal
```
GET /consulta.php?id={id_cliente}
```

### Exemplos de Uso

- **Consulta cliente ID 1:**
  ```
  http://localhost:8000/consulta.php?id=1
  ```

- **Consulta cliente ID 2:**
  ```
  http://localhost:8000/consulta.php?id=2
  ```

### Interface Web

O servidor local inclui uma interface web amigável em `http://localhost:8000` com:
- Botões de teste para diferentes IDs
- Documentação dos endpoints
- Interface responsiva e moderna

## ⚙️ Configuração

### Arquivo `confApi.php`
```php
$host = 'https://app.core3.com.br/webservice/v1';
$token = '91:343929a438b6196da8dcb68a911099c95a07d56ffb8b17ff9f34a9a3ba550f6d';
$selfSigned = true;
```

### Personalização
- **Host:** Altere a URL do webservice
- **Token:** Atualize com seu token de autenticação
- **Certificados:** Configure `$selfSigned` conforme necessário

## 🔌 Funcionalidades da API

### WebserviceClient
- **GET:** Consultas com parâmetros
- **POST:** Criação de registros
- **PUT:** Atualização de registros
- **DELETE:** Remoção de registros
- **Headers customizados**
- **Suporte a JSON**

### Consulta de Clientes
- Filtros por ID
- Paginação
- Ordenação
- Parâmetros de busca

## 🚨 Solução de Problemas

### Erro de CORS
- O arquivo `confApi.php` já inclui headers CORS
- Se persistir, verifique as configurações do servidor

### Erro de SSL
- `$selfSigned = true` ignora certificados SSL
- Para produção, configure certificados válidos

### Erro de Token
- Verifique se o token em `confApi.php` está correto
- Confirme as permissões no IXCsoft

## 📱 Compatibilidade

- **PHP:** 7.4+ (recomendado 8.0+)
- **Extensões:** cURL
- **Navegadores:** Todos os modernos
- **Sistemas:** Windows, macOS, Linux

## 🔒 Segurança

- **Token:** Mantenha o token seguro
- **Produção:** Use HTTPS e certificados válidos
- **Acesso:** Restrinja o acesso em ambientes de produção

## 📞 Suporte

Para dúvidas sobre:
- **IXCsoft:** Consulte a documentação oficial
- **API:** Verifique os comentários no código
- **Servidor:** Use a interface web em `/`

---

**🎯 Status:** Pronto para testes locais
**🔧 Versão:** 1.0
**📅 Última atualização:** $(date)



