# 🚀 INSTRUÇÕES DE USO - API IXCsoft

## 📋 Pré-requisitos

✅ **PHP 7.4+** (recomendado 8.0+)  
✅ **Extensão cURL** habilitada  
✅ **Arquivos do projeto** na pasta atual  

## 🚀 COMO INICIAR O SERVIDOR

### Opção 1: Script Automático (Recomendado)

```bash
# Dar permissão de execução (apenas na primeira vez)
chmod +x start-server.sh

# Executar o script
./start-server.sh
```

### Opção 2: Comando Manual

```bash
# Iniciar servidor na porta 8000
php -S localhost:8000 server.php
```

### Opção 3: Porta Personalizada

```bash
# Iniciar em porta diferente (ex: 8080)
php -S localhost:8080 server.php
```

## 🌐 ACESSOS DISPONÍVEIS

Após iniciar o servidor, você terá acesso a:

| URL | Descrição |
|-----|-----------|
| `http://localhost:8000/` | 🏠 **Interface principal** com botões de teste |
| `http://localhost:8000/consulta.php?id=1` | 🔍 **API direta** para consultar cliente ID 1 |
| `http://localhost:8000/test-api.php` | 🧪 **Interface de testes** avançada |
| `http://localhost:8000/exemplo-uso.php` | 📚 **Exemplos de código** e demonstrações |

## 🧪 TESTANDO A API

### 1. Teste Básico (Interface Web)
1. Acesse `http://localhost:8000/`
2. Clique em "🧪 Testar com ID 1"
3. Veja a resposta da API

### 2. Teste Avançado
1. Acesse `http://localhost:8000/test-api.php`
2. Use os botões para diferentes tipos de teste:
   - 🔌 **Teste de Conexão**
   - 👤 **Teste de Cliente por ID**
   - 📋 **Teste de Lista de Clientes**
   - 🔄 **Teste Completo**

### 3. Teste via Terminal
```bash
# Executar testes interativos
php exemplo-uso.php

# Testar conexão direta
curl "http://localhost:8000/consulta.php?id=1"
```

## 📱 USANDO A API PROGRAMATICAMENTE

### Exemplo Básico
```php
<?php
require_once('config.php');
require_once('WebserviceClient.php');

// Criar instância da API
$api = new IXCsoft\WebserviceClient(
    getConfig('host'),
    getConfig('token'),
    getConfig('selfSigned')
);

// Consultar cliente
$api->get('cliente', ['id' => 1]);
$response = $api->getRespostaConteudo(false);
echo $response;
?>
```

### Operações Disponíveis
- **GET**: `$api->get('recurso', $parametros)`
- **POST**: `$api->post('recurso', $dados)`
- **PUT**: `$api->put('recurso', $dados, $id)`
- **DELETE**: `$api->delete('recurso', $id)`

## ⚙️ CONFIGURAÇÕES

### Arquivo `config.php`
```php
// Alterar ambiente
define('ENVIRONMENT', 'development'); // development, staging, production

// Configurações da API
$config = [
    'development' => [
        'host' => 'https://app.core3.com.br/webservice/v1',
        'token' => 'SEU_TOKEN_AQUI',
        'selfSigned' => true,
        'debug' => true
    ]
];
```

### Variáveis de Ambiente (Opcional)
```bash
# Criar arquivo .env (não versionado)
cp .env.example .env

# Editar configurações
nano .env
```

## 🔧 SOLUÇÃO DE PROBLEMAS

### Erro: "PHP não está instalado"
```bash
# macOS
brew install php

# Ubuntu/Debian
sudo apt install php php-curl

# Windows
# Baixar do php.net
```

### Erro: "Extensão cURL não habilitada"
```bash
# Verificar extensões
php -m | grep curl

# Se não aparecer, habilitar no php.ini
# Localizar php.ini: php --ini
# Adicionar: extension=curl
```

### Erro: "Porta já em uso"
```bash
# Verificar portas em uso
lsof -i :8000

# Usar porta diferente
php -S localhost:8080 server.php
```

### Erro de CORS
- ✅ O arquivo já inclui headers CORS
- ✅ Verifique se o `.htaccess` está sendo lido
- ✅ Para produção, configure origens específicas

## 📊 MONITORAMENTO

### Logs da API
```bash
# Ver logs em tempo real
tail -f api.log

# Ver últimos 50 logs
tail -n 50 api.log
```

### Status do Servidor
```bash
# Verificar se está rodando
ps aux | grep "php -S"

# Ver portas abertas
netstat -an | grep 8000
```

## 🚀 DEPLOY EM PRODUÇÃO

### 1. Servidor Apache
```bash
# Copiar arquivos para /var/www/html/
sudo cp -r * /var/www/html/

# Configurar virtual host
sudo nano /etc/apache2/sites-available/api.conf
```

### 2. Servidor Nginx
```bash
# Configurar nginx.conf
server {
    listen 80;
    server_name sua-api.com;
    root /var/www/html;
    
    location / {
        try_files $uri $uri/ /index.php;
    }
}
```

### 3. Docker (Opcional)
```dockerfile
FROM php:8.0-apache
COPY . /var/www/html/
RUN a2enmod rewrite
EXPOSE 80
```

## 📞 SUPORTE

### Documentação
- 📖 **README.md** - Visão geral do projeto
- 🔧 **config.php** - Configurações e funções
- 🧪 **test-api.php** - Testes automatizados
- 📚 **exemplo-uso.php** - Exemplos de código

### Logs e Debug
- 📝 **api.log** - Logs de todas as operações
- 🔍 **Debug mode** - Ativado em desenvolvimento
- ⚠️ **Error handling** - Tratamento de erros robusto

### Comandos Úteis
```bash
# Verificar status
./start-server.sh

# Testar API
php exemplo-uso.php

# Ver logs
tail -f api.log

# Parar servidor
# Ctrl+C no terminal onde está rodando
```

---

## 🎯 PRÓXIMOS PASSOS

1. ✅ **Servidor funcionando** - Teste básico
2. 🔄 **Testes da API** - Verificar conectividade
3. 📱 **Interface web** - Usar botões de teste
4. 🔧 **Configurações** - Personalizar conforme necessário
5. 🚀 **Deploy** - Mover para servidor de produção

---

**🎉 Sua API está pronta para uso!**

Para dúvidas ou problemas, verifique:
- Logs em `api.log`
- Configurações em `config.php`
- Testes em `test-api.php`



